/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.filesystem.MacroExpansionFileSystem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u00020\u00112\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionVfsBatch;", "", "project", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionProject;", "<init>", "(Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionProject;)V", "cratesToDelete", "", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionCrate;", "value", "", "hasChanges", "getHasChanges", "()Z", "macroExpansionFileSystem", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem;", "createFile", "", "crate", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "expansionName", "", "content", "implicit", "deleteFile", "file", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;", "applyToVfs", "callback", "Ljava/lang/Runnable;", "deleteCrate", "Path", "intellij.rustrover.core"})
public final class MacroExpansionVfsBatch {
    @NotNull
    private final MacroExpansionFileSystem.MacroExpansionProject project;
    @NotNull
    private final List<MacroExpansionFileSystem.MacroExpansionCrate> cratesToDelete;
    private boolean hasChanges;
    @NotNull
    private final MacroExpansionFileSystem macroExpansionFileSystem;

    public MacroExpansionVfsBatch(@NotNull MacroExpansionFileSystem.MacroExpansionProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cratesToDelete = new ArrayList();
        this.macroExpansionFileSystem = MacroExpansionFileSystem.Helper.INSTANCE.getInstance();
    }

    public final boolean getHasChanges() {
        return this.hasChanges;
    }

    public final void createFile(int crate, @NotNull String expansionName, @NotNull String content, boolean implicit) {
        Intrinsics.checkNotNullParameter((Object)expansionName, (String)"expansionName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (implicit) {
            String string = content;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.project.createFileWithImplicitContent(crate, expansionName, byArray.length);
        } else {
            String string = content;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            this.project.createFileWithExplicitContent(crate, expansionName, byArray);
        }
        this.hasChanges = true;
    }

    public static /* synthetic */ void createFile$default(MacroExpansionVfsBatch macroExpansionVfsBatch, int n, String string, String string2, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        macroExpansionVfsBatch.createFile(n, string, string2, bl);
    }

    public final void deleteFile(@NotNull MacroExpansionFileSystem.MacroExpansionFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        file.delete();
        this.hasChanges = true;
    }

    public final void applyToVfs(@Nullable Runnable callback) {
        for (MacroExpansionFileSystem.MacroExpansionCrate crate : this.cratesToDelete) {
            this.project.deleteCrate(crate);
        }
        this.macroExpansionFileSystem.applyToVfs(callback);
    }

    public static /* synthetic */ void applyToVfs$default(MacroExpansionVfsBatch macroExpansionVfsBatch, Runnable runnable, int n, Object object) {
        if ((n & 1) != 0) {
            runnable = null;
        }
        macroExpansionVfsBatch.applyToVfs(runnable);
    }

    public final void deleteCrate(@NotNull MacroExpansionFileSystem.MacroExpansionCrate crate) {
        Intrinsics.checkNotNullParameter((Object)crate, (String)"crate");
        this.cratesToDelete.add(crate);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionVfsBatch$Path;", "", "path", "", "<init>", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "intellij.rustrover.core"})
    public static final class Path {
        @NotNull
        private final String path;

        public Path(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }
    }
}

