/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.RsTask;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.lang.core.macros.ExpansionResultOk;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.MacroExpansionSharedCache;
import org.rust.lang.core.macros.MacroExpansionTask;
import org.rust.lang.core.macros.MacroExpansionTaskKt;
import org.rust.lang.core.macros.MacroExpansionTaskListener;
import org.rust.lang.core.macros.MacroExpansionVfsBatch;
import org.rust.lang.core.macros.errors.MacroExpansionError;
import org.rust.lang.core.macros.filesystem.ExpandedMacroStorageKt;
import org.rust.lang.core.macros.filesystem.MacroExpansionFileSystem;
import org.rust.lang.core.psi.RsPsiManager;
import org.rust.lang.core.resolve2.CrateDefMap;
import org.rust.lang.core.resolve2.DefMapService;
import org.rust.lang.core.resolve2.DefMapServiceKt;
import org.rust.lang.core.resolve2.FacadeUpdateDefMapKt;
import org.rust.lang.core.resolve2.MacroCallLightInfo;
import org.rust.openapiext.Testmark;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.HashCode;
import org.rust.stdext.RsResult;
import org.rust.util.UnitTestUtilService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u00012\u00020\u0002:\u0005EFGHIB?\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\u000b0\b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0016\u0010\u001e\u001a\u00020\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J$\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0 H\u0002J.\u0010(\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0 \u0012\n\u0012\b\u0012\u0004\u0012\u00020'0 0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J$\u0010+\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0 2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0 H\u0002J\u001e\u0010,\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010 2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0 H\u0002J\u0016\u00100\u001a\u00020#2\f\u00101\u001a\b\u0012\u0004\u0012\u00020-0 H\u0002J0\u00102\u001a\u00020\u001b2\u001e\u00103\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0 \u0012\n\u0012\b\u0012\u0004\u0012\u00020'0 0)2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u001b2\u0006\u00104\u001a\u000205H\u0002J \u00107\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u000209082\n\u0010:\u001a\u00060\tj\u0002`\nH\u0002J\u001e\u0010;\u001a\u00020#2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u00104\u001a\u000205H\u0002J\b\u0010<\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u00060\tj\u0002`\n\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u0014\u0010C\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010?\u00a8\u0006J"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "Lorg/rust/RsTask;", "project", "Lcom/intellij/openapi/project/Project;", "modificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "lastUpdatedMacrosAt", "", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "", "projectDirectoryName", "", "taskType", "Lorg/rust/RsTask$TaskType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/SimpleModificationTracker;Ljava/util/Map;Ljava/lang/String;Lorg/rust/RsTask$TaskType;)V", "getTaskType", "()Lorg/rust/RsTask$TaskType;", "macroExpansionFileSystem", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem;", "expansionSharedCache", "Lorg/rust/lang/core/macros/MacroExpansionSharedCache;", "defMapService", "Lorg/rust/lang/core/resolve2/DefMapService;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "updateMacrosFiles", "allDefMaps", "", "Lorg/rust/lang/core/resolve2/CrateDefMap;", "onlyOneCrateIsAffected", "", "creations", "Lorg/rust/lang/core/macros/MacroExpansionTask$FileCreation;", "deletions", "Lorg/rust/lang/core/macros/MacroExpansionTask$FileDeletion;", "collectFilesForCreationAndDeletion", "Lkotlin/Pair;", "defMaps", "applyChangesFastPath", "applyChangesFastPathReadAction", "Lorg/rust/lang/core/macros/MacroExpansionTask$PreparedFileDeletionAndCreation2;", "prepared1", "Lorg/rust/lang/core/macros/MacroExpansionTask$PreparedFileDeletionAndCreation1;", "applyChangesFastPathWriteAction", "prepared2", "createOrDeleteNeededFiles", "files", "batch", "Lorg/rust/lang/core/macros/MacroExpansionVfsBatch;", "applyBatch", "collectExistingFiles", "", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;", "crate", "deleteStaleExpansions", "onFinished", "waitForSmartMode", "getWaitForSmartMode", "()Z", "progressBarShowDelay", "getProgressBarShowDelay", "()I", "runSyncInUnitTests", "getRunSyncInUnitTests", "FileCreation", "FileDeletion", "PreparedFileDeletionAndCreation1", "PreparedFileDeletionAndCreation2", "MoveToTheSameCrate", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroExpansionTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionTask.kt\norg/rust/lang/core/macros/MacroExpansionTask\n+ 2 utils.kt\norg/rust/openapiext/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Collections.kt\norg/rust/stdext/CollectionsKt\n*L\n1#1,388:1\n318#2,6:389\n324#2,4:403\n1669#3,8:395\n774#3:407\n865#3,2:408\n1563#3:410\n1634#3,3:411\n1563#3:414\n1634#3,3:415\n1634#3,3:419\n150#4:418\n*S KotlinDebug\n*F\n+ 1 MacroExpansionTask.kt\norg/rust/lang/core/macros/MacroExpansionTask\n*L\n89#1:389,6\n89#1:403,4\n89#1:395,8\n119#1:407\n119#1:408,2\n199#1:410\n199#1:411,3\n226#1:414\n226#1:415,3\n317#1:419,3\n317#1:418\n*E\n"})
public final class MacroExpansionTask
extends Task.Backgroundable
implements RsTask {
    @NotNull
    private final SimpleModificationTracker modificationTracker;
    @NotNull
    private final Map<Integer, Long> lastUpdatedMacrosAt;
    @NotNull
    private final String projectDirectoryName;
    @NotNull
    private final RsTask.TaskType taskType;
    @NotNull
    private final MacroExpansionFileSystem macroExpansionFileSystem;
    @NotNull
    private final MacroExpansionSharedCache expansionSharedCache;
    @NotNull
    private final DefMapService defMapService;

    public MacroExpansionTask(@NotNull Project project, @NotNull SimpleModificationTracker modificationTracker, @NotNull Map<Integer, Long> lastUpdatedMacrosAt, @NotNull String projectDirectoryName, @NotNull RsTask.TaskType taskType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modificationTracker, (String)"modificationTracker");
        Intrinsics.checkNotNullParameter(lastUpdatedMacrosAt, (String)"lastUpdatedMacrosAt");
        Intrinsics.checkNotNullParameter((Object)projectDirectoryName, (String)"projectDirectoryName");
        Intrinsics.checkNotNullParameter((Object)((Object)taskType), (String)"taskType");
        super(project, RsBundle.INSTANCE.message("progress.title.expanding.rust.macros", new Object[0]), false);
        this.modificationTracker = modificationTracker;
        this.lastUpdatedMacrosAt = lastUpdatedMacrosAt;
        this.projectDirectoryName = projectDirectoryName;
        this.taskType = taskType;
        this.macroExpansionFileSystem = MacroExpansionFileSystem.Helper.INSTANCE.getInstance();
        this.expansionSharedCache = MacroExpansionSharedCache.Companion.getInstance();
        this.defMapService = DefMapServiceKt.getDefMapService(project);
    }

    @Override
    @NotNull
    public RsTask.TaskType getTaskType() {
        return this.taskType;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        indicator.checkCanceled();
        indicator.setIndeterminate(false);
        indicator.setText(RsBundle.INSTANCE.message("progress.text.preparing.resolve.data", new Object[0]));
        Pair pair = (Pair)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends List<? extends CrateDefMap>, ? extends Long>>, Object>(this, null){
            int label;
            final /* synthetic */ MacroExpansionTask this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FacadeUpdateDefMapKt.updateDefMapForAllCratesWithWriteActionPriority(MacroExpansionTask.access$getDefMapService$p(this.this$0), (Continuation<? super Pair<? extends List<CrateDefMap>, Long>>)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Pair<? extends List<CrateDefMap>, Long>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        Pair pair2 = pair;
        List allDefMaps = (List)pair2.component1();
        long start1 = ((Number)pair2.component2()).longValue();
        boolean $i$f$weakAssert = false;
        boolean $i$f$weakAssert2 = false;
        if (UtilsKt.isUnitTestMode() || UtilsKt.isInternal()) {
            boolean bl = false;
            Iterable $this$distinctBy$iv = allDefMaps;
            boolean $i$f$distinctBy = false;
            HashSet<Integer> set$iv = new HashSet<Integer>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                CrateDefMap it2 = (CrateDefMap)e$iv;
                boolean bl2 = false;
                Integer key$iv = it2.getCrate();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            if (!(((List)list$iv).size() == allDefMaps.size())) {
                boolean bl3 = false;
                String message$iv$iv = "Assertion failed";
                throw new AssertionError((Object)message$iv$iv);
            }
        }
        long start2 = System.currentTimeMillis();
        long elapsed1 = start2 - start1;
        MacroExpansionManagerKt.MACRO_LOG.debug("Finished building DefMaps for all crates in " + elapsed1 + " ms");
        indicator.setText(RsBundle.INSTANCE.message("progress.text.save.macro.expansions", new Object[0]));
        this.updateMacrosFiles(allDefMaps);
        long elapsed2 = System.currentTimeMillis() - start2;
        MacroExpansionManagerKt.MACRO_LOG.debug("Finished macro expansion task in " + elapsed2 + " ms");
        if (this.getTaskType() == RsTask.TaskType.MACROS_UNPROCESSED) {
            long totalSeconds = (elapsed1 + elapsed2) / (long)1000;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RsCounterUsagesCollector.INSTANCE.logMacroTaskDuration(project, (int)totalSeconds);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateMacrosFiles(List<CrateDefMap> allDefMaps) {
        boolean fastPathApplied;
        boolean tryFastPath;
        void $this$filterTo$iv$iv;
        MacroExpansionFileSystem.MacroExpansionProject macroExpansionProject = this.macroExpansionFileSystem.findProject(this.projectDirectoryName);
        if (macroExpansionProject == null) {
            return;
        }
        MacroExpansionFileSystem.MacroExpansionProject macroExpansionProject2 = macroExpansionProject;
        if (this.lastUpdatedMacrosAt.isEmpty() && !((Collection)allDefMaps).isEmpty()) {
            VirtualFile contentRootVirtualFile = macroExpansionProject2.getVirtualFile();
            VirtualFile[] virtualFileArray = new VirtualFile[]{contentRootVirtualFile};
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            UnitTestUtilService.Companion.waitUntilIndexesAreReadyInUnitTests(project);
        }
        MacroExpansionVfsBatch batch = new MacroExpansionVfsBatch(macroExpansionProject2);
        boolean hasStaleExpansions = this.deleteStaleExpansions(allDefMaps, batch);
        Iterable $this$filter$iv = allDefMaps;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CrateDefMap it2 = (CrateDefMap)element$iv$iv;
            boolean bl = false;
            Long l = this.lastUpdatedMacrosAt.get(it2.getCrate());
            long l2 = it2.getTimestamp();
            if (!(l == null || l != l2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List defMaps2 = (List)destination$iv$iv;
        if (!hasStaleExpansions && defMaps2.isEmpty()) {
            return;
        }
        Pair<List<FileCreation>, List<FileDeletion>> files2 = this.collectFilesForCreationAndDeletion(defMaps2);
        boolean bl = tryFastPath = !batch.getHasChanges() && ((List)files2.getFirst()).size() == ((List)files2.getSecond()).size() && ((List)files2.getFirst()).size() < FileBasedIndexProjectHandler.ourMinFilesToStartDumbMode && this.onlyOneCrateIsAffected((List)files2.getFirst(), (List)files2.getSecond());
        if (tryFastPath) {
            boolean applied = this.applyChangesFastPath((List)files2.getFirst(), (List)files2.getSecond());
            if (!applied) {
                files2 = this.collectFilesForCreationAndDeletion(defMaps2);
            }
            v4 = applied;
        } else {
            v4 = fastPathApplied = false;
        }
        if (!fastPathApplied) {
            this.createOrDeleteNeededFiles(files2, batch);
            this.applyBatch(batch);
        }
        for (CrateDefMap defMap : defMaps2) {
            this.lastUpdatedMacrosAt.put(defMap.getCrate(), defMap.getTimestamp());
        }
    }

    private final boolean onlyOneCrateIsAffected(List<FileCreation> creations, List<FileDeletion> deletions) {
        Integer n = (Integer)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)creations), MacroExpansionTask::onlyOneCrateIsAffected$lambda$0)));
        if (n == null) {
            return false;
        }
        int creationsCrate = n;
        Integer n2 = (Integer)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)deletions), MacroExpansionTask::onlyOneCrateIsAffected$lambda$1)));
        if (n2 == null) {
            return false;
        }
        int deletionsCrate = n2;
        return creationsCrate == deletionsCrate;
    }

    private final Pair<List<FileCreation>, List<FileDeletion>> collectFilesForCreationAndDeletion(List<CrateDefMap> defMaps2) {
        List pendingFileWrites = new ArrayList();
        List pendingFileDeletions = new ArrayList();
        for (CrateDefMap defMap : defMaps2) {
            Map<String, MacroExpansionFileSystem.MacroExpansionFile> existingFiles = this.collectExistingFiles(defMap.getCrate());
            Map<String, MacroCallLightInfo> requiredExpansions = defMap.getExpansionNameToMacroCall();
            Set filesToDelete = SetsKt.minus(existingFiles.keySet(), (Iterable)requiredExpansions.keySet());
            Set filesToCreate = SetsKt.minus(requiredExpansions.keySet(), (Iterable)existingFiles.keySet());
            for (String expansionName : filesToCreate) {
                HashCode mixHash = MacroExpansionTaskKt.extractMixHashFromExpansionName(expansionName);
                RsResult<ExpansionResultOk, MacroExpansionError> rsResult = this.expansionSharedCache.getExpansionIfCached(mixHash);
                if (rsResult == null || (rsResult = rsResult.ok()) == null) continue;
                RsResult<ExpansionResultOk, MacroExpansionError> expansion = rsResult;
                ((Collection)pendingFileWrites).add(new FileCreation(defMap.getCrate(), expansionName, ((ExpansionResultOk)((Object)expansion)).getText()));
            }
            for (String fileName : filesToDelete) {
                MacroExpansionFileSystem.MacroExpansionFile file = (MacroExpansionFileSystem.MacroExpansionFile)MapsKt.getValue(existingFiles, (Object)fileName);
                ((Collection)pendingFileDeletions).add(new FileDeletion(file));
            }
        }
        return TuplesKt.to((Object)pendingFileWrites, (Object)pendingFileDeletions);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean applyChangesFastPath(List<FileCreation> creations, List<FileDeletion> deletions) {
        boolean bl;
        void $this$mapTo$iv$iv;
        if (!(creations.size() == deletions.size())) {
            throw new IllegalStateException("Check failed.");
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)deletions, (Iterable)creations);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            FileDeletion deletion = (FileDeletion)pair.component1();
            FileCreation creation = (FileCreation)pair.component2();
            collection.add(new PreparedFileDeletionAndCreation1(creation, deletion));
        }
        List prepared1 = (List)destination$iv$iv;
        if (UtilsKt.isUnitTestMode() && UtilsKt.isDispatchThread()) {
            List<PreparedFileDeletionAndCreation2> list = this.applyChangesFastPathReadAction(prepared1);
            if (list == null) {
                return false;
            }
            List<PreparedFileDeletionAndCreation2> prepared2 = list;
            bl = (Boolean)ActionsKt.runWriteAction(() -> MacroExpansionTask.applyChangesFastPath$lambda$1(this, prepared2));
        } else {
            bl = (Boolean)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(this, (List<PreparedFileDeletionAndCreation1>)prepared1, null){
                int label;
                final /* synthetic */ MacroExpansionTask this$0;
                final /* synthetic */ List<PreparedFileDeletionAndCreation1> $prepared1;
                {
                    this.this$0 = $receiver;
                    this.$prepared1 = $prepared1;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = com.intellij.openapi.application.CoroutinesKt.readAndEdtWriteAction(arg_0 -> applyChangesFastPath.result.2.invokeSuspend$lambda$0(this.this$0, this.$prepared1, arg_0), (Continuation)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final ReadResult invokeSuspend$lambda$0(MacroExpansionTask this$0, List $prepared1, ReadAndWriteScope $this$readAndEdtWriteAction) {
                    List list = MacroExpansionTask.access$applyChangesFastPathReadAction(this$0, $prepared1);
                    if (list == null) {
                        return $this$readAndEdtWriteAction.value((Object)false);
                    }
                    List prepared2 = list;
                    return $this$readAndEdtWriteAction.writeAction(() -> applyChangesFastPath.result.2.invokeSuspend$lambda$0$0(this$0, prepared2));
                }

                private static final boolean invokeSuspend$lambda$0$0(MacroExpansionTask this$0, List $prepared2) {
                    return MacroExpansionTask.access$applyChangesFastPathWriteAction(this$0, $prepared2);
                }
            }));
        }
        boolean result2 = bl;
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PreparedFileDeletionAndCreation2> applyChangesFastPathReadAction(List<PreparedFileDeletionAndCreation1> prepared1) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = prepared1;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiFile oldPsiFile;
            PreparedFileDeletionAndCreation1 preparedFileDeletionAndCreation1 = (PreparedFileDeletionAndCreation1)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FileCreation creation = preparedFileDeletionAndCreation1.component1();
            FileDeletion deletion = preparedFileDeletionAndCreation1.component2();
            MacroExpansionFileSystem.MacroExpansionFile oldFile = deletion.getFile();
            VirtualFile virtualFile = oldFile.getVirtualFile();
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (UtilsKt.toPsiFile(virtualFile, project) == null) {
                return null;
            }
            oldFile.getVirtualFile().contentsToByteArray();
            collection.add(new PreparedFileDeletionAndCreation2(creation, oldFile, oldPsiFile));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean applyChangesFastPathWriteAction(List<PreparedFileDeletionAndCreation2> prepared2) {
        for (PreparedFileDeletionAndCreation2 preparedFileDeletionAndCreation2 : prepared2) {
            Document doc;
            MacroExpansionFileSystem.MacroExpansionFile oldFile;
            block12: {
                FileCreation creation = preparedFileDeletionAndCreation2.component1();
                oldFile = preparedFileDeletionAndCreation2.component2();
                PsiFile oldPsiFile = preparedFileDeletionAndCreation2.component3();
                try {
                    RsPsiManager.Companion.withIgnoredPsiEvents(oldPsiFile, () -> MacroExpansionTask.applyChangesFastPathWriteAction$lambda$0(oldFile, creation));
                    doc = FileDocumentManager.getInstance().getCachedDocument(oldFile.getVirtualFile());
                    if (doc == null) {
                        Closeable closeable = oldFile.getOutputStream();
                        Throwable throwable = null;
                        try {
                            OutputStream it2 = (OutputStream)closeable;
                            boolean bl = false;
                            byte[] byArray = creation.getContent().getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                            it2.write(byArray);
                            Unit unit = Unit.INSTANCE;
                            break block12;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                    UndoUtil.disableUndoFor((Document)doc);
                    CommandProcessor.getInstance().runUndoTransparentAction(() -> MacroExpansionTask.applyChangesFastPathWriteAction$lambda$2(doc, creation));
                    UndoUtil.enableUndoFor((Document)doc);
                    MacroExpansionFileSystem.Helper.INSTANCE.withAllowedWriting(oldFile, () -> MacroExpansionTask.applyChangesFastPathWriteAction$lambda$3(doc));
                }
                catch (IOException e) {
                    MacroExpansionManagerKt.MACRO_LOG.error((Throwable)e);
                    try {
                        oldFile.delete();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return false;
                }
            }
            if (UtilsKt.isUnitTestMode() && this.getRunSyncInUnitTests() && (doc = FileDocumentManager.getInstance().getCachedDocument(oldFile.getVirtualFile())) != null) {
                PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(doc);
            }
            this.modificationTracker.incModificationCount();
        }
        return true;
    }

    private final void createOrDeleteNeededFiles(Pair<? extends List<FileCreation>, ? extends List<FileDeletion>> files2, MacroExpansionVfsBatch batch) {
        for (FileCreation fileCreation : (List)files2.getFirst()) {
            batch.createFile(fileCreation.getCrate(), fileCreation.getExpansionName(), fileCreation.getContent(), true);
        }
        for (FileDeletion fileDeletion : (List)files2.getSecond()) {
            batch.deleteFile(fileDeletion.getFile());
        }
    }

    private final void applyBatch(MacroExpansionVfsBatch batch) {
        if (!batch.getHasChanges()) {
            return;
        }
        batch.applyToVfs(() -> MacroExpansionTask.applyBatch$lambda$0(this));
        if (UtilsKt.isUnitTestMode()) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            UnitTestUtilService.Companion.waitUntilIndexesAreReadyInUnitTests(project);
        }
    }

    private final Map<String, MacroExpansionFileSystem.MacroExpansionFile> collectExistingFiles(int crate) {
        return this.macroExpansionFileSystem.getAllFiles(this.projectDirectoryName, crate);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean deleteStaleExpansions(List<CrateDefMap> allDefMaps, MacroExpansionVfsBatch batch) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv = allDefMaps;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection entry2 = new HashSet(org.rust.stdext.CollectionsKt.mapCapacity(org.rust.stdext.CollectionsKt.collectionSizeOrDefault($this$mapToSet$iv, 10)));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            CrateDefMap crateDefMap = (CrateDefMap)item$iv$iv;
            Collection collection = entry2;
            boolean bl = false;
            collection.add(it2.getCrate());
        }
        Set crates = (Set)entry2;
        this.lastUpdatedMacrosAt.entrySet().removeIf(arg_0 -> MacroExpansionTask.deleteStaleExpansions$lambda$2(arg_0 -> MacroExpansionTask.deleteStaleExpansions$lambda$1(crates, arg_0), arg_0));
        Map<Integer, MacroExpansionFileSystem.MacroExpansionCrate> existingCrates = this.macroExpansionFileSystem.getAllCrates(this.projectDirectoryName);
        boolean deletedAny = false;
        for (Map.Entry entry3 : existingCrates.entrySet()) {
            int name2 = ((Number)entry3.getKey()).intValue();
            MacroExpansionFileSystem.MacroExpansionCrate crate = (MacroExpansionFileSystem.MacroExpansionCrate)entry3.getValue();
            if (crates.contains(name2)) continue;
            batch.deleteCrate(crate);
            deletedAny = true;
        }
        return deletedAny;
    }

    public void onFinished() {
        if (this.getProject().isDisposed()) {
            return;
        }
        ((MacroExpansionTaskListener)this.getProject().getMessageBus().syncPublisher(MacroExpansionTaskListener.Companion.getMACRO_EXPANSION_TASK_TOPIC())).onMacroExpansionTaskFinished();
    }

    @Override
    public boolean getWaitForSmartMode() {
        return true;
    }

    @Override
    public int getProgressBarShowDelay() {
        return WhenMappings.$EnumSwitchMapping$0[this.getTaskType().ordinal()] == 1 ? 0 : 2000;
    }

    @Override
    public boolean getRunSyncInUnitTests() {
        return true;
    }

    private static final int onlyOneCrateIsAffected$lambda$0(FileCreation it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getCrate();
    }

    private static final int onlyOneCrateIsAffected$lambda$1(FileDeletion it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getFile().getCrate().getId();
    }

    private static final boolean applyChangesFastPath$lambda$1(MacroExpansionTask this$0, List $prepared2) {
        return this$0.applyChangesFastPathWriteAction($prepared2);
    }

    private static final Unit applyChangesFastPathWriteAction$lambda$0(MacroExpansionFileSystem.MacroExpansionFile $oldFile, FileCreation $creation) {
        ExpandedMacroStorageKt.clearCachedRangeMap($oldFile.getVirtualFile());
        if ($creation.getCrate() != $oldFile.getCrate().getId()) {
            MacroExpansionManagerKt.MACRO_LOG.error("Can only move macro expansions within a single crate, but creation (" + $creation + ") and deletion (" + $oldFile + ") have different crates - " + $creation.getCrate() + " and " + $oldFile.getCrate().getId());
        } else {
            MoveToTheSameCrate.INSTANCE.hit();
        }
        $oldFile.rename($creation.getExpansionName());
        return Unit.INSTANCE;
    }

    private static final void applyChangesFastPathWriteAction$lambda$2(Document $doc, FileCreation $creation) {
        $doc.setText((CharSequence)$creation.getContent());
    }

    private static final Unit applyChangesFastPathWriteAction$lambda$3(Document $doc) {
        FileDocumentManager.getInstance().saveDocument($doc);
        return Unit.INSTANCE;
    }

    private static final void applyBatch$lambda$0(MacroExpansionTask this$0) {
        this$0.modificationTracker.incModificationCount();
    }

    private static final boolean deleteStaleExpansions$lambda$1(Set $crates, Map.Entry entry2) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"<destruct>");
        int crate = ((Number)entry2.getKey()).intValue();
        return !$crates.contains(crate);
    }

    private static final boolean deleteStaleExpansions$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ DefMapService access$getDefMapService$p(MacroExpansionTask $this) {
        return $this.defMapService;
    }

    public static final /* synthetic */ List access$applyChangesFastPathReadAction(MacroExpansionTask $this, List prepared1) {
        return $this.applyChangesFastPathReadAction(prepared1);
    }

    public static final /* synthetic */ boolean access$applyChangesFastPathWriteAction(MacroExpansionTask $this, List prepared2) {
        return $this.applyChangesFastPathWriteAction(prepared2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000f\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0006H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionTask$FileCreation;", "", "crate", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "expansionName", "", "content", "<init>", "(ILjava/lang/String;Ljava/lang/String;)V", "getCrate", "()I", "getExpansionName", "()Ljava/lang/String;", "getContent", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.rustrover.core"})
    private static final class FileCreation {
        private final int crate;
        @NotNull
        private final String expansionName;
        @NotNull
        private final String content;

        public FileCreation(int crate, @NotNull String expansionName, @NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)expansionName, (String)"expansionName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.crate = crate;
            this.expansionName = expansionName;
            this.content = content;
        }

        public final int getCrate() {
            return this.crate;
        }

        @NotNull
        public final String getExpansionName() {
            return this.expansionName;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        public final int component1() {
            return this.crate;
        }

        @NotNull
        public final String component2() {
            return this.expansionName;
        }

        @NotNull
        public final String component3() {
            return this.content;
        }

        @NotNull
        public final FileCreation copy(int crate, @NotNull String expansionName, @NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)expansionName, (String)"expansionName");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new FileCreation(crate, expansionName, content);
        }

        public static /* synthetic */ FileCreation copy$default(FileCreation fileCreation, int n, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = fileCreation.crate;
            }
            if ((n2 & 2) != 0) {
                string = fileCreation.expansionName;
            }
            if ((n2 & 4) != 0) {
                string2 = fileCreation.content;
            }
            return fileCreation.copy(n, string, string2);
        }

        @NotNull
        public String toString() {
            return "FileCreation(crate=" + this.crate + ", expansionName=" + this.expansionName + ", content=" + this.content + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.crate);
            result2 = result2 * 31 + this.expansionName.hashCode();
            result2 = result2 * 31 + this.content.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileCreation)) {
                return false;
            }
            FileCreation fileCreation = (FileCreation)other;
            if (this.crate != fileCreation.crate) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.expansionName, (Object)fileCreation.expansionName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.content, (Object)fileCreation.content);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionTask$FileDeletion;", "", "file", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;", "<init>", "(Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;)V", "getFile", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;", "intellij.rustrover.core"})
    private static final class FileDeletion {
        @NotNull
        private final MacroExpansionFileSystem.MacroExpansionFile file;

        public FileDeletion(@NotNull MacroExpansionFileSystem.MacroExpansionFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
        }

        @NotNull
        public final MacroExpansionFileSystem.MacroExpansionFile getFile() {
            return this.file;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionTask$MoveToTheSameCrate;", "Lorg/rust/openapiext/Testmark;", "<init>", "()V", "intellij.rustrover.core"})
    public static final class MoveToTheSameCrate
    extends Testmark {
        @NotNull
        public static final MoveToTheSameCrate INSTANCE = new MoveToTheSameCrate();

        private MoveToTheSameCrate() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionTask$PreparedFileDeletionAndCreation1;", "", "creation", "Lorg/rust/lang/core/macros/MacroExpansionTask$FileCreation;", "deletion", "Lorg/rust/lang/core/macros/MacroExpansionTask$FileDeletion;", "<init>", "(Lorg/rust/lang/core/macros/MacroExpansionTask$FileCreation;Lorg/rust/lang/core/macros/MacroExpansionTask$FileDeletion;)V", "getCreation", "()Lorg/rust/lang/core/macros/MacroExpansionTask$FileCreation;", "getDeletion", "()Lorg/rust/lang/core/macros/MacroExpansionTask$FileDeletion;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    private static final class PreparedFileDeletionAndCreation1 {
        @NotNull
        private final FileCreation creation;
        @NotNull
        private final FileDeletion deletion;

        public PreparedFileDeletionAndCreation1(@NotNull FileCreation creation, @NotNull FileDeletion deletion) {
            Intrinsics.checkNotNullParameter((Object)creation, (String)"creation");
            Intrinsics.checkNotNullParameter((Object)deletion, (String)"deletion");
            this.creation = creation;
            this.deletion = deletion;
        }

        @NotNull
        public final FileCreation getCreation() {
            return this.creation;
        }

        @NotNull
        public final FileDeletion getDeletion() {
            return this.deletion;
        }

        @NotNull
        public final FileCreation component1() {
            return this.creation;
        }

        @NotNull
        public final FileDeletion component2() {
            return this.deletion;
        }

        @NotNull
        public final PreparedFileDeletionAndCreation1 copy(@NotNull FileCreation creation, @NotNull FileDeletion deletion) {
            Intrinsics.checkNotNullParameter((Object)creation, (String)"creation");
            Intrinsics.checkNotNullParameter((Object)deletion, (String)"deletion");
            return new PreparedFileDeletionAndCreation1(creation, deletion);
        }

        public static /* synthetic */ PreparedFileDeletionAndCreation1 copy$default(PreparedFileDeletionAndCreation1 preparedFileDeletionAndCreation1, FileCreation fileCreation, FileDeletion fileDeletion, int n, Object object) {
            if ((n & 1) != 0) {
                fileCreation = preparedFileDeletionAndCreation1.creation;
            }
            if ((n & 2) != 0) {
                fileDeletion = preparedFileDeletionAndCreation1.deletion;
            }
            return preparedFileDeletionAndCreation1.copy(fileCreation, fileDeletion);
        }

        @NotNull
        public String toString() {
            return "PreparedFileDeletionAndCreation1(creation=" + this.creation + ", deletion=" + this.deletion + ")";
        }

        public int hashCode() {
            int result2 = this.creation.hashCode();
            result2 = result2 * 31 + this.deletion.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PreparedFileDeletionAndCreation1)) {
                return false;
            }
            PreparedFileDeletionAndCreation1 preparedFileDeletionAndCreation1 = (PreparedFileDeletionAndCreation1)other;
            if (!Intrinsics.areEqual((Object)this.creation, (Object)preparedFileDeletionAndCreation1.creation)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.deletion, (Object)preparedFileDeletionAndCreation1.deletion);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionTask$PreparedFileDeletionAndCreation2;", "", "creation", "Lorg/rust/lang/core/macros/MacroExpansionTask$FileCreation;", "oldFile", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;", "oldPsiFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lorg/rust/lang/core/macros/MacroExpansionTask$FileCreation;Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;Lcom/intellij/psi/PsiFile;)V", "getCreation", "()Lorg/rust/lang/core/macros/MacroExpansionTask$FileCreation;", "getOldFile", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionFile;", "getOldPsiFile", "()Lcom/intellij/psi/PsiFile;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    private static final class PreparedFileDeletionAndCreation2 {
        @NotNull
        private final FileCreation creation;
        @NotNull
        private final MacroExpansionFileSystem.MacroExpansionFile oldFile;
        @NotNull
        private final PsiFile oldPsiFile;

        public PreparedFileDeletionAndCreation2(@NotNull FileCreation creation, @NotNull MacroExpansionFileSystem.MacroExpansionFile oldFile, @NotNull PsiFile oldPsiFile) {
            Intrinsics.checkNotNullParameter((Object)creation, (String)"creation");
            Intrinsics.checkNotNullParameter((Object)oldFile, (String)"oldFile");
            Intrinsics.checkNotNullParameter((Object)oldPsiFile, (String)"oldPsiFile");
            this.creation = creation;
            this.oldFile = oldFile;
            this.oldPsiFile = oldPsiFile;
        }

        @NotNull
        public final FileCreation getCreation() {
            return this.creation;
        }

        @NotNull
        public final MacroExpansionFileSystem.MacroExpansionFile getOldFile() {
            return this.oldFile;
        }

        @NotNull
        public final PsiFile getOldPsiFile() {
            return this.oldPsiFile;
        }

        @NotNull
        public final FileCreation component1() {
            return this.creation;
        }

        @NotNull
        public final MacroExpansionFileSystem.MacroExpansionFile component2() {
            return this.oldFile;
        }

        @NotNull
        public final PsiFile component3() {
            return this.oldPsiFile;
        }

        @NotNull
        public final PreparedFileDeletionAndCreation2 copy(@NotNull FileCreation creation, @NotNull MacroExpansionFileSystem.MacroExpansionFile oldFile, @NotNull PsiFile oldPsiFile) {
            Intrinsics.checkNotNullParameter((Object)creation, (String)"creation");
            Intrinsics.checkNotNullParameter((Object)oldFile, (String)"oldFile");
            Intrinsics.checkNotNullParameter((Object)oldPsiFile, (String)"oldPsiFile");
            return new PreparedFileDeletionAndCreation2(creation, oldFile, oldPsiFile);
        }

        public static /* synthetic */ PreparedFileDeletionAndCreation2 copy$default(PreparedFileDeletionAndCreation2 preparedFileDeletionAndCreation2, FileCreation fileCreation, MacroExpansionFileSystem.MacroExpansionFile macroExpansionFile, PsiFile psiFile, int n, Object object) {
            if ((n & 1) != 0) {
                fileCreation = preparedFileDeletionAndCreation2.creation;
            }
            if ((n & 2) != 0) {
                macroExpansionFile = preparedFileDeletionAndCreation2.oldFile;
            }
            if ((n & 4) != 0) {
                psiFile = preparedFileDeletionAndCreation2.oldPsiFile;
            }
            return preparedFileDeletionAndCreation2.copy(fileCreation, macroExpansionFile, psiFile);
        }

        @NotNull
        public String toString() {
            return "PreparedFileDeletionAndCreation2(creation=" + this.creation + ", oldFile=" + this.oldFile + ", oldPsiFile=" + this.oldPsiFile + ")";
        }

        public int hashCode() {
            int result2 = this.creation.hashCode();
            result2 = result2 * 31 + this.oldFile.hashCode();
            result2 = result2 * 31 + this.oldPsiFile.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PreparedFileDeletionAndCreation2)) {
                return false;
            }
            PreparedFileDeletionAndCreation2 preparedFileDeletionAndCreation2 = (PreparedFileDeletionAndCreation2)other;
            if (!Intrinsics.areEqual((Object)this.creation, (Object)preparedFileDeletionAndCreation2.creation)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.oldFile, (Object)preparedFileDeletionAndCreation2.oldFile)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.oldPsiFile, (Object)preparedFileDeletionAndCreation2.oldPsiFile);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RsTask.TaskType.values().length];
            try {
                nArray[RsTask.TaskType.MACROS_UNPROCESSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

