/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubTreeSerializer;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.io.PersistentHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.macros.ExpansionResultOk;
import org.rust.lang.core.macros.MacroExpander;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.MacroExpansionSharedCache;
import org.rust.lang.core.macros.PersistentCacheData;
import org.rust.lang.core.macros.RangeMap;
import org.rust.lang.core.macros.RsMacroData;
import org.rust.lang.core.macros.RsMacroDefAndCallDataWithMixHash;
import org.rust.lang.core.macros.errors.MacroExpansionError;
import org.rust.lang.core.macros.errors.MacroExpansionErrorKt;
import org.rust.lang.core.stubs.RsFileStub;
import org.rust.openapiext.RsPathManager;
import org.rust.stdext.ConcurrencyKt;
import org.rust.stdext.HashCode;
import org.rust.stdext.RsResult;
import org.rust.stdext.UtilsKt;
import org.rust.util.ZipKt;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 K2\u00020\u0001:\u0004HIJKB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\u0006\u0010\u001a\u001a\u00020\u0013J\u0087\u0001\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001c2\u001e\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001c0 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001c0\"2\u0006\u0010#\u001a\u0002H\u001d2\"\b\u0002\u0010$\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020\u0013\u0018\u00010%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u001c0\u001fH\u0002\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0002JH\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u0002H/0-\"\b\b\u0000\u00100*\u000201\"\b\b\u0001\u0010/*\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u0002H/042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H006J\u001c\u00107\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u000202\u0018\u00010-2\u0006\u00108\u001a\u00020\rJ\u0018\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<2\u0006\u00108\u001a\u00020\rJ\u001e\u00109\u001a\u0004\u0018\u00010:2\u0006\u00108\u001a\u00020\r2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0=J^\u0010>\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010@\u0012\u0004\u0012\u00020.0?\u0012\u0004\u0012\u0002H/0-\"\b\b\u0000\u00100*\u000201\"\b\b\u0001\u0010/*\u0002022\u0006\u0010A\u001a\u00020B2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u0002H/042\f\u00105\u001a\b\u0012\u0004\u0012\u0002H006J,\u0010C\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\n2\u0006\u0010D\u001a\u00020\r2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u0002020-H\u0002J\u0010\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010D\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006L"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionSharedCache;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "globalSerMgr", "Lcom/intellij/psi/stubs/SerializationManagerEx;", "stubExternalizer", "Lcom/intellij/psi/stubs/StubForwardIndexExternalizer;", "data", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/rust/lang/core/macros/PersistentCacheData;", "cachedExpandPerMacroLocks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/rust/stdext/HashCode;", "Ljava/util/concurrent/locks/ReentrantLock;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "tryCreateData", "tryCreateFromPrebuiltCache", "", "macroExpansionCacheDir", "Ljava/nio/file/Path;", "isEnabled", "", "()Z", "dispose", "flush", "getOrPut", "Value", "Key", "getMap", "Lkotlin/Function1;", "Lcom/intellij/util/io/PersistentHashMap;", "cacheRetrievingStrategy", "Lorg/rust/lang/core/macros/MacroExpansionSharedCache$CacheRetrievingStrategy;", "key", "afterSuccessWrite", "Lkotlin/Function3;", "computeValue", "(Lkotlin/jvm/functions/Function1;Lorg/rust/lang/core/macros/MacroExpansionSharedCache$CacheRetrievingStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "onError", "lastData", "e", "Ljava/io/IOException;", "cachedExpand", "Lorg/rust/stdext/RsResult;", "Lorg/rust/lang/core/macros/ExpansionResultOk;", "E", "T", "Lorg/rust/lang/core/macros/RsMacroData;", "Lorg/rust/lang/core/macros/errors/MacroExpansionError;", "expander", "Lorg/rust/lang/core/macros/MacroExpander;", "input", "Lorg/rust/lang/core/macros/RsMacroDefAndCallDataWithMixHash;", "getExpansionIfCached", "hash", "cachedBuildStub", "Lcom/intellij/psi/stubs/SerializedStubTree;", "fileContent", "Lcom/intellij/util/indexing/FileContent;", "Lkotlin/Function0;", "createExpansionStub", "Lkotlin/Pair;", "Lorg/rust/lang/core/stubs/RsFileStub;", "project", "Lcom/intellij/openapi/project/Project;", "setRangeMap", "mixHash", "result", "getRangeMap", "Lorg/rust/lang/core/macros/RangeMap;", "CacheRetrievingStrategy", "RetrieveEverythingStrategy", "DontRetrieveSomeErrorsStrategy", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroExpansionSharedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionSharedCache.kt\norg/rust/lang/core/macros/MacroExpansionSharedCache\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 RsResult.kt\norg/rust/stdext/RsResultKt\n+ 6 RsResult.kt\norg/rust/stdext/RsResult\n*L\n1#1,524:1\n13#2:525\n72#3,2:526\n1#4:528\n60#5,4:529\n34#6,4:533\n29#6,4:537\n*S KotlinDebug\n*F\n+ 1 MacroExpansionSharedCache.kt\norg/rust/lang/core/macros/MacroExpansionSharedCache\n*L\n75#1:525\n194#1:526,2\n194#1:528\n243#1:529,4\n200#1:533,4\n199#1:537,4\n*E\n"})
public final class MacroExpansionSharedCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SerializationManagerEx globalSerMgr;
    @NotNull
    private final StubForwardIndexExternalizer<?> stubExternalizer;
    @NotNull
    private final AtomicReference<PersistentCacheData> data;
    @NotNull
    private final ConcurrentHashMap<HashCode, ReentrantLock> cachedExpandPerMacroLocks;
    @NotNull
    private final Logger LOG;
    @NotNull
    public static final String MACRO_EXPANSION_CACHE_ZIP_NAME_PREFIX = "macro-expansion-cache";

    public MacroExpansionSharedCache() {
        SerializationManagerEx serializationManagerEx = SerializationManagerEx.getInstanceEx();
        Intrinsics.checkNotNullExpressionValue((Object)serializationManagerEx, (String)"getInstanceEx(...)");
        this.globalSerMgr = serializationManagerEx;
        StubForwardIndexExternalizer stubForwardIndexExternalizer = StubForwardIndexExternalizer.createFileLocalExternalizer();
        Intrinsics.checkNotNullExpressionValue((Object)stubForwardIndexExternalizer, (String)"createFileLocalExternalizer(...)");
        this.stubExternalizer = stubForwardIndexExternalizer;
        this.data = new AtomicReference<PersistentCacheData>(this.tryCreateData());
        this.cachedExpandPerMacroLocks = new ConcurrentHashMap();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MacroExpansionSharedCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    private final PersistentCacheData tryCreateData() {
        Path macroExpansionCacheDir = MacroExpansionManagerKt.getMacroExpansionCacheDir();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(macroExpansionCacheDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.tryCreateFromPrebuiltCache(macroExpansionCacheDir);
        }
        return PersistentCacheData.Companion.tryCreate(macroExpansionCacheDir, this.stubExternalizer);
    }

    private final void tryCreateFromPrebuiltCache(Path macroExpansionCacheDir) {
        Path cachesDir = RsPathManager.INSTANCE.bundledCachesDir();
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(cachesDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        List prebuiltMacroExpansionCacheZips = SequencesKt.toList((Sequence)SequencesKt.filter(UtilsKt.list(cachesDir), MacroExpansionSharedCache::tryCreateFromPrebuiltCache$lambda$0));
        if (prebuiltMacroExpansionCacheZips.size() > 1) {
            this.LOG.error("Macro cache expansion zip must only contain one zip, but " + prebuiltMacroExpansionCacheZips.size() + " found");
        } else if (prebuiltMacroExpansionCacheZips.size() == 1) {
            Path prebuiltMacroExpansionCacheZip = (Path)CollectionsKt.single((List)prebuiltMacroExpansionCacheZips);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(prebuiltMacroExpansionCacheZip, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                macroExpansionCacheDir.toFile().mkdirs();
                ZipInputStream zipStream = new ZipInputStream(Files.newInputStream(prebuiltMacroExpansionCacheZip, new OpenOption[0]));
                ZipKt.unzipTo(zipStream, macroExpansionCacheDir);
            }
        }
    }

    public final boolean isEnabled() {
        return this.data.get() != null;
    }

    public void dispose() {
        PersistentCacheData lastData;
        do {
            PersistentCacheData persistentCacheData = lastData = this.data.get();
            if (persistentCacheData == null) continue;
            persistentCacheData.close();
        } while (!this.data.compareAndSet(lastData, null));
    }

    public final void flush() {
        block0: {
            PersistentCacheData persistentCacheData = this.data.get();
            if (persistentCacheData == null) break block0;
            persistentCacheData.flush();
        }
    }

    private final <Key, Value> Value getOrPut(Function1<? super PersistentCacheData, PersistentHashMap<Key, Value>> getMap, CacheRetrievingStrategy<? super Value> cacheRetrievingStrategy, Key key, Function3<? super PersistentCacheData, ? super Key, ? super Value, Unit> afterSuccessWrite, Function1<? super SerializationManagerEx, ? extends Value> computeValue) {
        Object object;
        Object object2;
        PersistentCacheData persistentCacheData = this.data.get();
        if (persistentCacheData == null) {
            return (Value)computeValue.invoke((Object)this.globalSerMgr);
        }
        PersistentCacheData data2 = persistentCacheData;
        PersistentHashMap map2 = (PersistentHashMap)getMap.invoke((Object)data2);
        try {
            object2 = map2.get(key);
        }
        catch (IOException e) {
            this.onError(data2, e);
            return (Value)computeValue.invoke((Object)this.globalSerMgr);
        }
        Object existingValue = object2;
        if (existingValue != null && cacheRetrievingStrategy.isRetrievedValueReusable(existingValue)) {
            object = existingValue;
        } else {
            Object newValue = computeValue.invoke((Object)data2.getLocalSerMgr());
            try {
                map2.put(key, newValue);
                Function3<? super PersistentCacheData, ? super Key, ? super Value, Unit> function3 = afterSuccessWrite;
                if (function3 != null) {
                    function3.invoke((Object)data2, key, newValue);
                }
            }
            catch (IOException e) {
                this.onError(data2, e);
            }
            object = newValue;
        }
        return (Value)object;
    }

    static /* synthetic */ Object getOrPut$default(MacroExpansionSharedCache macroExpansionSharedCache, Function1 function1, CacheRetrievingStrategy cacheRetrievingStrategy, Object object, Function3 function3, Function1 function12, int n, Object object2) {
        if ((n & 8) != 0) {
            function3 = null;
        }
        return macroExpansionSharedCache.getOrPut(function1, cacheRetrievingStrategy, object, function3, function12);
    }

    private final void onError(PersistentCacheData lastData, IOException e) {
        if (this.data.compareAndSet(lastData, null)) {
            lastData.close();
        }
        MacroExpansionManagerKt.MACRO_LOG.warn((Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends RsMacroData, E extends MacroExpansionError> RsResult<ExpansionResultOk, E> cachedExpand(@NotNull MacroExpander<? super T, ? extends E> expander, @NotNull RsMacroDefAndCallDataWithMixHash<T> input) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(expander, (String)"expander");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Object object = this.cachedExpandPerMacroLocks;
        HashCode key$iv = input.getMixHash();
        boolean $i$f$getOrPut = false;
        Object object2 = $this$getOrPut$iv.get(key$iv);
        if (object2 == null) {
            boolean bl = false;
            ReentrantLock default$iv = new ReentrantLock();
            boolean bl2 = false;
            object2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        }
        ReentrantLock lock = (ReentrantLock)object2;
        try {
            Intrinsics.checkNotNull((Object)lock);
            object = (RsResult)ConcurrencyKt.withLockAndCheckingCancelled(lock, () -> MacroExpansionSharedCache.cachedExpand$lambda$1(this, input, expander));
        }
        finally {
            this.cachedExpandPerMacroLocks.remove(input.getMixHash());
        }
        return object;
    }

    @Nullable
    public final RsResult<ExpansionResultOk, MacroExpansionError> getExpansionIfCached(@NotNull HashCode hash) {
        RsResult rsResult;
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        PersistentCacheData persistentCacheData = this.data.get();
        if (persistentCacheData == null) {
            return null;
        }
        PersistentCacheData data2 = persistentCacheData;
        PersistentHashMap<HashCode, RsResult<ExpansionResultOk, MacroExpansionError>> map2 = data2.getExpansions();
        try {
            rsResult = (RsResult)map2.get((Object)hash);
        }
        catch (IOException e) {
            this.onError(data2, e);
            rsResult = null;
        }
        return rsResult;
    }

    @Nullable
    public final SerializedStubTree cachedBuildStub(@NotNull FileContent fileContent2, @NotNull HashCode hash) {
        Intrinsics.checkNotNullParameter((Object)fileContent2, (String)"fileContent");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        return this.cachedBuildStub(hash, (Function0<? extends FileContent>)((Function0)() -> MacroExpansionSharedCache.cachedBuildStub$lambda$0(fileContent2)));
    }

    @Nullable
    public final SerializedStubTree cachedBuildStub(@NotNull HashCode hash, @NotNull Function0<? extends FileContent> fileContent2) {
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter(fileContent2, (String)"fileContent");
        return (SerializedStubTree)MacroExpansionSharedCache.getOrPut$default(this, (Function1)cachedBuildStub.2.INSTANCE, RetrieveEverythingStrategy.INSTANCE, hash, null, arg_0 -> MacroExpansionSharedCache.cachedBuildStub$lambda$1(fileContent2, this, arg_0), 8, null);
    }

    @NotNull
    public final <T extends RsMacroData, E extends MacroExpansionError> RsResult<Pair<RsFileStub, ExpansionResultOk>, E> createExpansionStub(@NotNull Project project, @NotNull MacroExpander<? super T, ? extends E> expander, @NotNull RsMacroDefAndCallDataWithMixHash<T> input) {
        Stub stub;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(expander, (String)"expander");
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Stub $this$unwrapOrElse$iv = this.cachedExpand(expander, input);
        boolean $i$f$unwrapOrElse = false;
        Stub stub2 = $this$unwrapOrElse$iv;
        if (!(stub2 instanceof RsResult.Ok)) {
            if (stub2 instanceof RsResult.Err) {
                MacroExpansionError it2 = (MacroExpansionError)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl = false;
                return new RsResult.Err<MacroExpansionError>(it2);
            }
            throw new NoWhenBranchMatchedException();
        }
        ExpansionResultOk result2 = (ExpansionResultOk)((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        SerializedStubTree serializedStubTree = this.cachedBuildStub(input.getMixHash(), (Function0<? extends FileContent>)((Function0)() -> MacroExpansionSharedCache.createExpansionStub$lambda$1(result2, project)));
        if (serializedStubTree == null) {
            return new RsResult.Ok<Pair>(TuplesKt.to(null, (Object)result2));
        }
        SerializedStubTree serializedStub = serializedStubTree;
        try {
            stub = serializedStub.getStub();
        }
        catch (SerializerNotFoundException e) {
            MacroExpansionManagerKt.MACRO_LOG.error((Throwable)e);
            return new RsResult.Ok<Pair>(TuplesKt.to(null, (Object)result2));
        }
        stub2 = stub;
        Intrinsics.checkNotNull((Object)stub2);
        Stub stub3 = stub2;
        if (stub3 == SerializedStubTree.NO_STUB) {
            return new RsResult.Ok<Pair>(TuplesKt.to(null, (Object)result2));
        }
        return new RsResult.Ok<Pair>(TuplesKt.to((Object)((RsFileStub)stub3), (Object)result2));
    }

    private final void setRangeMap(PersistentCacheData data2, HashCode mixHash, RsResult<ExpansionResultOk, ? extends MacroExpansionError> result2) {
        ExpansionResultOk expansionResultOk = result2.ok();
        if (expansionResultOk == null) {
            return;
        }
        ExpansionResultOk expansionResult = expansionResultOk;
        data2.getRanges().put((Object)mixHash, (Object)expansionResult.getRanges());
    }

    @Nullable
    public final RangeMap getRangeMap(@NotNull HashCode mixHash) {
        RangeMap rangeMap;
        Intrinsics.checkNotNullParameter((Object)mixHash, (String)"mixHash");
        PersistentCacheData persistentCacheData = this.data.get();
        if (persistentCacheData == null) {
            return null;
        }
        PersistentCacheData data2 = persistentCacheData;
        PersistentHashMap<HashCode, RangeMap> map2 = data2.getRanges();
        try {
            rangeMap = (RangeMap)map2.get((Object)mixHash);
        }
        catch (IOException e) {
            this.onError(data2, e);
            rangeMap = null;
        }
        return rangeMap;
    }

    private static final boolean tryCreateFromPrebuiltCache$lambda$0(Path it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getFileName().startsWith(MACRO_EXPANSION_CACHE_ZIP_NAME_PREFIX) && Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it2), (Object)".zip");
    }

    private static final RsResult cachedExpand$lambda$1(MacroExpansionSharedCache this$0, RsMacroDefAndCallDataWithMixHash $input, MacroExpander $expander) {
        RsResult rsResult;
        RsResult this_$iv = (RsResult)this$0.getOrPut((Function1)cachedExpand.1.1.INSTANCE, DontRetrieveSomeErrorsStrategy.INSTANCE, $input.getMixHash(), (Function3)new Function3<PersistentCacheData, HashCode, RsResult<? extends ExpansionResultOk, ? extends MacroExpansionError>, Unit>((Object)this$0){

            public final void invoke(PersistentCacheData p0, HashCode p1, RsResult<ExpansionResultOk, ? extends MacroExpansionError> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                MacroExpansionSharedCache.access$setRangeMap((MacroExpansionSharedCache)this.receiver, p0, p1, p2);
            }
        }, arg_0 -> MacroExpansionSharedCache.cachedExpand$lambda$1$0($expander, $input, arg_0));
        boolean $i$f$mapErr = false;
        RsResult rsResult2 = this_$iv;
        if (rsResult2 instanceof RsResult.Ok) {
            rsResult = new RsResult.Ok(((RsResult.Ok)this_$iv).getOk());
        } else if (rsResult2 instanceof RsResult.Err) {
            MacroExpansionError it2 = (MacroExpansionError)((RsResult.Err)this_$iv).getErr();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2, (String)"null cannot be cast to non-null type E of org.rust.lang.core.macros.MacroExpansionSharedCache.cachedExpand");
            MacroExpansionError macroExpansionError = it2;
            rsResult = new RsResult.Err<MacroExpansionError>(macroExpansionError);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsResult;
    }

    private static final RsResult cachedExpand$lambda$1$0(MacroExpander $expander, RsMacroDefAndCallDataWithMixHash $input, SerializationManagerEx it2) {
        RsResult rsResult;
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        RsResult this_$iv = $expander.expandMacroAsTextWithErr($input.getDef(), $input.getCall());
        boolean $i$f$map = false;
        RsResult rsResult2 = this_$iv;
        if (rsResult2 instanceof RsResult.Ok) {
            Pair it3 = (Pair)((RsResult.Ok)this_$iv).getOk();
            boolean bl = false;
            ExpansionResultOk expansionResultOk = new ExpansionResultOk(it3.getFirst().toString(), (RangeMap)it3.getSecond(), null, 4, null);
            rsResult = new RsResult.Ok<ExpansionResultOk>(expansionResultOk);
        } else if (rsResult2 instanceof RsResult.Err) {
            rsResult = new RsResult.Err(((RsResult.Err)this_$iv).getErr());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rsResult;
    }

    private static final FileContent cachedBuildStub$lambda$0(FileContent $fileContent) {
        return $fileContent;
    }

    private static final SerializedStubTree cachedBuildStub$lambda$1(Function0 $fileContent, MacroExpansionSharedCache this$0, SerializationManagerEx serMgr) {
        Intrinsics.checkNotNullParameter((Object)serMgr, (String)"serMgr");
        FileContent fc = (FileContent)$fileContent.invoke();
        Stub stub = StubTreeBuilder.buildStubTree((FileContent)fc);
        if (stub == null) {
            return null;
        }
        Stub stub2 = stub;
        return SerializedStubTree.serializeStub((Stub)stub2, (StubTreeSerializer)((StubTreeSerializer)serMgr), this$0.stubExternalizer);
    }

    private static final FileContent createExpansionStub$lambda$1(ExpansionResultOk $result, Project $project) {
        ReadOnlyLightVirtualFile file = new ReadOnlyLightVirtualFile("macro.rs", (Language)RsLanguage.INSTANCE, (CharSequence)$result.getText());
        FileContent fileContent2 = FileContentImpl.createByText((VirtualFile)((VirtualFile)file), (CharSequence)$result.getText(), (Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)fileContent2, (String)"createByText(...)");
        return fileContent2;
    }

    @JvmStatic
    @NotNull
    public static final MacroExpansionSharedCache getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ void access$setRangeMap(MacroExpansionSharedCache $this, PersistentCacheData data2, HashCode mixHash, RsResult result2) {
        $this.setRangeMap(data2, mixHash, result2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bb\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionSharedCache$CacheRetrievingStrategy;", "T", "", "isRetrievedValueReusable", "", "value", "(Ljava/lang/Object;)Z", "intellij.rustrover.core"})
    private static interface CacheRetrievingStrategy<T> {
        public boolean isRetrievedValueReusable(T var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionSharedCache$Companion;", "", "<init>", "()V", "getInstance", "Lorg/rust/lang/core/macros/MacroExpansionSharedCache;", "MACRO_EXPANSION_CACHE_ZIP_NAME_PREFIX", "", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nMacroExpansionSharedCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionSharedCache.kt\norg/rust/lang/core/macros/MacroExpansionSharedCache$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,524:1\n42#2,3:525\n*S KotlinDebug\n*F\n+ 1 MacroExpansionSharedCache.kt\norg/rust/lang/core/macros/MacroExpansionSharedCache$Companion\n*L\n286#1:525,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MacroExpansionSharedCache getInstance() {
            boolean $i$f$service = false;
            Class<MacroExpansionSharedCache> serviceClass$iv = MacroExpansionSharedCache.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (MacroExpansionSharedCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionSharedCache$DontRetrieveSomeErrorsStrategy;", "Lorg/rust/lang/core/macros/MacroExpansionSharedCache$CacheRetrievingStrategy;", "Lorg/rust/stdext/RsResult;", "Lorg/rust/lang/core/macros/ExpansionResultOk;", "Lorg/rust/lang/core/macros/errors/MacroExpansionError;", "<init>", "()V", "isRetrievedValueReusable", "", "value", "intellij.rustrover.core"})
    private static final class DontRetrieveSomeErrorsStrategy
    implements CacheRetrievingStrategy<RsResult<? extends ExpansionResultOk, ? extends MacroExpansionError>> {
        @NotNull
        public static final DontRetrieveSomeErrorsStrategy INSTANCE = new DontRetrieveSomeErrorsStrategy();

        private DontRetrieveSomeErrorsStrategy() {
        }

        @Override
        public boolean isRetrievedValueReusable(@NotNull RsResult<ExpansionResultOk, ? extends MacroExpansionError> value) {
            boolean bl;
            Intrinsics.checkNotNullParameter(value, (String)"value");
            RsResult<ExpansionResultOk, ? extends MacroExpansionError> rsResult = value;
            if (rsResult instanceof RsResult.Ok) {
                bl = true;
            } else if (rsResult instanceof RsResult.Err) {
                bl = MacroExpansionErrorKt.canCacheError((MacroExpansionError)((RsResult.Err)value).getErr());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionSharedCache$RetrieveEverythingStrategy;", "Lorg/rust/lang/core/macros/MacroExpansionSharedCache$CacheRetrievingStrategy;", "", "<init>", "()V", "isRetrievedValueReusable", "", "value", "intellij.rustrover.core"})
    private static final class RetrieveEverythingStrategy
    implements CacheRetrievingStrategy<Object> {
        @NotNull
        public static final RetrieveEverythingStrategy INSTANCE = new RetrieveEverythingStrategy();

        private RetrieveEverythingStrategy() {
        }

        @Override
        public boolean isRetrievedValueReusable(@Nullable Object value) {
            return true;
        }
    }
}

