/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TemplateResultListener;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLargeFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rust.RsBundle;
import org.rust.RsProjectTaskQueueServiceKt;
import org.rust.RsTask;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.settings.RsProjectSettingsServiceBase;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.ide.experiments.RsExperiments;
import org.rust.lang.RsFileType;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.crate.CrateGraphServiceKt;
import org.rust.lang.core.macros.Dirs;
import org.rust.lang.core.macros.ExpansionResultOk;
import org.rust.lang.core.macros.MacroExpansion;
import org.rust.lang.core.macros.MacroExpansionContext;
import org.rust.lang.core.macros.MacroExpansionKt;
import org.rust.lang.core.macros.MacroExpansionManager;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.MacroExpansionMode;
import org.rust.lang.core.macros.MacroExpansionScope;
import org.rust.lang.core.macros.MacroExpansionServiceImplInner;
import org.rust.lang.core.macros.MacroExpansionSharedCache;
import org.rust.lang.core.macros.MacroExpansionTask;
import org.rust.lang.core.macros.MacroExpansionTaskKt;
import org.rust.lang.core.macros.RsExpandedElement;
import org.rust.lang.core.macros.RsMacroDataWithHash;
import org.rust.lang.core.macros.RsProcMacroData;
import org.rust.lang.core.macros.errors.GetMacroExpansionError;
import org.rust.lang.core.macros.errors.GetMacroExpansionErrorKt;
import org.rust.lang.core.macros.errors.MacroExpansionError;
import org.rust.lang.core.macros.errors.ProcMacroExpansionError;
import org.rust.lang.core.macros.errors.ResolveMacroWithoutPsiError;
import org.rust.lang.core.macros.filesystem.MacroExpansionFileSystem;
import org.rust.lang.core.macros.filesystem.MacroExpansionFileSystemKt;
import org.rust.lang.core.psi.ProcMacroAttribute;
import org.rust.lang.core.psi.ProcMacroAttributeUnresolved;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsProcMacroKind;
import org.rust.lang.core.psi.RsProcMacroPsiUtil;
import org.rust.lang.core.psi.RsPsiManager;
import org.rust.lang.core.psi.RsPsiManagerKt;
import org.rust.lang.core.psi.RsPsiTreeChangeAdapter;
import org.rust.lang.core.psi.RsPsiTreeChangeEvent;
import org.rust.lang.core.psi.RustPsiChangeListener;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsAttrProcMacroOwner;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsMetaItemKt;
import org.rust.lang.core.psi.ext.RsModificationTrackerOwnerKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKind;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKt;
import org.rust.lang.core.resolve2.ChangedFile;
import org.rust.lang.core.resolve2.CrateDefMap;
import org.rust.lang.core.resolve2.DefMapService;
import org.rust.lang.core.resolve2.DefMapServiceKt;
import org.rust.lang.core.resolve2.FacadeResolveKt;
import org.rust.lang.core.resolve2.FacadeUpdateDefMapKt;
import org.rust.lang.core.resolve2.FileInclusionPoint;
import org.rust.lang.core.resolve2.FileInclusionType;
import org.rust.lang.core.resolve2.ItemPointer;
import org.rust.lang.core.resolve2.MacroCallLightInfo;
import org.rust.lang.core.resolve2.MacroIndex;
import org.rust.lang.core.resolve2.ModData;
import org.rust.lang.core.resolve2.ProcMacroDefInfo;
import org.rust.lang.core.resolve2.ProcMacroMetadata;
import org.rust.lang.core.resolve2.RsModInfo;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.HashCode;
import org.rust.stdext.RsResult;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001:\u0004\u0095\u0001\u0096\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020\tJ\u001c\u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u000200\u0018\u00010/2\u0006\u00101\u001a\u00020\tJ\u000e\u00102\u001a\u000203H\u0086@\u00a2\u0006\u0002\u00104J2\u00105\u001a\u0002H6\"\u0004\b\u0000\u001062\u001c\u00107\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H609\u0012\u0006\u0012\u0004\u0018\u00010\u000108H\u0082@\u00a2\u0006\u0002\u0010:J\u0006\u0010;\u001a\u000203J\b\u0010<\u001a\u000203H\u0002J\b\u0010=\u001a\u000203H\u0002J\u0010\u0010>\u001a\u0002032\u0006\u0010?\u001a\u00020@H\u0002J\u000e\u0010A\u001a\u0002032\u0006\u0010B\u001a\u00020CJ\u0010\u0010D\u001a\u0002032\u0006\u0010E\u001a\u00020CH\u0002J\b\u0010F\u001a\u000203H\u0002J\b\u0010G\u001a\u000203H\u0002J\u0006\u0010H\u001a\u000203J\b\u0010N\u001a\u000203H\u0002J\b\u0010O\u001a\u000203H\u0002J\u0010\u0010P\u001a\u0002032\u0006\u0010Q\u001a\u00020RH\u0002J\b\u0010S\u001a\u00020'H\u0002J!\u0010T\u001a\b\u0012\u0004\u0012\u0002H60U\"\u0004\b\u0000\u001062\u0006\u0010V\u001a\u0002H6H\u0002\u00a2\u0006\u0002\u0010WJ$\u0010X\u001a\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020[0Y0Uj\u0002`\\2\u0006\u0010]\u001a\u00020^J&\u0010_\u001a\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u00020[0Y0Uj\u0002`\\2\u0006\u0010`\u001a\u00020[H\u0002J\u0010\u0010a\u001a\u0004\u0018\u00010^2\u0006\u0010b\u001a\u00020cJ\u0012\u0010d\u001a\u0004\u0018\u00010^2\u0006\u0010e\u001a\u00020fH\u0002J\u0012\u0010g\u001a\u0004\u0018\u00010^2\u0006\u0010e\u001a\u00020fH\u0002J\u0010\u0010h\u001a\u0004\u0018\u00010i2\u0006\u0010-\u001a\u00020fJ\u0012\u0010j\u001a\u0004\u0018\u00010i2\u0006\u0010-\u001a\u00020fH\u0002J\u001e\u0010k\u001a\u0010\u0012\u0004\u0012\u00020l\u0012\u0004\u0012\u00020m\u0018\u00010/2\u0006\u0010-\u001a\u00020fH\u0002J\u0010\u0010n\u001a\u0004\u0018\u00010o2\u0006\u0010p\u001a\u00020fJ\u0010\u0010q\u001a\u0004\u0018\u00010o2\u0006\u0010p\u001a\u00020fJ0\u0010r\u001a\u0004\u0018\u00010^2\u0006\u0010s\u001a\u00020l2\u0006\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020w2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020\u001aJ'\u0010{\u001a\u0004\u0018\u00010^*\u00020|2\u0006\u0010}\u001a\u00020\u001a2\u0006\u0010~\u001a\u00020'2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0002J&\u0010\u0081\u0001\u001a\u0004\u0018\u00010\t2\u0006\u0010x\u001a\u00020y2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002\u00a2\u0006\u0006\b\u0084\u0001\u0010\u0085\u0001J$\u0010\u0086\u0001\u001a\u0004\u0018\u00010\t2\u000b\u0010\u0087\u0001\u001a\u00060\u001aj\u0002`\u001b2\f\u0010\u0088\u0001\u001a\u000700j\u0003`\u0089\u0001J7\u0010\u008a\u0001\u001a\u00020[2\u0006\u0010]\u001a\u00020^2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010x\u001a\u00020y2\n\u0010\u0082\u0001\u001a\u0005\u0018\u00010\u0083\u0001H\u0002\u00a2\u0006\u0006\b\u008b\u0001\u0010\u008c\u0001J\u001f\u0010\u008d\u0001\u001a\u0010\u0012\u0004\u0012\u00020y\u0012\u0004\u0012\u000200\u0018\u00010/2\u0006\u0010-\u001a\u00020fH\u0002J\u001b\u0010\u008e\u0001\u001a\u00020C2\u0007\u0010\u008f\u0001\u001a\u00020'2\u0007\u0010\u0090\u0001\u001a\u00020'H\u0007J\t\u0010\u0091\u0001\u001a\u000203H\u0007J\u0012\u0010\u0092\u0001\u001a\u0002032\u0007\u0010\u0093\u0001\u001a\u00020'H\u0007J\u001b\u0010\u0094\u0001\u001a\u0002032\u0007\u0010\u008f\u0001\u001a\u00020'2\u0007\u0010\u0090\u0001\u001a\u00020'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\b\u0012\u00060\u001aj\u0002`\u001b\u0012\u0004\u0012\u00020\u00170\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020!8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001e\u0010&\u001a\u00020'8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010I\u001a\u00020J8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0011\u0010M\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010)\u00a8\u0006\u0097\u0001"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionServiceImplInner;", "", "project", "Lcom/intellij/openapi/project/Project;", "dirs", "Lorg/rust/lang/core/macros/Dirs;", "macroExpansionProject", "Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionProject;", "indexableDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/rust/lang/core/macros/Dirs;Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionProject;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getDirs", "()Lorg/rust/lang/core/macros/Dirs;", "getMacroExpansionProject", "()Lorg/rust/lang/core/macros/filesystem/MacroExpansionFileSystem$MacroExpansionProject;", "getIndexableDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "modificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "getModificationTracker", "()Lcom/intellij/openapi/util/SimpleModificationTracker;", "lastSavedStorageModCount", "", "lastUpdatedMacrosAt", "", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "dataFile", "Ljava/nio/file/Path;", "getDataFile", "()Ljava/nio/file/Path;", "macroExpansionMode", "Lorg/rust/lang/core/macros/MacroExpansionScope;", "getMacroExpansionMode", "()Lorg/rust/lang/core/macros/MacroExpansionScope;", "setMacroExpansionMode", "(Lorg/rust/lang/core/macros/MacroExpansionScope;)V", "enabledInUnitTests", "", "getEnabledInUnitTests", "()Z", "setEnabledInUnitTests", "(Z)V", "isExpansionFileOfCurrentProject", "file", "getCrateForExpansionFile", "Lkotlin/Pair;", "", "virtualFile", "save", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "withIoContextIfNotUnitTestMode", "T", "block", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "releaseExpansionDirectory", "cleanMacrosDirectoryAndStorage", "submitTask", "task", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "stateLoaded", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "setupListeners", "disposable", "deleteOldExpansionDir", "settingsChanged", "reexpand", "expansionMode", "Lorg/rust/lang/core/macros/MacroExpansionMode;", "getExpansionMode", "()Lorg/rust/lang/core/macros/MacroExpansionMode;", "isExpansionModeNew", "processUnprocessedMacros", "processChangedMacros", "processMacros", "taskType", "Lorg/rust/RsTask$TaskType;", "isIntellijTemplateActiveInAnyEditor", "everChanged", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "result", "(Ljava/lang/Object;)Lcom/intellij/psi/util/CachedValueProvider$Result;", "getExpansionFor", "Lorg/rust/stdext/RsResult;", "Lorg/rust/lang/core/macros/MacroExpansion;", "Lorg/rust/lang/core/macros/errors/GetMacroExpansionError;", "Lorg/rust/lang/core/macros/MacroExpansionCachedResult;", "call", "Lorg/rust/lang/core/psi/ext/RsPossibleMacroCall;", "withPsiModCount", "err", "getExpandedFrom", "element", "Lorg/rust/lang/core/macros/RsExpandedElement;", "getExpandedFromByExpansionFile", "parent", "Lorg/rust/lang/core/psi/RsFile;", "doGetExpandedFromForExpansionFile", "getIncludedFrom", "Lorg/rust/lang/core/psi/RsMacroCall;", "doGetIncludedFrom", "getIncludeMacroIndex", "Lorg/rust/lang/core/resolve2/ItemPointer;", "Lorg/rust/lang/core/resolve2/RsModInfo;", "getContextOfMacroCallExpandedFrom", "Lcom/intellij/psi/PsiElement;", "stubParent", "doGetContextOfMacroCallExpandedFrom", "findMacroCallByPointer", "macroPointer", "kind", "Lorg/rust/lang/core/psi/RsProcMacroKind;", "modData", "Lorg/rust/lang/core/resolve2/ModData;", "defMap", "Lorg/rust/lang/core/resolve2/CrateDefMap;", "indexOfDerive", "findAttrOrDeriveMacroCall", "Lorg/rust/lang/core/psi/ext/RsAttrProcMacroOwner;", "macroIndexInParent", "isDerive", "crate", "Lorg/rust/lang/core/crate/Crate;", "getExpansionVirtualFile", "callIndex", "Lorg/rust/lang/core/resolve2/MacroIndex;", "getExpansionVirtualFile-S-FK_iQ", "(Lorg/rust/lang/core/resolve2/CrateDefMap;Lkotlinx/collections/immutable/PersistentList;)Lcom/intellij/openapi/vfs/VirtualFile;", "getExpansionFileByName", "crateId", "expansionFileName", "Lorg/rust/lang/core/resolve2/MacroExpansionFileName;", "getReasonWhyExpansionFileNotFound", "getReasonWhyExpansionFileNotFound-ZVhftvM", "(Lorg/rust/lang/core/psi/ext/RsPossibleMacroCall;Lorg/rust/lang/core/crate/Crate;Lorg/rust/lang/core/resolve2/CrateDefMap;Lkotlinx/collections/immutable/PersistentList;)Lorg/rust/lang/core/macros/errors/GetMacroExpansionError;", "getDefMapForExpansionFile", "setupForUnitTests", "saveCacheOnDispose", "clearCacheBeforeDispose", "updateInUnitTestMode", "setMacroExpansionEnabled", "enabled", "disposeUnitTest", "ChangedMacrosScope", "ChangedMacroUpdater", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMacroExpansionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionManager.kt\norg/rust/lang/core/macros/MacroExpansionServiceImplInner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 utils.kt\norg/rust/openapiext/UtilsKt\n+ 5 RsResult.kt\norg/rust/stdext/RsResultKt\n*L\n1#1,1226:1\n1#2:1227\n1#2:1238\n1617#3,9:1228\n1869#3:1237\n1870#3:1239\n1626#3:1240\n305#4,10:1241\n60#5,4:1251\n*S KotlinDebug\n*F\n+ 1 MacroExpansionManager.kt\norg/rust/lang/core/macros/MacroExpansionServiceImplInner\n*L\n904#1:1238\n904#1:1228,9\n904#1:1237\n904#1:1239\n904#1:1240\n924#1:1241,10\n964#1:1251,4\n*E\n"})
final class MacroExpansionServiceImplInner {
    @NotNull
    private final Project project;
    @NotNull
    private final Dirs dirs;
    @NotNull
    private final MacroExpansionFileSystem.MacroExpansionProject macroExpansionProject;
    @NotNull
    private final VirtualFile indexableDirectory;
    @NotNull
    private final SimpleModificationTracker modificationTracker;
    private volatile long lastSavedStorageModCount;
    @NotNull
    private final Map<Integer, Long> lastUpdatedMacrosAt;
    @TestOnly
    @NotNull
    private MacroExpansionScope macroExpansionMode;
    @TestOnly
    private boolean enabledInUnitTests;

    public MacroExpansionServiceImplInner(@NotNull Project project, @NotNull Dirs dirs, @NotNull MacroExpansionFileSystem.MacroExpansionProject macroExpansionProject, @NotNull VirtualFile indexableDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dirs, (String)"dirs");
        Intrinsics.checkNotNullParameter((Object)macroExpansionProject, (String)"macroExpansionProject");
        Intrinsics.checkNotNullParameter((Object)indexableDirectory, (String)"indexableDirectory");
        this.project = project;
        this.dirs = dirs;
        this.macroExpansionProject = macroExpansionProject;
        this.indexableDirectory = indexableDirectory;
        this.modificationTracker = new SimpleModificationTracker();
        this.lastSavedStorageModCount = this.modificationTracker.getModificationCount();
        this.lastUpdatedMacrosAt = new HashMap();
        this.macroExpansionMode = MacroExpansionScope.NONE;
        this.enabledInUnitTests = true;
    }

    @NotNull
    public final Dirs getDirs() {
        return this.dirs;
    }

    @NotNull
    public final MacroExpansionFileSystem.MacroExpansionProject getMacroExpansionProject() {
        return this.macroExpansionProject;
    }

    @NotNull
    public final VirtualFile getIndexableDirectory() {
        return this.indexableDirectory;
    }

    @NotNull
    public final SimpleModificationTracker getModificationTracker() {
        return this.modificationTracker;
    }

    private final Path getDataFile() {
        return this.dirs.getDataFile();
    }

    @NotNull
    public final MacroExpansionScope getMacroExpansionMode() {
        return this.macroExpansionMode;
    }

    public final void setMacroExpansionMode(@NotNull MacroExpansionScope macroExpansionScope) {
        Intrinsics.checkNotNullParameter((Object)((Object)macroExpansionScope), (String)"<set-?>");
        this.macroExpansionMode = macroExpansionScope;
    }

    public final boolean getEnabledInUnitTests() {
        return this.enabledInUnitTests;
    }

    public final void setEnabledInUnitTests(boolean bl) {
        this.enabledInUnitTests = bl;
    }

    public final boolean isExpansionFileOfCurrentProject(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.macroExpansionProject.isOwnsVirtualFile(file);
    }

    @Nullable
    public final Pair<Integer, String> getCrateForExpansionFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!this.isExpansionFileOfCurrentProject(virtualFile)) {
            return null;
        }
        String string = MacroExpansionFileSystemKt.getMacroExpansionName(virtualFile);
        if (string == null) {
            return null;
        }
        String expansionName = string;
        String string2 = virtualFile.getParent().getParent().getParent().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Integer n = StringsKt.toIntOrNull((String)string2);
        if (n == null) {
            return null;
        }
        int crateId = n;
        return TuplesKt.to((Object)crateId, (Object)expansionName);
    }

    @Nullable
    public final Object save(@NotNull Continuation<? super Unit> $completion) {
        if (this.lastSavedStorageModCount == this.modificationTracker.getModificationCount()) {
            return Unit.INSTANCE;
        }
        Object object = this.withIoContextIfNotUnitTestMode((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ MacroExpansionServiceImplInner this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Pair pair = (Pair)ActionsKt.runReadAction(() -> save.2.invokeSuspend$lambda$0(this.this$0));
                        BufferExposingByteArrayOutputStream buffer = (BufferExposingByteArrayOutputStream)pair.component1();
                        long modCount = ((Number)pair.component2()).longValue();
                        Files.createDirectories(MacroExpansionServiceImplInner.access$getDataFile(this.this$0).getParent(), new FileAttribute[0]);
                        Closeable closeable = org.rust.stdext.PathKt.newDeflaterDataOutputStream(MacroExpansionServiceImplInner.access$getDataFile(this.this$0));
                        Throwable throwable = null;
                        try {
                            java.io.DataOutputStream it2 = (java.io.DataOutputStream)closeable;
                            boolean bl = false;
                            it2.write(buffer.getInternalBuffer());
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        MacroExpansionFileSystem.Helper.INSTANCE.saveProjectDirs();
                        MacroExpansionServiceImplInner.access$setLastSavedStorageModCount$p(this.this$0, modCount);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final Pair invokeSuspend$lambda$0(MacroExpansionServiceImplInner this$0) {
                BufferExposingByteArrayOutputStream buffer = new BufferExposingByteArrayOutputStream(0x100000);
                Closeable closeable = (Closeable)new DataOutputStream((OutputStream)buffer);
                Throwable throwable = null;
                try {
                    DataOutputStream data2 = (DataOutputStream)closeable;
                    boolean bl = false;
                    MacroExpansionFileSystem vfs = MacroExpansionFileSystem.Helper.INSTANCE.getInstance();
                    vfs.writeProjectData(this$0.getDirs().getProjectDirName(), data2);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return TuplesKt.to((Object)buffer, (Object)this$0.getModificationTracker().getModificationCount());
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final <T> Object withIoContextIfNotUnitTestMode(Function1<? super Continuation<? super T>, ? extends Object> block, Continuation<? super T> $completion) {
        if (UtilsKt.isUnitTestMode()) {
            return block.invoke($completion);
        }
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)new Function2<CoroutineScope, Continuation<? super T>, Object>(block, null){
            int label;
            final /* synthetic */ Function1<Continuation<? super T>, Object> $block;
            {
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$block.invoke((Object)((Object)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super T> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    public final void dispose() {
        if (!UtilsKt.isUnitTestMode()) {
            this.releaseExpansionDirectory();
        }
    }

    private final void releaseExpansionDirectory() {
        MacroExpansionFileSystem macroExpansionFileSystem = MacroExpansionFileSystem.Helper.INSTANCE.getInstanceOrNull();
        if (macroExpansionFileSystem == null) {
            return;
        }
        MacroExpansionFileSystem vfs = macroExpansionFileSystem;
        vfs.releaseExpansionDirectory(this.macroExpansionProject);
    }

    private final void cleanMacrosDirectoryAndStorage() {
        Project project = this.project;
        String string = RsBundle.INSTANCE.message("progress.title.cleaning.outdated.macros", new Object[0]);
        this.submitTask((Task.Backgroundable)new RsTask(this, project, string){
            final /* synthetic */ MacroExpansionServiceImplInner this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                if (!UtilsKt.isUnitTestMode()) {
                    UtilsKt.checkReadAccessNotAllowed();
                }
                this.this$0.getMacroExpansionProject().clean();
                this.this$0.getMacroExpansionProject().init();
                PathKt.delete$default((Path)this.this$0.getDirs().getDataFile(), (boolean)false, (int)1, null);
                WriteAction.runAndWait(() -> cleanMacrosDirectoryAndStorage.1.run$lambda$0(this.this$0, this));
            }

            public boolean getRunSyncInUnitTests() {
                return true;
            }

            public RsTask.TaskType getTaskType() {
                return RsTask.TaskType.MACROS_CLEAR;
            }

            private static final void run$lambda$0(MacroExpansionServiceImplInner this$0, cleanMacrosDirectoryAndStorage.1 this$1) {
                this$0.getMacroExpansionProject().markDirtyAndRefresh();
                this$0.getModificationTracker().incModificationCount();
                if (!this$1.getProject().isDisposed()) {
                    Project project = this$1.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    RsPsiManagerKt.getRustPsiManager(project).incRustStructureModificationCount();
                }
            }
        });
    }

    private final void submitTask(Task.Backgroundable task2) {
        RsProjectTaskQueueServiceKt.getTaskQueue(this.project).run(task2);
    }

    public final void stateLoaded(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        if (!(!UtilsKt.isUnitTestMode())) {
            throw new IllegalStateException("Check failed.");
        }
        UtilsKt.checkWriteAccessAllowed();
        this.setupListeners(parentDisposable);
        this.deleteOldExpansionDir();
        CargoProjectsService cargoProjects = CargoProjectServiceKt.getCargoProjects(this.project);
        if (!cargoProjects.getInitialized()) {
            MacroExpansionManagerKt.MACRO_LOG.debug("Loading MacroExpansionManager finished - no events fired");
        } else if (!cargoProjects.getHasAtLeastOneValidProject()) {
            this.cleanMacrosDirectoryAndStorage();
            MacroExpansionManagerKt.MACRO_LOG.debug("Loading MacroExpansionManager finished - no rust projects");
        } else {
            ProjectRootManagerEx.getInstanceEx((Project)this.project).makeRootsChange(EmptyRunnable.getInstance(), RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED);
            this.processUnprocessedMacros();
            MacroExpansionManagerKt.MACRO_LOG.debug("Loading MacroExpansionManager finished - roots change fired");
        }
    }

    private final void setupListeners(Disposable disposable) {
        ChangedMacroUpdater treeChangeListener = new ChangedMacroUpdater();
        PsiManager.getInstance((Project)this.project).addPsiTreeChangeListener((PsiTreeChangeListener)treeChangeListener, disposable);
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)treeChangeListener, disposable);
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)treeChangeListener, disposable);
        MessageBusConnection connect = this.project.getMessageBus().connect(disposable);
        connect.subscribe(CargoProjectsService.Companion.getCARGO_PROJECTS_TOPIC(), (Object)treeChangeListener);
        RsPsiManagerKt.getRustPsiManager(this.project).subscribeRustPsiChange(connect, treeChangeListener);
        connect.subscribe(RsProjectSettingsServiceBase.Companion.getRUST_SETTINGS_TOPIC(), (Object)new RsProjectSettingsServiceBase.RsSettingsListener(this){
            final /* synthetic */ MacroExpansionServiceImplInner this$0;
            {
                this.this$0 = $receiver;
            }

            public <T extends RsProjectSettingsServiceBase.RsProjectSettingsBase<T>> void settingsChanged(RsProjectSettingsServiceBase.SettingsChangedEventBase<T> e) {
                Intrinsics.checkNotNullParameter(e, (String)"e");
                if (!(e instanceof RustProjectSettingsService.SettingsChangedEvent)) {
                    return;
                }
                if (!((RustProjectSettingsService.SettingsChangedEvent)e).getAffectsCargoMetadata() && ((RustProjectSettingsService.SettingsChangedEvent)e).isChanged((KProperty1)setupListeners.settingsChanged.1.INSTANCE)) {
                    MacroExpansionServiceImplInner.access$settingsChanged(this.this$0);
                }
            }
        });
        Topic topic = TemplateManager.TEMPLATE_STARTED_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TEMPLATE_STARTED_TOPIC");
        connect.subscribe(topic, arg_0 -> MacroExpansionServiceImplInner.setupListeners$lambda$0(this, arg_0));
    }

    private final void deleteOldExpansionDir() {
        Path oldDirPath = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("rust_expanded_macros");
        Intrinsics.checkNotNull((Object)oldDirPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(oldDirPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathKt.delete$default((Path)oldDirPath, (boolean)false, (int)1, null);
            VirtualFile oldDirVFile = LocalFileSystem.getInstance().findFileByIoFile(oldDirPath.toFile());
            if (oldDirVFile != null) {
                VirtualFile[] virtualFileArray = new VirtualFile[]{oldDirVFile};
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
            }
        }
    }

    private final void settingsChanged() {
        if (!this.isExpansionModeNew()) {
            this.cleanMacrosDirectoryAndStorage();
        }
        WriteCommandAction.writeCommandAction((Project)this.project).run(() -> MacroExpansionServiceImplInner.settingsChanged$lambda$0(this));
        this.processUnprocessedMacros();
    }

    public final void reexpand() {
        this.cleanMacrosDirectoryAndStorage();
        this.processUnprocessedMacros();
    }

    @NotNull
    public final MacroExpansionMode getExpansionMode() {
        return UtilsKt.isUnitTestMode() ? (MacroExpansionMode)new MacroExpansionMode.New(this.macroExpansionMode) : MacroExpansionManagerKt.access$toMode(RustProjectSettingsServiceKt.getRustSettings(this.project).getMacroExpansionEngine());
    }

    public final boolean isExpansionModeNew() {
        return this.getExpansionMode() instanceof MacroExpansionMode.New;
    }

    private final void processUnprocessedMacros() {
        MacroExpansionManagerKt.MACRO_LOG.info("processUnprocessedMacros");
        this.processMacros(RsTask.TaskType.MACROS_UNPROCESSED);
    }

    private final void processChangedMacros() {
        MacroExpansionManagerKt.MACRO_LOG.info("processChangedMacros");
        if (this.isIntellijTemplateActiveInAnyEditor()) {
            return;
        }
        this.processMacros(RsTask.TaskType.MACROS_FULL);
    }

    private final void processMacros(RsTask.TaskType taskType) {
        if (!this.isExpansionModeNew() || !this.enabledInUnitTests) {
            return;
        }
        if (UtilsKt.isUnitTestMode() && DumbService.Companion.isDumb(this.project)) {
            return;
        }
        MacroExpansionTask task2 = new MacroExpansionTask(this.project, this.modificationTracker, this.lastUpdatedMacrosAt, this.dirs.getProjectDirName(), taskType);
        this.submitTask(task2);
    }

    private final boolean isIntellijTemplateActiveInAnyEditor() {
        TemplateManager tm = TemplateManager.getInstance((Project)this.project);
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getAllEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
        for (FileEditor editor2 : fileEditorArray) {
            Template activeTemplate;
            if (!(editor2 instanceof TextEditor) || tm.getActiveTemplate(((TextEditor)editor2).getEditor()) == null || Intrinsics.areEqual((Object)activeTemplate.getId(), (Object)"__RustCustomTemplate")) continue;
            return true;
        }
        return false;
    }

    private final <T> CachedValueProvider.Result<T> everChanged(T result2) {
        Object[] objectArray = new Object[]{ModificationTracker.EVER_CHANGED};
        CachedValueProvider.Result result3 = CachedValueProvider.Result.create(result2, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"create(...)");
        return result3;
    }

    @NotNull
    public final CachedValueProvider.Result<RsResult<MacroExpansion, GetMacroExpansionError>> getExpansionFor(@NotNull RsPossibleMacroCall call2) {
        RsModInfo info;
        block17: {
            block16: {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                if (Intrinsics.areEqual((Object)this.getExpansionMode(), (Object)MacroExpansionMode.DISABLED)) {
                    return this.everChanged(new RsResult.Err<GetMacroExpansionError.MacroExpansionIsDisabled>(GetMacroExpansionError.MacroExpansionIsDisabled.INSTANCE));
                }
                if (Intrinsics.areEqual((Object)this.getExpansionMode(), (Object)MacroExpansionMode.OLD)) {
                    if (!(call2 instanceof RsMacroCall)) {
                        return this.everChanged(new RsResult.Err<GetMacroExpansionError.MemExpAttrMacro>(GetMacroExpansionError.MemExpAttrMacro.INSTANCE));
                    }
                    return MacroExpansionManagerKt.access$expandMacroOld((RsMacroCall)call2);
                }
                PsiFile containingFile = call2.getContainingFile();
                Intrinsics.checkNotNull((Object)containingFile);
                RsFile containingRsFile = PsiElementKt.getContainingRsFileSkippingCodeFragments((PsiElement)containingFile);
                VirtualFile containingVirtualFile = containingFile.getVirtualFile();
                RsModInfo rsModInfo = FacadeResolveKt.getModInfo(call2.getContainingMod());
                if (rsModInfo == null) {
                    return this.withPsiModCount(GetMacroExpansionError.ModDataNotFound.INSTANCE);
                }
                info = rsModInfo;
                if (containingRsFile != null && containingRsFile.getMacroExpansionDepth() >= info.getDefMap().getRecursionLimit()) {
                    MacroExpansionManager.Testmarks.TooDeepExpansion.INSTANCE.hit();
                    return this.withPsiModCount(GetMacroExpansionError.TooDeepExpansion.INSTANCE);
                }
                if (!RsPossibleMacroCallKt.isTopLevelExpansion(call2)) break block16;
                VirtualFile virtualFile = containingVirtualFile;
                if ((virtualFile != null && (virtualFile = virtualFile.getFileSystem()) != null ? MacroExpansionManagerKt.access$isSupportedFs((VirtualFileSystem)virtualFile) : false) && info.getModData().isNormalCrate()) break block17;
            }
            return MacroExpansionManagerKt.access$expandMacroToMemoryFile(call2, true);
        }
        PersistentList<? extends Integer> persistentList = FacadeResolveKt.getMacroIndex(info, call2, info.getCrate());
        if (persistentList == null) {
            return this.withPsiModCount(this.getReasonWhyExpansionFileNotFound-ZVhftvM(call2, info.getCrate(), info.getDefMap(), null));
        }
        PersistentList<? extends Integer> macroIndex2 = persistentList;
        VirtualFile virtualFile = this.getExpansionVirtualFile-S-FK_iQ(info.getDefMap(), macroIndex2);
        if (virtualFile == null) {
            return this.withPsiModCount(this.getReasonWhyExpansionFileNotFound-ZVhftvM(call2, info.getCrate(), info.getDefMap(), macroIndex2));
        }
        VirtualFile expansionVirtualFile = virtualFile;
        PsiFile expansionPsiFile = UtilsKt.toPsiFile(expansionVirtualFile, this.project);
        if (!(expansionPsiFile instanceof RsFile)) {
            if (expansionPsiFile instanceof PsiLargeFile || expansionPsiFile instanceof PsiPlainTextFile) {
                return this.withPsiModCount(GetMacroExpansionError.TooLargeExpansion.INSTANCE);
            }
            if (expansionPsiFile == null) {
                return this.withPsiModCount(GetMacroExpansionError.VirtualFileFoundButPsiIsNull.INSTANCE);
            }
            return this.withPsiModCount(GetMacroExpansionError.VirtualFileFoundButPsiIsUnknown.INSTANCE);
        }
        RsFile expansionFile = (RsFile)expansionPsiFile;
        if (!Intrinsics.areEqual((Object)this.getExpandedFromByExpansionFile(expansionFile), (Object)call2)) {
            return this.withPsiModCount(GetMacroExpansionError.InconsistentExpansionExpandedFrom.INSTANCE);
        }
        MacroExpansion macroExpansion = MacroExpansionKt.getExpansionFromExpandedFile(MacroExpansionContext.ITEM, expansionFile);
        Intrinsics.checkNotNull((Object)macroExpansion);
        RsResult.Ok<MacroExpansion> expansion = new RsResult.Ok<MacroExpansion>(macroExpansion);
        Object[] objectArray = new Object[]{expansionFile, this.modificationTracker};
        List deps = CollectionsKt.mutableListOf((Object[])objectArray);
        if (call2 instanceof RsMacroCall) {
            ((Collection)deps).add(((RsMacroCall)call2).getModificationTracker());
        } else {
            ((Collection)deps).add(RsPsiManagerKt.getRustStructureOrAnyPsiModificationTracker(call2));
            deps.addAll((Collection)RsModificationTrackerOwnerKt.collectModificationTrackers(call2));
        }
        CachedValueProvider.Result result2 = CachedValueProvider.Result.create(expansion, (Collection)deps);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"create(...)");
        return result2;
    }

    private final CachedValueProvider.Result<RsResult<MacroExpansion, GetMacroExpansionError>> withPsiModCount(GetMacroExpansionError err) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        CachedValueProvider.Result result2 = CachedValueProvider.Result.create(new RsResult.Err<GetMacroExpansionError>(err), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"create(...)");
        return result2;
    }

    @Nullable
    public final RsPossibleMacroCall getExpandedFrom(@NotNull RsExpandedElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UtilsKt.checkReadAccessAllowed();
        PsiElement psiElement2 = PsiElementKt.getStubParent(element);
        RsFile rsFile = psiElement2 instanceof RsFile ? (RsFile)psiElement2 : null;
        if (rsFile == null) {
            return null;
        }
        RsFile parent2 = rsFile;
        return this.getExpandedFromByExpansionFile(parent2);
    }

    private final RsPossibleMacroCall getExpandedFromByExpansionFile(RsFile parent2) {
        return (RsPossibleMacroCall)CachedValuesManager.getCachedValue((PsiElement)parent2, (Key)MacroExpansionManagerKt.access$getGET_EXPANDED_FROM_KEY$p(), () -> MacroExpansionServiceImplInner.getExpandedFromByExpansionFile$lambda$0(this, parent2));
    }

    private final RsPossibleMacroCall doGetExpandedFromForExpansionFile(RsFile parent2) {
        Pair<CrateDefMap, String> pair = this.getDefMapForExpansionFile(parent2);
        if (pair == null) {
            return null;
        }
        Pair<CrateDefMap, String> pair2 = pair;
        CrateDefMap defMap = (CrateDefMap)pair2.component1();
        String expansionName = (String)pair2.component2();
        MacroCallLightInfo macroCallLightInfo = defMap.getExpansionNameToMacroCall().get(expansionName);
        if (macroCallLightInfo == null) {
            return null;
        }
        MacroCallLightInfo macroCallLightInfo2 = macroCallLightInfo;
        ModData modData = macroCallLightInfo2.component1();
        ItemPointer pointer = macroCallLightInfo2.component2();
        RsProcMacroKind kind2 = macroCallLightInfo2.component3();
        int indexOfDerive = macroCallLightInfo2.component4();
        return this.findMacroCallByPointer(pointer, kind2, modData, defMap, indexOfDerive);
    }

    @Nullable
    public final RsMacroCall getIncludedFrom(@NotNull RsFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        UtilsKt.checkReadAccessAllowed();
        return (RsMacroCall)CachedValuesManager.getCachedValue((PsiElement)file, (Key)MacroExpansionManagerKt.access$getGET_INCLUDED_FROM_KEY$p(), () -> MacroExpansionServiceImplInner.getIncludedFrom$lambda$0(this, file));
    }

    private final RsMacroCall doGetIncludedFrom(RsFile file) {
        RsModInfo info;
        Pair<ItemPointer, RsModInfo> pair = this.getIncludeMacroIndex(file);
        if (pair == null) {
            return null;
        }
        Pair<ItemPointer, RsModInfo> pair2 = pair;
        ItemPointer includeMacroIndex = (ItemPointer)pair2.component1();
        RsPossibleMacroCall rsPossibleMacroCall = this.findMacroCallByPointer(includeMacroIndex, RsProcMacroKind.FUNCTION_LIKE, (info = (RsModInfo)pair2.component2()).getModData(), info.getDefMap(), 0);
        return rsPossibleMacroCall instanceof RsMacroCall ? (RsMacroCall)rsPossibleMacroCall : null;
    }

    private final Pair<ItemPointer, RsModInfo> getIncludeMacroIndex(RsFile file) {
        Object v1;
        Crate crate;
        block4: {
            crate = file.getCrate();
            Integer n = crate.getId();
            if (n == null) {
                return null;
            }
            int crateId = n;
            Iterable iterable = FacadeResolveKt.findFileInclusionPointsFor(file);
            for (Object t : iterable) {
                FileInclusionPoint it2 = (FileInclusionPoint)t;
                boolean bl = false;
                if (!(it2.getDefMap().getCrate() == crateId)) continue;
                v1 = t;
                break block4;
            }
            v1 = null;
        }
        FileInclusionPoint fileInclusionPoint = v1;
        if (fileInclusionPoint == null) {
            return null;
        }
        FileInclusionPoint fileInclusionPoint2 = fileInclusionPoint;
        CrateDefMap defMap = fileInclusionPoint2.component1();
        ModData modData = fileInclusionPoint2.component2();
        byte inclusionType = fileInclusionPoint2.component3-EeTUO30();
        ItemPointer includeMacroIndex = fileInclusionPoint2.component4();
        if (!FileInclusionType.isIncluded-impl(inclusionType) || includeMacroIndex == null) {
            return null;
        }
        RsModInfo info = new RsModInfo(this.project, defMap, modData, crate, null);
        return TuplesKt.to((Object)includeMacroIndex, (Object)info);
    }

    @Nullable
    public final PsiElement getContextOfMacroCallExpandedFrom(@NotNull RsFile stubParent) {
        Intrinsics.checkNotNullParameter((Object)stubParent, (String)"stubParent");
        UtilsKt.checkReadAccessAllowed();
        return (PsiElement)CachedValuesManager.getCachedValue((PsiElement)stubParent, (Key)MacroExpansionManagerKt.access$getGET_CONTEXT_OF_MACRO_CALL_EXPANDED_FROM_KEY$p(), () -> MacroExpansionServiceImplInner.getContextOfMacroCallExpandedFrom$lambda$0(this, stubParent));
    }

    @Nullable
    public final PsiElement doGetContextOfMacroCallExpandedFrom(@NotNull RsFile stubParent) {
        Intrinsics.checkNotNullParameter((Object)stubParent, (String)"stubParent");
        UtilsKt.checkReadAccessAllowed();
        Pair<CrateDefMap, String> pair = this.getDefMapForExpansionFile(stubParent);
        if (pair == null) {
            return null;
        }
        Pair<CrateDefMap, String> pair2 = pair;
        CrateDefMap defMap = (CrateDefMap)pair2.component1();
        String expansionName = (String)pair2.component2();
        MacroCallLightInfo macroCallLightInfo = defMap.getExpansionNameToMacroCall().get(expansionName);
        if (macroCallLightInfo == null) {
            return null;
        }
        ModData modData = macroCallLightInfo.component1();
        return FacadeResolveKt.toScopeByPointer(modData, this.project);
    }

    @Nullable
    public final RsPossibleMacroCall findMacroCallByPointer(@NotNull ItemPointer macroPointer, @NotNull RsProcMacroKind kind2, @NotNull ModData modData, @NotNull CrateDefMap defMap, int indexOfDerive) {
        RsPossibleMacroCall rsPossibleMacroCall;
        Intrinsics.checkNotNullParameter((Object)macroPointer, (String)"macroPointer");
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)modData, (String)"modData");
        Intrinsics.checkNotNullParameter((Object)defMap, (String)"defMap");
        RsElement rsElement = FacadeResolveKt.toPsiByPointer(macroPointer, this.project, modData.getCrate());
        if (rsElement == null) {
            return null;
        }
        RsElement owner = rsElement;
        if (kind2 == RsProcMacroKind.FUNCTION_LIKE) {
            rsPossibleMacroCall = owner instanceof RsMacroCall ? (RsMacroCall)owner : null;
        } else {
            Crate crate = CrateGraphServiceKt.getCrateGraph(this.project).findCrateById(defMap.getCrate());
            if (crate == null) {
                return null;
            }
            Crate crate2 = crate;
            if (!(owner instanceof RsAttrProcMacroOwner)) {
                return null;
            }
            rsPossibleMacroCall = this.findAttrOrDeriveMacroCall((RsAttrProcMacroOwner)owner, indexOfDerive, kind2 == RsProcMacroKind.DERIVE, crate2);
        }
        return rsPossibleMacroCall;
    }

    /*
     * WARNING - void declaration
     */
    private final RsPossibleMacroCall findAttrOrDeriveMacroCall(RsAttrProcMacroOwner $this$findAttrOrDeriveMacroCall, int macroIndexInParent, boolean isDerive, Crate crate) {
        Sequence attrs = ProcMacroAttribute.Companion.getProcMacroAttributeWithoutResolve$default(ProcMacroAttribute.Companion, $this$findAttrOrDeriveMacroCall, null, crate, null, false, false, 58, null);
        ProcMacroAttributeUnresolved.DeriveLazyResolveMap resolvedDerives = new ProcMacroAttributeUnresolved.DeriveLazyResolveMap();
        int macroIndexInParent2 = macroIndexInParent;
        for (ProcMacroAttributeUnresolved attr : attrs) {
            ProcMacroAttributeUnresolved procMacroAttributeUnresolved = attr;
            if (procMacroAttributeUnresolved instanceof ProcMacroAttributeUnresolved.Attr) {
                if (isDerive) continue;
                return (RsPossibleMacroCall)((ProcMacroAttributeUnresolved.Attr)attr).getAttr();
            }
            if (procMacroAttributeUnresolved instanceof ProcMacroAttributeUnresolved.Derive) {
                if (!isDerive) continue;
                List derives = SequencesKt.toList(((ProcMacroAttributeUnresolved.Derive)attr).getDerives());
                if (derives.size() > macroIndexInParent2) {
                    return (RsPossibleMacroCall)SequencesKt.elementAtOrNull(((ProcMacroAttributeUnresolved.Derive)attr).getDerives(), (int)macroIndexInParent2);
                }
                macroIndexInParent2 -= derives.size();
                continue;
            }
            if (procMacroAttributeUnresolved instanceof ProcMacroAttributeUnresolved.PossibleHelper) {
                void $this$mapNotNullTo$iv$iv;
                if (isDerive) continue;
                Iterable $this$mapNotNull$iv = ((ProcMacroAttributeUnresolved.PossibleHelper)attr).getCanBeHelperOf();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    List<String> it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    RsMetaItem derive = (RsMetaItem)element$iv$iv;
                    boolean bl2 = false;
                    Object object = resolvedDerives.getOrPut(derive);
                    if ((object != null && (object = ((ProcMacroDefInfo)object).getMetadata()) != null ? ((ProcMacroMetadata)object).getHelperAttributes() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                boolean isHelper = CollectionsKt.contains((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)), (Object)RsMetaItemKt.getName(((ProcMacroAttributeUnresolved.PossibleHelper)attr).getAttr()));
                if (isHelper) continue;
                return (RsPossibleMacroCall)((ProcMacroAttributeUnresolved.PossibleHelper)attr).getAttr();
            }
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    private final VirtualFile getExpansionVirtualFile-S-FK_iQ(CrateDefMap defMap, PersistentList<? extends Integer> persistentList) {
        String string = defMap.getMacroCallToExpansionName().get(MacroIndex.box-impl(persistentList));
        if (string == null) {
            return null;
        }
        String expansionId = string;
        return this.getExpansionFileByName(defMap.getCrate(), expansionId);
    }

    @Nullable
    public final VirtualFile getExpansionFileByName(int crateId, @NotNull String expansionFileName) {
        Intrinsics.checkNotNullParameter((Object)expansionFileName, (String)"expansionFileName");
        MacroExpansionFileSystem.MacroExpansionCrate macroExpansionCrate = this.macroExpansionProject.findCrate(crateId);
        if (macroExpansionCrate == null) {
            return null;
        }
        MacroExpansionFileSystem.MacroExpansionCrate crate = macroExpansionCrate;
        MacroExpansionFileSystem.MacroExpansionFile macroExpansionFile = crate.findFile(expansionFileName);
        if (macroExpansionFile == null || (macroExpansionFile = macroExpansionFile.getVirtualFileOrNull()) == null) {
            return null;
        }
        MacroExpansionFileSystem.MacroExpansionFile file = macroExpansionFile;
        boolean $i$f$testAssert = false;
        boolean $i$f$testAssert2 = false;
        if (UtilsKt.isUnitTestMode()) {
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)RsFileType.INSTANCE))) {
                boolean bl2 = false;
                String message$iv$iv = "Assertion failed";
                throw new AssertionError((Object)message$iv$iv);
            }
        }
        return file;
    }

    private final GetMacroExpansionError getReasonWhyExpansionFileNotFound-ZVhftvM(RsPossibleMacroCall call2, Crate crate, CrateDefMap defMap, PersistentList<? extends Integer> callIndex) {
        boolean procMacroExpansionIsDisabled;
        RegistryValue registryValue;
        if (!CfgUtilsKt.existsAfterExpansion(call2, crate)) {
            return GetMacroExpansionError.CfgDisabled.INSTANCE;
        }
        if (crate.getOrigin() != PackageOrigin.WORKSPACE && (Intrinsics.areEqual((Object)crate.getKind(), (Object)CargoWorkspace.TargetKind.Test.INSTANCE) || CfgUtilsKt.isUnderCfgTest((PsiElement)call2))) {
            return GetMacroExpansionError.MacroInDependencyTest.INSTANCE;
        }
        RsResult resolveResult = RsPossibleMacroCallKt.resolveToMacroWithoutPsiWithErr$default(call2, true, false, 2, null);
        boolean isProcMacro = resolveResult instanceof RsResult.Ok && ((RsMacroDataWithHash)((RsResult.Ok)resolveResult).getOk()).getData() instanceof RsProcMacroData || resolveResult instanceof RsResult.Err && ((RsResult.Err)resolveResult).getErr() instanceof ResolveMacroWithoutPsiError.NoProcMacroArtifact;
        RsPossibleMacroCallKind callKind = RsPossibleMacroCallKt.getKind(call2);
        if (callKind instanceof RsPossibleMacroCallKind.MacroCall) {
            registryValue = RsExperiments.INSTANCE.getFN_LIKE_PROC_MACROS();
        } else if (callKind instanceof RsPossibleMacroCallKind.MetaItem) {
            registryValue = RsProcMacroPsiUtil.INSTANCE.canBeCustomDerive(((RsPossibleMacroCallKind.MetaItem)callKind).getMeta()) ? RsExperiments.INSTANCE.getDERIVE_PROC_MACROS() : RsExperiments.INSTANCE.getATTR_PROC_MACROS();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        RegistryValue procMacroExperimentalFeature = registryValue;
        boolean bl = procMacroExpansionIsDisabled = isProcMacro && (!RsExperiments.INSTANCE.getEVALUATE_BUILD_SCRIPTS().asBoolean() || !RsExperiments.INSTANCE.getPROC_MACROS().asBoolean() && !procMacroExperimentalFeature.asBoolean());
        if (procMacroExpansionIsDisabled) {
            return new GetMacroExpansionError.ExpansionError(ProcMacroExpansionError.ProcMacroExpansionIsDisabled.INSTANCE);
        }
        RsResult $this$unwrapOrElse$iv = resolveResult;
        boolean $i$f$unwrapOrElse = false;
        RsResult rsResult = $this$unwrapOrElse$iv;
        if (!(rsResult instanceof RsResult.Ok)) {
            if (rsResult instanceof RsResult.Err) {
                ResolveMacroWithoutPsiError it2 = (ResolveMacroWithoutPsiError)((RsResult.Err)$this$unwrapOrElse$iv).getErr();
                boolean bl2 = false;
                return GetMacroExpansionErrorKt.toExpansionError(it2);
            }
            throw new NoWhenBranchMatchedException();
        }
        ((RsResult.Ok)$this$unwrapOrElse$iv).getOk();
        if (callIndex == null) {
            return GetMacroExpansionError.NoMacroIndex.INSTANCE;
        }
        String string = defMap.getMacroCallToExpansionName().get(MacroIndex.box-impl(callIndex));
        if (string == null) {
            return GetMacroExpansionError.ExpansionNameNotFound.INSTANCE;
        }
        String expansionName = string;
        HashCode mixHash = MacroExpansionTaskKt.extractMixHashFromExpansionName(expansionName);
        RsResult<ExpansionResultOk, MacroExpansionError> rsResult2 = MacroExpansionSharedCache.Companion.getInstance().getExpansionIfCached(mixHash);
        if (rsResult2 == null) {
            return GetMacroExpansionError.ExpansionFileNotFound.INSTANCE;
        }
        RsResult<ExpansionResultOk, MacroExpansionError> expansion = rsResult2;
        MacroExpansionError macroExpansionError = expansion.err();
        if (macroExpansionError == null) {
            return GetMacroExpansionError.InconsistentExpansionCacheAndVfs.INSTANCE;
        }
        MacroExpansionError error = macroExpansionError;
        return new GetMacroExpansionError.ExpansionError(error);
    }

    private final Pair<CrateDefMap, String> getDefMapForExpansionFile(RsFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Pair<Integer, String> pair = this.getCrateForExpansionFile(virtualFile2);
        if (pair == null) {
            return null;
        }
        Pair<Integer, String> pair2 = pair;
        int crateId = ((Number)pair2.component1()).intValue();
        String expansionName = (String)pair2.component2();
        CrateDefMap crateDefMap = FacadeUpdateDefMapKt.getOrUpdateIfNeeded(DefMapServiceKt.getDefMapService(this.project), crateId);
        if (crateDefMap == null) {
            return null;
        }
        CrateDefMap defMap = crateDefMap;
        return TuplesKt.to((Object)defMap, (Object)expansionName);
    }

    @TestOnly
    @NotNull
    public final Disposable setupForUnitTests(boolean saveCacheOnDispose, boolean clearCacheBeforeDispose) {
        Disposable disposable = () -> MacroExpansionServiceImplInner.setupForUnitTests$lambda$0(this, saveCacheOnDispose, clearCacheBeforeDispose);
        this.setupListeners(disposable);
        return disposable;
    }

    @TestOnly
    public final void updateInUnitTestMode() {
        this.processChangedMacros();
    }

    @TestOnly
    public final void setMacroExpansionEnabled(boolean enabled) {
        this.enabledInUnitTests = enabled;
    }

    private final void disposeUnitTest(boolean saveCacheOnDispose, boolean clearCacheBeforeDispose) {
        if (!UtilsKt.isUnitTestMode()) {
            throw new IllegalStateException("Check failed.");
        }
        if (clearCacheBeforeDispose) {
            this.macroExpansionProject.clean();
        }
        if (saveCacheOnDispose) {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ MacroExpansionServiceImplInner this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.save((Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        } else {
            PathKt.delete$default((Path)this.dirs.getDataFile(), (boolean)false, (int)1, null);
        }
        this.releaseExpansionDirectory();
    }

    private static final void setupListeners$lambda$0(MacroExpansionServiceImplInner this$0, TemplateState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        state.addTemplateStateListener((TemplateEditingListener)new TemplateResultListener(arg_0 -> MacroExpansionServiceImplInner.setupListeners$lambda$0$0(this$0, arg_0)));
    }

    private static final Unit setupListeners$lambda$0$0(MacroExpansionServiceImplInner this$0, TemplateResultListener.TemplateResult it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        this$0.processChangedMacros();
        return Unit.INSTANCE;
    }

    private static final void settingsChanged$lambda$0(MacroExpansionServiceImplInner this$0) {
        DefMapServiceKt.getDefMapService(this$0.project).scheduleRebuildAllDefMaps();
        RsPsiManagerKt.getRustPsiManager(this$0.project).incRustStructureModificationCount();
    }

    private static final CachedValueProvider.Result getExpandedFromByExpansionFile$lambda$0(MacroExpansionServiceImplInner this$0, RsFile $parent) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)this$0.doGetExpandedFromForExpansionFile($parent), (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getIncludedFrom$lambda$0(MacroExpansionServiceImplInner this$0, RsFile $file) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)this$0.doGetIncludedFrom($file), (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getContextOfMacroCallExpandedFrom$lambda$0(MacroExpansionServiceImplInner this$0, RsFile $stubParent) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)this$0.doGetContextOfMacroCallExpandedFrom($stubParent), (Object[])objectArray);
    }

    private static final void setupForUnitTests$lambda$0(MacroExpansionServiceImplInner this$0, boolean $saveCacheOnDispose, boolean $clearCacheBeforeDispose) {
        this$0.disposeUnitTest($saveCacheOnDispose, $clearCacheBeforeDispose);
    }

    public static final /* synthetic */ Path access$getDataFile(MacroExpansionServiceImplInner $this) {
        return $this.getDataFile();
    }

    public static final /* synthetic */ void access$setLastSavedStorageModCount$p(MacroExpansionServiceImplInner $this, long l) {
        $this.lastSavedStorageModCount = l;
    }

    public static final /* synthetic */ Object access$withIoContextIfNotUnitTestMode(MacroExpansionServiceImplInner $this, Function1 block, Continuation $completion) {
        return $this.withIoContextIfNotUnitTestMode(block, $completion);
    }

    public static final /* synthetic */ void access$settingsChanged(MacroExpansionServiceImplInner $this) {
        $this.settingsChanged();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0018\u0010 \u001a\u0004\u0018\u00010!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionServiceImplInner$ChangedMacroUpdater;", "Lorg/rust/lang/core/psi/RsPsiTreeChangeAdapter;", "Lorg/rust/lang/core/psi/RustPsiChangeListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "Lorg/rust/cargo/project/model/CargoProjectsService$CargoProjectsListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "(Lorg/rust/lang/core/macros/MacroExpansionServiceImplInner;)V", "shouldProcessChangedMacrosOnWriteActionFinish", "Lorg/rust/lang/core/macros/MacroExpansionServiceImplInner$ChangedMacrosScope;", "handleEvent", "", "event", "Lorg/rust/lang/core/psi/RsPsiTreeChangeEvent;", "rustPsiChanged", "file", "Lcom/intellij/psi/PsiFile;", "element", "Lcom/intellij/psi/PsiElement;", "isStructureModification", "", "cargoProjectsUpdated", "service", "Lorg/rust/cargo/project/model/CargoProjectsService;", "projects", "", "Lorg/rust/cargo/project/model/CargoProject;", "afterWriteActionFinished", "action", "", "scheduleChangedMacrosUpdate", "scope", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nMacroExpansionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroExpansionManager.kt\norg/rust/lang/core/macros/MacroExpansionServiceImplInner$ChangedMacroUpdater\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1226:1\n15#2:1227\n15#2:1229\n130#3:1228\n1#4:1230\n1#4:1241\n1617#5,9:1231\n1869#5:1240\n1870#5:1242\n1626#5:1243\n*S KotlinDebug\n*F\n+ 1 MacroExpansionManager.kt\norg/rust/lang/core/macros/MacroExpansionServiceImplInner$ChangedMacroUpdater\n*L\n615#1:1227\n628#1:1229\n617#1:1228\n658#1:1241\n658#1:1231,9\n658#1:1240\n658#1:1242\n658#1:1243\n*E\n"})
    private final class ChangedMacroUpdater
    extends RsPsiTreeChangeAdapter
    implements RustPsiChangeListener,
    ApplicationListener,
    CargoProjectsService.CargoProjectsListener,
    AsyncFileListener {
        @NotNull
        private ChangedMacrosScope shouldProcessChangedMacrosOnWriteActionFinish = ChangedMacrosScope.NONE;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void handleEvent(@NotNull RsPsiTreeChangeEvent event) {
            PsiElement parentOrSelf;
            PsiElement element;
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!MacroExpansionServiceImplInner.this.isExpansionModeNew()) {
                return;
            }
            PsiFile psiFile = event.getFile();
            if (!(psiFile instanceof RsFile)) return;
            RsFile rsFile = (RsFile)psiFile;
            if (rsFile == null) {
                return;
            }
            RsFile file = rsFile;
            if (RsPsiManager.Companion.isIgnorePsiEvents((PsiFile)file)) {
                return;
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (!(virtualFile2 instanceof VirtualFileWithId)) {
                return;
            }
            if (file.getTreeElement() == null) {
                return;
            }
            RsPsiTreeChangeEvent rsPsiTreeChangeEvent = event;
            if (rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildAddition.After) {
                psiElement2 = ((RsPsiTreeChangeEvent.ChildAddition.After)event).getChild();
            } else if (rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildReplacement.After) {
                psiElement2 = ((RsPsiTreeChangeEvent.ChildReplacement.After)event).getNewChild();
            } else {
                if (!(rsPsiTreeChangeEvent instanceof RsPsiTreeChangeEvent.ChildrenChange.After)) return;
                if (((RsPsiTreeChangeEvent.ChildrenChange.After)event).isGenericChange()) return;
                psiElement2 = ((RsPsiTreeChangeEvent.ChildrenChange.After)event).getParent();
            }
            PsiElement $this$ancestorOrSelf$iv = element = psiElement2;
            boolean $i$f$ancestorOrSelf = false;
            RsMetaItem rsMetaItem = (RsMetaItem)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsMetaItem.class, (boolean)false);
            PsiElement $this$descendantsOfTypeOrSelf$iv = parentOrSelf = rsMetaItem != null ? (PsiElement)rsMetaItem : element;
            boolean $i$f$descendantsOfTypeOrSelf = false;
            Class[] classArray = new Class[]{RsPossibleMacroCall.class};
            Collection collection = PsiTreeUtil.findChildrenOfAnyType((PsiElement)$this$descendantsOfTypeOrSelf$iv, (boolean)false, (Class[])classArray);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfAnyType(...)");
            Collection macroCalls = collection;
            if (macroCalls.isEmpty()) return;
            boolean bl = true;
            if (!bl) return;
            if (MacroExpansionManager.Companion.isExpansionFile(virtualFile2)) return;
            this.scheduleChangedMacrosUpdate(ChangedMacrosScope.CHANGED);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void rustPsiChanged(@NotNull PsiFile file, @NotNull PsiElement element, boolean isStructureModification) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!MacroExpansionServiceImplInner.this.isExpansionModeNew()) {
                return;
            }
            if (!isStructureModification) {
                PsiElement $this$ancestorOrSelf$iv = element;
                boolean $i$f$ancestorOrSelf = false;
                RsPossibleMacroCall rsPossibleMacroCall = (RsPossibleMacroCall)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsPossibleMacroCall.class, (boolean)false);
                if (!(rsPossibleMacroCall != null ? RsPossibleMacroCallKt.isTopLevelExpansion(rsPossibleMacroCall) : false)) {
                    if (!RsProcMacroPsiUtil.INSTANCE.canBeInProcMacroCallBody(element)) return;
                }
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) return;
            VirtualFile it2 = virtualFile;
            boolean bl = false;
            if (MacroExpansionManager.Companion.isExpansionFile(it2)) return;
            boolean bl2 = true;
            if (!bl2) return;
            boolean bl3 = true;
            boolean shouldScheduleUpdate = bl3;
            if (!shouldScheduleUpdate) return;
            if (!(file instanceof RsFile)) return;
            this.scheduleChangedMacrosUpdate(ChangedMacrosScope.CHANGED);
            DefMapServiceKt.getDefMapService(MacroExpansionServiceImplInner.this.project).onFileChanged(ChangedFile.Companion.rustFile((RsFile)file));
        }

        @Override
        public void cargoProjectsUpdated(@NotNull CargoProjectsService service, @NotNull Collection<? extends CargoProject> projects) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            this.scheduleChangedMacrosUpdate(ChangedMacrosScope.UNPROCESSED);
        }

        public void afterWriteActionFinished(@NotNull Object action2) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            ChangedMacrosScope shouldProcessChangedMacros = this.shouldProcessChangedMacrosOnWriteActionFinish;
            this.shouldProcessChangedMacrosOnWriteActionFinish = ChangedMacrosScope.NONE;
            switch (WhenMappings.$EnumSwitchMapping$0[shouldProcessChangedMacros.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    MacroExpansionServiceImplInner.this.processChangedMacros();
                    break;
                }
                case 3: {
                    MacroExpansionServiceImplInner.this.processUnprocessedMacros();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final void scheduleChangedMacrosUpdate(ChangedMacrosScope scope) {
            this.shouldProcessChangedMacrosOnWriteActionFinish = scope;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            if (MacroExpansionServiceImplInner.this.project.isDisposed()) {
                return null;
            }
            Iterable iterable = events;
            MacroExpansionServiceImplInner macroExpansionServiceImplInner = MacroExpansionServiceImplInner.this;
            boolean $i$f$mapNotNull = false;
            void var6_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                VFileEvent event = (VFileEvent)element$iv$iv;
                boolean bl2 = false;
                if (!(event instanceof VFileContentChangeEvent)) {
                    pair = null;
                } else if (Intrinsics.areEqual((Object)((VFileContentChangeEvent)event).getFile().getFileType(), (Object)((Object)RsFileType.INSTANCE))) {
                    pair = null;
                } else {
                    VirtualFile virtualFile = ((VFileContentChangeEvent)event).getFile();
                    VirtualFileWithId virtualFileWithId = virtualFile instanceof VirtualFileWithId ? (VirtualFileWithId)virtualFile : null;
                    if (virtualFileWithId == null) {
                        pair = null;
                    } else {
                        int id = virtualFileWithId.getId();
                        pair = !DefMapServiceKt.getDefMapService(macroExpansionServiceImplInner.project).isManagedNonRustFile(id) ? null : TuplesKt.to((Object)event, (Object)id);
                    }
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List modificationEvents = (List)destination$iv$iv;
            if (modificationEvents.isEmpty()) {
                return null;
            }
            return new AsyncFileListener.ChangeApplier(modificationEvents, MacroExpansionServiceImplInner.this, this){
                final /* synthetic */ List<Pair<VFileContentChangeEvent, Integer>> $modificationEvents;
                final /* synthetic */ MacroExpansionServiceImplInner this$0;
                final /* synthetic */ ChangedMacroUpdater this$1;
                {
                    this.$modificationEvents = $modificationEvents;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void afterVfsChange() {
                    boolean updated = false;
                    Iterator<Pair<VFileContentChangeEvent, Integer>> iterator2 = this.$modificationEvents.iterator();
                    while (iterator2.hasNext()) {
                        VFileContentChangeEvent event = (VFileContentChangeEvent)iterator2.next().component1();
                        if (Intrinsics.areEqual((Object)event.getFile().getFileType(), (Object)((Object)RsFileType.INSTANCE))) continue;
                        DefMapService defMapService = DefMapServiceKt.getDefMapService(MacroExpansionServiceImplInner.access$getProject$p(this.this$0));
                        Project project = MacroExpansionServiceImplInner.access$getProject$p(this.this$0);
                        VirtualFile virtualFile = event.getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                        defMapService.onFileChanged(ChangedFile.Companion.nonRustFile(project, virtualFile));
                        updated = true;
                    }
                    if (updated) {
                        RsPsiManagerKt.getRustPsiManager(MacroExpansionServiceImplInner.access$getProject$p(this.this$0)).incRustStructureModificationCount();
                        ChangedMacroUpdater.access$scheduleChangedMacrosUpdate(this.this$1, ChangedMacrosScope.CHANGED);
                    }
                }
            };
        }

        public static final /* synthetic */ void access$scheduleChangedMacrosUpdate(ChangedMacroUpdater $this, ChangedMacrosScope scope) {
            $this.scheduleChangedMacrosUpdate(scope);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ChangedMacrosScope.values().length];
                try {
                    nArray[ChangedMacrosScope.NONE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChangedMacrosScope.CHANGED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ChangedMacrosScope.UNPROCESSED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionServiceImplInner$ChangedMacrosScope;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "CHANGED", "UNPROCESSED", "intellij.rustrover.core"})
    private static final class ChangedMacrosScope
    extends Enum<ChangedMacrosScope> {
        public static final /* enum */ ChangedMacrosScope NONE = new ChangedMacrosScope();
        public static final /* enum */ ChangedMacrosScope CHANGED = new ChangedMacrosScope();
        public static final /* enum */ ChangedMacrosScope UNPROCESSED = new ChangedMacrosScope();
        private static final /* synthetic */ ChangedMacrosScope[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ChangedMacrosScope[] values() {
            return (ChangedMacrosScope[])$VALUES.clone();
        }

        public static ChangedMacrosScope valueOf(String value) {
            return Enum.valueOf(ChangedMacrosScope.class, value);
        }

        @NotNull
        public static EnumEntries<ChangedMacrosScope> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = changedMacrosScopeArray = new ChangedMacrosScope[]{ChangedMacrosScope.NONE, ChangedMacrosScope.CHANGED, ChangedMacrosScope.UNPROCESSED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

