/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.Dirs;
import org.rust.lang.core.macros.MacroExpansionManager;
import org.rust.lang.core.macros.MacroExpansionServiceImplInner;
import org.rust.lang.core.macros.filesystem.MacroExpansionFileSystem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/rust/lang/core/macros/MacroExpansionServiceBuilder;", "", "<init>", "()V", "build", "Lorg/rust/lang/core/macros/MacroExpansionServiceImplInner;", "project", "Lcom/intellij/openapi/project/Project;", "dirs", "Lorg/rust/lang/core/macros/Dirs;", "intellij.rustrover.core"})
final class MacroExpansionServiceBuilder {
    @NotNull
    public static final MacroExpansionServiceBuilder INSTANCE = new MacroExpansionServiceBuilder();

    private MacroExpansionServiceBuilder() {
    }

    @NotNull
    public final MacroExpansionServiceImplInner build(@NotNull Project project, @NotNull Dirs dirs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dirs, (String)"dirs");
        Path dataFile = dirs.getDataFile();
        MacroExpansionManager.Companion.checkInvalidatedStorage();
        MacroExpansionFileSystem.Helper.INSTANCE.loadProjectDirs();
        MacroExpansionFileSystem vfs = MacroExpansionFileSystem.Helper.INSTANCE.getInstance();
        MacroExpansionFileSystem.MacroExpansionProject macroExpansionProject = vfs.loadProject(dataFile, dirs.getProjectDirName());
        VirtualFile virtualFile = vfs.refreshAndFindVirtualFile(macroExpansionProject.getPath());
        if (virtualFile == null) {
            throw new IllegalStateException(("Impossible because the directory is just created; " + macroExpansionProject.getPath()).toString());
        }
        VirtualFile virtualFile2 = virtualFile;
        return new MacroExpansionServiceImplInner(project, dirs, macroExpansionProject, virtualFile2);
    }
}

