/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.MappedTextRange;
import org.rust.lang.core.macros.RangeMap;
import org.rust.lang.core.macros.RangeMapKt;
import org.rust.lang.core.macros.decl.MacroExpansionMarks;
import org.rust.lang.core.parser.ExtensionsKt;
import org.rust.lang.core.parser.UtilKt;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.doc.psi.RsDocKind;
import org.rust.lang.utils.RsEscapesUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u001e\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0005\u001a\f\u0010\u0007\u001a\u00020\u0003*\u00020\u0002H\u0002\u001a$\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0001*\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007\u001a\f\u0010\f\u001a\u00020\u000b*\u00020\u0002H\u0002\u001a\u0018\u0010\r\u001a\u00020\u000e*\u00020\t2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u000e*\u00020\t2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"lowerDocCommentsToAdaptedPsiBuilder", "Lkotlin/Pair;", "Lcom/intellij/lang/PsiBuilder;", "Lorg/rust/lang/core/macros/RangeMap;", "project", "Lcom/intellij/openapi/project/Project;", "lowerDocCommentsToPsiBuilder", "defaultRangeMap", "lowerDocComments", "", "asRawLiteral", "", "hasDocComments", "appendAsRustLiteralTo", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendAsRustRawLiteralTo", "detectHashesCount", "", "intellij.rustrover.core"})
public final class DocsLoweringKt {
    @NotNull
    public static final Pair<PsiBuilder, RangeMap> lowerDocCommentsToAdaptedPsiBuilder(@NotNull PsiBuilder $this$lowerDocCommentsToAdaptedPsiBuilder, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$lowerDocCommentsToAdaptedPsiBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Pair<CharSequence, RangeMap> pair = DocsLoweringKt.lowerDocComments($this$lowerDocCommentsToAdaptedPsiBuilder, true);
        if (pair == null) {
            return TuplesKt.to((Object)$this$lowerDocCommentsToAdaptedPsiBuilder, (Object)DocsLoweringKt.defaultRangeMap($this$lowerDocCommentsToAdaptedPsiBuilder));
        }
        Pair<CharSequence, RangeMap> lowered = pair;
        return TuplesKt.to((Object)UtilKt.createAdaptedRustPsiBuilder(project, (CharSequence)lowered.getFirst()), (Object)lowered.getSecond());
    }

    @NotNull
    public static final Pair<PsiBuilder, RangeMap> lowerDocCommentsToPsiBuilder(@NotNull PsiBuilder $this$lowerDocCommentsToPsiBuilder, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$lowerDocCommentsToPsiBuilder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Pair<CharSequence, RangeMap> pair = DocsLoweringKt.lowerDocComments($this$lowerDocCommentsToPsiBuilder, false);
        if (pair == null) {
            return TuplesKt.to((Object)$this$lowerDocCommentsToPsiBuilder, (Object)DocsLoweringKt.defaultRangeMap($this$lowerDocCommentsToPsiBuilder));
        }
        Pair<CharSequence, RangeMap> lowered = pair;
        return TuplesKt.to((Object)UtilKt.createRustPsiBuilder(project, (CharSequence)lowered.getFirst()), (Object)lowered.getSecond());
    }

    private static final RangeMap defaultRangeMap(PsiBuilder $this$defaultRangeMap) {
        CharSequence charSequence = $this$defaultRangeMap.getOriginalText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOriginalText(...)");
        return charSequence.length() > 0 ? new RangeMap(new MappedTextRange(0, 0, $this$defaultRangeMap.getOriginalText().length())) : RangeMap.Companion.getEMPTY();
    }

    @VisibleForTesting
    @Nullable
    public static final Pair<CharSequence, RangeMap> lowerDocComments(@NotNull PsiBuilder $this$lowerDocComments, boolean asRawLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$lowerDocComments, (String)"<this>");
        if (!DocsLoweringKt.hasDocComments($this$lowerDocComments)) {
            return null;
        }
        MacroExpansionMarks.DocsLowering.INSTANCE.hit();
        StringBuilder sb = new StringBuilder((int)((double)$this$lowerDocComments.getOriginalText().length() * 1.1));
        SmartList ranges = new SmartList();
        int i2 = 0;
        while ($this$lowerDocComments.rawLookup(i2) != null) {
            StringBuilder stringBuilder;
            IElementType token;
            CharSequence text = ExtensionsKt.rawLookupText($this$lowerDocComments, i2);
            int start2 = $this$lowerDocComments.rawTokenTypeStart(i2);
            ++i2;
            if (RsTokenTypeKt.getRS_DOC_COMMENTS().contains(token)) {
                String attrPrefix;
                RsDocKind kind2 = RsDocKind.Companion.of(token);
                String string = attrPrefix = kind2 == RsDocKind.InnerBlock || kind2 == RsDocKind.InnerEol ? "#!" : "#";
                if (kind2.isBlock()) {
                    sb.append(attrPrefix);
                    sb.append("[doc=");
                    CharSequence commentText = StringsKt.removeSuffix((CharSequence)StringsKt.removePrefix((CharSequence)text, (CharSequence)kind2.getPrefix()), (CharSequence)kind2.getSuffix());
                    if (asRawLiteral) {
                        DocsLoweringKt.appendAsRustRawLiteralTo(commentText, sb);
                    } else {
                        DocsLoweringKt.appendAsRustLiteralTo(commentText, sb);
                    }
                    stringBuilder = sb.append("]\n");
                    continue;
                }
                String[] stringArray = new String[]{"\n"};
                for (String comment : StringsKt.splitToSequence$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                    sb.append(attrPrefix);
                    sb.append("[doc=");
                    String commentText = StringsKt.removePrefix((String)((Object)StringsKt.trimStart((CharSequence)comment)).toString(), (CharSequence)kind2.getPrefix());
                    if (asRawLiteral) {
                        DocsLoweringKt.appendAsRustRawLiteralTo(commentText, sb);
                    } else {
                        DocsLoweringKt.appendAsRustLiteralTo(commentText, sb);
                    }
                    sb.append("]\n");
                }
                stringBuilder = Unit.INSTANCE;
                continue;
            }
            RangeMapKt.mergeAdd((List)ranges, new MappedTextRange(start2, sb.length(), text.length()));
            stringBuilder = sb.append(text);
        }
        return TuplesKt.to((Object)sb, (Object)new RangeMap(ranges));
    }

    public static /* synthetic */ Pair lowerDocComments$default(PsiBuilder psiBuilder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return DocsLoweringKt.lowerDocComments(psiBuilder, bl);
    }

    private static final boolean hasDocComments(PsiBuilder $this$hasDocComments) {
        int i2 = 0;
        while ($this$hasDocComments.rawLookup(i2++) != null) {
            IElementType token;
            if (!RsTokenTypeKt.getRS_DOC_COMMENTS().contains(token)) continue;
            return true;
        }
        return false;
    }

    private static final void appendAsRustLiteralTo(CharSequence $this$appendAsRustLiteralTo, StringBuilder out) {
        out.append("\"");
        RsEscapesUtilsKt.escapeRust$default($this$appendAsRustLiteralTo, out, false, 2, null);
        out.append("\"");
    }

    private static final void appendAsRustRawLiteralTo(CharSequence $this$appendAsRustRawLiteralTo, StringBuilder out) {
        int it2;
        int requiredHashCount = DocsLoweringKt.detectHashesCount($this$appendAsRustRawLiteralTo);
        out.append("r");
        int n = 0;
        while (n < requiredHashCount) {
            it2 = n++;
            boolean bl = false;
            out.append("#");
        }
        out.append("\"");
        RsEscapesUtilsKt.escapeRustRaw$default($this$appendAsRustRawLiteralTo, out, false, 2, null);
        out.append("\"");
        n = 0;
        while (n < requiredHashCount) {
            it2 = n++;
            boolean bl = false;
            out.append("#");
        }
    }

    private static final int detectHashesCount(CharSequence $this$detectHashesCount) {
        int i2 = 0;
        int largestHashesEncounter = 0;
        while (i2 < $this$detectHashesCount.length()) {
            if ($this$detectHashesCount.charAt(i2) != '\"') {
                ++i2;
                continue;
            }
            int requiredHashes = 1;
            ++i2;
            while (i2 < $this$detectHashesCount.length() && $this$detectHashesCount.charAt(i2) == '#') {
                ++requiredHashes;
                ++i2;
            }
            largestHashesEncounter = Math.max(largestHashesEncounter, requiredHashes);
        }
        return Math.min(largestHashesEncounter, 255);
    }
}

