/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.macros;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.MacroExpansion;
import org.rust.lang.core.macros.MacroExpansionContext;
import org.rust.lang.core.macros.MacroExpansionKt;
import org.rust.lang.core.macros.MacroExpansionManagerKt;
import org.rust.lang.core.macros.RsBuiltinMacroData;
import org.rust.lang.core.macros.RsExpandedElement;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.macros.RsMacroDataWithHash;
import org.rust.lang.core.macros.errors.GetMacroExpansionError;
import org.rust.lang.core.psi.RsConcatMacroArgument;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMacroExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsLitExprKt;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKt;
import org.rust.lang.utils.RsEscapesUtilsKt;
import org.rust.openapiext.UtilsKt;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a(\u0010\u0000\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0018\u00010\u0001j\u0004\u0018\u0001`\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a:\u0010\b\u001a\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001j\u0002`\u00052\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0006\u001a\u00020\rH\u0002\u001a\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0006\u001a\u00020\rH\u0002\u001a\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0006\u001a\u00020\rH\u0002\u001a\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0006\u001a\u00020\rH\u0002\u001a\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0006\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0006\u001a\u00020\r\u001a.\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0006\u001a\u00020\rH\u0002\u001a\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\u0006\u001a\u00020\rH\u0002\"\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"getBuiltInMacroExpansion", "Lcom/intellij/psi/util/CachedValueProvider$Result;", "Lorg/rust/stdext/RsResult;", "Lorg/rust/lang/core/macros/MacroExpansion;", "Lorg/rust/lang/core/macros/errors/GetMacroExpansionError;", "Lorg/rust/lang/core/macros/MacroExpansionCachedResult;", "call", "Lorg/rust/lang/core/psi/ext/RsPossibleMacroCall;", "cached", "result", "dependency", "", "expandConcat", "Lorg/rust/lang/core/psi/RsMacroCall;", "expandLine", "expandColumn", "getLineColumnPosition", "Lkotlin/Pair;", "", "expandStringify", "WHITESPACE_REGEX", "Lkotlin/text/Regex;", "expandStringifyAsString", "", "createMacroExpansionFromText", "expandedText", "context", "Lorg/rust/lang/core/macros/MacroExpansionContext;", "expandInclude", "expandIncludeStr", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nBuiltinMacroExpansion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltinMacroExpansion.kt\norg/rust/lang/core/macros/BuiltinMacroExpansionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n*L\n1#1,157:1\n1#2:158\n1#2:171\n113#3,2:159\n116#3:175\n115#3:176\n1617#4,9:161\n1869#4:170\n1870#4:172\n1626#4:173\n31#5:174\n*S KotlinDebug\n*F\n+ 1 BuiltinMacroExpansion.kt\norg/rust/lang/core/macros/BuiltinMacroExpansionKt\n*L\n136#1:171\n136#1:159,2\n136#1:175\n136#1:176\n136#1:161,9\n136#1:170\n136#1:172\n136#1:173\n136#1:174\n*E\n"})
public final class BuiltinMacroExpansionKt {
    @NotNull
    private static final Regex WHITESPACE_REGEX = new Regex("\\s+");

    @Nullable
    public static final CachedValueProvider.Result<RsResult<MacroExpansion, GetMacroExpansionError>> getBuiltInMacroExpansion(@NotNull RsPossibleMacroCall call2) {
        CachedValueProvider.Result<RsResult<MacroExpansion, GetMacroExpansionError>> result2;
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Object object = call2 instanceof RsMacroCall ? (RsMacroCall)call2 : null;
        if (object == null || (object = RsMacroCallKt.getMacroName((RsMacroCall)object)) == null) {
            return null;
        }
        Object macroName = object;
        if (Intrinsics.areEqual((Object)macroName, (Object)"include")) {
            return BuiltinMacroExpansionKt.cached(BuiltinMacroExpansionKt.expandInclude((RsMacroCall)call2), MacroExpansionManagerKt.getModificationTrackersForMemExpansion(call2));
        }
        RsMacroDataWithHash rsMacroDataWithHash = RsPossibleMacroCallKt.resolveToMacroWithoutPsi$default(call2, false, 1, null);
        Object t = rsMacroDataWithHash != null ? rsMacroDataWithHash.getData() : null;
        RsBuiltinMacroData rsBuiltinMacroData = t instanceof RsBuiltinMacroData ? (RsBuiltinMacroData)t : null;
        if (rsBuiltinMacroData == null) {
            return null;
        }
        RsBuiltinMacroData macroData = rsBuiltinMacroData;
        switch (macroData.getName()) {
            case "include_str": {
                result2 = BuiltinMacroExpansionKt.cached(BuiltinMacroExpansionKt.expandIncludeStr((RsMacroCall)call2), MacroExpansionManagerKt.getModificationTrackersForMemExpansion(call2));
                break;
            }
            case "concat": {
                result2 = BuiltinMacroExpansionKt.cached(BuiltinMacroExpansionKt.expandConcat((RsMacroCall)call2), MacroExpansionManagerKt.getModificationTrackersForMemExpansion(call2));
                break;
            }
            case "line": {
                RsResult<MacroExpansion, GetMacroExpansionError> rsResult = BuiltinMacroExpansionKt.expandLine((RsMacroCall)call2);
                Key key = PsiModificationTracker.MODIFICATION_COUNT;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"MODIFICATION_COUNT");
                result2 = BuiltinMacroExpansionKt.cached(rsResult, key);
                break;
            }
            case "column": {
                RsResult<MacroExpansion, GetMacroExpansionError> rsResult = BuiltinMacroExpansionKt.expandColumn((RsMacroCall)call2);
                Key key = PsiModificationTracker.MODIFICATION_COUNT;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"MODIFICATION_COUNT");
                result2 = BuiltinMacroExpansionKt.cached(rsResult, key);
                break;
            }
            case "stringify": {
                result2 = BuiltinMacroExpansionKt.cached(BuiltinMacroExpansionKt.expandStringify((RsMacroCall)call2), MacroExpansionManagerKt.getModificationTrackersForMemExpansion(call2));
                break;
            }
            default: {
                return null;
            }
        }
        return result2;
    }

    private static final CachedValueProvider.Result<RsResult<MacroExpansion, GetMacroExpansionError>> cached(RsResult<? extends MacroExpansion, ? extends GetMacroExpansionError> result2, Object dependency) {
        Object[] objectArray = new Object[]{dependency};
        CachedValueProvider.Result result3 = CachedValueProvider.Result.create(result2, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"create(...)");
        return result3;
    }

    private static final RsResult<MacroExpansion, GetMacroExpansionError> expandConcat(RsMacroCall call2) {
        RsConcatMacroArgument rsConcatMacroArgument = call2.getConcatMacroArgument();
        if (rsConcatMacroArgument == null) {
            return new RsResult.Err<GetMacroExpansionError.ConcatArgumentsMustBeLiteral>(GetMacroExpansionError.ConcatArgumentsMustBeLiteral.INSTANCE);
        }
        RsConcatMacroArgument concatArgs = rsConcatMacroArgument;
        StringBuilder expansionBuilder = new StringBuilder();
        for (RsExpr expr : concatArgs.getExprList()) {
            String string;
            RsExpr rsExpr = expr;
            if (rsExpr instanceof RsLitExpr) {
                string = BuiltinMacroExpansionKt.expandConcat$literalToString((RsLitExpr)expr);
                if (string == null) {
                    return new RsResult.Err<GetMacroExpansionError.ConcatArgumentsMustBeLiteral>(GetMacroExpansionError.ConcatArgumentsMustBeLiteral.INSTANCE);
                }
            } else if (rsExpr instanceof RsMacroExpr) {
                RsLitExpr literal;
                RsExpandedElement element = expr;
                while (element instanceof RsMacroExpr) {
                    RsMacroCall rsMacroCall = ((RsMacroExpr)element).getMacroCall();
                    Intrinsics.checkNotNullExpressionValue((Object)rsMacroCall, (String)"getMacroCall(...)");
                    RsResult<MacroExpansion, GetMacroExpansionError> expansionResult = RsPossibleMacroCallKt.getExpansionResult(rsMacroCall);
                    if (expansionResult.isErr()) {
                        return expansionResult;
                    }
                    MacroExpansion expansion = expansionResult.unwrap();
                    if ((RsExpandedElement)CollectionsKt.firstOrNull(expansion.getElements()) != null) continue;
                    return new RsResult.Err<GetMacroExpansionError.ConcatArgumentsMustBeLiteral>(GetMacroExpansionError.ConcatArgumentsMustBeLiteral.INSTANCE);
                }
                RsExpr rsExpr2 = element;
                if ((rsExpr2 instanceof RsLitExpr ? (RsLitExpr)rsExpr2 : null) == null) {
                    return new RsResult.Err<GetMacroExpansionError.ConcatArgumentsMustBeLiteral>(GetMacroExpansionError.ConcatArgumentsMustBeLiteral.INSTANCE);
                }
                string = BuiltinMacroExpansionKt.expandConcat$literalToString(literal = literal);
                if (string == null) {
                    return new RsResult.Err<GetMacroExpansionError.ConcatArgumentsMustBeLiteral>(GetMacroExpansionError.ConcatArgumentsMustBeLiteral.INSTANCE);
                }
            } else {
                return new RsResult.Err<GetMacroExpansionError.ConcatArgumentsMustBeLiteral>(GetMacroExpansionError.ConcatArgumentsMustBeLiteral.INSTANCE);
            }
            String segment = string;
            RsEscapesUtilsKt.escapeRust$default(segment, expansionBuilder, false, 2, null);
        }
        String expandedText = "\"" + expansionBuilder + "\"";
        return BuiltinMacroExpansionKt.createMacroExpansionFromText$default(call2, expandedText, null, 4, null);
    }

    private static final RsResult<MacroExpansion, GetMacroExpansionError> expandLine(RsMacroCall call2) {
        int line = ((Number)BuiltinMacroExpansionKt.getLineColumnPosition(call2).component1()).intValue();
        return BuiltinMacroExpansionKt.createMacroExpansionFromText$default(call2, String.valueOf(line + 1), null, 4, null);
    }

    private static final RsResult<MacroExpansion, GetMacroExpansionError> expandColumn(RsMacroCall call2) {
        int column = ((Number)BuiltinMacroExpansionKt.getLineColumnPosition(call2).component2()).intValue();
        return BuiltinMacroExpansionKt.createMacroExpansionFromText$default(call2, String.valueOf(column + 1), null, 4, null);
    }

    private static final Pair<Integer, Integer> getLineColumnPosition(RsMacroCall call2) {
        Document document;
        Document document2 = document = PsiDocumentManager.getInstance((Project)call2.getProject()).getLastCommittedDocument(call2.getContainingFile());
        int line = document2 != null ? document2.getLineNumber(PsiElementKt.getStartOffset(call2)) : 0;
        Document document3 = document;
        int startLine = document3 != null ? document3.getLineStartOffset(line) : 0;
        int column = PsiElementKt.getStartOffset(call2) - startLine;
        return TuplesKt.to((Object)line, (Object)column);
    }

    private static final RsResult<MacroExpansion, GetMacroExpansionError> expandStringify(RsMacroCall call2) {
        String string = BuiltinMacroExpansionKt.expandStringifyAsString(call2);
        if (string == null) {
            return new RsResult.Err<GetMacroExpansionError.MacroCallSyntax>(GetMacroExpansionError.MacroCallSyntax.INSTANCE);
        }
        String result2 = string;
        return BuiltinMacroExpansionKt.createMacroExpansionFromText$default(call2, "\"" + result2 + "\"", null, 4, null);
    }

    @Nullable
    public static final String expandStringifyAsString(@NotNull RsMacroCall call2) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        String string = RsMacroCallKt.getMacroBody(call2);
        if (string == null) {
            return null;
        }
        String body = string;
        CharSequence charSequence = body;
        Regex regex = WHITESPACE_REGEX;
        String string2 = "";
        return RsEscapesUtilsKt.escapeRust$default(regex.replace(charSequence, string2), false, 1, null);
    }

    private static final RsResult<MacroExpansion, GetMacroExpansionError> createMacroExpansionFromText(RsMacroCall call2, String expandedText, MacroExpansionContext context) {
        Project project = call2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 4, null);
        MacroExpansion macroExpansion = MacroExpansionKt.parseExpandedTextWithContext(context, factory2, expandedText);
        if (macroExpansion == null) {
            return new RsResult.Err<GetMacroExpansionError.MacroCallSyntax>(GetMacroExpansionError.MacroCallSyntax.INSTANCE);
        }
        MacroExpansion expansion = macroExpansion;
        for (RsExpandedElement element : expansion.getElements()) {
            RsElement it2;
            MacroExpansionManagerKt.setExpandedFrom(element, call2);
            PsiElement psiElement2 = RsPossibleMacroCallKt.getContextToSetForExpansion(call2);
            if ((psiElement2 instanceof RsElement ? (RsElement)psiElement2 : null) == null) continue;
            it2 = it2;
            boolean bl = false;
            RsExpandedElementKt.setExpandedElementContext(element, it2);
        }
        return new RsResult.Ok<MacroExpansion>(expansion);
    }

    static /* synthetic */ RsResult createMacroExpansionFromText$default(RsMacroCall rsMacroCall, String string, MacroExpansionContext macroExpansionContext, int n, Object object) {
        if ((n & 4) != 0) {
            macroExpansionContext = MacroExpansionKt.getExpansionContext(rsMacroCall);
        }
        return BuiltinMacroExpansionKt.createMacroExpansionFromText(rsMacroCall, string, macroExpansionContext);
    }

    /*
     * WARNING - void declaration
     */
    private static final RsResult<MacroExpansion, GetMacroExpansionError> expandInclude(RsMacroCall call2) {
        RsResult rsResult;
        PsiFile psiFile = RsMacroCallKt.findIncludingFile(call2);
        if (psiFile == null) {
            return new RsResult.Err<GetMacroExpansionError.IncludingFileNotFound>(GetMacroExpansionError.IncludingFileNotFound.INSTANCE);
        }
        PsiFile includingFile = psiFile;
        MacroExpansionContext context = MacroExpansionKt.getExpansionContext(call2);
        if (context == MacroExpansionContext.ITEM) {
            List list;
            RsFile rsFile = includingFile instanceof RsFile ? (RsFile)includingFile : null;
            if (rsFile == null) {
                VirtualFile virtualFile = includingFile.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                Project project = call2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                rsFile = MacroExpansionKt.prepareIncludeExpansionForNonRust(virtualFile, project);
                if (rsFile == null) {
                    return new RsResult.Err<GetMacroExpansionError.IncludingFileNotFound>(GetMacroExpansionError.IncludingFileNotFound.INSTANCE);
                }
            }
            RsFile includingRsFile = rsFile;
            PsiElement $this$stubChildrenOfType$iv = includingRsFile;
            boolean $i$f$stubChildrenOfType = false;
            if ($this$stubChildrenOfType$iv instanceof PsiFileImpl) {
                Object object = ((PsiFileImpl)$this$stubChildrenOfType$iv).getStub();
                if (object != null && (object = object.getChildrenStubs()) != null) {
                    void $this$mapNotNullTo$iv$iv$iv;
                    Iterable $this$mapNotNull$iv$iv = (Iterable)object;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv$iv;
                    Collection destination$iv$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        PsiElement it$iv$iv$iv;
                        Object element$iv$iv$iv$iv;
                        Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        StubElement it$iv = (StubElement)element$iv$iv$iv;
                        boolean bl2 = false;
                        PsiElement psiElement2 = it$iv.getPsi();
                        if (!(psiElement2 instanceof RsExpandedElement)) {
                            psiElement2 = null;
                        }
                        if ((PsiElement)((RsExpandedElement)psiElement2) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv$iv.add(it$iv$iv$iv);
                    }
                    list = (List)destination$iv$iv$iv;
                } else {
                    PsiElement $this$childrenOfType$iv$iv = $this$stubChildrenOfType$iv;
                    boolean $i$f$childrenOfType = false;
                    List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv$iv, RsExpandedElement.class);
                    list = list2;
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
                }
            } else {
                List list3 = PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)$this$stubChildrenOfType$iv, RsExpandedElement.class);
                Intrinsics.checkNotNull((Object)list3);
                list = list3;
            }
            List items = list;
            rsResult = new RsResult.Ok<MacroExpansion.Items>(new MacroExpansion.Items(includingRsFile, items));
        } else {
            String string = includingFile.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            rsResult = BuiltinMacroExpansionKt.createMacroExpansionFromText(call2, string, context);
        }
        return rsResult;
    }

    private static final RsResult<MacroExpansion, GetMacroExpansionError> expandIncludeStr(RsMacroCall call2) {
        PsiFile psiFile;
        Object object = call2.getIncludeMacroArgument();
        if (object == null || (object = object.getExpr()) == null || (object = RsMacroCallKt.getValue((RsExpr)object)) == null || (object = (String)((RsResult)object).ok()) == null) {
            return new RsResult.Err<GetMacroExpansionError.MacroCallSyntax>(GetMacroExpansionError.MacroCallSyntax.INSTANCE);
        }
        Object path = object;
        RsPossibleMacroCall rsPossibleMacroCall = RsExpandedElementKt.findMacroCallExpandedFrom(call2);
        if (rsPossibleMacroCall == null) {
            rsPossibleMacroCall = call2;
        }
        if ((psiFile = rsPossibleMacroCall.getContainingFile()) == null || (psiFile = psiFile.getOriginalFile()) == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return new RsResult.Err<GetMacroExpansionError.IncludingFileNotFound>(GetMacroExpansionError.IncludingFileNotFound.INSTANCE);
        }
        PsiFile file = psiFile;
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null || (virtualFile = UtilsKt.findFileByMaybeRelativePath(virtualFile, (String)path)) == null) {
            return new RsResult.Err<GetMacroExpansionError.IncludingFileNotFound>(GetMacroExpansionError.IncludingFileNotFound.INSTANCE);
        }
        VirtualFile includedFile = virtualFile;
        Object object2 = UtilsKt.getDocument(includedFile);
        if (object2 == null || (object2 = object2.getText()) == null) {
            return new RsResult.Err<GetMacroExpansionError.IncludingFileNotFound>(GetMacroExpansionError.IncludingFileNotFound.INSTANCE);
        }
        Object text = object2;
        return BuiltinMacroExpansionKt.createMacroExpansionFromText$default(call2, "\"" + RsEscapesUtilsKt.escapeRust$default((CharSequence)text, false, 1, null) + "\"", null, 4, null);
    }

    private static final String expandConcat$literalToString(RsLitExpr expr) {
        String string;
        RsLiteralKind rsLiteralKind = RsLiteralKindKt.getKind(expr);
        if (rsLiteralKind instanceof RsLiteralKind.String) {
            string = RsLitExprKt.getStringValue(expr);
        } else if (rsLiteralKind instanceof RsLiteralKind.Char) {
            string = RsLitExprKt.getCharValue(expr);
        } else if (rsLiteralKind instanceof RsLiteralKind.Integer) {
            Long l = RsLitExprKt.getIntegerValue(expr);
            string = l != null ? String.valueOf(l) : null;
        } else if (rsLiteralKind instanceof RsLiteralKind.Float) {
            string = expr.getText();
            if (string == null) {
                string = "";
            }
        } else if (rsLiteralKind instanceof RsLiteralKind.Boolean) {
            Boolean bl = RsLitExprKt.getBooleanValue(expr);
            string = bl != null ? String.valueOf(bl) : null;
        } else if (rsLiteralKind == null) {
            string = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }
}

