/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.lexer;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.lexer.EscapeUtilsKt;
import org.rust.lang.core.lexer.LexerBaseEx;
import org.rust.lang.core.psi.RsElementTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014J\"\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u0005H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/rust/lang/core/lexer/RsEscapesLexer;", "Lorg/rust/lang/core/lexer/LexerBaseEx;", "defaultToken", "Lcom/intellij/psi/tree/IElementType;", "unicode", "", "eol", "extendedByte", "<init>", "(Lcom/intellij/psi/tree/IElementType;ZZZ)V", "getDefaultToken", "()Lcom/intellij/psi/tree/IElementType;", "getUnicode", "()Z", "getEol", "getExtendedByte", "determineTokenType", "locateToken", "", "start", "isValidByteEscape", "end", "extended", "isValidUnicodeEscape", "testCodepointRange", "max", "Companion", "intellij.rustrover.common"})
@SourceDebugExtension(value={"SMAP\nRsEscapesLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsEscapesLexer.kt\norg/rust/lang/core/lexer/RsEscapesLexer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,157:1\n1104#2,3:158\n434#2:161\n507#2,5:162\n*S KotlinDebug\n*F\n+ 1 RsEscapesLexer.kt\norg/rust/lang/core/lexer/RsEscapesLexer\n*L\n103#1:158,3\n113#1:161\n113#1:162,5\n*E\n"})
public final class RsEscapesLexer
extends LexerBaseEx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IElementType defaultToken;
    private final boolean unicode;
    private final boolean eol;
    private final boolean extendedByte;
    @NotNull
    private static final TokenSet ESCAPABLE_LITERALS_TOKEN_SET;

    private RsEscapesLexer(IElementType defaultToken, boolean unicode, boolean eol, boolean extendedByte) {
        this.defaultToken = defaultToken;
        this.unicode = unicode;
        this.eol = eol;
        this.extendedByte = extendedByte;
    }

    /* synthetic */ RsEscapesLexer(IElementType iElementType, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        this(iElementType, bl, bl2, bl3);
    }

    @NotNull
    public final IElementType getDefaultToken() {
        return this.defaultToken;
    }

    public final boolean getUnicode() {
        return this.unicode;
    }

    public final boolean getEol() {
        return this.eol;
    }

    public final boolean getExtendedByte() {
        return this.extendedByte;
    }

    @Override
    @Nullable
    protected IElementType determineTokenType() {
        if (this.getTokenStart() >= this.getTokenEnd()) {
            return null;
        }
        if (this.getBufferSequence().charAt(this.getTokenStart()) != '\\') {
            return this.defaultToken;
        }
        if (this.getTokenStart() + 1 >= this.getTokenEnd()) {
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        return switch (this.getBufferSequence().charAt(this.getTokenStart() + 1)) {
            case 'u' -> {
                if (!this.unicode) {
                    yield StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                }
                if (this.isValidUnicodeEscape(this.getTokenStart(), this.getTokenEnd())) {
                    yield StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                }
                yield StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
            case 'x' -> EscapeUtilsKt.esc(this.isValidByteEscape(this.getTokenStart(), this.getTokenEnd(), this.extendedByte));
            case '\n', '\r' -> EscapeUtilsKt.esc(this.eol);
            case '\"', '\'', '0', '\\', 'n', 'r', 't' -> StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            default -> StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        };
    }

    @Override
    protected int locateToken(int start2) {
        if (start2 >= this.getBufferEnd()) {
            return start2;
        }
        if (this.getBufferSequence().charAt(start2) == '\\') {
            int i2 = start2 + 1;
            if (i2 >= this.getBufferEnd()) {
                return this.getBufferEnd();
            }
            switch (this.getBufferSequence().charAt(i2)) {
                case 'x': {
                    if (this.getBufferEnd() - (i2 + 1) < 1 || !StringUtil.isHexDigit((char)this.getBufferSequence().charAt(i2 + 1))) break;
                    return this.getBufferEnd() - (i2 + 2) >= 1 && StringUtil.isHexDigit((char)this.getBufferSequence().charAt(i2 + 2)) ? i2 + 2 + 1 : i2 + 1 + 1;
                }
                case 'u': {
                    if (this.getBufferEnd() - (i2 + 1) < 1 || this.getBufferSequence().charAt(i2 + 1) != '{') break;
                    int idx = CharArrayUtil.indexOf((CharSequence)this.getBufferSequence(), (CharSequence)"}", (int)(i2 + 1), (int)this.getBufferEnd());
                    return idx != -1 ? idx + 1 : this.getBufferEnd();
                }
                case '\n': 
                case '\r': {
                    int j;
                    for (j = i2; j < this.getBufferEnd() && EscapeUtilsKt.isWhitespaceChar(this.getBufferSequence().charAt(j)); ++j) {
                    }
                    return j;
                }
            }
            return i2 + 1;
        }
        int idx = CharArrayUtil.indexOf((CharSequence)this.getBufferSequence(), (CharSequence)"\\", (int)(start2 + 1), (int)this.getBufferEnd());
        return idx != -1 ? idx : this.getBufferEnd();
    }

    private final boolean isValidByteEscape(int start2, int end, boolean extended) {
        return end - start2 == 4 && StringsKt.startsWith$default((CharSequence)this.getBufferSequence(), (CharSequence)"\\x", (int)start2, (boolean)false, (int)4, null) && this.testCodepointRange(start2 + 2, end, extended ? 255 : 127);
    }

    static /* synthetic */ boolean isValidByteEscape$default(RsEscapesLexer rsEscapesLexer, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = false;
        }
        return rsEscapesLexer.isValidByteEscape(n, n2, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValidUnicodeEscape(int start2, int end) {
        void $this$count$iv;
        CharSequence charSequence = ((Object)this.getBufferSequence().subSequence(start2, end)).toString();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it2 = element$iv = $this$count$iv.charAt(j);
            boolean bl = false;
            if (!(it2 != '_')) continue;
            ++count$iv;
        }
        int n = count$iv;
        return (5 <= n ? n < 11 : false) && StringsKt.startsWith$default((CharSequence)this.getBufferSequence(), (CharSequence)"\\u{", (int)start2, (boolean)false, (int)4, null) && this.getBufferSequence().charAt(end - 1) == '}' && this.testCodepointRange(start2 + 3, end - 1, 0x10FFFF);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean testCodepointRange(int start2, int end, int max) {
        boolean bl;
        try {
            boolean bl2;
            String range = ((Object)this.getBufferSequence().subSequence(start2, end)).toString();
            if (StringsKt.startsWith$default((CharSequence)range, (char)'_', (boolean)false, (int)2, null)) {
                bl2 = false;
            } else {
                void $this$filterTo$iv$iv;
                String $this$filter$iv = range;
                boolean $i$f$filter = false;
                CharSequence charSequence = $this$filter$iv;
                Appendable destination$iv$iv = new StringBuilder();
                boolean $i$f$filterTo = false;
                int n = $this$filterTo$iv$iv.length();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    char element$iv$iv;
                    char it2 = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    boolean bl3 = false;
                    if (!(it2 != '_')) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                bl2 = Integer.parseInt(((StringBuilder)destination$iv$iv).toString(), 16) <= max;
            }
            bl = bl2;
        }
        catch (NumberFormatException e) {
            bl = false;
        }
        return bl;
    }

    public /* synthetic */ RsEscapesLexer(IElementType defaultToken, boolean unicode, boolean eol, boolean extendedByte, DefaultConstructorMarker $constructor_marker) {
        this(defaultToken, unicode, eol, extendedByte);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{RsElementTypes.BYTE_LITERAL, RsElementTypes.CHAR_LITERAL, RsElementTypes.STRING_LITERAL, RsElementTypes.BYTE_STRING_LITERAL, RsElementTypes.CSTRING_LITERAL};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        ESCAPABLE_LITERALS_TOKEN_SET = tokenSet;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J$\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\nR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/lexer/RsEscapesLexer$Companion;", "", "<init>", "()V", "of", "Lorg/rust/lang/core/lexer/RsEscapesLexer;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "dummy", "unicode", "", "eol", "extendedByte", "ESCAPABLE_LITERALS_TOKEN_SET", "Lcom/intellij/psi/tree/TokenSet;", "getESCAPABLE_LITERALS_TOKEN_SET", "()Lcom/intellij/psi/tree/TokenSet;", "intellij.rustrover.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RsEscapesLexer of(@NotNull IElementType tokenType) {
            RsEscapesLexer rsEscapesLexer;
            Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
            IElementType iElementType = tokenType;
            if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.BYTE_LITERAL)) {
                IElementType iElementType2 = RsElementTypes.BYTE_LITERAL;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"BYTE_LITERAL");
                rsEscapesLexer = new RsEscapesLexer(iElementType2, false, false, true, 6, null);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.CHAR_LITERAL)) {
                IElementType iElementType3 = RsElementTypes.CHAR_LITERAL;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType3, (String)"CHAR_LITERAL");
                rsEscapesLexer = new RsEscapesLexer(iElementType3, true, false, false, 12, null);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.BYTE_STRING_LITERAL)) {
                IElementType iElementType4 = RsElementTypes.BYTE_STRING_LITERAL;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType4, (String)"BYTE_STRING_LITERAL");
                rsEscapesLexer = new RsEscapesLexer(iElementType4, false, true, true, 2, null);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.CSTRING_LITERAL)) {
                IElementType iElementType5 = RsElementTypes.CSTRING_LITERAL;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType5, (String)"CSTRING_LITERAL");
                rsEscapesLexer = new RsEscapesLexer(iElementType5, true, true, true, null);
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.STRING_LITERAL)) {
                IElementType iElementType6 = RsElementTypes.STRING_LITERAL;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType6, (String)"STRING_LITERAL");
                rsEscapesLexer = new RsEscapesLexer(iElementType6, true, true, false, 8, null);
            } else {
                throw new IllegalArgumentException("unsupported literal type: " + tokenType);
            }
            return rsEscapesLexer;
        }

        @NotNull
        public final RsEscapesLexer dummy(boolean unicode, boolean eol, boolean extendedByte) {
            IElementType iElementType = RsElementTypes.STRING_LITERAL;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"STRING_LITERAL");
            return new RsEscapesLexer(iElementType, unicode, eol, extendedByte, null);
        }

        public static /* synthetic */ RsEscapesLexer dummy$default(Companion companion, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            if ((n & 2) != 0) {
                bl2 = true;
            }
            if ((n & 4) != 0) {
                bl3 = true;
            }
            return companion.dummy(bl, bl2, bl3);
        }

        @NotNull
        public final TokenSet getESCAPABLE_LITERALS_TOKEN_SET() {
            return ESCAPABLE_LITERALS_TOKEN_SET;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

