/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.IndexableSetContributor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.macros.MacroExpansionManager;
import org.rust.lang.core.macros.MacroExpansionManagerKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/rust/lang/core/indexing/RsIndexableSetContributor;", "Lcom/intellij/util/indexing/IndexableSetContributor;", "<init>", "()V", "getAdditionalRootsToIndex", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAdditionalProjectRootsToIndex", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rustrover.core"})
public final class RsIndexableSetContributor
extends IndexableSetContributor {
    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        return SetsKt.emptySet();
    }

    @NotNull
    public Set<VirtualFile> getAdditionalProjectRootsToIndex(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HashSet additionalProjectRootsToIndex = new HashSet();
        MacroExpansionManager macroExpansionManager = MacroExpansionManagerKt.getMacroExpansionManagerIfCreated(project);
        if (macroExpansionManager == null) {
            return SetsKt.emptySet();
        }
        MacroExpansionManager macroExpansionManager2 = macroExpansionManager;
        if (!macroExpansionManager2.isReady()) {
            return SetsKt.emptySet();
        }
        VirtualFile indexableDirectory = macroExpansionManager2.getIndexableDirectory();
        if (indexableDirectory == null) {
            MacroExpansionManagerKt.MACRO_LOG.error("Macro expansion directory not created for " + project.getName());
        } else {
            ((Collection)additionalProjectRootsToIndex).add(indexableDirectory);
        }
        return additionalProjectRootsToIndex;
    }
}

