/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.dfa.liveness;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.dfa.Cmt;
import org.rust.lang.core.dfa.DataFlowContext;
import org.rust.lang.core.dfa.KillFrom;
import org.rust.lang.core.dfa.liveness.Declaration;
import org.rust.lang.core.dfa.liveness.LiveDataFlowOperator;
import org.rust.lang.core.dfa.liveness.Usage;
import org.rust.lang.core.dfa.liveness.UsagePath;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.ext.RsElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BM\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\tH\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\t2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u001aJ\u0018\u0010\u001b\u001a\u00020\u00152\u0010\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u001e0\u001dj\u0002`\u001fJ\u0016\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00152\u0006\u0010!\u001a\u00020&R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/rust/lang/core/dfa/liveness/LivenessData;", "", "usages", "", "Lorg/rust/lang/core/dfa/liveness/Usage;", "declarations", "Lorg/rust/lang/core/dfa/liveness/Declaration;", "paths", "", "Lorg/rust/lang/core/dfa/liveness/UsagePath;", "pathToIndex", "", "", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/List;Ljava/util/Map;)V", "getUsages", "()Ljava/util/Set;", "getDeclarations", "getPaths", "()Ljava/util/List;", "addUsagePath", "", "usagePath", "eachBasePath", "", "predicate", "Lkotlin/Function1;", "addGenKills", "dfcxLiveness", "Lorg/rust/lang/core/dfa/DataFlowContext;", "Lorg/rust/lang/core/dfa/liveness/LiveDataFlowOperator;", "Lorg/rust/lang/core/dfa/liveness/LivenessDataFlow;", "addUsage", "element", "Lorg/rust/lang/core/psi/ext/RsElement;", "cmt", "Lorg/rust/lang/core/dfa/Cmt;", "addDeclaration", "Lorg/rust/lang/core/psi/RsPatBinding;", "intellij.rustrover.core"})
public final class LivenessData {
    @NotNull
    private final Set<Usage> usages;
    @NotNull
    private final Set<Declaration> declarations;
    @NotNull
    private final List<UsagePath> paths;
    @NotNull
    private final Map<UsagePath, Integer> pathToIndex;

    public LivenessData(@NotNull Set<Usage> usages, @NotNull Set<Declaration> declarations, @NotNull List<UsagePath> paths, @NotNull Map<UsagePath, Integer> pathToIndex) {
        Intrinsics.checkNotNullParameter(usages, (String)"usages");
        Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter(pathToIndex, (String)"pathToIndex");
        this.usages = usages;
        this.declarations = declarations;
        this.paths = paths;
        this.pathToIndex = pathToIndex;
    }

    public /* synthetic */ LivenessData(Set set, Set set2, List list, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        if ((n & 2) != 0) {
            set2 = new LinkedHashSet();
        }
        if ((n & 4) != 0) {
            list = new ArrayList();
        }
        if ((n & 8) != 0) {
            map2 = new LinkedHashMap();
        }
        this(set, set2, list, map2);
    }

    @NotNull
    public final Set<Usage> getUsages() {
        return this.usages;
    }

    @NotNull
    public final Set<Declaration> getDeclarations() {
        return this.declarations;
    }

    @NotNull
    public final List<UsagePath> getPaths() {
        return this.paths;
    }

    private final void addUsagePath(UsagePath usagePath) {
        if (!this.pathToIndex.containsKey(usagePath)) {
            int index = this.paths.size();
            this.paths.add(usagePath);
            this.pathToIndex.put(usagePath, index);
        }
    }

    public final boolean eachBasePath(@NotNull UsagePath usagePath, @NotNull Function1<? super UsagePath, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)usagePath, (String)"usagePath");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        UsagePath path = usagePath;
        while (true) {
            if (!((Boolean)predicate.invoke((Object)path)).booleanValue()) {
                return false;
            }
            UsagePath usagePath2 = path;
            if (usagePath2 instanceof UsagePath.Base) {
                return true;
            }
            if (!(usagePath2 instanceof UsagePath.Extend)) break;
            path = ((UsagePath.Extend)path).getParent();
        }
        throw new NoWhenBranchMatchedException();
    }

    public final void addGenKills(@NotNull DataFlowContext<LiveDataFlowOperator> dfcxLiveness) {
        int bit;
        Intrinsics.checkNotNullParameter(dfcxLiveness, (String)"dfcxLiveness");
        for (Usage usage : this.usages) {
            Integer n = this.pathToIndex.get(usage.getPath());
            if (n == null) {
                throw new IllegalStateException("No such usage path in pathToIndex".toString());
            }
            bit = n;
            dfcxLiveness.addGen(usage.getElement(), bit);
        }
        for (Declaration declaration : this.declarations) {
            Integer n = this.pathToIndex.get(declaration.getPath());
            if (n == null) {
                throw new IllegalStateException("No such declaration path in pathToIndex".toString());
            }
            bit = n;
            dfcxLiveness.addKill(KillFrom.ScopeEnd, declaration.getElement(), bit);
        }
    }

    public final void addUsage(@NotNull RsElement element, @NotNull Cmt cmt) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)cmt, (String)"cmt");
        UsagePath usagePath = UsagePath.Companion.computeFor(cmt);
        if (usagePath == null) {
            return;
        }
        UsagePath usagePath2 = usagePath;
        if (!this.pathToIndex.containsKey(usagePath2)) {
            return;
        }
        this.usages.add(new Usage(usagePath2, element));
    }

    public final void addDeclaration(@NotNull RsPatBinding element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UsagePath.Base usagePath = new UsagePath.Base(element);
        this.addUsagePath(usagePath);
        this.declarations.add(new Declaration(usagePath, null, 2, null));
    }

    public LivenessData() {
        this(null, null, null, null, 15, null);
    }
}

