/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.dfa.liveness;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.dfa.ControlFlowGraph;
import org.rust.lang.core.dfa.DataFlowContext;
import org.rust.lang.core.dfa.DataFlowOperator;
import org.rust.lang.core.dfa.FlowDirection;
import org.rust.lang.core.dfa.liveness.LiveDataFlowOperator;
import org.rust.lang.core.dfa.liveness.LivenessContext;
import org.rust.lang.core.dfa.liveness.LivenessData;
import org.rust.lang.core.dfa.liveness.Usage;
import org.rust.lang.core.dfa.liveness.UsagePath;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.ext.RsElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/rust/lang/core/dfa/liveness/FlowedLivenessData;", "", "ctx", "Lorg/rust/lang/core/dfa/liveness/LivenessContext;", "livenessData", "Lorg/rust/lang/core/dfa/liveness/LivenessData;", "dfcxLivePaths", "Lorg/rust/lang/core/dfa/DataFlowContext;", "Lorg/rust/lang/core/dfa/liveness/LiveDataFlowOperator;", "Lorg/rust/lang/core/dfa/liveness/LivenessDataFlow;", "<init>", "(Lorg/rust/lang/core/dfa/liveness/LivenessContext;Lorg/rust/lang/core/dfa/liveness/LivenessData;Lorg/rust/lang/core/dfa/DataFlowContext;)V", "collectDeadDeclarations", "", "collectLastUsages", "isDeadOnEntry", "", "Lorg/rust/lang/core/dfa/liveness/UsagePath;", "element", "Lorg/rust/lang/core/psi/ext/RsElement;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nLiveness.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Liveness.kt\norg/rust/lang/core/dfa/liveness/FlowedLivenessData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,276:1\n808#2,11:277\n*S KotlinDebug\n*F\n+ 1 Liveness.kt\norg/rust/lang/core/dfa/liveness/FlowedLivenessData\n*L\n79#1:277,11\n*E\n"})
public final class FlowedLivenessData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LivenessContext ctx;
    @NotNull
    private final LivenessData livenessData;
    @NotNull
    private final DataFlowContext<LiveDataFlowOperator> dfcxLivePaths;

    public FlowedLivenessData(@NotNull LivenessContext ctx, @NotNull LivenessData livenessData, @NotNull DataFlowContext<LiveDataFlowOperator> dfcxLivePaths) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)livenessData, (String)"livenessData");
        Intrinsics.checkNotNullParameter(dfcxLivePaths, (String)"dfcxLivePaths");
        this.ctx = ctx;
        this.livenessData = livenessData;
        this.dfcxLivePaths = dfcxLivePaths;
    }

    /*
     * WARNING - void declaration
     */
    public final void collectDeadDeclarations() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.livenessData.getPaths();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UsagePath.Base)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List basePaths = (List)destination$iv$iv;
        for (UsagePath.Base usagePath : basePaths) {
            RsPatBinding usageDeclaration;
            if (!this.isDeadOnEntry(usagePath, usageDeclaration = usagePath.getDeclaration())) continue;
            this.ctx.registerDeadDeclaration(usageDeclaration, usagePath.getDeclarationKind());
        }
    }

    public final void collectLastUsages() {
        for (Usage usage : this.livenessData.getUsages()) {
            RsElement usageElement;
            UsagePath usagePath = usage.getPath();
            if (!this.isDeadOnEntry(usagePath, usageElement = usage.getElement())) continue;
            this.ctx.registerLastUsage(usagePath.getDeclaration(), usageElement);
        }
    }

    private final boolean isDeadOnEntry(UsagePath $this$isDeadOnEntry, RsElement element) {
        Ref.BooleanRef isDead = new Ref.BooleanRef();
        isDead.element = true;
        return this.dfcxLivePaths.eachBitOnEntry(element, (Function1<Integer, Boolean>)((Function1)arg_0 -> FlowedLivenessData.isDeadOnEntry$lambda$0(this, $this$isDeadOnEntry, isDead, arg_0)));
    }

    private static final boolean isDeadOnEntry$lambda$0(FlowedLivenessData this$0, UsagePath $this_isDeadOnEntry, Ref.BooleanRef $isDead, int index) {
        UsagePath path = this$0.livenessData.getPaths().get(index);
        if (Intrinsics.areEqual((Object)$this_isDeadOnEntry, (Object)path)) {
            $isDead.element = false;
        } else {
            boolean isEachExtensionDead = this$0.livenessData.eachBasePath(path, (Function1<? super UsagePath, Boolean>)((Function1)arg_0 -> FlowedLivenessData.isDeadOnEntry$lambda$0$0($this_isDeadOnEntry, arg_0)));
            if (!isEachExtensionDead) {
                $isDead.element = false;
            }
        }
        return $isDead.element;
    }

    private static final boolean isDeadOnEntry$lambda$0$0(UsagePath $this_isDeadOnEntry, UsagePath it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return !Intrinsics.areEqual((Object)it2, (Object)$this_isDeadOnEntry);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/rust/lang/core/dfa/liveness/FlowedLivenessData$Companion;", "", "<init>", "()V", "buildFor", "Lorg/rust/lang/core/dfa/liveness/FlowedLivenessData;", "ctx", "Lorg/rust/lang/core/dfa/liveness/LivenessContext;", "livenessData", "Lorg/rust/lang/core/dfa/liveness/LivenessData;", "cfg", "Lorg/rust/lang/core/dfa/ControlFlowGraph;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FlowedLivenessData buildFor(@NotNull LivenessContext ctx, @NotNull LivenessData livenessData, @NotNull ControlFlowGraph cfg) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)livenessData, (String)"livenessData");
            Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
            DataFlowContext<DataFlowOperator> dfcxLivePaths = new DataFlowContext<DataFlowOperator>(cfg, LiveDataFlowOperator.INSTANCE, livenessData.getPaths().size(), FlowDirection.Backward);
            livenessData.addGenKills(dfcxLivePaths);
            dfcxLivePaths.propagate();
            return new FlowedLivenessData(ctx, livenessData, dfcxLivePaths);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

