/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.dfa;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.dfa.BorrowKind;
import org.rust.lang.core.dfa.Categorization;
import org.rust.lang.core.dfa.Cmt;
import org.rust.lang.core.dfa.MutabilityCategory;
import org.rust.lang.core.dfa.PointerKind;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsEnumVariant;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFieldLookupExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsIndexExpr;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsOuterAttributedExpr;
import org.rust.lang.core.psi.RsParenExpr;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPatField;
import org.rust.lang.core.psi.RsPatFieldFull;
import org.rust.lang.core.psi.RsPatIdent;
import org.rust.lang.core.psi.RsPatSlice;
import org.rust.lang.core.psi.RsPatStruct;
import org.rust.lang.core.psi.RsPatTup;
import org.rust.lang.core.psi.RsPatTupleStruct;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsSelfParameter;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.ext.RsConstantKt;
import org.rust.lang.core.psi.ext.RsDotExpr;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsIndexExprKt;
import org.rust.lang.core.psi.ext.RsPatBindingKt;
import org.rust.lang.core.psi.ext.RsSelfParameterKt;
import org.rust.lang.core.psi.ext.RsUnaryExprKt;
import org.rust.lang.core.resolve.ImplLookup;
import org.rust.lang.core.resolve.ref.RsReference;
import org.rust.lang.core.types.infer.Adjustment;
import org.rust.lang.core.types.infer.ResolvedPath;
import org.rust.lang.core.types.infer.RsInferenceData;
import org.rust.lang.core.types.regions.ReStatic;
import org.rust.lang.core.types.regions.Region;
import org.rust.lang.core.types.ty.Mutability;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyKt;
import org.rust.lang.core.types.ty.TyRawPtr;
import org.rust.lang.core.types.ty.TyRef;
import org.rust.lang.core.types.ty.TyUnknown;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002J\u0018\u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\rH\u0002J\u001a\u0010+\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010,\u001a\u00020-H\u0002J\u001e\u0010+\u001a\u00020\r2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020-J6\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\r2\u0006\u00105\u001a\u0002062\u001e\u00107\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020308J*\u0010:\u001a\u00020\r2\u0006\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020\r2\b\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010=\u001a\u00020-H\u0002J\u0018\u0010>\u001a\u00020\r2\u0006\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006?"}, d2={"Lorg/rust/lang/core/dfa/MemoryCategorizationContext;", "", "lookup", "Lorg/rust/lang/core/resolve/ImplLookup;", "inference", "Lorg/rust/lang/core/types/infer/RsInferenceData;", "<init>", "(Lorg/rust/lang/core/resolve/ImplLookup;Lorg/rust/lang/core/types/infer/RsInferenceData;)V", "getLookup", "()Lorg/rust/lang/core/resolve/ImplLookup;", "getInference", "()Lorg/rust/lang/core/types/infer/RsInferenceData;", "processExpr", "Lorg/rust/lang/core/dfa/Cmt;", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "processExprAdjustedWith", "adjustments", "", "Lorg/rust/lang/core/types/infer/Adjustment;", "processExprUnadjusted", "processUnaryExpr", "unaryExpr", "Lorg/rust/lang/core/psi/RsUnaryExpr;", "processDotExpr", "dotExpr", "Lorg/rust/lang/core/psi/ext/RsDotExpr;", "processIndexExpr", "indexExpr", "Lorg/rust/lang/core/psi/RsIndexExpr;", "processOverloadedPlace", "base", "processPathExpr", "pathExpr", "Lorg/rust/lang/core/psi/RsPathExpr;", "processParenExpr", "parenExpr", "Lorg/rust/lang/core/psi/RsParenExpr;", "processOuterAttributedExpr", "outerAttributedExpr", "Lorg/rust/lang/core/psi/RsOuterAttributedExpr;", "processDeref", "baseCmt", "processRvalue", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "element", "Lorg/rust/lang/core/psi/ext/RsElement;", "tempScope", "Lorg/rust/lang/core/types/regions/Region;", "walkPat", "", "cmt", "pat", "Lorg/rust/lang/core/psi/RsPat;", "callback", "Lkotlin/Function3;", "Lorg/rust/lang/core/psi/RsPatBinding;", "cmtOfField", "fieldName", "", "fieldType", "cmtOfSliceElement", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMemoryCategorization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryCategorization.kt\norg/rust/lang/core/dfa/MemoryCategorizationContext\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,438:1\n19#2:439\n1#3:440\n1869#4,2:441\n127#5:443\n*S KotlinDebug\n*F\n+ 1 MemoryCategorization.kt\norg/rust/lang/core/dfa/MemoryCategorizationContext\n*L\n284#1:439\n417#1:441,2\n374#1:443\n*E\n"})
public final class MemoryCategorizationContext {
    @NotNull
    private final ImplLookup lookup;
    @NotNull
    private final RsInferenceData inference;

    public MemoryCategorizationContext(@NotNull ImplLookup lookup2, @NotNull RsInferenceData inference) {
        Intrinsics.checkNotNullParameter((Object)lookup2, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)inference, (String)"inference");
        this.lookup = lookup2;
        this.inference = inference;
    }

    @NotNull
    public final ImplLookup getLookup() {
        return this.lookup;
    }

    @NotNull
    public final RsInferenceData getInference() {
        return this.inference;
    }

    @NotNull
    public final Cmt processExpr(@NotNull RsExpr expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        List<Adjustment> adjustments = this.inference.getExprAdjustments(expr);
        return this.processExprAdjustedWith(expr, CollectionsKt.asReversed(adjustments).iterator());
    }

    private final Cmt processExprAdjustedWith(RsExpr expr, Iterator<? extends Adjustment> adjustments) {
        Cmt cmt;
        Adjustment adjustment = org.rust.stdext.CollectionsKt.nextOrNull(adjustments);
        if (adjustment == null) {
            cmt = this.processExprUnadjusted(expr);
        } else if (adjustment instanceof Adjustment.Deref) {
            Cmt cmt2;
            if (((Adjustment.Deref)adjustment).getOverloaded() != null) {
                TyRef ref = new TyRef(((Adjustment.Deref)adjustment).getTarget(), ((Adjustment.Deref)adjustment).getOverloaded(), null, null, 12, null);
                cmt2 = this.processRvalue(expr, ref);
            } else {
                cmt2 = this.processExprAdjustedWith(expr, adjustments);
            }
            Cmt cmt3 = cmt2;
            cmt = this.processDeref(expr, cmt3);
        } else if (adjustment instanceof Adjustment.BorrowReference) {
            TyRef target = ((Adjustment.BorrowReference)adjustment).getTarget();
            Cmt unadjustedCmt = this.processExprUnadjusted(expr);
            cmt = target.getMutability().isMut() && !unadjustedCmt.isMutable() ? this.processExprUnadjusted(expr) : this.processRvalue(expr, target);
        } else {
            Ty target = adjustment.getTarget();
            cmt = this.processRvalue(expr, target);
        }
        return cmt;
    }

    private final Cmt processExprUnadjusted(RsExpr expr) {
        RsExpr rsExpr = expr;
        return rsExpr instanceof RsUnaryExpr ? this.processUnaryExpr((RsUnaryExpr)expr) : (rsExpr instanceof RsDotExpr ? this.processDotExpr((RsDotExpr)expr) : (rsExpr instanceof RsIndexExpr ? this.processIndexExpr((RsIndexExpr)expr) : (rsExpr instanceof RsPathExpr ? this.processPathExpr((RsPathExpr)expr) : (rsExpr instanceof RsParenExpr ? this.processParenExpr((RsParenExpr)expr) : (rsExpr instanceof RsOuterAttributedExpr ? this.processOuterAttributedExpr((RsOuterAttributedExpr)expr) : MemoryCategorizationContext.processRvalue$default(this, expr, null, 2, null))))));
    }

    private final Cmt processUnaryExpr(RsUnaryExpr unaryExpr) {
        Cmt cmt;
        if (!RsUnaryExprKt.isDereference(unaryExpr)) {
            return MemoryCategorizationContext.processRvalue$default(this, unaryExpr, null, 2, null);
        }
        RsExpr rsExpr = unaryExpr.getExpr();
        if (rsExpr == null) {
            return new Cmt(unaryExpr, null, null, this.inference.getExprType(unaryExpr), 6, null);
        }
        RsExpr base = rsExpr;
        if (this.inference.isOverloadedOperator(unaryExpr)) {
            cmt = this.processOverloadedPlace(unaryExpr, base);
        } else {
            Cmt baseCmt = this.processExpr(base);
            cmt = this.processDeref(unaryExpr, baseCmt);
        }
        return cmt;
    }

    /*
     * WARNING - void declaration
     */
    private final Cmt processDotExpr(RsDotExpr dotExpr) {
        Object object;
        RsFieldLookupExpr rsFieldLookupExpr;
        void $this$asSafely$iv;
        if (dotExpr instanceof RsMethodCallExpr) {
            return MemoryCategorizationContext.processRvalue$default(this, dotExpr, null, 2, null);
        }
        Ty type = this.inference.getExprType(dotExpr);
        RsExpr base = dotExpr.getReceiver();
        Cmt baseCmt = this.processExpr(base);
        RsElement rsElement = dotExpr;
        boolean $i$f$asSafely = false;
        Object v0 = $this$asSafely$iv;
        if (!(v0 instanceof RsFieldLookupExpr)) {
            v0 = null;
        }
        if ((rsFieldLookupExpr = (RsFieldLookupExpr)v0) != null && (rsElement = rsFieldLookupExpr.getFieldLookup()) != null) {
            RsElement it2 = rsElement;
            boolean bl = false;
            object = it2.getIdentifier();
            if (object == null || (object = object.getText()) == null) {
                PsiElement psiElement2 = it2.getIntegerLiteral();
                object = psiElement2 != null ? psiElement2.getText() : null;
            }
        } else {
            object = null;
        }
        PsiElement fieldName = object;
        return this.cmtOfField(dotExpr, baseCmt, (String)fieldName, type);
    }

    private final Cmt processIndexExpr(RsIndexExpr indexExpr) {
        if (this.inference.isOverloadedOperator(indexExpr)) {
            return this.processOverloadedPlace(indexExpr, RsIndexExprKt.getContainerExpr(indexExpr));
        }
        Ty type = this.inference.getExprType(indexExpr);
        Cmt baseCmt = this.processExpr(RsIndexExprKt.getContainerExpr(indexExpr));
        return new Cmt(indexExpr, new Categorization.Interior.Index(baseCmt), baseCmt.getMutabilityCategory().inherit(), type);
    }

    private final Cmt processOverloadedPlace(RsExpr expr, RsExpr base) {
        Ty placeTy = this.inference.getExprType(expr);
        Ty ty2 = this.inference.getExprTypeAdjusted(base);
        TyRef tyRef = ty2 instanceof TyRef ? (TyRef)ty2 : null;
        if (tyRef == null) {
            return new Cmt(expr, null, null, placeTy, 6, null);
        }
        TyRef baseTy = tyRef;
        TyRef refTy = new TyRef(placeTy, baseTy.getMutability(), baseTy.getRegion(), null, 8, null);
        return this.processDeref(expr, this.processRvalue(expr, refTy));
    }

    private final Cmt processPathExpr(RsPathExpr pathExpr) {
        Ty type = this.inference.getExprType(pathExpr);
        Object object = (ResolvedPath)CollectionsKt.singleOrNull(this.inference.getResolvedPath(pathExpr));
        if (object == null || (object = ((ResolvedPath)object).getElement()) == null) {
            return new Cmt(pathExpr, null, null, type, 6, null);
        }
        Object declaration = object;
        Object object2 = declaration;
        return object2 instanceof RsConstant ? (!RsConstantKt.isConst((RsConstant)declaration) ? new Cmt(pathExpr, Categorization.StaticItem.INSTANCE, MutabilityCategory.Companion.from(RsConstantKt.getMutability((RsConstant)declaration)), type) : MemoryCategorizationContext.processRvalue$default(this, pathExpr, null, 2, null)) : (object2 instanceof RsEnumVariant || object2 instanceof RsStructItem || object2 instanceof RsFunction ? MemoryCategorizationContext.processRvalue$default(this, pathExpr, null, 2, null) : (object2 instanceof RsPatBinding ? new Cmt(pathExpr, new Categorization.Local((RsElement)declaration), MutabilityCategory.Companion.from(RsPatBindingKt.getMutability((RsPatBinding)declaration)), type) : (object2 instanceof RsSelfParameter ? new Cmt(pathExpr, new Categorization.Local((RsElement)declaration), MutabilityCategory.Companion.from(RsSelfParameterKt.getMutability((RsSelfParameter)declaration)), type) : new Cmt(pathExpr, null, null, type, 6, null))));
    }

    private final Cmt processParenExpr(RsParenExpr parenExpr) {
        RsExpr wrapped;
        RsExpr rsExpr = wrapped = parenExpr.getExpr();
        return rsExpr != null ? this.processExpr(rsExpr) : MemoryCategorizationContext.processRvalue$default(this, parenExpr, null, 2, null);
    }

    private final Cmt processOuterAttributedExpr(RsOuterAttributedExpr outerAttributedExpr) {
        RsExpr wrapped;
        RsExpr rsExpr = wrapped = outerAttributedExpr.getExpr();
        return rsExpr != null ? this.processExpr(rsExpr) : MemoryCategorizationContext.processRvalue$default(this, outerAttributedExpr, null, 2, null);
    }

    private final Cmt processDeref(RsExpr expr, Cmt baseCmt) {
        Ty baseType = baseCmt.getTy();
        Pair pair = TyKt.builtinDeref$default(baseType, this.lookup.getItems(), false, 2, null);
        if (pair == null) {
            pair = new Pair((Object)TyUnknown.INSTANCE, (Object)Mutability.Companion.getDEFAULT_MUTABILITY());
        }
        Pair pair2 = pair;
        Ty derefType = (Ty)pair2.component1();
        Mutability derefMut = (Mutability)((Object)pair2.component2());
        Ty ty2 = baseType;
        PointerKind pointerKind = ty2 instanceof TyAdt ? (PointerKind)PointerKind.Unique.INSTANCE : (ty2 instanceof TyRef ? (PointerKind)new PointerKind.BorrowedPointer(BorrowKind.Companion.from(((TyRef)baseType).getMutability()), ((TyRef)baseType).getRegion()) : (ty2 instanceof TyRawPtr ? (PointerKind)new PointerKind.UnsafePointer(((TyRawPtr)baseType).getMutability()) : (PointerKind)new PointerKind.UnsafePointer(derefMut)));
        return new Cmt(expr, new Categorization.Deref(baseCmt, pointerKind), MutabilityCategory.Companion.from(baseCmt.getMutabilityCategory(), pointerKind), derefType);
    }

    private final Cmt processRvalue(RsExpr expr, Ty ty2) {
        return new Cmt(expr, new Categorization.Rvalue(ReStatic.INSTANCE), MutabilityCategory.Declared, ty2);
    }

    static /* synthetic */ Cmt processRvalue$default(MemoryCategorizationContext memoryCategorizationContext, RsExpr rsExpr, Ty ty2, int n, Object object) {
        if ((n & 2) != 0) {
            ty2 = memoryCategorizationContext.inference.getExprType(rsExpr);
        }
        return memoryCategorizationContext.processRvalue(rsExpr, ty2);
    }

    @NotNull
    public final Cmt processRvalue(@NotNull RsElement element, @NotNull Region tempScope, @NotNull Ty ty2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)tempScope, (String)"tempScope");
        Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
        return new Cmt(element, new Categorization.Rvalue(tempScope), MutabilityCategory.Declared, ty2);
    }

    public final void walkPat(@NotNull Cmt cmt, @NotNull RsPat pat, @NotNull Function3<? super Cmt, ? super RsPat, ? super RsPatBinding, Unit> callback) {
        block13: {
            RsPat rsPat;
            block12: {
                Intrinsics.checkNotNullParameter((Object)cmt, (String)"cmt");
                Intrinsics.checkNotNullParameter((Object)pat, (String)"pat");
                Intrinsics.checkNotNullParameter(callback, (String)"callback");
                rsPat = pat;
                if (!(rsPat instanceof RsPatIdent)) break block12;
                RsPatBinding rsPatBinding = ((RsPatIdent)pat).getPatBinding();
                Intrinsics.checkNotNullExpressionValue((Object)rsPatBinding, (String)"getPatBinding(...)");
                RsPatBinding binding = rsPatBinding;
                RsElement rsElement = ((RsReference)binding.getReference()).resolve();
                if (!(rsElement != null ? RsElementKt.isConstantLike(rsElement) : false)) {
                    callback.invoke((Object)cmt, (Object)pat, (Object)binding);
                }
                if (((RsReference)((RsPatIdent)pat).getPatBinding().getReference()).resolve() instanceof RsEnumVariant) break block13;
                RsPat rsPat2 = ((RsPatIdent)pat).getPat();
                if (rsPat2 != null) {
                    RsPat it2 = rsPat2;
                    boolean bl = false;
                    this.walkPat(cmt, it2, callback);
                }
                break block13;
            }
            if (rsPat instanceof RsPatTupleStruct) {
                List<RsPat> list = ((RsPatTupleStruct)pat).getPatList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getPatList(...)");
                MemoryCategorizationContext.walkPat$processTuplePats(this, pat, cmt, callback, list);
            } else if (rsPat instanceof RsPatTup) {
                List<RsPat> list = ((RsPatTup)pat).getPatList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getPatList(...)");
                MemoryCategorizationContext.walkPat$processTuplePats(this, pat, cmt, callback, list);
            } else if (rsPat instanceof RsPatStruct) {
                for (RsPatField patField : ((RsPatStruct)pat).getPatFieldList()) {
                    RsPat fieldPat;
                    RsPatFieldFull patFieldFull;
                    RsPatBinding binding = patField.getPatBinding();
                    if (binding != null) {
                        String fieldName = binding.getReferenceName();
                        Ty fieldType = this.inference.getBindingType(binding);
                        Cmt fieldCmt = this.cmtOfField(pat, cmt, fieldName, fieldType);
                        callback.invoke((Object)fieldCmt, (Object)pat, (Object)binding);
                        continue;
                    }
                    if (patField.getPatFieldFull() == null) continue;
                    String fieldName = patFieldFull.getReferenceName();
                    Intrinsics.checkNotNullExpressionValue((Object)patFieldFull.getPat(), (String)"getPat(...)");
                    Ty fieldType = this.inference.getPatType(fieldPat);
                    Cmt fieldCmt = this.cmtOfField(pat, cmt, fieldName, fieldType);
                    this.walkPat(fieldCmt, fieldPat, callback);
                }
            } else if (rsPat instanceof RsPatSlice) {
                Cmt elementCmt = this.cmtOfSliceElement(pat, cmt);
                List<RsPat> list = ((RsPatSlice)pat).getPatList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getPatList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RsPat it3 = (RsPat)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it3);
                    this.walkPat(elementCmt, it3, callback);
                }
            }
        }
    }

    private final Cmt cmtOfField(RsElement element, Cmt baseCmt, String fieldName, Ty fieldType) {
        return new Cmt(element, new Categorization.Interior.Field(baseCmt, fieldName), baseCmt.getMutabilityCategory().inherit(), fieldType);
    }

    private final Cmt cmtOfSliceElement(RsElement element, Cmt baseCmt) {
        return new Cmt(element, new Categorization.Interior.Pattern(baseCmt), baseCmt.getMutabilityCategory().inherit(), baseCmt.getTy());
    }

    private static final void walkPat$processTuplePats(MemoryCategorizationContext this$0, RsPat $pat, Cmt $cmt, Function3<? super Cmt, ? super RsPat, ? super RsPatBinding, Unit> $callback, List<? extends RsPat> pats) {
        Iterator iterator2 = ((Iterable)pats).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            RsPatBinding subBinding;
            int index = n++;
            RsPat subPat = (RsPat)iterator2.next();
            PsiElement $this$descendantsOfType$iv = subPat;
            boolean $i$f$descendantsOfType = false;
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsPatBinding.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
            if ((RsPatBinding)CollectionsKt.firstOrNull((Iterable)collection) == null) continue;
            Ty subType = this$0.inference.getBindingType(subBinding);
            Cmt subCmt = new Cmt($pat, new Categorization.Interior.Field($cmt, String.valueOf(index)), $cmt.getMutabilityCategory().inherit(), subType);
            this$0.walkPat(subCmt, subPat, $callback);
        }
    }
}

