/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.dfa;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.dfa.Categorization;
import org.rust.lang.core.dfa.Cmt;
import org.rust.lang.core.dfa.ConsumeMode;
import org.rust.lang.core.dfa.Delegate;
import org.rust.lang.core.dfa.ExprUseWalkerKt;
import org.rust.lang.core.dfa.MatchMode;
import org.rust.lang.core.dfa.MemoryCategorizationContext;
import org.rust.lang.core.dfa.MoveReason;
import org.rust.lang.core.dfa.MutabilityCategory;
import org.rust.lang.core.dfa.MutateMode;
import org.rust.lang.core.dfa.TrackMatchMode;
import org.rust.lang.core.dfa.liveness.GatherLivenessContext;
import org.rust.lang.core.macros.MacroExpansion;
import org.rust.lang.core.macros.RsExpandedElement;
import org.rust.lang.core.psi.RsArrayExpr;
import org.rust.lang.core.psi.RsAsmMacroArgument;
import org.rust.lang.core.psi.RsAssertEqMacroArgument;
import org.rust.lang.core.psi.RsAssertMacroArgument;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsBinaryOp;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsBreakExpr;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsCastExpr;
import org.rust.lang.core.psi.RsConcatMacroArgument;
import org.rust.lang.core.psi.RsEnvMacroArgument;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprMacroArgument;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsFieldLookupExpr;
import org.rust.lang.core.psi.RsForExpr;
import org.rust.lang.core.psi.RsFormatMacroArg;
import org.rust.lang.core.psi.RsFormatMacroArgument;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsIncludeMacroArgument;
import org.rust.lang.core.psi.RsIndexExpr;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsLetDecl;
import org.rust.lang.core.psi.RsLetExpr;
import org.rust.lang.core.psi.RsLoopExpr;
import org.rust.lang.core.psi.RsMacroArgument;
import org.rust.lang.core.psi.RsMacroBodyIdent;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMacroExpr;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsMatchArmGuard;
import org.rust.lang.core.psi.RsMatchExpr;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsNamedFieldDecl;
import org.rust.lang.core.psi.RsOuterAttributedExpr;
import org.rust.lang.core.psi.RsParenExpr;
import org.rust.lang.core.psi.RsPat;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPathExpr;
import org.rust.lang.core.psi.RsRangeExpr;
import org.rust.lang.core.psi.RsRetExpr;
import org.rust.lang.core.psi.RsStmt;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsStructLiteral;
import org.rust.lang.core.psi.RsStructLiteralBody;
import org.rust.lang.core.psi.RsStructLiteralField;
import org.rust.lang.core.psi.RsTryExpr;
import org.rust.lang.core.psi.RsTupleExpr;
import org.rust.lang.core.psi.RsTypeReference;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.RsValueParameter;
import org.rust.lang.core.psi.RsVecMacroArgument;
import org.rust.lang.core.psi.RsWhileExpr;
import org.rust.lang.core.psi.ext.ArithmeticAssignmentOp;
import org.rust.lang.core.psi.ext.AssignmentOp;
import org.rust.lang.core.psi.ext.BinaryOperator;
import org.rust.lang.core.psi.ext.RsBindingModeKind;
import org.rust.lang.core.psi.ext.RsBlockKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.RsFieldsOwnerKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsIfExprKt;
import org.rust.lang.core.psi.ext.RsIndexExprKt;
import org.rust.lang.core.psi.ext.RsLetExprKt;
import org.rust.lang.core.psi.ext.RsMacroCallKt;
import org.rust.lang.core.psi.ext.RsMatchArmKt;
import org.rust.lang.core.psi.ext.RsMatchExprKt;
import org.rust.lang.core.psi.ext.RsPatBindingKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCallKt;
import org.rust.lang.core.psi.ext.RsStructLiteralBodyKt;
import org.rust.lang.core.psi.ext.RsStructLiteralFieldKt;
import org.rust.lang.core.resolve.NamespaceKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.infer.FoldKt;
import org.rust.lang.core.types.infer.TypeFoldable;
import org.rust.lang.core.types.regions.ReScope;
import org.rust.lang.core.types.regions.Scope;
import org.rust.lang.core.types.ty.Mutability;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyFunctionBase;
import org.rust.lang.core.types.ty.TyUnknown;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0014H\u0002J\u0010\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u0014H\u0002J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020\t2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\u000bH\u0002J\u0010\u00105\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u00106\u001a\u00020\t2\f\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00132\b\u00109\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00102\u0006\u0010=\u001a\u00020>H\u0002J \u0010?\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u00102\u0006\u0010=\u001a\u00020>2\u0006\u0010!\u001a\u00020@H\u0002J\u0018\u0010A\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u00102\u0006\u0010B\u001a\u00020CH\u0002J \u0010D\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00102\u0006\u0010B\u001a\u00020C2\u0006\u0010!\u001a\u00020;H\u0002J \u0010E\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u00102\u0006\u0010B\u001a\u00020C2\u0006\u0010F\u001a\u00020@H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/rust/lang/core/dfa/ExprUseWalker;", "", "delegate", "Lorg/rust/lang/core/dfa/Delegate;", "mc", "Lorg/rust/lang/core/dfa/MemoryCategorizationContext;", "<init>", "(Lorg/rust/lang/core/dfa/Delegate;Lorg/rust/lang/core/dfa/MemoryCategorizationContext;)V", "consumeBody", "", "body", "Lorg/rust/lang/core/psi/RsBlock;", "delegateConsume", "element", "Lorg/rust/lang/core/psi/ext/RsElement;", "cmt", "Lorg/rust/lang/core/dfa/Cmt;", "consumeExprs", "exprs", "", "Lorg/rust/lang/core/psi/RsExpr;", "consumeExpr", "expr", "usePath", "pathExpr", "Lorg/rust/lang/core/psi/RsPathExpr;", "useAllPaths", "useMacroBodyIdent", "ident", "Lorg/rust/lang/core/psi/RsMacroBodyIdent;", "useAllMacroBodyIdents", "mutateExpr", "assignmentExpr", "mode", "Lorg/rust/lang/core/dfa/MutateMode;", "selectFromExpr", "walkExpr", "walkCallee", "callee", "walkMacroCall", "macroCall", "Lorg/rust/lang/core/psi/RsMacroCall;", "walkStmt", "stmt", "Lorg/rust/lang/core/psi/RsStmt;", "walkLet", "declaration", "Lorg/rust/lang/core/psi/RsLetDecl;", "walkLetExpr", "letExpr", "Lorg/rust/lang/core/psi/RsLetExpr;", "walkBlock", "block", "walk", "walkStructExpr", "fields", "Lorg/rust/lang/core/psi/RsStructLiteralField;", "withExpr", "armMoveMode", "Lorg/rust/lang/core/dfa/TrackMatchMode;", "discriminantCmt", "arm", "Lorg/rust/lang/core/psi/RsMatchArm;", "walkArm", "Lorg/rust/lang/core/dfa/MatchMode;", "walkIrrefutablePat", "pat", "Lorg/rust/lang/core/psi/RsPat;", "determinePatMoveMode", "walkPat", "matchMode", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nExprUseWalker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExprUseWalker.kt\norg/rust/lang/core/dfa/ExprUseWalker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,523:1\n1869#2,2:524\n1869#2,2:529\n1869#2,2:531\n1869#2,2:533\n1869#2,2:535\n1563#2:537\n1634#2,3:538\n1869#2,2:541\n1563#2:543\n1634#2,3:544\n1869#2,2:547\n1869#2,2:549\n1563#2:551\n1634#2,3:552\n1869#2,2:555\n1761#2,3:558\n1869#2,2:561\n1869#2,2:563\n1#3:526\n127#4:527\n127#4:528\n127#4:557\n*S KotlinDebug\n*F\n+ 1 ExprUseWalker.kt\norg/rust/lang/core/dfa/ExprUseWalker\n*L\n135#1:524,2\n303#1:529,2\n321#1:531,2\n322#1:533,2\n323#1:535,2\n332#1:537\n332#1:538,3\n332#1:541,2\n343#1:543\n343#1:544,3\n343#1:547,2\n353#1:549,2\n354#1:551\n354#1:552,3\n354#1:555,2\n451#1:558,3\n468#1:561,2\n473#1:563,2\n150#1:527\n172#1:528\n394#1:557\n*E\n"})
public final class ExprUseWalker {
    @NotNull
    private final Delegate delegate;
    @NotNull
    private final MemoryCategorizationContext mc;

    public ExprUseWalker(@NotNull Delegate delegate, @NotNull MemoryCategorizationContext mc) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        this.delegate = delegate;
        this.mc = mc;
    }

    public final void consumeBody(@NotNull RsBlock body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        PsiElement psiElement2 = body.getParent();
        RsFunction rsFunction = psiElement2 instanceof RsFunction ? (RsFunction)psiElement2 : null;
        if (rsFunction == null) {
            return;
        }
        RsFunction function = rsFunction;
        for (RsValueParameter parameter : RsFunctionKt.getValueParameters(function)) {
            RsPat parameterPat;
            Object object = parameter.getTypeReference();
            if (object == null || (object = ExtensionsKt.normType((RsTypeReference)object, this.mc.getLookup())) == null) continue;
            Object parameterType = object;
            if (parameter.getPat() == null) continue;
            ReScope bodyScopeRegion = new ReScope(new Scope.Node(body));
            Cmt parameterCmt = this.mc.processRvalue(parameter, bodyScopeRegion, (Ty)parameterType);
            this.walkIrrefutablePat(parameterCmt, parameterPat);
        }
        this.walkBlock(body);
    }

    private final void delegateConsume(RsElement element, Cmt cmt) {
        ConsumeMode mode = ExprUseWalkerKt.copyOrMove(this.mc, cmt, MoveReason.DirectRefMove);
        this.delegate.consume(element, cmt, mode);
    }

    private final void consumeExprs(List<? extends RsExpr> exprs) {
        Iterable $this$forEach$iv = exprs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RsExpr it2 = (RsExpr)element$iv;
            boolean bl = false;
            this.consumeExpr(it2);
        }
    }

    private final void consumeExpr(RsExpr expr) {
        Cmt cmt = this.mc.processExpr(expr);
        this.delegateConsume(expr, cmt);
        this.walkExpr(expr);
    }

    private final void usePath(RsPathExpr pathExpr) {
        Cmt cmt = this.mc.processExpr(pathExpr);
        this.delegate.useElement(pathExpr, cmt);
    }

    private final void useAllPaths(RsElement element) {
        RsPathExpr rsPathExpr = element instanceof RsPathExpr ? (RsPathExpr)element : null;
        if (rsPathExpr != null) {
            RsPathExpr it2 = rsPathExpr;
            boolean bl = false;
            this.usePath(it2);
        }
        PsiElement $this$descendantsOfType$iv = element;
        boolean $i$f$descendantsOfType = false;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsPathExpr.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        for (RsPathExpr path : collection) {
            this.usePath(path);
        }
    }

    private final void useMacroBodyIdent(RsMacroBodyIdent ident) {
        PsiElement psiElement2;
        String string = ident.getReferenceName();
        if (string != null) {
            String it2 = string;
            boolean bl = false;
            psiElement2 = RsElementKt.findInScope(ident, it2, NamespaceKt.getVALUES());
        } else {
            psiElement2 = null;
        }
        PsiElement psiElement3 = psiElement2;
        RsPatBinding rsPatBinding = psiElement3 instanceof RsPatBinding ? (RsPatBinding)psiElement3 : null;
        if (rsPatBinding == null) {
            return;
        }
        RsPatBinding declaration = rsPatBinding;
        Mutability mutability = RsPatBindingKt.getMutability(declaration);
        Ty type = ExtensionsKt.getType(declaration);
        Cmt cmt = new Cmt(ident, new Categorization.Local(declaration), MutabilityCategory.Companion.from(mutability), type);
        this.delegate.useElement(ident, cmt);
    }

    private final void useAllMacroBodyIdents(RsElement element) {
        PsiElement $this$descendantsOfType$iv = element;
        boolean $i$f$descendantsOfType = false;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsMacroBodyIdent.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        Collection idents = collection;
        for (RsMacroBodyIdent ident : idents) {
            this.useMacroBodyIdent(ident);
        }
    }

    private final void mutateExpr(RsExpr assignmentExpr, RsExpr expr, MutateMode mode) {
        Cmt cmt = this.mc.processExpr(expr);
        this.delegate.mutate(assignmentExpr, cmt, mode);
        this.walkExpr(expr);
    }

    private final void selectFromExpr(RsExpr expr) {
        this.walkExpr(expr);
        this.useAllPaths(expr);
    }

    private final void walkExpr(RsExpr expr) {
        RsExpr rsExpr = expr;
        if (rsExpr instanceof RsOuterAttributedExpr) {
            RsExpr rsExpr2 = ((RsOuterAttributedExpr)expr).getExpr();
            if (rsExpr2 == null) {
                return;
            }
            this.walkExpr(rsExpr2);
        } else if (rsExpr instanceof RsUnaryExpr) {
            RsExpr rsExpr3 = ((RsUnaryExpr)expr).getExpr();
            if (rsExpr3 == null) {
                return;
            }
            RsExpr base = rsExpr3;
            if (((RsUnaryExpr)expr).getMul() != null) {
                this.selectFromExpr(base);
            } else if (((RsUnaryExpr)expr).getAnd() != null) {
                this.selectFromExpr(base);
            } else {
                this.consumeExpr(base);
            }
        } else if (rsExpr instanceof RsFieldLookupExpr) {
            RsExpr rsExpr4 = ((RsFieldLookupExpr)expr).getReceiver();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr4, (String)"<get-receiver>(...)");
            this.selectFromExpr(rsExpr4);
        } else if (rsExpr instanceof RsMethodCallExpr) {
            if (((RsMethodCallExpr)expr).getMethodCall().getReference().resolve() != null) {
                RsExpr rsExpr5 = ((RsMethodCallExpr)expr).getReceiver();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr5, (String)"<get-receiver>(...)");
                this.consumeExpr(rsExpr5);
            } else {
                RsExpr rsExpr6 = ((RsMethodCallExpr)expr).getReceiver();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr6, (String)"<get-receiver>(...)");
                this.selectFromExpr(rsExpr6);
            }
            List<RsExpr> list = ((RsMethodCallExpr)expr).getMethodCall().getValueArgumentList().getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            this.consumeExprs(list);
        } else if (rsExpr instanceof RsIndexExpr) {
            this.selectFromExpr(RsIndexExprKt.getContainerExpr((RsIndexExpr)expr));
            RsExpr rsExpr7 = RsIndexExprKt.getIndexExpr((RsIndexExpr)expr);
            if (rsExpr7 != null) {
                RsExpr it2 = rsExpr7;
                boolean bl = false;
                this.consumeExpr(it2);
            }
        } else if (rsExpr instanceof RsCallExpr) {
            RsExpr rsExpr8 = ((RsCallExpr)expr).getExpr();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr8, (String)"getExpr(...)");
            this.walkCallee(rsExpr8);
            List<RsExpr> list = ((RsCallExpr)expr).getValueArgumentList().getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            this.consumeExprs(list);
        } else if (rsExpr instanceof RsStructLiteral) {
            RsStructLiteralBody rsStructLiteralBody = ((RsStructLiteral)expr).getStructLiteralBody();
            Intrinsics.checkNotNullExpressionValue((Object)rsStructLiteralBody, (String)"getStructLiteralBody(...)");
            this.walkStructExpr(RsStructLiteralBodyKt.getExpandedFields(rsStructLiteralBody), ((RsStructLiteral)expr).getStructLiteralBody().getExpr());
        } else if (rsExpr instanceof RsTupleExpr) {
            List<RsExpr> list = ((RsTupleExpr)expr).getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            this.consumeExprs(list);
        } else if (rsExpr instanceof RsIfExpr) {
            RsElement rsElement;
            RsElement rsElement2;
            RsElement rsElement3 = ((RsIfExpr)expr).getCondition();
            if (rsElement3 != null && (rsElement3 = rsElement3.getExpr()) != null) {
                RsElement it3 = rsElement3;
                boolean bl = false;
                this.walkExpr((RsExpr)it3);
            }
            RsBlock rsBlock = RsIfExprKt.getBlock((RsIfExpr)expr);
            if (rsBlock != null) {
                RsBlock it4 = rsBlock;
                boolean bl = false;
                this.walkBlock(it4);
            }
            if ((rsElement2 = ((RsIfExpr)expr).getElseBranch()) != null && (rsElement2 = RsIfExprKt.getIfExpr(rsElement2)) != null) {
                RsElement it5 = rsElement2;
                boolean bl = false;
                this.walkExpr((RsExpr)it5);
            }
            if ((rsElement = ((RsIfExpr)expr).getElseBranch()) != null && (rsElement = RsIfExprKt.getBlock(rsElement)) != null) {
                RsElement it6 = rsElement;
                boolean bl = false;
                this.walkBlock((RsBlock)it6);
            }
        } else if (rsExpr instanceof RsMatchExpr) {
            RsExpr rsExpr9 = ((RsMatchExpr)expr).getScrutinee();
            if (rsExpr9 == null) {
                return;
            }
            RsExpr discriminant = rsExpr9;
            Cmt discriminantCmt = this.mc.processExpr(discriminant);
            this.selectFromExpr(discriminant);
            for (RsMatchArm arm : RsMatchExprKt.getArms((RsMatchExpr)expr)) {
                MatchMode mode = this.armMoveMode(discriminantCmt, arm).getMatchMode();
                this.walkArm(discriminantCmt, arm, mode);
            }
        } else if (rsExpr instanceof RsArrayExpr) {
            List<RsExpr> list = ((RsArrayExpr)expr).getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            this.consumeExprs(list);
        } else if (rsExpr instanceof RsLoopExpr) {
            RsBlock rsBlock = ((RsLoopExpr)expr).getBlock();
            if (rsBlock != null) {
                RsBlock it7 = rsBlock;
                boolean bl = false;
                this.walkBlock(it7);
            }
        } else if (rsExpr instanceof RsWhileExpr) {
            RsElement rsElement = ((RsWhileExpr)expr).getCondition();
            if (rsElement != null && (rsElement = rsElement.getExpr()) != null) {
                RsElement it8 = rsElement;
                boolean bl = false;
                this.walkExpr((RsExpr)it8);
            }
            RsBlock rsBlock = ((RsWhileExpr)expr).getBlock();
            if (rsBlock != null) {
                RsBlock it9 = rsBlock;
                boolean bl = false;
                this.walkBlock(it9);
            }
        } else if (rsExpr instanceof RsForExpr) {
            RsExpr init = ((RsForExpr)expr).getExpr();
            RsPat pat = ((RsForExpr)expr).getPat();
            if (init != null && pat != null) {
                this.walkExpr(init);
                Cmt initCmt = this.mc.processExpr(init);
                this.walkPat(initCmt, pat, MatchMode.NonConsumingMatch);
            }
            RsBlock rsBlock = ((RsForExpr)expr).getBlock();
            if (rsBlock != null) {
                RsBlock it10 = rsBlock;
                boolean bl = false;
                this.walkBlock(it10);
            }
        } else if (rsExpr instanceof RsBinaryExpr) {
            RsExpr rsExpr10 = ((RsBinaryExpr)expr).getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr10, (String)"getLeft(...)");
            RsExpr left = rsExpr10;
            RsExpr rsExpr11 = ((RsBinaryExpr)expr).getRight();
            if (rsExpr11 == null) {
                return;
            }
            RsExpr right = rsExpr11;
            RsBinaryOp rsBinaryOp = ((RsBinaryExpr)expr).getBinaryOp();
            Intrinsics.checkNotNullExpressionValue((Object)rsBinaryOp, (String)"getBinaryOp(...)");
            BinaryOperator initCmt = RsExprKt.getOperatorType(rsBinaryOp);
            if (initCmt instanceof ArithmeticAssignmentOp) {
                this.mutateExpr(expr, left, MutateMode.WriteAndRead);
            } else if (initCmt instanceof AssignmentOp) {
                this.mutateExpr(expr, left, MutateMode.JustWrite);
            } else {
                this.consumeExpr(left);
            }
            this.consumeExpr(right);
        } else if (rsExpr instanceof RsLambdaExpr) {
            RsExpr rsExpr12 = ((RsLambdaExpr)expr).getExpr();
            if (rsExpr12 != null) {
                RsExpr it11 = rsExpr12;
                boolean bl = false;
                this.walkExpr(it11);
            }
        } else if (rsExpr instanceof RsBlockExpr) {
            RsBlock rsBlock = ((RsBlockExpr)expr).getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)rsBlock, (String)"<get-block>(...)");
            this.walkBlock(rsBlock);
        } else if (rsExpr instanceof RsBreakExpr) {
            RsExpr rsExpr13 = ((RsBreakExpr)expr).getExpr();
            if (rsExpr13 != null) {
                RsExpr it12 = rsExpr13;
                boolean bl = false;
                this.consumeExpr(it12);
            }
        } else if (rsExpr instanceof RsRetExpr) {
            RsExpr rsExpr14 = ((RsRetExpr)expr).getExpr();
            if (rsExpr14 != null) {
                RsExpr it13 = rsExpr14;
                boolean bl = false;
                this.consumeExpr(it13);
            }
        } else if (rsExpr instanceof RsCastExpr) {
            RsExpr rsExpr15 = ((RsCastExpr)expr).getExpr();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr15, (String)"getExpr(...)");
            this.consumeExpr(rsExpr15);
        } else if (rsExpr instanceof RsParenExpr) {
            RsExpr rsExpr16 = ((RsParenExpr)expr).getExpr();
            if (rsExpr16 != null) {
                RsExpr it14 = rsExpr16;
                boolean bl = false;
                this.walkExpr(it14);
            }
        } else if (rsExpr instanceof RsTryExpr) {
            RsExpr rsExpr17 = ((RsTryExpr)expr).getExpr();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr17, (String)"getExpr(...)");
            this.walkExpr(rsExpr17);
        } else if (rsExpr instanceof RsMacroExpr) {
            RsMacroCall rsMacroCall = ((RsMacroExpr)expr).getMacroCall();
            Intrinsics.checkNotNullExpressionValue((Object)rsMacroCall, (String)"getMacroCall(...)");
            this.walkMacroCall(rsMacroCall);
        } else if (rsExpr instanceof RsPathExpr) {
            this.usePath((RsPathExpr)expr);
        } else if (rsExpr instanceof RsRangeExpr) {
            List<RsExpr> list = ((RsRangeExpr)expr).getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RsExpr p0 = (RsExpr)element$iv;
                boolean bl = false;
                this.walkExpr(p0);
            }
        } else if (rsExpr instanceof RsLetExpr) {
            this.walkLetExpr((RsLetExpr)expr);
        }
    }

    private final void walkCallee(RsExpr callee) {
        if (ExtensionsKt.getType(callee) instanceof TyFunctionBase) {
            this.consumeExpr(callee);
        } else {
            this.useAllPaths(callee);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void walkMacroCall(RsMacroCall macroCall) {
        RsElement argument = RsMacroCallKt.getMacroArgumentElement(macroCall);
        if (argument instanceof RsExprMacroArgument) {
            RsExpr rsExpr = ((RsExprMacroArgument)argument).getExpr();
            if (rsExpr != null) {
                RsExpr p0 = rsExpr;
                boolean bl = false;
                this.walkExpr(p0);
            }
        } else if (argument instanceof RsIncludeMacroArgument) {
            RsExpr rsExpr = ((RsIncludeMacroArgument)argument).getExpr();
            if (rsExpr != null) {
                RsExpr p0 = rsExpr;
                boolean bl = false;
                this.walkExpr(p0);
            }
        } else if (argument instanceof RsConcatMacroArgument) {
            List<RsExpr> list = ((RsConcatMacroArgument)argument).getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RsExpr p0 = (RsExpr)element$iv;
                boolean bl = false;
                this.walkExpr(p0);
            }
        } else if (argument instanceof RsEnvMacroArgument) {
            List<RsExpr> list = ((RsEnvMacroArgument)argument).getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RsExpr p0 = (RsExpr)element$iv;
                boolean bl = false;
                this.walkExpr(p0);
            }
        } else if (argument instanceof RsVecMacroArgument) {
            List<RsExpr> list = ((RsVecMacroArgument)argument).getExprList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RsExpr p0 = (RsExpr)element$iv;
                boolean bl = false;
                this.walkExpr(p0);
            }
        } else if (argument instanceof RsFormatMacroArgument) {
            MacroExpansion expansion = RsPossibleMacroCallKt.getExpansion(macroCall);
            if (expansion != null) {
                for (RsExpandedElement expandedElement : expansion.getElements()) {
                    this.walk(expandedElement);
                }
            } else {
                void $this$forEach$iv;
                Iterator $this$mapTo$iv$iv;
                List<RsFormatMacroArg> list = ((RsFormatMacroArgument)argument).getFormatMacroArgList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"<get-formatMacroArgList>(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    void it2;
                    Object item$iv$iv = iterator2.next();
                    RsFormatMacroArg rsFormatMacroArg = (RsFormatMacroArg)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it2.getExpr());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    RsExpr p0 = (RsExpr)element$iv2;
                    boolean bl = false;
                    this.walkExpr(p0);
                }
            }
        } else if (argument instanceof RsAssertMacroArgument) {
            MacroExpansion expansion = RsPossibleMacroCallKt.getExpansion(macroCall);
            if (expansion != null) {
                for (RsExpandedElement expandedElement : expansion.getElements()) {
                    this.walk(expandedElement);
                }
            } else {
                void $this$forEach$iv;
                Iterator $this$mapTo$iv$iv;
                Object p0;
                RsExpr rsExpr = ((RsAssertMacroArgument)argument).getExpr();
                if (rsExpr != null) {
                    p0 = rsExpr;
                    boolean bl = false;
                    this.walkExpr((RsExpr)p0);
                }
                List<RsFormatMacroArg> list = ((RsAssertMacroArgument)argument).getFormatMacroArgList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"<get-formatMacroArgList>(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                p0 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator bl = $this$mapTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    Object item$iv$iv = bl.next();
                    RsFormatMacroArg it2 = (RsFormatMacroArg)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it2.getExpr());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RsExpr p02 = (RsExpr)element$iv;
                    boolean bl3 = false;
                    this.walkExpr(p02);
                }
            }
        } else if (argument instanceof RsAssertEqMacroArgument) {
            MacroExpansion expansion = RsPossibleMacroCallKt.getExpansion(macroCall);
            if (expansion != null) {
                for (RsExpandedElement expandedElement : expansion.getElements()) {
                    this.walk(expandedElement);
                }
            } else {
                List<RsExpr> list = ((RsAssertEqMacroArgument)argument).getExprList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getExprList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RsExpr p0 = (RsExpr)element$iv;
                    boolean bl = false;
                    this.walkExpr(p0);
                }
                List<RsFormatMacroArg> list2 = ((RsAssertEqMacroArgument)argument).getFormatMacroArgList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"<get-formatMacroArgList>(...)");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator bl = $this$mapTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    Object item$iv$iv = bl.next();
                    RsFormatMacroArg it3 = (RsFormatMacroArg)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it3.getExpr());
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RsExpr p0 = (RsExpr)element$iv;
                    boolean bl5 = false;
                    this.walkExpr(p0);
                }
            }
        } else if (!(argument instanceof RsAsmMacroArgument)) {
            if (argument instanceof RsMacroArgument) {
                MacroExpansion expansion = RsPossibleMacroCallKt.getExpansion(macroCall);
                if (expansion != null) {
                    for (RsExpandedElement expandedElement : expansion.getElements()) {
                        this.walk(expandedElement);
                    }
                } else {
                    this.useAllPaths(macroCall);
                    this.useAllMacroBodyIdents(macroCall);
                }
            } else if (argument == null) {
                this.useAllMacroBodyIdents(macroCall);
            } else {
                throw new IllegalStateException("unreachable".toString());
            }
        }
    }

    private final void walkStmt(RsStmt stmt) {
        RsStmt rsStmt = stmt;
        if (rsStmt instanceof RsLetDecl) {
            this.walkLet((RsLetDecl)stmt);
        } else if (rsStmt instanceof RsExprStmt) {
            RsExpr rsExpr = ((RsExprStmt)stmt).getExpr();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getExpr(...)");
            this.consumeExpr(rsExpr);
        }
    }

    private final void walkLet(RsLetDecl declaration) {
        block4: {
            RsElement rsElement;
            RsExpr init = declaration.getExpr();
            RsPat rsPat = declaration.getPat();
            if (rsPat != null) {
                RsPat it2 = rsPat;
                boolean bl = false;
                if (init != null) {
                    this.walkExpr(init);
                    Cmt initCmt = this.mc.processExpr(init);
                    this.walkIrrefutablePat(initCmt, it2);
                } else {
                    PsiElement $this$descendantsOfType$iv = it2;
                    boolean $i$f$descendantsOfType = false;
                    Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsPatBinding.class);
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
                    for (RsPatBinding binding : collection) {
                        this.delegate.declarationWithoutInit(binding);
                    }
                }
            }
            if ((rsElement = declaration.getLetElseBranch()) == null || (rsElement = rsElement.getBlock()) == null) break block4;
            RsElement it3 = rsElement;
            boolean bl = false;
            this.walkBlock((RsBlock)it3);
        }
    }

    private final void walkLetExpr(RsLetExpr letExpr) {
        RsExpr rsExpr = letExpr.getExpr();
        if (rsExpr == null) {
            return;
        }
        RsExpr init = rsExpr;
        this.walkExpr(init);
        Cmt initCmt = this.mc.processExpr(init);
        List list = RsLetExprKt.getPatList(letExpr);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (RsPat pat : list) {
            this.walkIrrefutablePat(initCmt, pat);
        }
    }

    private final void walkBlock(RsBlock block) {
        Pair<List<RsStmt>, RsExpr> pair = RsBlockKt.getExpandedStmtsAndTailExpr(block);
        List expandedStmts = (List)pair.component1();
        RsExpr tailExpr = (RsExpr)pair.component2();
        for (RsStmt element : expandedStmts) {
            this.walk(element);
        }
        if (tailExpr != null) {
            this.consumeExpr(tailExpr);
        }
    }

    private final void walk(RsElement element) {
        RsElement rsElement = element;
        if (rsElement instanceof RsStmt) {
            this.walkStmt((RsStmt)element);
        } else if (rsElement instanceof RsExpr) {
            this.walkExpr((RsExpr)element);
        } else if (rsElement instanceof RsMacroCall) {
            this.walkMacroCall((RsMacroCall)element);
        }
    }

    private final void walkStructExpr(List<? extends RsStructLiteralField> fields, RsExpr withExpr) {
        Object mutability;
        for (RsStructLiteralField rsStructLiteralField : fields) {
            RsPatBinding binding;
            RsExpr expr = rsStructLiteralField.getExpr();
            if (expr != null) {
                this.consumeExpr(expr);
                continue;
            }
            if (rsStructLiteralField.getIdentifier() == null || RsStructLiteralFieldKt.resolveToBinding(rsStructLiteralField) == null) continue;
            mutability = RsPatBindingKt.getMutability(binding);
            Ty type = ExtensionsKt.getType(binding);
            Cmt cmt = new Cmt(rsStructLiteralField, new Categorization.Local(binding), MutabilityCategory.Companion.from((Mutability)((Object)mutability)), type);
            this.delegateConsume(rsStructLiteralField, cmt);
        }
        if (withExpr != null) {
            Cmt withCmt = this.mc.processExpr(withExpr);
            Ty ty2 = withCmt.getTy();
            if (ty2 instanceof TyAdt) {
                mutability = ((TyAdt)ty2).getItem();
                RsStructItem rsStructItem = mutability instanceof RsStructItem ? (RsStructItem)mutability : null;
                List list = rsStructItem != null ? RsFieldsOwnerKt.getExpandedNamedFields(rsStructItem) : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List withFields = list;
                for (RsNamedFieldDecl withField : withFields) {
                    boolean isMentioned;
                    boolean bl;
                    block10: {
                        Iterable $this$any$iv = fields;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                RsStructLiteralField it2 = (RsStructLiteralField)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)it2.getReferenceName(), (Object)withField.getName())) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (isMentioned = bl) continue;
                    Object object = withField.getTypeReference();
                    if (object == null || (object = ExtensionsKt.normType((RsTypeReference)object, this.mc.getLookup())) == null) {
                        object = TyUnknown.INSTANCE;
                    }
                    Object rawWithFieldType = object;
                    Ty withFieldType = (Ty)FoldKt.substituteOrUnknown((TypeFoldable)rawWithFieldType, ((TyAdt)ty2).getTypeParameterValues());
                    Categorization.Interior.Field interior = new Categorization.Interior.Field(withCmt, withField.getName());
                    Cmt fieldCmt = new Cmt(withExpr, interior, withCmt.getMutabilityCategory().inherit(), withFieldType);
                    this.delegateConsume(withExpr, fieldCmt);
                }
            }
            this.walkExpr(withExpr);
        }
    }

    private final TrackMatchMode armMoveMode(Cmt discriminantCmt, RsMatchArm arm) {
        TrackMatchMode mode = null;
        mode = TrackMatchMode.Unknown.INSTANCE;
        Iterable $this$forEach$iv = RsMatchArmKt.getPatList(arm);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RsPat it2 = (RsPat)element$iv;
            boolean bl = false;
            mode = this.determinePatMoveMode(discriminantCmt, it2, mode);
        }
        return mode;
    }

    private final void walkArm(Cmt discriminantCmt, RsMatchArm arm, MatchMode mode) {
        block2: {
            RsElement it2;
            Iterable $this$forEach$iv = RsMatchArmKt.getPatList(arm);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RsPat it3 = (RsPat)element$iv;
                boolean bl = false;
                this.walkPat(discriminantCmt, it3, mode);
            }
            RsMatchArmGuard guard = arm.getMatchArmGuard();
            RsElement rsElement = guard;
            if (rsElement != null && (rsElement = rsElement.getExpr()) != null) {
                it2 = rsElement;
                boolean bl = false;
                this.consumeExpr((RsExpr)it2);
            }
            RsExpr rsExpr = arm.getExpr();
            if (rsExpr == null) break block2;
            it2 = rsExpr;
            boolean bl = false;
            this.consumeExpr((RsExpr)it2);
        }
    }

    private final void walkIrrefutablePat(Cmt discriminantCmt, RsPat pat) {
        TrackMatchMode mode = this.determinePatMoveMode(discriminantCmt, pat, TrackMatchMode.Unknown.INSTANCE);
        this.walkPat(discriminantCmt, pat, mode.getMatchMode());
    }

    private final TrackMatchMode determinePatMoveMode(Cmt discriminantCmt, RsPat pat, TrackMatchMode mode) {
        Ref.ObjectRef newMode = new Ref.ObjectRef();
        newMode.element = mode;
        this.mc.walkPat(discriminantCmt, pat, (Function3<? super Cmt, ? super RsPat, ? super RsPatBinding, Unit>)((Function3)(arg_0, arg_1, arg_2) -> ExprUseWalker.determinePatMoveMode$lambda$0(newMode, this, arg_0, arg_1, arg_2)));
        return (TrackMatchMode)newMode.element;
    }

    private final void walkPat(Cmt discriminantCmt, RsPat pat, MatchMode matchMode) {
        this.mc.walkPat(discriminantCmt, pat, (Function3<? super Cmt, ? super RsPat, ? super RsPatBinding, Unit>)((Function3)(arg_0, arg_1, arg_2) -> ExprUseWalker.walkPat$lambda$0(this, matchMode, arg_0, arg_1, arg_2)));
    }

    private static final Unit determinePatMoveMode$lambda$0(Ref.ObjectRef $newMode, ExprUseWalker this$0, Cmt subPatCmt, RsPat rsPat, RsPatBinding binding) {
        TrackMatchMode trackMatchMode;
        Intrinsics.checkNotNullParameter((Object)subPatCmt, (String)"subPatCmt");
        Intrinsics.checkNotNullParameter((Object)rsPat, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        RsBindingModeKind rsBindingModeKind = RsPatBindingKt.getKind(binding);
        if (rsBindingModeKind instanceof RsBindingModeKind.BindByReference) {
            trackMatchMode = ((TrackMatchMode)$newMode.element).leastUpperBound(MatchMode.BorrowingMatch);
        } else if (rsBindingModeKind instanceof RsBindingModeKind.BindByValue) {
            trackMatchMode = ((TrackMatchMode)$newMode.element).leastUpperBound(ExprUseWalkerKt.copyOrMove(this$0.mc, subPatCmt, MoveReason.PatBindingMove).getMatchMode());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $newMode.element = trackMatchMode;
        return Unit.INSTANCE;
    }

    private static final Unit walkPat$lambda$0(ExprUseWalker this$0, MatchMode $matchMode, Cmt subPatCmt, RsPat subPat, RsPatBinding binding) {
        Intrinsics.checkNotNullParameter((Object)subPatCmt, (String)"subPatCmt");
        Intrinsics.checkNotNullParameter((Object)subPat, (String)"subPat");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        MutabilityCategory mutabilityCategory = MutabilityCategory.Companion.from(RsPatBindingKt.getMutability(binding));
        Cmt bindingCmt = new Cmt(binding, new Categorization.Local(binding), mutabilityCategory, ExtensionsKt.getType(binding));
        this$0.delegate.mutate(subPat, bindingCmt, MutateMode.Init);
        if (RsPatBindingKt.getKind(binding) instanceof RsBindingModeKind.BindByValue && ($matchMode != MatchMode.NonConsumingMatch || this$0.delegate instanceof GatherLivenessContext)) {
            this$0.delegate.consumePat(subPat, subPatCmt, ExprUseWalkerKt.copyOrMove(this$0.mc, subPatCmt, MoveReason.PatBindingMove));
        }
        return Unit.INSTANCE;
    }
}

