/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.dfa;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.dfa.ExitPoint;
import org.rust.lang.core.dfa.ExitPointKt;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsCallExpr;
import org.rust.lang.core.psi.RsEmptyDotExpr;
import org.rust.lang.core.psi.RsFieldLookupExpr;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMacroExpr;
import org.rust.lang.core.psi.RsMethodCallExpr;
import org.rust.lang.core.psi.RsRecursiveVisitor;
import org.rust.lang.core.psi.RsRetExpr;
import org.rust.lang.core.psi.RsTryExpr;
import org.rust.lang.core.psi.ext.RsBlockExprKt;
import org.rust.lang.core.psi.ext.RsMacroCallKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010$\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010$\u001a\u00020)H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lorg/rust/lang/core/dfa/ExitPointVisitor;", "Lorg/rust/lang/core/psi/RsRecursiveVisitor;", "sink", "Lkotlin/Function1;", "Lorg/rust/lang/core/dfa/ExitPoint;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "inTry", "", "getInTry", "()I", "setInTry", "(I)V", "visitLambdaExpr", "lambdaExpr", "Lorg/rust/lang/core/psi/RsLambdaExpr;", "visitFunction", "function", "Lorg/rust/lang/core/psi/RsFunction;", "visitBlockExpr", "blockExpr", "Lorg/rust/lang/core/psi/RsBlockExpr;", "visitRetExpr", "retExpr", "Lorg/rust/lang/core/psi/RsRetExpr;", "visitTryExpr", "tryExpr", "Lorg/rust/lang/core/psi/RsTryExpr;", "visitMacroExpr", "macroExpr", "Lorg/rust/lang/core/psi/RsMacroExpr;", "visitCallExpr", "callExpr", "Lorg/rust/lang/core/psi/RsCallExpr;", "visitMethodCallExpr", "o", "Lorg/rust/lang/core/psi/RsMethodCallExpr;", "visitFieldLookupExpr", "Lorg/rust/lang/core/psi/RsFieldLookupExpr;", "visitEmptyDotExpr", "Lorg/rust/lang/core/psi/RsEmptyDotExpr;", "intellij.rustrover.core"})
final class ExitPointVisitor
extends RsRecursiveVisitor {
    @NotNull
    private final Function1<ExitPoint, Unit> sink;
    private int inTry;

    public ExitPointVisitor(@NotNull Function1<? super ExitPoint, Unit> sink) {
        Intrinsics.checkNotNullParameter(sink, (String)"sink");
        this.sink = sink;
    }

    public final int getInTry() {
        return this.inTry;
    }

    public final void setInTry(int n) {
        this.inTry = n;
    }

    @Override
    public void visitLambdaExpr(@NotNull RsLambdaExpr lambdaExpr) {
        Intrinsics.checkNotNullParameter((Object)lambdaExpr, (String)"lambdaExpr");
    }

    @Override
    public void visitFunction(@NotNull RsFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
    }

    @Override
    public void visitBlockExpr(@NotNull RsBlockExpr blockExpr) {
        Intrinsics.checkNotNullParameter((Object)blockExpr, (String)"blockExpr");
        if (RsBlockExprKt.isTry(blockExpr)) {
            ++this.inTry;
            super.visitBlockExpr(blockExpr);
            --this.inTry;
        } else if (!RsBlockExprKt.isAsync(blockExpr) && !RsBlockExprKt.isGen(blockExpr)) {
            super.visitBlockExpr(blockExpr);
        }
    }

    @Override
    public void visitRetExpr(@NotNull RsRetExpr retExpr) {
        Intrinsics.checkNotNullParameter((Object)retExpr, (String)"retExpr");
        this.sink.invoke((Object)new ExitPoint.Return(retExpr));
    }

    @Override
    public void visitTryExpr(@NotNull RsTryExpr tryExpr) {
        Intrinsics.checkNotNullParameter((Object)tryExpr, (String)"tryExpr");
        tryExpr.getExpr().acceptChildren(this);
        if (this.inTry == 0) {
            this.sink.invoke((Object)new ExitPoint.TryExpr(tryExpr));
        }
    }

    @Override
    public void visitMacroExpr(@NotNull RsMacroExpr macroExpr) {
        Intrinsics.checkNotNullParameter((Object)macroExpr, (String)"macroExpr");
        super.visitMacroExpr(macroExpr);
        RsMacroCall rsMacroCall = macroExpr.getMacroCall();
        Intrinsics.checkNotNullExpressionValue((Object)rsMacroCall, (String)"getMacroCall(...)");
        RsMacroCall macroCall = rsMacroCall;
        if (RsMacroCallKt.isStdTryMacro(macroCall) && this.inTry == 0) {
            this.sink.invoke((Object)new ExitPoint.TryExpr(macroExpr));
        }
        ExitPointKt.access$markNeverTypeAsExit(macroExpr, this.sink);
    }

    @Override
    public void visitCallExpr(@NotNull RsCallExpr callExpr) {
        Intrinsics.checkNotNullParameter((Object)callExpr, (String)"callExpr");
        super.visitCallExpr(callExpr);
        ExitPointKt.access$markNeverTypeAsExit(callExpr, this.sink);
    }

    @Override
    public void visitMethodCallExpr(@NotNull RsMethodCallExpr o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        super.visitMethodCallExpr(o);
        ExitPointKt.access$markNeverTypeAsExit(o, this.sink);
    }

    @Override
    public void visitFieldLookupExpr(@NotNull RsFieldLookupExpr o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        super.visitFieldLookupExpr(o);
        ExitPointKt.access$markNeverTypeAsExit(o, this.sink);
    }

    @Override
    public void visitEmptyDotExpr(@NotNull RsEmptyDotExpr o) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        super.visitEmptyDotExpr(o);
        ExitPointKt.access$markNeverTypeAsExit(o, this.sink);
    }
}

