/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.dfa;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.dfa.ExitPointVisitor;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsBreakExpr;
import org.rust.lang.core.psi.RsElseBranch;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsExprStmt;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsIfExpr;
import org.rust.lang.core.psi.RsLabelDecl;
import org.rust.lang.core.psi.RsLambdaExpr;
import org.rust.lang.core.psi.RsLetDecl;
import org.rust.lang.core.psi.RsLoopExpr;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsMatchBody;
import org.rust.lang.core.psi.RsMatchExpr;
import org.rust.lang.core.psi.RsRetExpr;
import org.rust.lang.core.psi.RsStmt;
import org.rust.lang.core.psi.ext.RsBlockExprKt;
import org.rust.lang.core.psi.ext.RsBlockKt;
import org.rust.lang.core.psi.ext.RsFunctionKt;
import org.rust.lang.core.psi.ext.RsFunctionOrLambda;
import org.rust.lang.core.psi.ext.RsIfExprKt;
import org.rust.lang.core.psi.ext.RsLabeledExpression;
import org.rust.lang.core.psi.ext.RsLabeledExpressionKt;
import org.rust.lang.core.psi.ext.RsStmtKt;
import org.rust.lang.core.types.ExtensionsKt;
import org.rust.lang.core.types.ty.TyNever;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \t2\u00020\u0001:\u0006\u0004\u0005\u0006\u0007\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0005\n\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/rust/lang/core/dfa/ExitPoint;", "", "<init>", "()V", "Return", "TryExpr", "DivergingExpr", "TailExpr", "InvalidTailStatement", "Companion", "Lorg/rust/lang/core/dfa/ExitPoint$DivergingExpr;", "Lorg/rust/lang/core/dfa/ExitPoint$InvalidTailStatement;", "Lorg/rust/lang/core/dfa/ExitPoint$Return;", "Lorg/rust/lang/core/dfa/ExitPoint$TailExpr;", "Lorg/rust/lang/core/dfa/ExitPoint$TryExpr;", "intellij.rustrover.core"})
public abstract sealed class ExitPoint {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private ExitPoint() {
    }

    public /* synthetic */ ExitPoint(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tJ\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tJ$\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tH\u0002J$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/rust/lang/core/dfa/ExitPoint$Companion;", "", "<init>", "()V", "process", "", "fn", "Lorg/rust/lang/core/psi/ext/RsFunctionOrLambda;", "sink", "Lkotlin/Function1;", "Lorg/rust/lang/core/dfa/ExitPoint;", "block", "Lorg/rust/lang/core/psi/RsBlock;", "processBlockTailExprs", "processTailExpr", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void process(@NotNull RsFunctionOrLambda fn, @NotNull Function1<? super ExitPoint, Unit> sink) {
            Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
            Intrinsics.checkNotNullParameter(sink, (String)"sink");
            RsFunctionOrLambda rsFunctionOrLambda = fn;
            if (rsFunctionOrLambda instanceof RsFunction) {
                RsBlock rsBlock = RsFunctionKt.getBlock((RsFunction)fn);
                if (rsBlock == null) {
                    return;
                }
                this.process(rsBlock, sink);
            } else if (rsFunctionOrLambda instanceof RsLambdaExpr) {
                RsExpr rsExpr = ((RsLambdaExpr)fn).getExpr();
                if (rsExpr == null) {
                    return;
                }
                RsExpr expr = rsExpr;
                if (expr instanceof RsBlockExpr) {
                    RsBlock rsBlock = ((RsBlockExpr)expr).getBlock();
                    Intrinsics.checkNotNullExpressionValue((Object)rsBlock, (String)"<get-block>(...)");
                    this.process(rsBlock, sink);
                } else {
                    this.processTailExpr(expr, sink);
                }
            }
        }

        public final void process(@NotNull RsBlock block, @NotNull Function1<? super ExitPoint, Unit> sink) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter(sink, (String)"sink");
            block.acceptChildren(new ExitPointVisitor(sink));
            this.processBlockTailExprs(block, sink);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void processBlockTailExprs(RsBlock block, Function1<? super ExitPoint, Unit> sink) {
            Pair<List<RsStmt>, RsExpr> pair = RsBlockKt.getExpandedStmtsAndTailExpr(block);
            List stmts = (List)pair.component1();
            RsExpr tailExpr = (RsExpr)pair.component2();
            if (tailExpr != null) {
                this.processTailExpr(tailExpr, sink);
                return;
            }
            RsStmt lastStmt = (RsStmt)CollectionsKt.lastOrNull((List)stmts);
            if (lastStmt instanceof RsExprStmt && RsStmtKt.getHasSemicolon((RsExprStmt)lastStmt)) {
                RsExpr rsExpr = ((RsExprStmt)lastStmt).getExpr();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr, (String)"getExpr(...)");
                if (!Intrinsics.areEqual((Object)ExtensionsKt.getType(rsExpr), (Object)TyNever.INSTANCE)) {
                    sink.invoke((Object)new InvalidTailStatement(lastStmt));
                    return;
                }
            }
            if (!(lastStmt instanceof RsLetDecl)) return;
            if (((RsLetDecl)lastStmt).getSemicolon() == null) return;
            sink.invoke((Object)new InvalidTailStatement(lastStmt));
        }

        private final void processTailExpr(RsExpr expr, Function1<? super ExitPoint, Unit> sink) {
            RsExpr rsExpr = expr;
            if (rsExpr instanceof RsBlockExpr) {
                String label;
                if (RsBlockExprKt.isTry((RsBlockExpr)expr) || RsBlockExprKt.isAsync((RsBlockExpr)expr) || RsBlockExprKt.isGen((RsBlockExpr)expr)) {
                    sink.invoke((Object)new TailExpr(expr));
                    return;
                }
                RsLabelDecl rsLabelDecl = ((RsBlockExpr)expr).getLabelDecl();
                String string = label = rsLabelDecl != null ? rsLabelDecl.getName() : null;
                if (label != null) {
                    RsLabeledExpressionKt.processBreakExprs((RsLabeledExpression)expr, label, true, (Function1<? super RsBreakExpr, Unit>)((Function1)arg_0 -> Companion.processTailExpr$lambda$0(sink, arg_0)));
                }
                RsBlock rsBlock = ((RsBlockExpr)expr).getBlock();
                Intrinsics.checkNotNullExpressionValue((Object)rsBlock, (String)"<get-block>(...)");
                this.processBlockTailExprs(rsBlock, sink);
            } else if (rsExpr instanceof RsIfExpr) {
                RsIfExpr elseIf;
                RsBlock ifBlock = RsIfExprKt.getBlock((RsIfExpr)expr);
                if (ifBlock != null) {
                    this.processBlockTailExprs(ifBlock, sink);
                }
                RsElseBranch rsElseBranch = ((RsIfExpr)expr).getElseBranch();
                if (rsElseBranch == null) {
                    return;
                }
                RsElseBranch elseBranch = rsElseBranch;
                RsBlock elseBranchBlock = RsIfExprKt.getBlock(elseBranch);
                if (elseBranchBlock != null) {
                    this.processBlockTailExprs(elseBranchBlock, sink);
                }
                if ((elseIf = RsIfExprKt.getIfExpr(elseBranch)) != null) {
                    this.processTailExpr(elseIf, sink);
                }
            } else if (rsExpr instanceof RsMatchExpr) {
                RsMatchBody rsMatchBody = ((RsMatchExpr)expr).getMatchBody();
                List list = rsMatchBody != null ? rsMatchBody.getMatchArmList() : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                for (RsMatchArm arm : list) {
                    RsExpr armExpr;
                    if (arm.getExpr() == null) continue;
                    this.processTailExpr(armExpr, sink);
                }
            } else if (rsExpr instanceof RsLoopExpr) {
                RsLabelDecl rsLabelDecl = ((RsLoopExpr)expr).getLabelDecl();
                RsLabeledExpressionKt.processBreakExprs((RsLabeledExpression)expr, rsLabelDecl != null ? rsLabelDecl.getName() : null, false, (Function1<? super RsBreakExpr, Unit>)((Function1)arg_0 -> Companion.processTailExpr$lambda$1(sink, arg_0)));
            } else {
                sink.invoke((Object)new TailExpr(expr));
            }
        }

        private static final Unit processTailExpr$lambda$0(Function1 $sink, RsBreakExpr it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            $sink.invoke((Object)new TailExpr(it2));
            return Unit.INSTANCE;
        }

        private static final Unit processTailExpr$lambda$1(Function1 $sink, RsBreakExpr it2) {
            Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
            $sink.invoke((Object)new TailExpr(it2));
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/dfa/ExitPoint$DivergingExpr;", "Lorg/rust/lang/core/dfa/ExitPoint;", "e", "Lorg/rust/lang/core/psi/RsExpr;", "<init>", "(Lorg/rust/lang/core/psi/RsExpr;)V", "getE", "()Lorg/rust/lang/core/psi/RsExpr;", "intellij.rustrover.core"})
    public static final class DivergingExpr
    extends ExitPoint {
        @NotNull
        private final RsExpr e;

        public DivergingExpr(@NotNull RsExpr e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super(null);
            this.e = e;
        }

        @NotNull
        public final RsExpr getE() {
            return this.e;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/dfa/ExitPoint$InvalidTailStatement;", "Lorg/rust/lang/core/dfa/ExitPoint;", "stmt", "Lorg/rust/lang/core/psi/RsStmt;", "<init>", "(Lorg/rust/lang/core/psi/RsStmt;)V", "getStmt", "()Lorg/rust/lang/core/psi/RsStmt;", "intellij.rustrover.core"})
    public static final class InvalidTailStatement
    extends ExitPoint {
        @NotNull
        private final RsStmt stmt;

        public InvalidTailStatement(@NotNull RsStmt stmt) {
            Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
            super(null);
            this.stmt = stmt;
        }

        @NotNull
        public final RsStmt getStmt() {
            return this.stmt;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/dfa/ExitPoint$Return;", "Lorg/rust/lang/core/dfa/ExitPoint;", "e", "Lorg/rust/lang/core/psi/RsRetExpr;", "<init>", "(Lorg/rust/lang/core/psi/RsRetExpr;)V", "getE", "()Lorg/rust/lang/core/psi/RsRetExpr;", "intellij.rustrover.core"})
    public static final class Return
    extends ExitPoint {
        @NotNull
        private final RsRetExpr e;

        public Return(@NotNull RsRetExpr e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super(null);
            this.e = e;
        }

        @NotNull
        public final RsRetExpr getE() {
            return this.e;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/dfa/ExitPoint$TailExpr;", "Lorg/rust/lang/core/dfa/ExitPoint;", "e", "Lorg/rust/lang/core/psi/RsExpr;", "<init>", "(Lorg/rust/lang/core/psi/RsExpr;)V", "getE", "()Lorg/rust/lang/core/psi/RsExpr;", "intellij.rustrover.core"})
    public static final class TailExpr
    extends ExitPoint {
        @NotNull
        private final RsExpr e;

        public TailExpr(@NotNull RsExpr e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super(null);
            this.e = e;
        }

        @NotNull
        public final RsExpr getE() {
            return this.e;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/dfa/ExitPoint$TryExpr;", "Lorg/rust/lang/core/dfa/ExitPoint;", "e", "Lorg/rust/lang/core/psi/RsExpr;", "<init>", "(Lorg/rust/lang/core/psi/RsExpr;)V", "getE", "()Lorg/rust/lang/core/psi/RsExpr;", "intellij.rustrover.core"})
    public static final class TryExpr
    extends ExitPoint {
        @NotNull
        private final RsExpr e;

        public TryExpr(@NotNull RsExpr e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super(null);
            this.e = e;
        }

        @NotNull
        public final RsExpr getE() {
            return this.e;
        }
    }
}

