/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.dfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.dfa.BitwiseOperator;
import org.rust.lang.core.dfa.CFGNodeData;
import org.rust.lang.core.dfa.ControlFlowGraph;
import org.rust.lang.core.dfa.DataFlowOperator;
import org.rust.lang.core.dfa.EntryOrExit;
import org.rust.lang.core.dfa.FlowDirection;
import org.rust.lang.core.dfa.KillFrom;
import org.rust.lang.core.dfa.Subtract;
import org.rust.lang.core.dfa.Union;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.utils.Edge;
import org.rust.lang.utils.Graph;
import org.rust.lang.utils.Node;
import org.rust.lang.utils.PresentableGraph;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u000256B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ&\u0010\u001b\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J,\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0!2\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001aH\u0002J\u001e\u0010#\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010%\u001a\u00020\bH\u0002J\u0016\u0010&\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\bJ\u001e\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001d\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\bJ2\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001a2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\"\u0010,\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00162\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001f0.J<\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u0002012\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001a2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001f0.H\u0002J\"\u00102\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u00162\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001f0.J*\u00103\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001f0.H\u0002J\u0006\u00104\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0014\u001a$\u0012\u0004\u0012\u00020\u0016\u0012\u001a\u0012\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001a0\u00100\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/rust/lang/core/dfa/DataFlowContext;", "O", "Lorg/rust/lang/core/dfa/DataFlowOperator;", "", "cfg", "Lorg/rust/lang/core/dfa/ControlFlowGraph;", "oper", "bitsPerElement", "", "flowDirection", "Lorg/rust/lang/core/dfa/FlowDirection;", "<init>", "(Lorg/rust/lang/core/dfa/ControlFlowGraph;Lorg/rust/lang/core/dfa/DataFlowOperator;ILorg/rust/lang/core/dfa/FlowDirection;)V", "Lorg/rust/lang/core/dfa/DataFlowOperator;", "wordsPerElement", "gens", "", "scopeKills", "actionKills", "onEntry", "cfgTable", "", "Lorg/rust/lang/core/psi/ext/RsElement;", "Lorg/rust/lang/utils/Node;", "Lorg/rust/lang/core/dfa/CFGNodeData;", "", "Lorg/rust/lang/core/dfa/CFGNode;", "getCfgNodes", "", "element", "hasBitSetForElement", "", "getRange", "Lkotlin/Pair;", "node", "setBit", "words", "bit", "addGen", "addKill", "kind", "Lorg/rust/lang/core/dfa/KillFrom;", "applyGenKill", "bits", "eachBitOnEntry", "predicate", "Lkotlin/Function1;", "eachBitForNode", "e", "Lorg/rust/lang/core/dfa/EntryOrExit;", "eachGenBit", "eachBit", "propagate", "Companion", "PropagationContext", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nDataFlow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFlow.kt\norg/rust/lang/core/dfa/DataFlowContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1#2:229\n1869#3,2:230\n1869#3,2:232\n1740#3,3:234\n1740#3,3:237\n*S KotlinDebug\n*F\n+ 1 DataFlow.kt\norg/rust/lang/core/dfa/DataFlowContext\n*L\n60#1:230,2\n67#1:232,2\n88#1:234,3\n110#1:237,3\n*E\n"})
public final class DataFlowContext<O extends DataFlowOperator> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ControlFlowGraph cfg;
    @NotNull
    private final O oper;
    private final int bitsPerElement;
    @NotNull
    private final FlowDirection flowDirection;
    private final int wordsPerElement;
    @NotNull
    private final List<Integer> gens;
    @NotNull
    private final List<Integer> scopeKills;
    @NotNull
    private final List<Integer> actionKills;
    @NotNull
    private final List<Integer> onEntry;
    @NotNull
    private final Map<RsElement, List<Node<CFGNodeData, Unit>>> cfgTable;
    private static final int BITS_PER_INT = 32;

    public DataFlowContext(@NotNull ControlFlowGraph cfg, @NotNull O oper, int bitsPerElement, @NotNull FlowDirection flowDirection) {
        int it2;
        ArrayList<Integer> arrayList;
        int n;
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        Intrinsics.checkNotNullParameter(oper, (String)"oper");
        Intrinsics.checkNotNullParameter((Object)((Object)flowDirection), (String)"flowDirection");
        this.cfg = cfg;
        this.oper = oper;
        this.bitsPerElement = bitsPerElement;
        this.flowDirection = flowDirection;
        this.wordsPerElement = (this.bitsPerElement + 32 - 1) / 32;
        int size = this.cfg.getGraph().getNodesCount() * this.wordsPerElement;
        DataFlowContext dataFlowContext = this;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(size);
        int n2 = 0;
        while (n2 < size) {
            int n3 = n = n2++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(0);
        }
        dataFlowContext.gens = arrayList2;
        dataFlowContext = this;
        arrayList2 = new ArrayList(size);
        n2 = 0;
        while (n2 < size) {
            it2 = n = n2++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(0);
        }
        dataFlowContext.actionKills = arrayList2;
        dataFlowContext = this;
        arrayList2 = new ArrayList(size);
        n2 = 0;
        while (n2 < size) {
            it2 = n = n2++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(0);
        }
        dataFlowContext.scopeKills = arrayList2;
        dataFlowContext = this;
        arrayList2 = new ArrayList(size);
        n2 = 0;
        while (n2 < size) {
            it2 = n = n2++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add(this.oper.getNeutralElement());
        }
        dataFlowContext.onEntry = arrayList2;
        this.cfgTable = this.cfg.buildLocalIndex();
    }

    private final List<Node<CFGNodeData, Unit>> getCfgNodes(RsElement element) {
        return this.cfgTable.getOrDefault(element, new ArrayList());
    }

    private final boolean hasBitSetForElement(RsElement element) {
        return this.cfgTable.containsKey(element);
    }

    private final Pair<Integer, Integer> getRange(Node<CFGNodeData, Unit> node) {
        int start2 = node.getIndex() * this.wordsPerElement;
        int end = start2 + this.wordsPerElement;
        return new Pair((Object)start2, (Object)end);
    }

    private final boolean setBit(List<Integer> words, int bit) {
        int word = bit / 32;
        int bitInWord = bit % 32;
        int bitMask = 1 << bitInWord;
        int oldValue = ((Number)words.get(word)).intValue();
        int newValue = oldValue | bitMask;
        words.set(word, newValue);
        return oldValue != newValue;
    }

    public final void addGen(@NotNull RsElement element, int bit) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Iterable $this$forEach$iv = this.getCfgNodes(element);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it2 = (Node)element$iv;
            boolean bl = false;
            Pair<Integer, Integer> pair = this.getRange(it2);
            int start2 = ((Number)pair.component1()).intValue();
            int end = ((Number)pair.component2()).intValue();
            this.setBit(this.gens.subList(start2, end), bit);
        }
    }

    public final void addKill(@NotNull KillFrom kind2, @NotNull RsElement element, int bit) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Iterable $this$forEach$iv = this.getCfgNodes(element);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it2 = (Node)element$iv;
            boolean bl = false;
            Pair<Integer, Integer> pair = this.getRange(it2);
            int start2 = ((Number)pair.component1()).intValue();
            int end = ((Number)pair.component2()).intValue();
            switch (WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
                case 1: {
                    boolean bl2 = this.setBit(this.scopeKills.subList(start2, end), bit);
                    break;
                }
                case 2: {
                    boolean bl2 = this.setBit(this.actionKills.subList(start2, end), bit);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @NotNull
    public final List<Integer> applyGenKill(@NotNull Node<CFGNodeData, Unit> node, @NotNull List<Integer> bits) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        Intrinsics.checkNotNullParameter(bits, (String)"bits");
        Pair<Integer, Integer> pair = this.getRange(node);
        int start2 = ((Number)pair.component1()).intValue();
        int end = ((Number)pair.component2()).intValue();
        List result2 = CollectionsKt.toMutableList((Collection)bits);
        Union.INSTANCE.bitwise(result2, this.gens.subList(start2, end));
        Subtract.INSTANCE.bitwise(result2, this.actionKills.subList(start2, end));
        Subtract.INSTANCE.bitwise(result2, this.scopeKills.subList(start2, end));
        return result2;
    }

    public final boolean eachBitOnEntry(@NotNull RsElement element, @NotNull Function1<? super Integer, Boolean> predicate) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            if (!this.hasBitSetForElement(element)) {
                return true;
            }
            List<Node<CFGNodeData, Unit>> nodes = this.getCfgNodes(element);
            Iterable $this$all$iv = nodes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Node it2 = (Node)element$iv;
                    boolean bl2 = false;
                    if (this.eachBitForNode(EntryOrExit.Entry, it2, predicate)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean eachBitForNode(EntryOrExit e, Node<CFGNodeData, Unit> node, Function1<? super Integer, Boolean> predicate) {
        if (this.bitsPerElement == 0) {
            return true;
        }
        Pair<Integer, Integer> pair = this.getRange(node);
        int start2 = ((Number)pair.component1()).intValue();
        int end = ((Number)pair.component2()).intValue();
        List<Integer> onEntry = this.onEntry.subList(start2, end);
        List<Integer> slice = switch (WhenMappings.$EnumSwitchMapping$1[e.ordinal()]) {
            case 1 -> onEntry;
            case 2 -> this.applyGenKill(node, onEntry);
            default -> throw new NoWhenBranchMatchedException();
        };
        return this.eachBit(slice, predicate);
    }

    public final boolean eachGenBit(@NotNull RsElement element, @NotNull Function1<? super Integer, Boolean> predicate) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            if (!this.hasBitSetForElement(element)) {
                return true;
            }
            if (this.bitsPerElement == 0) {
                return true;
            }
            List<Node<CFGNodeData, Unit>> nodes = this.getCfgNodes(element);
            Iterable $this$all$iv = nodes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int end;
                    Node it2 = (Node)element$iv;
                    boolean bl2 = false;
                    Pair<Integer, Integer> pair = this.getRange(it2);
                    int start2 = ((Number)pair.component1()).intValue();
                    if (this.eachBit(this.gens.subList(start2, end = ((Number)pair.component2()).intValue()), predicate)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean eachBit(List<Integer> words, Function1<? super Integer, Boolean> predicate) {
        Iterator iterator2 = ((Iterable)words).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            int word = ((Number)iterator2.next()).intValue();
            if (word == 0) continue;
            int baseIndex = index * 32;
            for (int offset = 0; offset < 32; ++offset) {
                int bit = 1 << offset;
                if ((word & bit) == 0) continue;
                int bitIndex = baseIndex + offset;
                if (bitIndex >= this.bitsPerElement) {
                    return true;
                }
                if (((Boolean)predicate.invoke((Object)bitIndex)).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public final void propagate() {
        if (this.bitsPerElement == 0) {
            return;
        }
        PropagationContext propagationContext = new PropagationContext(this, true, this.flowDirection);
        List orderedNodes = switch (WhenMappings.$EnumSwitchMapping$2[this.flowDirection.ordinal()]) {
            case 1 -> CollectionsKt.asReversed((List)Graph.nodesInPostOrder$default(this.cfg.getGraph(), this.cfg.getEntry(), null, 2, null));
            case 2 -> Graph.nodesInPostOrder$default(this.cfg.getGraph(), this.cfg.getEntry(), null, 2, null);
            default -> throw new NoWhenBranchMatchedException();
        };
        while (propagationContext.getChanged()) {
            propagationContext.setChanged(false);
            propagationContext.walkCfg(orderedNodes);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/lang/core/dfa/DataFlowContext$Companion;", "", "<init>", "()V", "BITS_PER_INT", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\u001b\u001a\u00020\u00172\u001c\u0010\u001c\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u001ej\u0002`\u001f0\u001dJ.\u0010 \u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u001ej\u0002`\u001fH\u0002J.\u0010$\u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u001ej\u0002`\u001fH\u0002J.\u0010%\u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001d2\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u001ej\u0002`\u001fH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R!\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015j\u0002`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Lorg/rust/lang/core/dfa/DataFlowContext$PropagationContext;", "O", "Lorg/rust/lang/core/dfa/DataFlowOperator;", "", "dataFlowContext", "Lorg/rust/lang/core/dfa/DataFlowContext;", "changed", "", "flowDirection", "Lorg/rust/lang/core/dfa/FlowDirection;", "<init>", "(Lorg/rust/lang/core/dfa/DataFlowContext;ZLorg/rust/lang/core/dfa/FlowDirection;)V", "getDataFlowContext", "()Lorg/rust/lang/core/dfa/DataFlowContext;", "getChanged", "()Z", "setChanged", "(Z)V", "getFlowDirection", "()Lorg/rust/lang/core/dfa/FlowDirection;", "graph", "Lorg/rust/lang/utils/PresentableGraph;", "Lorg/rust/lang/core/dfa/CFGNodeData;", "", "Lorg/rust/lang/core/dfa/CFGGraph;", "getGraph", "()Lorg/rust/lang/utils/PresentableGraph;", "walkCfg", "orderedNodes", "", "Lorg/rust/lang/utils/Node;", "Lorg/rust/lang/core/dfa/CFGNode;", "propagateBitsIntoGraphSuccessorsOf", "predBits", "", "node", "propagateBitsIntoGraphPredecessorsOf", "propagateBitsIntoEntrySetFor", "intellij.rustrover.core"})
    private static final class PropagationContext<O extends DataFlowOperator> {
        @NotNull
        private final DataFlowContext<O> dataFlowContext;
        private boolean changed;
        @NotNull
        private final FlowDirection flowDirection;
        @NotNull
        private final PresentableGraph<CFGNodeData, Unit> graph;

        public PropagationContext(@NotNull DataFlowContext<O> dataFlowContext, boolean changed, @NotNull FlowDirection flowDirection) {
            Intrinsics.checkNotNullParameter(dataFlowContext, (String)"dataFlowContext");
            Intrinsics.checkNotNullParameter((Object)((Object)flowDirection), (String)"flowDirection");
            this.dataFlowContext = dataFlowContext;
            this.changed = changed;
            this.flowDirection = flowDirection;
            this.graph = ((DataFlowContext)this.dataFlowContext).cfg.getGraph();
        }

        @NotNull
        public final DataFlowContext<O> getDataFlowContext() {
            return this.dataFlowContext;
        }

        public final boolean getChanged() {
            return this.changed;
        }

        public final void setChanged(boolean bl) {
            this.changed = bl;
        }

        @NotNull
        public final FlowDirection getFlowDirection() {
            return this.flowDirection;
        }

        @NotNull
        public final PresentableGraph<CFGNodeData, Unit> getGraph() {
            return this.graph;
        }

        public final void walkCfg(@NotNull List<Node<CFGNodeData, Unit>> orderedNodes) {
            Intrinsics.checkNotNullParameter(orderedNodes, (String)"orderedNodes");
            block4: for (Node<CFGNodeData, Unit> node : orderedNodes) {
                Pair pair = ((DataFlowContext)this.dataFlowContext).getRange(node);
                int start2 = ((Number)pair.component1()).intValue();
                int end = ((Number)pair.component2()).intValue();
                List<Integer> onEntry = ((DataFlowContext)this.dataFlowContext).onEntry.subList(start2, end);
                List<Integer> result2 = this.dataFlowContext.applyGenKill(node, onEntry);
                switch (WhenMappings.$EnumSwitchMapping$0[this.flowDirection.ordinal()]) {
                    case 1: {
                        this.propagateBitsIntoGraphSuccessorsOf(result2, node);
                        continue block4;
                    }
                    case 2: {
                        this.propagateBitsIntoGraphPredecessorsOf(result2, node);
                        continue block4;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
        }

        private final void propagateBitsIntoGraphSuccessorsOf(List<Integer> predBits, Node<CFGNodeData, Unit> node) {
            for (Edge edge : this.graph.outgoingEdges(node)) {
                this.propagateBitsIntoEntrySetFor(predBits, edge.getTarget());
            }
        }

        private final void propagateBitsIntoGraphPredecessorsOf(List<Integer> predBits, Node<CFGNodeData, Unit> node) {
            for (Edge edge : this.graph.incomingEdges(node)) {
                this.propagateBitsIntoEntrySetFor(predBits, edge.getSource());
            }
        }

        private final void propagateBitsIntoEntrySetFor(List<Integer> predBits, Node<CFGNodeData, Unit> node) {
            Pair pair = ((DataFlowContext)this.dataFlowContext).getRange(node);
            int start2 = ((Number)pair.component1()).intValue();
            int end = ((Number)pair.component2()).intValue();
            List<Integer> onEntry = ((DataFlowContext)this.dataFlowContext).onEntry.subList(start2, end);
            boolean changed = ((BitwiseOperator)((DataFlowContext)this.dataFlowContext).oper).bitwise(onEntry, predBits);
            if (changed) {
                this.changed = true;
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FlowDirection.values().length];
                try {
                    nArray[FlowDirection.Forward.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FlowDirection.Backward.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[KillFrom.values().length];
            try {
                nArray[KillFrom.ScopeEnd.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KillFrom.Execution.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EntryOrExit.values().length];
            try {
                nArray[EntryOrExit.Entry.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EntryOrExit.Exit.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[FlowDirection.values().length];
            try {
                nArray[FlowDirection.Forward.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FlowDirection.Backward.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

