/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.crate.impl;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.FeatureState;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.crate.impl.CrateGraph;
import org.rust.lang.core.crate.impl.CrateGraphBuilder;
import org.rust.lang.core.crate.impl.CrateGraphServiceImpl;
import org.rust.lang.core.crate.impl.CyclicGraphException;
import org.rust.lang.core.crate.impl.ProjectPackage;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u001a\u0012\u0010\n\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u001a<\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002\u001a\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\b\u0012\u0004\u0012\u00020\u00140\u0005H\u0002\u001a\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013*\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "buildCrateGraph", "Lorg/rust/lang/core/crate/impl/CrateGraph;", "cargoProjects", "", "Lorg/rust/cargo/project/model/CargoProject;", "checkInvariants", "", "Lorg/rust/lang/core/crate/Crate;", "assertTopSorted", "", "mergeFeatures", "", "", "Lorg/rust/cargo/project/workspace/FeatureState;", "features1", "features2", "sortedDeterministically", "", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Package;", "Lorg/rust/cargo/project/workspace/CargoWorkspace$Dependency;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCrateGraphServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrateGraphServiceImpl.kt\norg/rust/lang/core/crate/impl/CrateGraphServiceImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,492:1\n1740#2,3:493\n1056#2:496\n13#3:497\n*S KotlinDebug\n*F\n+ 1 CrateGraphServiceImpl.kt\norg/rust/lang/core/crate/impl/CrateGraphServiceImplKt\n*L\n416#1:493,3\n461#1:496\n84#1:497\n*E\n"})
public final class CrateGraphServiceImplKt {
    @NotNull
    private static final Logger LOG;

    private static final CrateGraph buildCrateGraph(Collection<? extends CargoProject> cargoProjects) {
        CrateGraphBuilder builder = new CrateGraphBuilder();
        for (CargoProject cargoProject : cargoProjects) {
            CargoWorkspace workspace;
            if (cargoProject.getWorkspace() == null) continue;
            for (CargoWorkspace.Package pkg : CrateGraphServiceImplKt.sortedDeterministically(workspace.getPackages())) {
                try {
                    builder.lowerPackage(new ProjectPackage(cargoProject, pkg, null, 4, null));
                }
                catch (CyclicGraphException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return builder.build();
    }

    private static final void checkInvariants(Crate $this$checkInvariants) {
        if (!UtilsKt.isUnitTestMode()) {
            return;
        }
        CrateGraphServiceImplKt.assertTopSorted((Iterable<? extends Crate>)$this$checkInvariants.getFlatDependencies());
        for (Crate.Dependency dep : $this$checkInvariants.getDependencies()) {
            if ($this$checkInvariants.getFlatDependencies().contains(dep.getCrate())) continue;
            boolean bl = false;
            String string = "Error in structure of crate `" + $this$checkInvariants + "`: no `" + dep.getCrate() + "` dependency in flatDependencies: " + $this$checkInvariants.getFlatDependencies();
            throw new IllegalStateException(string.toString());
        }
    }

    private static final void assertTopSorted(Iterable<? extends Crate> $this$assertTopSorted) {
        if (!UtilsKt.isUnitTestMode()) {
            return;
        }
        HashSet set = new HashSet();
        for (Crate crate : $this$assertTopSorted) {
            boolean bl;
            block6: {
                Iterable $this$all$iv = crate.getDependencies();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Crate.Dependency it2 = (Crate.Dependency)element$iv;
                        boolean bl2 = false;
                        if (set.contains(it2.getCrate())) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                throw new IllegalStateException("Check failed.");
            }
            ((Collection)set).add(crate);
        }
    }

    private static final Map<String, FeatureState> mergeFeatures(Map<String, ? extends FeatureState> features1, Map<String, ? extends FeatureState> features2) {
        Map featureMap = MapsKt.toMutableMap(features1);
        for (Map.Entry<String, ? extends FeatureState> entry2 : features2.entrySet()) {
            String k = entry2.getKey();
            FeatureState v = entry2.getValue();
            featureMap.merge(k, v, (arg_0, arg_1) -> CrateGraphServiceImplKt.mergeFeatures$lambda$1(CrateGraphServiceImplKt::mergeFeatures$lambda$0, arg_0, arg_1));
        }
        return featureMap;
    }

    private static final List<CargoWorkspace.Package> sortedDeterministically(Collection<? extends CargoWorkspace.Package> $this$sortedDeterministically) {
        Function1[] function1Array = new Function1[]{CrateGraphServiceImplKt::sortedDeterministically$lambda$0, CrateGraphServiceImplKt::sortedDeterministically$lambda$1, CrateGraphServiceImplKt::sortedDeterministically$lambda$2};
        return CollectionsKt.sortedWith((Iterable)$this$sortedDeterministically, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
    }

    private static final List<CargoWorkspace.Dependency> sortedDeterministically(Iterable<? extends CargoWorkspace.Dependency> $this$sortedDeterministically) {
        Iterable<? extends CargoWorkspace.Dependency> $this$sortedBy$iv = $this$sortedDeterministically;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith($this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CargoWorkspace.Dependency it2 = (CargoWorkspace.Dependency)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it2.getName());
                it2 = (CargoWorkspace.Dependency)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it2.getName())));
            }
        });
    }

    private static final FeatureState mergeFeatures$lambda$0(FeatureState v1, FeatureState v2) {
        Intrinsics.checkNotNullParameter((Object)((Object)v1), (String)"v1");
        Intrinsics.checkNotNullParameter((Object)((Object)v2), (String)"v2");
        return v1 == FeatureState.Enabled ? FeatureState.Enabled : (v2 == FeatureState.Enabled ? FeatureState.Enabled : FeatureState.Disabled);
    }

    private static final FeatureState mergeFeatures$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (FeatureState)((Object)$tmp0.invoke(p0, p1));
    }

    private static final Comparable sortedDeterministically$lambda$0(CargoWorkspace.Package it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return switch (WhenMappings.$EnumSwitchMapping$0[it2.getOrigin().ordinal()]) {
            case 1 -> Integer.valueOf(0);
            case 2 -> Integer.valueOf(1);
            case 3 -> Integer.valueOf(2);
            case 4 -> Integer.valueOf(3);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Comparable sortedDeterministically$lambda$1(CargoWorkspace.Package it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return (Comparable)((Object)it2.getName());
    }

    private static final Comparable sortedDeterministically$lambda$2(CargoWorkspace.Package it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return (Comparable)((Object)it2.getVersion());
    }

    public static final /* synthetic */ CrateGraph access$buildCrateGraph(Collection cargoProjects) {
        return CrateGraphServiceImplKt.buildCrateGraph(cargoProjects);
    }

    public static final /* synthetic */ Map access$mergeFeatures(Map features1, Map features2) {
        return CrateGraphServiceImplKt.mergeFeatures(features1, features2);
    }

    public static final /* synthetic */ List access$sortedDeterministically(Iterable $receiver) {
        return CrateGraphServiceImplKt.sortedDeterministically($receiver);
    }

    public static final /* synthetic */ void access$assertTopSorted(Iterable $receiver) {
        CrateGraphServiceImplKt.assertTopSorted($receiver);
    }

    public static final /* synthetic */ void access$checkInvariants(Crate $receiver) {
        CrateGraphServiceImplKt.checkInvariants($receiver);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CrateGraphServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PackageOrigin.values().length];
            try {
                nArray[PackageOrigin.STDLIB_DEPENDENCY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PackageOrigin.STDLIB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PackageOrigin.DEPENDENCY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PackageOrigin.WORKSPACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

