/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.crate.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.crate.CrateGraphService;
import org.rust.lang.core.crate.impl.CrateGraph;
import org.rust.lang.core.crate.impl.CrateGraphServiceImplKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00122\n\u0010\u0016\u001a\u00060\u0017j\u0002`\u0018H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/rust/lang/core/crate/impl/CrateGraphServiceImpl;", "Lorg/rust/lang/core/crate/CrateGraphService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cargoProjectsModTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "crateGraphCachedValue", "Lcom/intellij/psi/util/CachedValue;", "Lorg/rust/lang/core/crate/impl/CrateGraph;", "crateGraph", "getCrateGraph", "()Lorg/rust/lang/core/crate/impl/CrateGraph;", "topSortedCrates", "", "Lorg/rust/lang/core/crate/Crate;", "getTopSortedCrates", "()Ljava/util/List;", "findCrateById", "id", "", "Lorg/rust/lang/core/crate/CratePersistentId;", "findCrateByRootMod", "rootModFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasUpToDateGraph", "", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCrateGraphServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrateGraphServiceImpl.kt\norg/rust/lang/core/crate/impl/CrateGraphServiceImpl\n+ 2 Utils.kt\norg/rust/stdext/UtilsKt\n*L\n1#1,492:1\n37#2:493\n*S KotlinDebug\n*F\n+ 1 CrateGraphServiceImpl.kt\norg/rust/lang/core/crate/impl/CrateGraphServiceImpl\n*L\n72#1:493\n*E\n"})
public final class CrateGraphServiceImpl
implements CrateGraphService {
    @NotNull
    private final Project project;
    @NotNull
    private final SimpleModificationTracker cargoProjectsModTracker;
    @NotNull
    private final CachedValue<CrateGraph> crateGraphCachedValue;

    public CrateGraphServiceImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cargoProjectsModTracker = new SimpleModificationTracker();
        this.project.getMessageBus().connect().subscribe(CargoProjectsService.Companion.getCARGO_PROJECTS_TOPIC(), (arg_0, arg_1) -> CrateGraphServiceImpl._init_$lambda$0(this, arg_0, arg_1));
        this.crateGraphCachedValue = (CachedValue)new CachedValueImpl(() -> CrateGraphServiceImpl.crateGraphCachedValue$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final CrateGraph getCrateGraph() {
        Object object = this.crateGraphCachedValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (CrateGraph)object;
    }

    @Override
    @NotNull
    public List<Crate> getTopSortedCrates() {
        UtilsKt.checkReadAccessAllowed();
        return this.getCrateGraph().getTopSortedCrates();
    }

    @Override
    @Nullable
    public Crate findCrateById(int id) {
        UtilsKt.checkReadAccessAllowed();
        return (Crate)this.getCrateGraph().getIdToCrate().get(id);
    }

    @Override
    @Nullable
    public Crate findCrateByRootMod(@NotNull VirtualFile rootModFile) {
        Intrinsics.checkNotNullParameter((Object)rootModFile, (String)"rootModFile");
        UtilsKt.checkReadAccessAllowed();
        VirtualFile $this$applyWithSymlink$iv = rootModFile;
        boolean $i$f$applyWithSymlink = false;
        VirtualFile it2 = $this$applyWithSymlink$iv;
        boolean bl = false;
        Crate crate = it2 instanceof VirtualFileWithId ? this.findCrateById(((VirtualFileWithId)it2).getId()) : null;
        if (crate == null) {
            VirtualFile virtualFile = $this$applyWithSymlink$iv.getCanonicalFile();
            if (virtualFile == null) {
                crate = null;
            } else {
                VirtualFile it3 = virtualFile;
                $i$a$-applyWithSymlink-CrateGraphServiceImpl$findCrateByRootMod$1 = false;
                crate = it3 instanceof VirtualFileWithId ? this.findCrateById(((VirtualFileWithId)it3).getId()) : null;
            }
        }
        return crate;
    }

    @TestOnly
    public final boolean hasUpToDateGraph() {
        return this.crateGraphCachedValue.hasUpToDateValue();
    }

    private static final void _init_$lambda$0(CrateGraphServiceImpl this$0, CargoProjectsService cargoProjectsService, Collection collection) {
        Intrinsics.checkNotNullParameter((Object)cargoProjectsService, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"<unused var>");
        this$0.cargoProjectsModTracker.incModificationCount();
    }

    private static final CachedValueProvider.Result crateGraphCachedValue$lambda$0(CrateGraphServiceImpl this$0) {
        CrateGraph result2 = CrateGraphServiceImplKt.access$buildCrateGraph(CargoProjectServiceKt.getCargoProjects(this$0.project).getAllProjects());
        Object[] objectArray = new Object[]{this$0.cargoProjectsModTracker, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS};
        return new CachedValueProvider.Result((Object)result2, objectArray);
    }
}

