/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.completion.lint;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.icons.RsIcons;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.RsPsiPattern;
import org.rust.lang.core.completion.LookupElementsKt;
import org.rust.lang.core.completion.RsCompletionProvider;
import org.rust.lang.core.completion.RsLookupElementProperties;
import org.rust.lang.core.completion.lint.Lint;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.ext.RsPathKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J$\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lorg/rust/lang/core/completion/lint/RsLintCompletionProvider;", "Lorg/rust/lang/core/completion/RsCompletionProvider;", "<init>", "()V", "prefix", "", "getPrefix", "()Ljava/lang/String;", "lints", "", "Lorg/rust/lang/core/completion/lint/Lint;", "getLints", "()Ljava/util/List;", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "addLintToCompletion", "lint", "completionText", "elementPattern", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/psi/PsiElement;", "getElementPattern", "()Lcom/intellij/patterns/ElementPattern;", "getIcon", "Ljavax/swing/Icon;", "getElementKind", "Lorg/rust/lang/core/completion/RsLookupElementProperties$ElementKind;", "getPathPrefix", "path", "Lorg/rust/lang/core/psi/RsPath;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsLintCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLintCompletionProvider.kt\norg/rust/lang/core/completion/lint/RsLintCompletionProvider\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 RsPsiPattern.kt\norg/rust/lang/core/RsPsiPatternKt\n*L\n1#1,87:1\n66#2,2:88\n1869#3,2:90\n558#4:92\n*S KotlinDebug\n*F\n+ 1 RsLintCompletionProvider.kt\norg/rust/lang/core/completion/lint/RsLintCompletionProvider\n*L\n38#1:88,2\n42#1:90,2\n66#1:92\n*E\n"})
public abstract class RsLintCompletionProvider
extends RsCompletionProvider {
    @NotNull
    private final String prefix;

    public RsLintCompletionProvider() {
        this.prefix = "";
    }

    @NotNull
    protected String getPrefix() {
        return this.prefix;
    }

    @NotNull
    protected abstract List<Lint> getLints();

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement2 = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPosition(...)");
        PsiElement $this$parentOfType_u24default$iv = psiElement2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        RsPath rsPath = (RsPath)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, RsPath.class, (boolean)true);
        if (rsPath == null) {
            return;
        }
        RsPath path = rsPath;
        String currentPrefix = this.getPathPrefix(path);
        if (!Intrinsics.areEqual((Object)currentPrefix, (Object)this.getPrefix())) {
            return;
        }
        Iterable $this$forEach$iv = this.getLints();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Lint it2 = (Lint)element$iv;
            boolean bl = false;
            RsLintCompletionProvider.addLintToCompletion$default(this, result2, it2, null, 4, null);
        }
    }

    protected final void addLintToCompletion(@NotNull CompletionResultSet result2, @NotNull Lint lint, @Nullable String completionText) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)lint, (String)"lint");
        String string = completionText;
        if (string == null) {
            string = lint.getName();
        }
        String text = string;
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)text).withPresentableText(lint.getName()).withIcon(this.getIcon(lint));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withIcon(...)");
        LookupElement element = LookupElementsKt.toRsLookupElement((LookupElement)lookupElementBuilder, new RsLookupElementProperties(false, null, false, false, false, false, this.getElementKind(lint), false, false, false, false, false, false, false, 16319, null));
        result2.addElement(element);
    }

    public static /* synthetic */ void addLintToCompletion$default(RsLintCompletionProvider rsLintCompletionProvider, CompletionResultSet completionResultSet, Lint lint, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addLintToCompletion");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        rsLintCompletionProvider.addLintToCompletion(completionResultSet, lint, string);
    }

    @Override
    @NotNull
    public ElementPattern<? extends PsiElement> getElementPattern() {
        PsiElementPattern.Capture capture = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage((Language)RsLanguage.INSTANCE)).withParent(RsPath.class);
        boolean $i$f$psiElement = false;
        PsiElementPattern.Capture capture2 = PlatformPatterns.psiElement(RsMetaItem.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture2, (String)"psiElement(...)");
        TreeElementPattern treeElementPattern = capture.inside((ElementPattern)capture2.withSuperParent(2, (ElementPattern)RsPsiPattern.INSTANCE.getLintAttributeMetaItem()));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"inside(...)");
        return (ElementPattern)treeElementPattern;
    }

    private final Icon getIcon(Lint lint) {
        return lint.isGroup() ? RsIcons.INSTANCE.getATTRIBUTE_GROUP() : RsIcons.INSTANCE.getATTRIBUTE();
    }

    private final RsLookupElementProperties.ElementKind getElementKind(Lint lint) {
        return lint.isGroup() ? RsLookupElementProperties.ElementKind.LINT_GROUP : RsLookupElementProperties.ElementKind.LINT;
    }

    @NotNull
    protected final String getPathPrefix(@NotNull RsPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        RsPath rsPath = RsPathKt.getQualifier(path);
        if (rsPath == null) {
            Object object = path.getColoncolon();
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            return object;
        }
        RsPath qualifier = rsPath;
        String string = this.getPathPrefix(qualifier);
        String string2 = qualifier.getReferenceName();
        if (string2 == null) {
            string2 = "";
        }
        return string + string2 + "::";
    }
}

