/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.ide.typing.UtilsKt;
import org.rust.lang.core.completion.InsertionContextFromCompletionPlace;
import org.rust.lang.core.completion.LookupPrefixData;
import org.rust.lang.core.completion.RsDefaultInsertHandler;
import org.rust.lang.core.psi.ext.RsElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/completion/RsWithPrefixInsertHandler;", "Lorg/rust/lang/core/completion/RsDefaultInsertHandler;", "contextFromCompletionPlace", "Lorg/rust/lang/core/completion/InsertionContextFromCompletionPlace;", "prefixData", "Lorg/rust/lang/core/completion/LookupPrefixData;", "<init>", "(Lorg/rust/lang/core/completion/InsertionContextFromCompletionPlace;Lorg/rust/lang/core/completion/LookupPrefixData;)V", "handleInsert", "", "element", "Lorg/rust/lang/core/psi/ext/RsElement;", "scopeName", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "escapeIfNeeded", "logStatistics", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rustrover.core"})
public class RsWithPrefixInsertHandler
extends RsDefaultInsertHandler {
    @NotNull
    private final LookupPrefixData prefixData;

    public RsWithPrefixInsertHandler(@NotNull InsertionContextFromCompletionPlace contextFromCompletionPlace, @NotNull LookupPrefixData prefixData) {
        Intrinsics.checkNotNullParameter((Object)contextFromCompletionPlace, (String)"contextFromCompletionPlace");
        Intrinsics.checkNotNullParameter((Object)prefixData, (String)"prefixData");
        super(contextFromCompletionPlace);
        this.prefixData = prefixData;
    }

    @Override
    public void handleInsert(@NotNull RsElement element, @NotNull String scopeName, @NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (this.prefixData.getRemoveDot()) {
            CharSequence charSequence = context.getDocument().getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            Character c = StringsKt.getOrNull((CharSequence)charSequence, (int)(context.getStartOffset() - 1));
            char c2 = '.';
            if (c != null && c.charValue() == c2) {
                Document document = context.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                UtilsKt.deleteChar(document, context.getStartOffset() - 1);
            }
        }
        context.getDocument().insertString(context.getStartOffset(), (CharSequence)this.prefixData.getPrefix());
        context.commitDocument();
        super.handleInsert(element, scopeName, context, item);
    }

    @Override
    public void escapeIfNeeded(@NotNull RsElement element, @NotNull String scopeName, @NotNull InsertionContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RsDefaultInsertHandler.Companion.escapeIfNeeded(element, scopeName, context, this.prefixData.getPrefix().length());
    }

    @Override
    public void logStatistics(@NotNull LookupElement item, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.logStatistics(item, project);
        if (this.prefixData.getParts().contains("await.")) {
            RsCounterUsagesCollector.INSTANCE.logAwaitChainedMethodCompleted(project);
        }
        if (this.prefixData.getParts().contains("?.")) {
            RsCounterUsagesCollector.INSTANCE.logQuestionMarkChainedMethodCompleted(project);
        }
        if (this.prefixData.getParts().contains("unwrap().")) {
            RsCounterUsagesCollector.INSTANCE.logUnwrapChainedMethodCompleted(project);
        }
        if (this.prefixData.getParts().contains("iter().")) {
            RsCounterUsagesCollector.INSTANCE.logIteratedChainedMethodCompleted(project);
        }
        if (this.prefixData.getParts().contains("self.")) {
            RsCounterUsagesCollector.INSTANCE.logSelfPrefixCompleted(project);
        }
        if (this.prefixData.getParts().contains("Self::")) {
            RsCounterUsagesCollector.INSTANCE.logCSelfPrefixCompleted(project);
        }
    }
}

