/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.lang.core.RsPsiPatternKt;
import org.rust.lang.core.completion.FormatDescriptionParser;
import org.rust.lang.core.completion.RsCompletionProvider;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsMacroArgument;
import org.rust.lang.core.psi.RsMacroBodyIdent;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsTokenTypeKt;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.resolve.ref.RsPathReference;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002R\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/rust/lang/core/completion/RsTimeFormatDescriptionCompletionProvider;", "Lorg/rust/lang/core/completion/RsCompletionProvider;", "<init>", "()V", "elementPattern", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/psi/PsiElement;", "getElementPattern", "()Lcom/intellij/patterns/ElementPattern;", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "formatSpecifierVersion", "", "macroArgument", "Lorg/rust/lang/core/psi/RsMacroArgument;", "components", "", "", "Lorg/rust/lang/core/completion/RsTimeFormatDescriptionCompletionProvider$ComponentSpec;", "ComponentSpec", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsTimeFormatDescriptionCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsTimeFormatDescriptionCompletionProvider.kt\norg/rust/lang/core/completion/RsTimeFormatDescriptionCompletionProvider\n+ 2 RsPsiPattern.kt\norg/rust/lang/core/RsPsiPatternKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,385:1\n558#2:386\n1#3:387\n*S KotlinDebug\n*F\n+ 1 RsTimeFormatDescriptionCompletionProvider.kt\norg/rust/lang/core/completion/RsTimeFormatDescriptionCompletionProvider\n*L\n38#1:386\n*E\n"})
public final class RsTimeFormatDescriptionCompletionProvider
extends RsCompletionProvider {
    @NotNull
    public static final RsTimeFormatDescriptionCompletionProvider INSTANCE = new RsTimeFormatDescriptionCompletionProvider();
    @NotNull
    private static final Map<String, ComponentSpec> components;

    private RsTimeFormatDescriptionCompletionProvider() {
    }

    @Override
    @NotNull
    public ElementPattern<? extends PsiElement> getElementPattern() {
        boolean $i$f$psiElement = false;
        PsiElementPattern.Capture capture = PlatformPatterns.psiElement(PsiElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture, (String)"psiElement(...)");
        PsiElementPattern psiElementPattern = capture.withElementType(RsTokenTypeKt.getRS_ALL_STRING_LITERALS());
        Intrinsics.checkNotNullExpressionValue((Object)psiElementPattern, (String)"withElementType(...)");
        Object Self2 = RsPsiPatternKt.with((ObjectPattern)psiElementPattern, "isTimeFormatArgument", RsTimeFormatDescriptionCompletionProvider::_get_elementPattern_$lambda$0);
        Intrinsics.checkNotNullExpressionValue(Self2, (String)"with(...)");
        return (ElementPattern)Self2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement2 = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getPosition(...)");
        PsiElement element = psiElement2;
        String formatSpecifier = element.getText();
        int offset = parameters.getOffset() - PsiElementKt.getStartOffset(element);
        PsiElement psiElement3 = element.getParent();
        PsiElement psiElement4 = psiElement3 != null ? psiElement3.getParent() : null;
        int version = this.formatSpecifierVersion(psiElement4 instanceof RsMacroArgument ? (RsMacroArgument)psiElement4 : null);
        Intrinsics.checkNotNull((Object)formatSpecifier);
        FormatDescriptionParser parser = new FormatDescriptionParser(formatSpecifier, version);
        FormatDescriptionParser.NodeLocation nodeLocation = parser.findLocationAtOffset(parser.parse(), offset);
        if (nodeLocation == null) {
            return;
        }
        FormatDescriptionParser.NodeLocation location = nodeLocation;
        switch (WhenMappings.$EnumSwitchMapping$0[location.getNode().getKind().ordinal()]) {
            case 1: {
                int i2;
                RsTimeFormatDescriptionCompletionProvider rsTimeFormatDescriptionCompletionProvider = this;
                boolean bl = false;
                for (i2 = offset; i2 >= 0; --i2) {
                    Character c = StringsKt.getOrNull((CharSequence)formatSpecifier, (int)(i2 - 1));
                    boolean bl2 = c != null ? Character.isLetter(c.charValue()) : false;
                    if (!bl2) break;
                }
                String string = formatSpecifier.substring(i2, offset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String prefix = string;
                for (Map.Entry<String, ComponentSpec> entry2 : components.entrySet()) {
                    LookupElementBuilder lookupElement;
                    String component = entry2.getKey();
                    ComponentSpec spec = entry2.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)("[" + component + "]")).withTypeText(spec.getDescription(), true), (String)"withTypeText(...)");
                    result2.withPrefixMatcher(prefix).addElement((LookupElement)lookupElement);
                }
                return;
            }
            case 2: {
                for (Map.Entry<String, ComponentSpec> entry3 : components.entrySet()) {
                    LookupElementBuilder lookupElement;
                    String prefix2;
                    String string = entry3.getKey();
                    ComponentSpec spec = entry3.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)formatSpecifier.substring(location.getNode().getStartOffset(), offset), (String)"substring(...)");
                    Character c = StringsKt.getOrNull((CharSequence)formatSpecifier, (int)location.getNode().getEndOffset());
                    char c2 = ']';
                    String completion = c != null && c.charValue() == c2 ? "[" + string : "[" + string + "]";
                    Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)completion).withTypeText(spec.getDescription(), true), (String)"withTypeText(...)");
                    result2.withPrefixMatcher(prefix2).addElement((LookupElement)lookupElement);
                }
                return;
            }
            case 3: {
                Object object = location.getParent();
                if (object == null || (object = ((FormatDescriptionParser.NodeLocation)object).getNode()) == null || (object = ((FormatDescriptionParser.Node)object).getName()) == null) return;
                Object it2 = object;
                boolean bl = false;
                ComponentSpec componentSpec = components.get(it2);
                object = componentSpec;
                if (componentSpec == null) {
                    return;
                }
                Object spec = object;
                String string = formatSpecifier.substring(location.getNode().getStartOffset(), offset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String prefix = string;
                for (String attr : ((ComponentSpec)spec).getAttributes().keySet()) {
                    Character c = StringsKt.getOrNull((CharSequence)formatSpecifier, (int)(location.getNode().getEndOffset() + 1));
                    char prefix2 = ':';
                    if (c != null && c.charValue() == prefix2) {
                        result2.withPrefixMatcher(prefix).addElement((LookupElement)LookupElementBuilder.create((String)attr).withInsertHandler(RsTimeFormatDescriptionCompletionProvider::addCompletions$lambda$2));
                        continue;
                    }
                    result2.withPrefixMatcher(prefix).addElement((LookupElement)LookupElementBuilder.create((String)(attr + ":")).withInsertHandler(RsTimeFormatDescriptionCompletionProvider::addCompletions$lambda$3));
                }
                return;
            }
            case 4: {
                Object object = location.getParent();
                if (object == null || (object = ((FormatDescriptionParser.NodeLocation)object).getParent()) == null || (object = ((FormatDescriptionParser.NodeLocation)object).getNode()) == null || (object = ((FormatDescriptionParser.Node)object).getName()) == null) return;
                Object it3 = object;
                boolean bl = false;
                ComponentSpec componentSpec = components.get(it3);
                object = componentSpec;
                if (componentSpec == null) {
                    return;
                }
                Object spec = object;
                List<String> list = ((ComponentSpec)spec).getAttributes().get(location.getParent().getNode().getName());
                if (list == null) {
                    return;
                }
                List<String> values = list;
                String string = formatSpecifier.substring(location.getNode().getStartOffset(), offset);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = string;
                for (String value : values) {
                    result2.withPrefixMatcher(string2).addElement((LookupElement)LookupElementBuilder.create((String)value));
                }
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final int formatSpecifierVersion(RsMacroArgument macroArgument) {
        Object object = macroArgument;
        if (object == null || (object = object.getMacroBodyIdentList()) == null || (object = (RsMacroBodyIdent)CollectionsKt.firstOrNull((List)object)) == null || (object = object.getFirstChild()) == null) {
            return 1;
        }
        Object versionElement = object;
        PsiElement psiElement2 = PsiElementExtensionsKt.getNextNonCommentSibling(versionElement.getParent());
        if (psiElement2 == null) {
            return 1;
        }
        PsiElement equalsElement = psiElement2;
        PsiElement psiElement3 = PsiElementExtensionsKt.getNextNonCommentSibling(equalsElement);
        if (psiElement3 == null) {
            return 1;
        }
        PsiElement numberElement = psiElement3;
        if (Intrinsics.areEqual((Object)versionElement.getText(), (Object)"version") && Intrinsics.areEqual((Object)equalsElement.getText(), (Object)"=") && Intrinsics.areEqual((Object)numberElement.getText(), (Object)"2")) {
            return 2;
        }
        return 1;
    }

    private static final boolean _get_elementPattern_$lambda$0(PsiElement psi) {
        PsiElement psiElement2 = psi.getParent();
        RsLitExpr rsLitExpr = psiElement2 instanceof RsLitExpr ? (RsLitExpr)psiElement2 : null;
        if (rsLitExpr == null) {
            return false;
        }
        RsLitExpr argument = rsLitExpr;
        PsiElement psiElement3 = argument.getParent();
        RsMacroArgument rsMacroArgument = psiElement3 instanceof RsMacroArgument ? (RsMacroArgument)psiElement3 : null;
        if (rsMacroArgument == null) {
            return false;
        }
        RsMacroArgument macroArgument = rsMacroArgument;
        PsiElement psiElement4 = macroArgument.getParent();
        RsMacroCall rsMacroCall = psiElement4 instanceof RsMacroCall ? (RsMacroCall)psiElement4 : null;
        if (rsMacroCall == null) {
            return false;
        }
        RsMacroCall macroCall = rsMacroCall;
        RsPathReference rsPathReference = macroCall.getPath().getReference();
        RsElement rsElement = rsPathReference != null ? rsPathReference.resolve() : null;
        RsFunction rsFunction = rsElement instanceof RsFunction ? (RsFunction)rsElement : null;
        if (rsFunction == null) {
            return false;
        }
        RsFunction definition = rsFunction;
        CargoWorkspace.Package package_ = RsElementKt.getContainingCargoPackage(definition);
        if (!Intrinsics.areEqual((Object)(package_ != null ? package_.getName() : null), (Object)"time-macros")) {
            return false;
        }
        return Intrinsics.areEqual((Object)definition.getName(), (Object)"format_description");
    }

    private static final void addCompletions$lambda$2(InsertionContext ctx, LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
        AutoPopupController.getInstance((Project)ctx.getProject()).scheduleAutoPopup(ctx.getEditor());
    }

    private static final void addCompletions$lambda$3(InsertionContext ctx, LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
        AutoPopupController.getInstance((Project)ctx.getProject()).scheduleAutoPopup(ctx.getEditor());
    }

    static {
        Pair[] pairArray = new Pair[19];
        Object[] objectArray = new String[]{"zero", "space", "none"};
        pairArray[0] = TuplesKt.to((Object)"day", (Object)new ComponentSpec("Day of the month", MapsKt.mapOf((Pair)TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray)))));
        pairArray[1] = TuplesKt.to((Object)"first", (Object)new ComponentSpec("First item", MapsKt.emptyMap()));
        pairArray[2] = TuplesKt.to((Object)"end", (Object)new ComponentSpec("End of input", MapsKt.emptyMap()));
        objectArray = new Pair[2];
        Object[] objectArray2 = new String[]{"zero", "space", "none"};
        objectArray[0] = TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"12", "24"};
        objectArray[1] = TuplesKt.to((Object)"repr", (Object)CollectionsKt.listOf((Object[])objectArray2));
        pairArray[3] = TuplesKt.to((Object)"hour", (Object)new ComponentSpec("Clock hour", MapsKt.mapOf((Pair[])objectArray)));
        pairArray[4] = TuplesKt.to((Object)"ignore", (Object)new ComponentSpec("Ignore", MapsKt.mapOf((Pair)TuplesKt.to((Object)"count", (Object)CollectionsKt.emptyList()))));
        objectArray = new String[]{"zero", "space", "none"};
        pairArray[5] = TuplesKt.to((Object)"minute", (Object)new ComponentSpec("Minute within the clock hour", MapsKt.mapOf((Pair)TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray)))));
        objectArray = new Pair[3];
        objectArray2 = new String[]{"zero", "space", "none"};
        objectArray[0] = TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"numerical", "long", "short"};
        objectArray[1] = TuplesKt.to((Object)"repr", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"true", "false"};
        objectArray[2] = TuplesKt.to((Object)"case_sensitive", (Object)CollectionsKt.listOf((Object[])objectArray2));
        pairArray[6] = TuplesKt.to((Object)"month", (Object)new ComponentSpec("Month", MapsKt.mapOf((Pair[])objectArray)));
        objectArray = new Pair[2];
        objectArray2 = new String[]{"zero", "space", "none"};
        objectArray[0] = TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"automatic", "mandatory"};
        objectArray[1] = TuplesKt.to((Object)"sign", (Object)CollectionsKt.listOf((Object[])objectArray2));
        pairArray[7] = TuplesKt.to((Object)"offset_hour", (Object)new ComponentSpec("Whole hours offset from UTC", MapsKt.mapOf((Pair[])objectArray)));
        objectArray = new String[]{"zero", "space", "none"};
        pairArray[8] = TuplesKt.to((Object)"offset_minute", (Object)new ComponentSpec("Minutes within the hour offset from UTC", MapsKt.mapOf((Pair)TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray)))));
        objectArray = new String[]{"zero", "space", "none"};
        pairArray[9] = TuplesKt.to((Object)"offset_second", (Object)new ComponentSpec("Seconds within the minute offset from UTC", MapsKt.mapOf((Pair)TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray)))));
        pairArray[10] = TuplesKt.to((Object)"optional", (Object)new ComponentSpec("Optional items", MapsKt.emptyMap()));
        objectArray = new String[]{"zero", "space", "none"};
        pairArray[11] = TuplesKt.to((Object)"ordinal", (Object)new ComponentSpec("Day of year", MapsKt.mapOf((Pair)TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray)))));
        objectArray = new Pair[2];
        objectArray2 = new String[]{"lower", "upper"};
        objectArray[0] = TuplesKt.to((Object)"case", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"true", "false"};
        objectArray[1] = TuplesKt.to((Object)"case_sensitive", (Object)CollectionsKt.listOf((Object[])objectArray2));
        pairArray[12] = TuplesKt.to((Object)"period", (Object)new ComponentSpec("AM/PM", MapsKt.mapOf((Pair[])objectArray)));
        objectArray = new String[]{"zero", "space", "none"};
        pairArray[13] = TuplesKt.to((Object)"second", (Object)new ComponentSpec("Second within the clock minute", MapsKt.mapOf((Pair)TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray)))));
        pairArray[14] = TuplesKt.to((Object)"subsecond", (Object)new ComponentSpec("Subsecond within the clock second", MapsKt.mapOf((Pair)TuplesKt.to((Object)"digits", (Object)CollectionsKt.emptyList()))));
        objectArray = new Pair[2];
        objectArray2 = new String[]{"second", "millisecond", "microsecond", "nanosecond"};
        objectArray[0] = TuplesKt.to((Object)"precision", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"automatic", "mandatory"};
        objectArray[1] = TuplesKt.to((Object)"sign", (Object)CollectionsKt.listOf((Object[])objectArray2));
        pairArray[15] = TuplesKt.to((Object)"unix_timestamp", (Object)new ComponentSpec("Unix timestamp", MapsKt.mapOf((Pair[])objectArray)));
        objectArray = new Pair[2];
        objectArray2 = new String[]{"zero", "space", "none"};
        objectArray[0] = TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"iso", "sunday", "monday"};
        objectArray[1] = TuplesKt.to((Object)"repr", (Object)CollectionsKt.listOf((Object[])objectArray2));
        pairArray[16] = TuplesKt.to((Object)"week_number", (Object)new ComponentSpec("Week of the year", MapsKt.mapOf((Pair[])objectArray)));
        objectArray = new Pair[3];
        objectArray2 = new String[]{"long", "short", "sunday", "monday"};
        objectArray[0] = TuplesKt.to((Object)"repr", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"true", "false"};
        objectArray[1] = TuplesKt.to((Object)"one_indexed", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"true", "false"};
        objectArray[2] = TuplesKt.to((Object)"case_sensitive", (Object)CollectionsKt.listOf((Object[])objectArray2));
        pairArray[17] = TuplesKt.to((Object)"weekday", (Object)new ComponentSpec("Day of the week", MapsKt.mapOf((Pair[])objectArray)));
        objectArray = new Pair[4];
        objectArray2 = new String[]{"zero", "space", "none"};
        objectArray[0] = TuplesKt.to((Object)"padding", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"full", "last_two"};
        objectArray[1] = TuplesKt.to((Object)"repr", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"calendar", "iso_week"};
        objectArray[2] = TuplesKt.to((Object)"base", (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new String[]{"automatic", "mandatory"};
        objectArray[3] = TuplesKt.to((Object)"sign", (Object)CollectionsKt.listOf((Object[])objectArray2));
        pairArray[18] = TuplesKt.to((Object)"year", (Object)new ComponentSpec("Year", MapsKt.mapOf((Pair[])objectArray)));
        components = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001b\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0003J/\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR#\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/completion/RsTimeFormatDescriptionCompletionProvider$ComponentSpec;", "", "description", "", "attributes", "", "", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "getDescription", "()Ljava/lang/String;", "getAttributes", "()Ljava/util/Map;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rustrover.core"})
    private static final class ComponentSpec {
        @NotNull
        private final String description;
        @NotNull
        private final Map<String, List<String>> attributes;

        public ComponentSpec(@NotNull String description, @NotNull Map<String, ? extends List<String>> attributes) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            this.description = description;
            this.attributes = attributes;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final Map<String, List<String>> getAttributes() {
            return this.attributes;
        }

        @NotNull
        public final String component1() {
            return this.description;
        }

        @NotNull
        public final Map<String, List<String>> component2() {
            return this.attributes;
        }

        @NotNull
        public final ComponentSpec copy(@NotNull String description, @NotNull Map<String, ? extends List<String>> attributes) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            return new ComponentSpec(description, attributes);
        }

        public static /* synthetic */ ComponentSpec copy$default(ComponentSpec componentSpec, String string, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                string = componentSpec.description;
            }
            if ((n & 2) != 0) {
                map2 = componentSpec.attributes;
            }
            return componentSpec.copy(string, map2);
        }

        @NotNull
        public String toString() {
            return "ComponentSpec(description=" + this.description + ", attributes=" + this.attributes + ")";
        }

        public int hashCode() {
            int result2 = this.description.hashCode();
            result2 = result2 * 31 + ((Object)this.attributes).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComponentSpec)) {
                return false;
            }
            ComponentSpec componentSpec = (ComponentSpec)other;
            if (!Intrinsics.areEqual((Object)this.description, (Object)componentSpec.description)) {
                return false;
            }
            return Intrinsics.areEqual(this.attributes, componentSpec.attributes);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormatDescriptionParser.NodeKind.values().length];
            try {
                nArray[FormatDescriptionParser.NodeKind.FormatDescription.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatDescriptionParser.NodeKind.Component.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatDescriptionParser.NodeKind.Attribute.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormatDescriptionParser.NodeKind.AttributeValue.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

