/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.RsPsiPatternKt;
import org.rust.lang.core.completion.RsCompletionProvider;
import org.rust.lang.core.completion.RsLiteralSuffixCompletionProviderKt;
import org.rust.lang.core.completion.UtilsKt;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsLiteralKind;
import org.rust.lang.core.psi.RsLiteralKindKt;
import org.rust.lang.core.types.ty.TyFloat;
import org.rust.lang.core.types.ty.TyInteger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/rust/lang/core/completion/RsLiteralSuffixCompletionProvider;", "Lorg/rust/lang/core/completion/RsCompletionProvider;", "<init>", "()V", "elementPattern", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/psi/PsiElement;", "getElementPattern", "()Lcom/intellij/patterns/ElementPattern;", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "getValidSuffixes", "", "", "literal", "tryToCompleteSuffix", "suffix", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsLiteralSuffixCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsLiteralSuffixCompletionProvider.kt\norg/rust/lang/core/completion/RsLiteralSuffixCompletionProvider\n+ 2 RsPsiPattern.kt\norg/rust/lang/core/RsPsiPatternKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n558#2:79\n558#2:80\n1869#3,2:81\n1761#3,3:83\n*S KotlinDebug\n*F\n+ 1 RsLiteralSuffixCompletionProvider.kt\norg/rust/lang/core/completion/RsLiteralSuffixCompletionProvider\n*L\n25#1:79\n26#1:80\n37#1:81,2\n32#1:83,3\n*E\n"})
public final class RsLiteralSuffixCompletionProvider
extends RsCompletionProvider {
    @NotNull
    public static final RsLiteralSuffixCompletionProvider INSTANCE = new RsLiteralSuffixCompletionProvider();

    private RsLiteralSuffixCompletionProvider() {
    }

    @NotNull
    public ElementPattern<PsiElement> getElementPattern() {
        boolean $i$f$psiElement = false;
        PsiElementPattern.Capture capture = PlatformPatterns.psiElement(PsiElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture, (String)"psiElement(...)");
        $i$f$psiElement = false;
        PsiElementPattern.Capture capture2 = PlatformPatterns.psiElement(RsLitExpr.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture2, (String)"psiElement(...)");
        TreeElementPattern treeElementPattern = capture.withParent((ElementPattern)RsPsiPatternKt.with((ObjectPattern)capture2, "isLiteralNumberWithoutExistingSuffix", RsLiteralSuffixCompletionProvider::_get_elementPattern_$lambda$0));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withParent(...)");
        return (ElementPattern)treeElementPattern;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        String literal = UtilsKt.getOriginalOrSelf(parameters.getPosition()).getText();
        Intrinsics.checkNotNull((Object)literal);
        Iterable $this$forEach$iv = this.getValidSuffixes(literal);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String suffix = (String)element$iv;
            boolean bl = false;
            INSTANCE.tryToCompleteSuffix(suffix, literal, result2);
        }
    }

    private final List<String> getValidSuffixes(String literal) {
        if (StringsKt.contains$default((CharSequence)literal, (CharSequence)".", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)literal, (CharSequence)"e", (boolean)false, (int)2, null)) {
            return TyFloat.Companion.getNAMES();
        }
        if (StringsKt.startsWith$default((String)literal, (String)"0b", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)literal, (String)"0o", (boolean)false, (int)2, null)) {
            return TyInteger.Companion.getNAMES();
        }
        return CollectionsKt.plus((Collection)TyInteger.Companion.getNAMES(), (Iterable)TyFloat.Companion.getNAMES());
    }

    private final void tryToCompleteSuffix(String suffix, String literal, CompletionResultSet result2) {
        for (String suffixPrefix : RsLiteralSuffixCompletionProviderKt.access$allNonEmptyPrefixes(suffix)) {
            if (!StringsKt.endsWith$default((String)literal, (String)suffixPrefix, (boolean)false, (int)2, null)) continue;
            result2.addElement((LookupElement)LookupElementBuilder.create((String)(literal + StringsKt.removePrefix((String)suffix, (CharSequence)suffixPrefix))));
            break;
        }
    }

    private static final boolean _get_elementPattern_$lambda$0(RsLitExpr psi) {
        boolean bl;
        block4: {
            PsiElement psiElement2 = UtilsKt.getOriginalOrSelf((PsiElement)psi);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getOriginalOrSelf(...)");
            RsLiteralKind kind2 = RsLiteralKindKt.getKind((RsLitExpr)psiElement2);
            String string = kind2 instanceof RsLiteralKind.Integer ? ((RsLiteralKind.Integer)kind2).getSuffix() : (kind2 instanceof RsLiteralKind.Float ? ((RsLiteralKind.Float)kind2).getSuffix() : null);
            if (string == null) {
                return false;
            }
            String suffix = string;
            Iterable $this$any$iv = CollectionsKt.plus((Collection)TyInteger.Companion.getNAMES(), (Iterable)TyFloat.Companion.getNAMES());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it2 = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)suffix, (CharSequence)it2, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return !bl;
    }
}

