/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.lang.core.RsPsiPattern;
import org.rust.lang.core.completion.LookupElementsKt;
import org.rust.lang.core.completion.RsCfgAttributeCompletionProviderKt;
import org.rust.lang.core.completion.RsCompletionProvider;
import org.rust.lang.core.completion.RustValueOptionInsertionHandler;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/rust/lang/core/completion/RsCfgAttributeCompletionProvider;", "Lorg/rust/lang/core/completion/RsCompletionProvider;", "<init>", "()V", "NAME_OPTIONS", "", "", "NAME_VALUE_OPTIONS", "OPERATORS", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "elementPattern", "Lcom/intellij/patterns/ElementPattern;", "Lcom/intellij/psi/PsiElement;", "getElementPattern", "()Lcom/intellij/patterns/ElementPattern;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsCfgAttributeCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCfgAttributeCompletionProvider.kt\norg/rust/lang/core/completion/RsCfgAttributeCompletionProvider\n+ 2 RsPsiPattern.kt\norg/rust/lang/core/RsPsiPatternKt\n*L\n1#1,108:1\n558#2:109\n*S KotlinDebug\n*F\n+ 1 RsCfgAttributeCompletionProvider.kt\norg/rust/lang/core/completion/RsCfgAttributeCompletionProvider\n*L\n88#1:109\n*E\n"})
public final class RsCfgAttributeCompletionProvider
extends RsCompletionProvider {
    @NotNull
    public static final RsCfgAttributeCompletionProvider INSTANCE = new RsCfgAttributeCompletionProvider();
    @NotNull
    private static final List<String> NAME_OPTIONS;
    @NotNull
    private static final List<String> NAME_VALUE_OPTIONS;
    @NotNull
    private static final List<String> OPERATORS;

    private RsCfgAttributeCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        for (String option : NAME_OPTIONS) {
            result2.addElement((LookupElement)LookupElementBuilder.create((String)option));
        }
        for (String option : NAME_VALUE_OPTIONS) {
            result2.addElement((LookupElement)LookupElementBuilder.create((String)option).withInsertHandler(RsCfgAttributeCompletionProvider::addCompletions$lambda$0));
        }
        for (String operator : OPERATORS) {
            result2.addElement((LookupElement)LookupElementBuilder.create((String)operator).withInsertHandler(RsCfgAttributeCompletionProvider::addCompletions$lambda$1));
        }
    }

    @Override
    @NotNull
    public ElementPattern<? extends PsiElement> getElementPattern() {
        PsiElementPattern.Capture capture = PlatformPatterns.psiElement((IElementType)RsElementTypes.IDENTIFIER);
        boolean $i$f$psiElement = false;
        PsiElementPattern.Capture capture2 = PlatformPatterns.psiElement(RsPath.class);
        Intrinsics.checkNotNullExpressionValue((Object)capture2, (String)"psiElement(...)");
        TreeElementPattern treeElementPattern = capture.withParent((ElementPattern)capture2.inside((ElementPattern)RsPsiPattern.INSTANCE.getAnyCfgCondition()));
        Intrinsics.checkNotNullExpressionValue((Object)treeElementPattern, (String)"withParent(...)");
        return (ElementPattern)RsPsiPattern.INSTANCE.orCfgCallWouldBeMatchedInCfgAttr((PsiElementPattern.Capture<PsiElement>)((PsiElementPattern.Capture)treeElementPattern));
    }

    private static final void addCompletions$lambda$0(InsertionContext ctx, LookupElement element) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RustValueOptionInsertionHandler.INSTANCE.handleInsert(ctx, element);
        if (!RsCfgAttributeCompletionProviderKt.access$getAlreadyHasValue(ctx) && Intrinsics.areEqual((Object)element.getLookupString(), (Object)"feature")) {
            AutoPopupController.getInstance((Project)ctx.getProject()).scheduleAutoPopup(ctx.getEditor());
        }
    }

    private static final void addCompletions$lambda$1(InsertionContext ctx, LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
        if (!LookupElementsKt.getAlreadyHasCallParens(ctx)) {
            ctx.getDocument().insertString(ctx.getSelectionEndOffset(), (CharSequence)"()");
        }
        EditorModificationUtil.moveCaretRelatively((Editor)ctx.getEditor(), (int)1);
    }

    static {
        Object[] objectArray = new String[]{"unix", "windows", "test", "debug_assertions"};
        NAME_OPTIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"target_arch", "target_endian", "target_env", "target_family", "target_feature", "target_os", "target_pointer_width", "target_vendor", "feature", "panic"};
        NAME_VALUE_OPTIONS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"all", "any", "not"};
        OPERATORS = CollectionsKt.listOf((Object[])objectArray);
    }
}

