/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core.completion;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0003!\"#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0005J\b\u0010\u000f\u001a\u00020\nH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0002J\b\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001c\u00a8\u0006$"}, d2={"Lorg/rust/lang/core/completion/FormatDescriptionParser;", "", "text", "", "version", "", "<init>", "(Ljava/lang/String;I)V", "position", "parse", "Lorg/rust/lang/core/completion/FormatDescriptionParser$Node;", "findLocationAtOffset", "Lorg/rust/lang/core/completion/FormatDescriptionParser$NodeLocation;", "node", "offset", "formatDescription", "component", "children", "attributes", "", "attributeValue", "name", "skipWs", "", "skipLiteral", "current", "", "getCurrent", "()Ljava/lang/Character;", "next", "getNext", "findNode", "location", "NodeKind", "Node", "NodeLocation", "intellij.rustrover.core"})
public final class FormatDescriptionParser {
    @NotNull
    private final String text;
    private final int version;
    private int position;

    public FormatDescriptionParser(@NotNull String text, int version) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.version = version;
    }

    @NotNull
    public final Node parse() {
        return this.formatDescription();
    }

    @Nullable
    public final NodeLocation findLocationAtOffset(@NotNull Node node, int offset) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.findNode(new NodeLocation(node, null), offset);
    }

    private final Node formatDescription() {
        List list;
        List $this$formatDescription_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (true) {
            Node c;
            this.skipLiteral();
            if (this.component() == null) break;
            $this$formatDescription_u24lambda_u240.add(c);
        }
        List components = CollectionsKt.build((List)list);
        return new Node(0, this.text.length(), "", NodeKind.FormatDescription, components);
    }

    private final Node component() {
        int start2 = this.position;
        Character c = this.getCurrent();
        int n = 91;
        if (c == null || c.charValue() != n) {
            return null;
        }
        n = this.position;
        this.position = n + 1;
        this.skipWs();
        String name2 = this.name();
        this.skipWs();
        List allChildren = CollectionsKt.plus((Collection)this.attributes(), (Iterable)CollectionsKt.listOfNotNull((Object)this.children()));
        return new Node(start2, this.position, name2, NodeKind.Component, allChildren);
    }

    private final Node children() {
        Character c = this.getCurrent();
        int n = 91;
        if (c == null || c.charValue() != n) {
            return null;
        }
        n = this.position;
        this.position = n + 1;
        Node result2 = this.formatDescription();
        Character c2 = this.getCurrent();
        int n2 = 93;
        if (c2 != null && c2.charValue() == n2) {
            n2 = this.position;
            this.position = n2 + 1;
        }
        return result2;
    }

    private final List<Node> attributes() {
        List list;
        List $this$attributes_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (true) {
            Character c = this.getCurrent();
            if (!(c != null ? Character.isLetterOrDigit(c.charValue()) : false)) {
                Character c2 = this.getCurrent();
                char c3 = '_';
                if (c2 == null || c2.charValue() != c3) break;
            }
            int start2 = this.position;
            String name2 = this.name();
            Character c4 = this.getCurrent();
            int n = 58;
            if (c4 != null && c4.charValue() == n) {
                n = this.position;
                this.position = n + 1;
            }
            Node value = this.attributeValue();
            $this$attributes_u24lambda_u240.add(new Node(start2, this.position, name2, NodeKind.Attribute, CollectionsKt.listOf((Object)value)));
            this.skipWs();
        }
        return CollectionsKt.build((List)list);
    }

    private final Node attributeValue() {
        int start2 = this.position;
        String name2 = this.name();
        return new Node(start2, this.position, name2, NodeKind.AttributeValue, CollectionsKt.emptyList());
    }

    private final String name() {
        int start2 = this.position;
        while (true) {
            int n;
            Character c = this.getCurrent();
            if (!(c != null ? Character.isLetterOrDigit(c.charValue()) : false)) {
                Character c2 = this.getCurrent();
                n = 95;
                if (c2 == null || c2.charValue() != n) break;
            }
            n = this.position;
            this.position = n + 1;
        }
        String string = this.text.substring(start2, this.position);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final void skipWs() {
        while (true) {
            Character c = this.getCurrent();
            boolean bl = c != null ? CharsKt.isWhitespace((char)c.charValue()) : false;
            if (!bl) break;
            int n = this.position;
            this.position = n + 1;
        }
    }

    private final void skipLiteral() {
        block4: while (this.getCurrent() != null) {
            switch (this.version) {
                case 1: {
                    Character c = this.getCurrent();
                    int n = 91;
                    if (c == null || c.charValue() != n) break;
                    Character c2 = this.getNext();
                    n = 91;
                    if (c2 == null || c2.charValue() != n) break block4;
                    n = this.position;
                    this.position = n + 1;
                    break;
                }
                case 2: {
                    Character c = this.getCurrent();
                    int n = 92;
                    if (c != null && c.charValue() == n) {
                        Character c3 = this.getNext();
                        n = 91;
                        if (c3 == null || c3.charValue() != n) break block4;
                        n = this.position;
                        this.position = n + 1;
                        break;
                    }
                    Character c4 = this.getCurrent();
                    n = 91;
                    if (c4 == null || c4.charValue() != n) break;
                    break block4;
                }
                default: {
                    throw new IllegalStateException("Invalid version".toString());
                }
            }
            int n = this.position;
            this.position = n + 1;
        }
    }

    private final Character getCurrent() {
        return StringsKt.getOrNull((CharSequence)this.text, (int)this.position);
    }

    private final Character getNext() {
        return StringsKt.getOrNull((CharSequence)this.text, (int)(this.position + 1));
    }

    private final NodeLocation findNode(NodeLocation location, int offset) {
        for (Node child : location.getNode().getChildren()) {
            NodeLocation nested = this.findNode(new NodeLocation(child, location), offset);
            if (nested == null) continue;
            return nested;
        }
        if (offset >= location.getNode().getStartOffset() && offset < location.getNode().getEndOffset()) {
            return location;
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u00c6\u0003JA\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lorg/rust/lang/core/completion/FormatDescriptionParser$Node;", "", "startOffset", "", "endOffset", "name", "", "kind", "Lorg/rust/lang/core/completion/FormatDescriptionParser$NodeKind;", "children", "", "<init>", "(IILjava/lang/String;Lorg/rust/lang/core/completion/FormatDescriptionParser$NodeKind;Ljava/util/List;)V", "getStartOffset", "()I", "getEndOffset", "getName", "()Ljava/lang/String;", "getKind", "()Lorg/rust/lang/core/completion/FormatDescriptionParser$NodeKind;", "getChildren", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.rustrover.core"})
    public static final class Node {
        private final int startOffset;
        private final int endOffset;
        @NotNull
        private final String name;
        @NotNull
        private final NodeKind kind;
        @NotNull
        private final List<Node> children;

        public Node(int startOffset, int endOffset, @NotNull String name2, @NotNull NodeKind kind2, @NotNull List<Node> children) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.name = name2;
            this.kind = kind2;
            this.children = children;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public final int getEndOffset() {
            return this.endOffset;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final NodeKind getKind() {
            return this.kind;
        }

        @NotNull
        public final List<Node> getChildren() {
            return this.children;
        }

        public final int component1() {
            return this.startOffset;
        }

        public final int component2() {
            return this.endOffset;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final NodeKind component4() {
            return this.kind;
        }

        @NotNull
        public final List<Node> component5() {
            return this.children;
        }

        @NotNull
        public final Node copy(int startOffset, int endOffset, @NotNull String name2, @NotNull NodeKind kind2, @NotNull List<Node> children) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)kind2), (String)"kind");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return new Node(startOffset, endOffset, name2, kind2, children);
        }

        public static /* synthetic */ Node copy$default(Node node, int n, int n2, String string, NodeKind nodeKind, List list, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = node.startOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = node.endOffset;
            }
            if ((n3 & 4) != 0) {
                string = node.name;
            }
            if ((n3 & 8) != 0) {
                nodeKind = node.kind;
            }
            if ((n3 & 0x10) != 0) {
                list = node.children;
            }
            return node.copy(n, n2, string, nodeKind, list);
        }

        @NotNull
        public String toString() {
            return "Node(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", name=" + this.name + ", kind=" + this.kind + ", children=" + this.children + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.startOffset);
            result2 = result2 * 31 + Integer.hashCode(this.endOffset);
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.kind.hashCode();
            result2 = result2 * 31 + ((Object)this.children).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node node = (Node)other;
            if (this.startOffset != node.startOffset) {
                return false;
            }
            if (this.endOffset != node.endOffset) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)node.name)) {
                return false;
            }
            if (this.kind != node.kind) {
                return false;
            }
            return Intrinsics.areEqual(this.children, node.children);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/lang/core/completion/FormatDescriptionParser$NodeKind;", "", "<init>", "(Ljava/lang/String;I)V", "FormatDescription", "Component", "Attribute", "AttributeValue", "intellij.rustrover.core"})
    public static final class NodeKind
    extends Enum<NodeKind> {
        public static final /* enum */ NodeKind FormatDescription = new NodeKind();
        public static final /* enum */ NodeKind Component = new NodeKind();
        public static final /* enum */ NodeKind Attribute = new NodeKind();
        public static final /* enum */ NodeKind AttributeValue = new NodeKind();
        private static final /* synthetic */ NodeKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NodeKind[] values() {
            return (NodeKind[])$VALUES.clone();
        }

        public static NodeKind valueOf(String value) {
            return Enum.valueOf(NodeKind.class, value);
        }

        @NotNull
        public static EnumEntries<NodeKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = nodeKindArray = new NodeKind[]{NodeKind.FormatDescription, NodeKind.Component, NodeKind.Attribute, NodeKind.AttributeValue};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0000H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/rust/lang/core/completion/FormatDescriptionParser$NodeLocation;", "", "node", "Lorg/rust/lang/core/completion/FormatDescriptionParser$Node;", "parent", "<init>", "(Lorg/rust/lang/core/completion/FormatDescriptionParser$Node;Lorg/rust/lang/core/completion/FormatDescriptionParser$NodeLocation;)V", "getNode", "()Lorg/rust/lang/core/completion/FormatDescriptionParser$Node;", "getParent", "()Lorg/rust/lang/core/completion/FormatDescriptionParser$NodeLocation;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rustrover.core"})
    public static final class NodeLocation {
        @NotNull
        private final Node node;
        @Nullable
        private final NodeLocation parent;

        public NodeLocation(@NotNull Node node, @Nullable NodeLocation parent2) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
            this.parent = parent2;
        }

        @NotNull
        public final Node getNode() {
            return this.node;
        }

        @Nullable
        public final NodeLocation getParent() {
            return this.parent;
        }

        @NotNull
        public final Node component1() {
            return this.node;
        }

        @Nullable
        public final NodeLocation component2() {
            return this.parent;
        }

        @NotNull
        public final NodeLocation copy(@NotNull Node node, @Nullable NodeLocation parent2) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return new NodeLocation(node, parent2);
        }

        public static /* synthetic */ NodeLocation copy$default(NodeLocation nodeLocation, Node node, NodeLocation nodeLocation2, int n, Object object) {
            if ((n & 1) != 0) {
                node = nodeLocation.node;
            }
            if ((n & 2) != 0) {
                nodeLocation2 = nodeLocation.parent;
            }
            return nodeLocation.copy(node, nodeLocation2);
        }

        @NotNull
        public String toString() {
            return "NodeLocation(node=" + this.node + ", parent=" + this.parent + ")";
        }

        public int hashCode() {
            int result2 = this.node.hashCode();
            result2 = result2 * 31 + (this.parent == null ? 0 : this.parent.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NodeLocation)) {
                return false;
            }
            NodeLocation nodeLocation = (NodeLocation)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)nodeLocation.node)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.parent, (Object)nodeLocation.parent);
        }
    }
}

