/*
 * Decompiled with CFR 0.152.
 */
package org.rust.lang.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.text.SemVer;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.util.ToolchainUtilKt;
import org.rust.ide.fixes.AddFeatureAttributeFix;
import org.rust.ide.inspections.RsProblemsHolder;
import org.rust.lang.core.FeatureAvailability;
import org.rust.lang.core.FeatureState;
import org.rust.lang.core.crate.Crate;
import org.rust.lang.core.crate.CrateKt;
import org.rust.lang.core.psi.RsInnerAttr;
import org.rust.lang.core.psi.RsMetaItem;
import org.rust.lang.core.psi.RsMetaItemArgs;
import org.rust.lang.core.psi.ext.RsDocAndAttributeOwnerKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsMetaItemKt;
import org.rust.lang.core.stubs.index.RsFeatureIndex;
import org.rust.lang.utils.RsDiagnostic;
import org.rust.lang.utils.RsDiagnosticKt;
import org.rust.lang.utils.evaluation.CfgEvaluator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014JC\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u000b\u0010\u001b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u001c2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ>\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00032\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ^\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010$\u001a\u00020\u00032\b\b\u0003\u0010%\u001a\u00020\u00032\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\b\u0003\u0010&\u001a\u00020\u0003J^\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010$\u001a\u00020\u00032\b\b\u0003\u0010%\u001a\u00020\u00032\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\b\u0003\u0010&\u001a\u00020\u0003J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014JV\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010\u00142\b\b\u0001\u0010$\u001a\u00020\u00032\b\b\u0001\u0010%\u001a\u00020\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\b\u0001\u0010&\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006,"}, d2={"Lorg/rust/lang/core/CompilerFeature;", "", "name", "", "state", "Lorg/rust/lang/core/FeatureState;", "since", "Lcom/intellij/util/text/SemVer;", "<init>", "(Ljava/lang/String;Lorg/rust/lang/core/FeatureState;Lcom/intellij/util/text/SemVer;)V", "(Ljava/lang/String;Lorg/rust/lang/core/FeatureState;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getState", "()Lorg/rust/lang/core/FeatureState;", "getSince", "()Lcom/intellij/util/text/SemVer;", "availability", "Lorg/rust/lang/core/FeatureAvailability;", "element", "Lcom/intellij/psi/PsiElement;", "findMetaItem", "Lorg/rust/lang/core/psi/RsMetaItem;", "check", "", "holder", "Lorg/rust/ide/inspections/RsProblemsHolder;", "presentableFeatureName", "Lorg/jetbrains/annotations/Nls;", "experimentalFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "removedFixes", "Lcom/intellij/lang/annotation/AnnotationHolder;", "startElement", "endElement", "experimentalMessageCanBeAdded", "removedMessage", "experimentalMessageNotAvailable", "addFeatureFix", "Lorg/rust/ide/fixes/AddFeatureAttributeFix;", "getDiagnostic", "Lorg/rust/lang/utils/RsDiagnostic;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nCompilerFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerFeature.kt\norg/rust/lang/core/CompilerFeature\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,349:1\n15#2:350\n15#2:351\n1#3:352\n13#4:353\n*S KotlinDebug\n*F\n+ 1 CompilerFeature.kt\norg/rust/lang/core/CompilerFeature\n*L\n56#1:350\n77#1:351\n189#1:353\n*E\n"})
public final class CompilerFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final FeatureState state;
    @Nullable
    private final SemVer since;
    @NotNull
    private static final String COMPILER_FEATURES_PATH = "compiler-info/compiler-features.json";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Lazy<ObjectMapper> MAPPER$delegate;
    @NotNull
    private static final Lazy<Map<String, CompilerFeature>> knownFeatures$delegate;
    @NotNull
    private static final CompilerFeature COROUTINES;
    @NotNull
    private static final CompilerFeature C_UNWIND_PARTIAL_STABILIZATION;
    @NotNull
    private static final CompilerFeature GENERATORS;
    @NotNull
    private static final CompilerFeature SPECIALIZATION;
    @NotNull
    private static final CompilerFeature MIN_SPECIALIZATION;

    public CompilerFeature(@NotNull String name2, @NotNull FeatureState state, @JsonSerialize(using=ToStringSerializer.class) @Nullable SemVer since) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.name = name2;
        this.state = state;
        this.since = since;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final FeatureState getState() {
        return this.state;
    }

    @Nullable
    public final SemVer getSince() {
        return this.since;
    }

    @JsonCreator
    public CompilerFeature(@NotNull String name2, @NotNull FeatureState state, @NotNull String since) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        this(name2, state, ToolchainUtilKt.parseSemVer(since));
    }

    @NotNull
    public final FeatureAvailability availability(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement $this$ancestorOrSelf$iv = element;
        boolean $i$f$ancestorOrSelf = false;
        RsElement rsElement = (RsElement)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsElement.class, (boolean)false);
        if (rsElement == null) {
            return FeatureAvailability.UNKNOWN;
        }
        RsElement rsElement2 = rsElement;
        Object object = RsElementKt.getCargoProject(rsElement2);
        if (object == null || (object = object.getRustcInfo()) == null || (object = ((RustcInfo)object).getVersion()) == null) {
            return FeatureAvailability.UNKNOWN;
        }
        Object version = object;
        if (this.since == null || ((RustcVersion)version).getSemver().isGreaterOrEqualThan(this.since.getMajor(), this.since.getMinor(), this.since.getPatch())) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                case 1: {
                    return FeatureAvailability.AVAILABLE;
                }
                case 2: {
                    return FeatureAvailability.REMOVED;
                }
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$1[RsDiagnosticKt.areUnstableFeaturesAvailable(rsElement2, (RustcVersion)version).ordinal()]) {
            case 1: {
                return FeatureAvailability.NOT_AVAILABLE;
            }
            case 2: {
                return FeatureAvailability.UNKNOWN;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return this.findMetaItem(rsElement2) != null ? FeatureAvailability.AVAILABLE : FeatureAvailability.CAN_BE_ADDED;
    }

    @Nullable
    public final RsMetaItem findMetaItem(@NotNull PsiElement element) {
        Object v3;
        block3: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement $this$ancestorOrSelf$iv = element;
            boolean $i$f$ancestorOrSelf = false;
            RsElement rsElement = (RsElement)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsElement.class, (boolean)false);
            if (rsElement == null) {
                return null;
            }
            RsElement rsElement2 = rsElement;
            Crate crate = CrateKt.getAsNotFake(RsElementKt.getContainingCrate(rsElement2));
            if (crate == null) {
                return null;
            }
            Crate crate2 = crate;
            CfgEvaluator cfgEvaluator = CfgEvaluator.Companion.forCrate(crate2);
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Sequence sequence2 = SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)RsFeatureIndex.Helper.INSTANCE.getFeatureAttributes(project, this.name)), arg_0 -> CompilerFeature.findMetaItem$lambda$0(crate2, arg_0)), arg_0 -> CompilerFeature.findMetaItem$lambda$1(cfgEvaluator, arg_0)), CompilerFeature::findMetaItem$lambda$2), CompilerFeature::findMetaItem$lambda$3);
            for (Object e : sequence2) {
                RsMetaItem it2 = (RsMetaItem)e;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                if (!Intrinsics.areEqual((Object)RsMetaItemKt.getName(it2), (Object)this.name)) continue;
                v3 = e;
                break block3;
            }
            v3 = null;
        }
        return v3;
    }

    public final void check(@NotNull RsProblemsHolder holder, @NotNull PsiElement element, @NotNull String presentableFeatureName, @NotNull List<? extends LocalQuickFix> experimentalFixes, @NotNull List<? extends LocalQuickFix> removedFixes) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)presentableFeatureName, (String)"presentableFeatureName");
        Intrinsics.checkNotNullParameter(experimentalFixes, (String)"experimentalFixes");
        Intrinsics.checkNotNullParameter(removedFixes, (String)"removedFixes");
        Object[] objectArray = new Object[]{presentableFeatureName};
        String string = RsBundle.INSTANCE.message("inspection.message.experimental.can.be.added", objectArray);
        objectArray = new Object[]{presentableFeatureName};
        String string2 = RsBundle.INSTANCE.message("inspection.message.has.been.removed2", objectArray);
        objectArray = new Object[]{presentableFeatureName};
        this.check(holder, element, null, string, string2, experimentalFixes, removedFixes, RsBundle.INSTANCE.message("inspection.message.experimental.not.available", objectArray));
    }

    public static /* synthetic */ void check$default(CompilerFeature compilerFeature, RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, String string, List list, List list2, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        compilerFeature.check(rsProblemsHolder, psiElement2, string, (List<? extends LocalQuickFix>)list, (List<? extends LocalQuickFix>)list2);
    }

    public final void check(@NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull String presentableFeatureName, @NotNull List<? extends LocalQuickFix> experimentalFixes, @NotNull List<? extends LocalQuickFix> removedFixes) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)presentableFeatureName, (String)"presentableFeatureName");
        Intrinsics.checkNotNullParameter(experimentalFixes, (String)"experimentalFixes");
        Intrinsics.checkNotNullParameter(removedFixes, (String)"removedFixes");
        Object[] objectArray = new Object[]{presentableFeatureName};
        String string = RsBundle.INSTANCE.message("inspection.message.experimental.can.be.added", objectArray);
        objectArray = new Object[]{presentableFeatureName};
        String string2 = RsBundle.INSTANCE.message("inspection.message.has.been.removed2", objectArray);
        objectArray = new Object[]{presentableFeatureName};
        this.check(holder, element, null, string, string2, experimentalFixes, removedFixes, RsBundle.INSTANCE.message("inspection.message.experimental.not.available", objectArray));
    }

    public static /* synthetic */ void check$default(CompilerFeature compilerFeature, AnnotationHolder annotationHolder, PsiElement psiElement2, String string, List list, List list2, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        compilerFeature.check(annotationHolder, psiElement2, string, (List<? extends LocalQuickFix>)list, (List<? extends LocalQuickFix>)list2);
    }

    public final void check(@NotNull AnnotationHolder holder, @NotNull PsiElement startElement, @Nullable PsiElement endElement, @InspectionMessage @NotNull String experimentalMessageCanBeAdded, @InspectionMessage @NotNull String removedMessage, @NotNull List<? extends LocalQuickFix> experimentalFixes, @NotNull List<? extends LocalQuickFix> removedFixes, @InspectionMessage @NotNull String experimentalMessageNotAvailable) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)experimentalMessageCanBeAdded, (String)"experimentalMessageCanBeAdded");
        Intrinsics.checkNotNullParameter((Object)removedMessage, (String)"removedMessage");
        Intrinsics.checkNotNullParameter(experimentalFixes, (String)"experimentalFixes");
        Intrinsics.checkNotNullParameter(removedFixes, (String)"removedFixes");
        Intrinsics.checkNotNullParameter((Object)experimentalMessageNotAvailable, (String)"experimentalMessageNotAvailable");
        RsDiagnostic rsDiagnostic = this.getDiagnostic(startElement, endElement, experimentalMessageCanBeAdded, removedMessage, experimentalFixes, removedFixes, experimentalMessageNotAvailable);
        if (rsDiagnostic != null) {
            RsDiagnosticKt.addToHolder(rsDiagnostic, holder);
        }
    }

    public static /* synthetic */ void check$default(CompilerFeature compilerFeature, AnnotationHolder annotationHolder, PsiElement psiElement2, PsiElement psiElement3, String string, String string2, List list, List list2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            Object[] objectArray = new Object[]{compilerFeature.name};
            string2 = RsBundle.INSTANCE.message("inspection.message.has.been.removed", objectArray);
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            string3 = string;
        }
        compilerFeature.check(annotationHolder, psiElement2, psiElement3, string, string2, (List<? extends LocalQuickFix>)list, (List<? extends LocalQuickFix>)list2, string3);
    }

    public final void check(@NotNull RsProblemsHolder holder, @NotNull PsiElement startElement, @Nullable PsiElement endElement, @InspectionMessage @NotNull String experimentalMessageCanBeAdded, @InspectionMessage @NotNull String removedMessage, @NotNull List<? extends LocalQuickFix> experimentalFixes, @NotNull List<? extends LocalQuickFix> removedFixes, @InspectionMessage @NotNull String experimentalMessageNotAvailable) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)experimentalMessageCanBeAdded, (String)"experimentalMessageCanBeAdded");
        Intrinsics.checkNotNullParameter((Object)removedMessage, (String)"removedMessage");
        Intrinsics.checkNotNullParameter(experimentalFixes, (String)"experimentalFixes");
        Intrinsics.checkNotNullParameter(removedFixes, (String)"removedFixes");
        Intrinsics.checkNotNullParameter((Object)experimentalMessageNotAvailable, (String)"experimentalMessageNotAvailable");
        RsDiagnostic rsDiagnostic = this.getDiagnostic(startElement, endElement, experimentalMessageCanBeAdded, removedMessage, experimentalFixes, removedFixes, experimentalMessageNotAvailable);
        if (rsDiagnostic != null) {
            RsDiagnosticKt.addToHolder$default(rsDiagnostic, holder, false, null, 6, null);
        }
    }

    public static /* synthetic */ void check$default(CompilerFeature compilerFeature, RsProblemsHolder rsProblemsHolder, PsiElement psiElement2, PsiElement psiElement3, String string, String string2, List list, List list2, String string3, int n, Object object) {
        if ((n & 0x10) != 0) {
            Object[] objectArray = new Object[]{compilerFeature.name};
            string2 = RsBundle.INSTANCE.message("inspection.message.has.been.removed", objectArray);
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            string3 = string;
        }
        compilerFeature.check(rsProblemsHolder, psiElement2, psiElement3, string, string2, (List<? extends LocalQuickFix>)list, (List<? extends LocalQuickFix>)list2, string3);
    }

    @NotNull
    public final AddFeatureAttributeFix addFeatureFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return new AddFeatureAttributeFix(this.name, element);
    }

    private final RsDiagnostic getDiagnostic(PsiElement startElement, PsiElement endElement, @InspectionMessage String experimentalMessageCanBeAdded, @InspectionMessage String removedMessage, List<? extends LocalQuickFix> experimentalFixes, List<? extends LocalQuickFix> removedFixes, @InspectionMessage String experimentalMessageNotAvailable) {
        return switch (WhenMappings.$EnumSwitchMapping$2[this.availability(startElement).ordinal()]) {
            case 1 -> new RsDiagnostic.ExperimentalFeature(startElement, endElement, experimentalMessageNotAvailable, experimentalFixes);
            case 2 -> {
                AddFeatureAttributeFix fix = this.addFeatureFix(startElement);
                yield new RsDiagnostic.ExperimentalFeature(startElement, endElement, experimentalMessageCanBeAdded, CollectionsKt.plus((Collection)experimentalFixes, (Object)((Object)fix)));
            }
            case 3 -> new RsDiagnostic.RemovedFeature(startElement, endElement, removedMessage, removedFixes);
            default -> null;
        };
    }

    private static final boolean findMetaItem$lambda$0(Crate $crate, RsInnerAttr it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return Intrinsics.areEqual((Object)RsElementKt.getContainingCrate(it2), (Object)$crate);
    }

    private static final Sequence findMetaItem$lambda$1(CfgEvaluator $cfgEvaluator, RsInnerAttr it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return RsDocAndAttributeOwnerKt.expandCfgAttrs($cfgEvaluator, SequencesKt.sequenceOf((Object)it2.getMetaItem()));
    }

    private static final boolean findMetaItem$lambda$2(RsMetaItem it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return Intrinsics.areEqual((Object)RsMetaItemKt.getName(it2), (Object)"feature");
    }

    private static final Iterable findMetaItem$lambda$3(RsMetaItem it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        RsMetaItemArgs rsMetaItemArgs = it2.getMetaItemArgs();
        List list = rsMetaItemArgs != null ? rsMetaItemArgs.getMetaItemList() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final ObjectMapper MAPPER_delegate$lambda$0() {
        return ExtensionsKt.jacksonObjectMapper();
    }

    private static final Map knownFeatures_delegate$lambda$0() {
        Map map2;
        Map it2 = map2 = CompilerFeature.Companion.readFeaturesFromResources();
        boolean bl = false;
        it2.put(CompilerFeature.GENERATORS.name, GENERATORS);
        it2.put(CompilerFeature.COROUTINES.name, COROUTINES);
        return map2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CompilerFeature.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        MAPPER$delegate = LazyKt.lazy(CompilerFeature::MAPPER_delegate$lambda$0);
        knownFeatures$delegate = LazyKt.lazy(CompilerFeature::knownFeatures_delegate$lambda$0);
        COROUTINES = new CompilerFeature("coroutines", FeatureState.ACTIVE, "1.76.0");
        C_UNWIND_PARTIAL_STABILIZATION = new CompilerFeature("c_unwind", FeatureState.ACCEPTED, "1.71.0");
        GENERATORS = new CompilerFeature("generators", FeatureState.REMOVED, "1.76.0");
        SPECIALIZATION = CompilerFeature.Companion.get("specialization");
        MIN_SPECIALIZATION = CompilerFeature.Companion.get("min_specialization");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0003\b\u0094\u0001\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u0015H\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\r\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u001a\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001cR\u0011\u0010!\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001cR\u0011\u0010#\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001cR\u0011\u0010%\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001cR\u0011\u0010'\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001cR\u0011\u0010)\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001cR\u0011\u0010+\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001cR\u0011\u0010-\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001cR\u0011\u0010/\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001cR\u0011\u00101\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001cR\u0011\u00103\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001cR\u0011\u00105\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001cR\u0011\u00107\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001cR\u0011\u00109\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u001cR\u0011\u0010;\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u001cR\u0011\u0010=\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u001cR\u0011\u0010?\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u001cR\u0011\u0010A\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u001cR\u0011\u0010C\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001cR\u0011\u0010E\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u001cR\u0011\u0010G\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u001cR\u0011\u0010I\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u001cR\u0011\u0010K\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u001cR\u0011\u0010M\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u001cR\u0011\u0010O\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u001cR\u0011\u0010Q\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bR\u0010\u001cR\u0011\u0010S\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bT\u0010\u001cR\u0011\u0010U\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010\u001cR\u0011\u0010W\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bX\u0010\u001cR\u0011\u0010Y\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bZ\u0010\u001cR\u0011\u0010[\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010\u001cR\u0011\u0010]\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b^\u0010\u001cR\u0011\u0010_\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b`\u0010\u001cR\u0011\u0010a\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bb\u0010\u001cR\u0011\u0010c\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bd\u0010\u001cR\u0011\u0010e\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bf\u0010\u001cR\u0011\u0010g\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bh\u0010\u001cR\u0011\u0010i\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bj\u0010\u001cR\u0011\u0010k\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bl\u0010\u001cR\u0011\u0010m\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bn\u0010\u001cR\u0011\u0010o\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bp\u0010\u001cR\u0011\u0010q\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\br\u0010\u001cR\u0011\u0010s\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bt\u0010\u001cR\u0011\u0010u\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bv\u0010\u001cR\u0011\u0010w\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bx\u0010\u001cR\u0011\u0010y\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bz\u0010\u001cR\u0011\u0010{\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b|\u0010\u001cR\u0011\u0010}\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b~\u0010\u001cR\u0012\u0010\u007f\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u0080\u0001\u0010\u001cR\u0013\u0010\u0081\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u0082\u0001\u0010\u001cR\u0013\u0010\u0083\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u0084\u0001\u0010\u001cR\u0013\u0010\u0085\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u0086\u0001\u0010\u001cR\u0013\u0010\u0087\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u0088\u0001\u0010\u001cR\u0013\u0010\u0089\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u008a\u0001\u0010\u001cR\u0013\u0010\u008b\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u008c\u0001\u0010\u001cR\u0013\u0010\u008d\u0001\u001a\u00020\u0010\u00a2\u0006\t\n\u0000\u001a\u0005\b\u008e\u0001\u0010\u001cR\u0013\u0010\u008f\u0001\u001a\u00020\u0010\u00a2\u0006\t\n\u0000\u001a\u0005\b\u0090\u0001\u0010\u001cR\u0013\u0010\u0091\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u0092\u0001\u0010\u001cR\u0013\u0010\u0093\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u0094\u0001\u0010\u001cR\u0013\u0010\u0095\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u0096\u0001\u0010\u001cR\u0013\u0010\u0097\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u0098\u0001\u0010\u001cR\u0013\u0010\u0099\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u009a\u0001\u0010\u001cR\u0013\u0010\u009b\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u009c\u0001\u0010\u001cR\u0013\u0010\u009d\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u009e\u0001\u0010\u001cR\u0013\u0010\u009f\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u00a0\u0001\u0010\u001cR\u0013\u0010\u00a1\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u00a2\u0001\u0010\u001cR\u0013\u0010\u00a3\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u00a4\u0001\u0010\u001cR\u0013\u0010\u00a5\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u00a6\u0001\u0010\u001cR\u0013\u0010\u00a7\u0001\u001a\u00020\u00108F\u00a2\u0006\u0007\u001a\u0005\b\u00a8\u0001\u0010\u001c\u00a8\u0006\u00a9\u0001"}, d2={"Lorg/rust/lang/core/CompilerFeature$Companion;", "", "<init>", "()V", "COMPILER_FEATURES_PATH", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMAPPER", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "MAPPER$delegate", "Lkotlin/Lazy;", "knownFeatures", "", "Lorg/rust/lang/core/CompilerFeature;", "getKnownFeatures", "()Ljava/util/Map;", "knownFeatures$delegate", "readFeaturesFromResources", "", "find", "featureName", "get", "name", "ABI_AMDGPU_KERNEL", "getABI_AMDGPU_KERNEL", "()Lorg/rust/lang/core/CompilerFeature;", "ABI_AVR_INTERRUPT", "getABI_AVR_INTERRUPT", "ABI_C_CMSE_NONSECURE_CALL", "getABI_C_CMSE_NONSECURE_CALL", "ABI_EFIAPI", "getABI_EFIAPI", "ABI_MSP430_INTERRUPT", "getABI_MSP430_INTERRUPT", "ABI_PTX", "getABI_PTX", "ABI_THISCALL", "getABI_THISCALL", "ABI_UNADJUSTED", "getABI_UNADJUSTED", "ABI_VECTORCALL", "getABI_VECTORCALL", "ABI_X86_INTERRUPT", "getABI_X86_INTERRUPT", "ADT_CONST_PARAMS", "getADT_CONST_PARAMS", "ARBITRARY_ENUM_DISCRIMINANT", "getARBITRARY_ENUM_DISCRIMINANT", "ASSOCIATED_TYPE_DEFAULTS", "getASSOCIATED_TYPE_DEFAULTS", "ASYNC_FOR_LOOP", "getASYNC_FOR_LOOP", "BOX_PATTERNS", "getBOX_PATTERNS", "BOX_SYNTAX", "getBOX_SYNTAX", "CONST_FN_TRAIT_BOUND", "getCONST_FN_TRAIT_BOUND", "CONST_GENERICS_DEFAULTS", "getCONST_GENERICS_DEFAULTS", "CONST_TRAIT_IMPL", "getCONST_TRAIT_IMPL", "COROUTINES", "getCOROUTINES", "CRATE_IN_PATHS", "getCRATE_IN_PATHS", "C_UNWIND", "getC_UNWIND", "C_UNWIND_PARTIAL_STABILIZATION", "getC_UNWIND_PARTIAL_STABILIZATION", "C_VARIADIC", "getC_VARIADIC", "DECL_MACRO", "getDECL_MACRO", "EXCLUSIVE_RANGE_PATTERN", "getEXCLUSIVE_RANGE_PATTERN", "EXTERN_CRATE_SELF", "getEXTERN_CRATE_SELF", "EXTERN_TYPES", "getEXTERN_TYPES", "FORMAT_ARGS_CAPTURE", "getFORMAT_ARGS_CAPTURE", "GENERATORS", "getGENERATORS", "GENERIC_ASSOCIATED_TYPES", "getGENERIC_ASSOCIATED_TYPES", "GEN_BLOCKS", "getGEN_BLOCKS", "IF_LET_GUARD", "getIF_LET_GUARD", "IF_WHILE_OR_PATTERNS", "getIF_WHILE_OR_PATTERNS", "INHERENT_ASSOCIATED_TYPES", "getINHERENT_ASSOCIATED_TYPES", "INLINE_CONST", "getINLINE_CONST", "INLINE_CONST_PAT", "getINLINE_CONST_PAT", "INTRINSICS", "getINTRINSICS", "IRREFUTABLE_LET_PATTERNS", "getIRREFUTABLE_LET_PATTERNS", "LABEL_BREAK_VALUE", "getLABEL_BREAK_VALUE", "LET_CHAINS", "getLET_CHAINS", "LET_ELSE", "getLET_ELSE", "MIN_CONST_GENERICS", "getMIN_CONST_GENERICS", "NON_MODRS_MODS", "getNON_MODRS_MODS", "OR_PATTERNS", "getOR_PATTERNS", "PARAM_ATTRS", "getPARAM_ATTRS", "PLATFORM_INTRINSICS", "getPLATFORM_INTRINSICS", "RAW_REF_OP", "getRAW_REF_OP", "RETURN_POSITION_IMPL_TRAIT_IN_TRAIT", "getRETURN_POSITION_IMPL_TRAIT_IN_TRAIT", "SLICE_PATTERNS", "getSLICE_PATTERNS", "TYPE_ALIAS_IMPORT_TRAIT", "getTYPE_ALIAS_IMPORT_TRAIT", "UNBOXED_CLOSURES", "getUNBOXED_CLOSURES", "UNSAFE_EXTERN_BLOCKS", "getUNSAFE_EXTERN_BLOCKS", "WASM_ABI", "getWASM_ABI", "HALF_OPEN_RANGE_PATTERNS", "getHALF_OPEN_RANGE_PATTERNS", "CONST_CLOSURES", "getCONST_CLOSURES", "C_STR_LITERAL", "getC_STR_LITERAL", "SPECIALIZATION", "getSPECIALIZATION", "MIN_SPECIALIZATION", "getMIN_SPECIALIZATION", "RUST_COLD_CC", "getRUST_COLD_CC", "ABI_RISCV_INTERRUPT", "getABI_RISCV_INTERRUPT", "IMPORTED_MAIN", "getIMPORTED_MAIN", "POSTFIX_MATCH", "getPOSTFIX_MATCH", "MACRO_METAVAR_EXPR", "getMACRO_METAVAR_EXPR", "MACRO_METAVAR_EXPR_CONCAT", "getMACRO_METAVAR_EXPR_CONCAT", "PRECISE_CAPTURING", "getPRECISE_CAPTURING", "ABI_CUSTOM", "getABI_CUSTOM", "ABI_GPU_KERNEL", "getABI_GPU_KERNEL", "ABI_CMSE_NONSECURE_ENTRY", "getABI_CMSE_NONSECURE_ENTRY", "CONST_REFS_TO_STATIC", "getCONST_REFS_TO_STATIC", "GENERIC_ARG_INFER", "getGENERIC_ARG_INFER", "intellij.rustrover.core"})
    @SourceDebugExtension(value={"SMAP\nCompilerFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerFeature.kt\norg/rust/lang/core/CompilerFeature$Companion\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,349:1\n131#2:350\n54#2:351\n132#2:352\n61#2,8:353\n71#2:362\n1#3:361\n1236#4,4:363\n*S KotlinDebug\n*F\n+ 1 CompilerFeature.kt\norg/rust/lang/core/CompilerFeature$Companion\n*L\n209#1:350\n209#1:351\n209#1:352\n209#1:353,8\n209#1:362\n209#1:361\n216#1:363,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ObjectMapper getMAPPER() {
            Lazy lazy = MAPPER$delegate;
            return (ObjectMapper)lazy.getValue();
        }

        private final Map<String, CompilerFeature> getKnownFeatures() {
            Lazy lazy = knownFeatures$delegate;
            return (Map)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final Map<String, CompilerFeature> readFeaturesFromResources() {
            void $this$associateByTo$iv;
            CompilerFeature $this$readValue$iv;
            Object object;
            Object stream;
            try {
                List list;
                stream = CompilerFeature.class.getClassLoader().getResourceAsStream(CompilerFeature.COMPILER_FEATURES_PATH);
                if (stream == null) {
                    LOG.error("Can't find `compiler-info/compiler-features.json` file in resources");
                    return new HashMap();
                }
                object = stream;
                int n = 8192;
                object = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
                Throwable throwable = null;
                try {
                    void $this$checkTypeMismatch$iv$iv;
                    BufferedInputStream it2 = (BufferedInputStream)object;
                    boolean bl = false;
                    ObjectMapper objectMapper = Companion.getMAPPER();
                    InputStream src$iv = it2;
                    boolean $i$f$readValue = false;
                    boolean $i$f$jacksonTypeRef22 = false;
                    Object $i$f$jacksonTypeRef22 = $this$readValue$iv.readValue(src$iv, (TypeReference)new TypeReference<List<? extends CompilerFeature>>(){});
                    boolean $i$f$checkTypeMismatch = false;
                    if (!($this$checkTypeMismatch$iv$iv instanceof List)) {
                        String string;
                        String nullability$iv$iv = "(non-null)";
                        StringBuilder stringBuilder = new StringBuilder().append("Deserialized value did not match the specified type; specified ").append(Reflection.getOrCreateKotlinClass(List.class).getQualifiedName()).append(nullability$iv$iv).append(" but was ");
                        void v1 = $this$checkTypeMismatch$iv$iv;
                        if (v1 != null) {
                            void it$iv$iv;
                            void var13_20 = v1;
                            StringBuilder stringBuilder2 = stringBuilder;
                            boolean bl2 = false;
                            string = Reflection.getOrCreateKotlinClass(it$iv$iv.getClass()).getQualifiedName();
                            stringBuilder = stringBuilder2;
                        } else {
                            string = null;
                        }
                        String string2 = stringBuilder.append(string).toString();
                        throw new RuntimeJsonMappingException(string2);
                    }
                    list = (List)$this$checkTypeMismatch$iv$iv;
                }
                catch (Throwable bl) {
                    throwable = bl;
                    throw bl;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                stream = list;
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                stream = CollectionsKt.emptyList();
            }
            Object features = stream;
            stream = (Iterable)features;
            Map destination$iv = new HashMap();
            boolean $i$f$associateByTo = false;
            for (Object element$iv : $this$associateByTo$iv) {
                void p0;
                $this$readValue$iv = (CompilerFeature)element$iv;
                Map map2 = destination$iv;
                boolean bl = false;
                map2.put(p0.getName(), element$iv);
            }
            return object;
        }

        @Nullable
        public final CompilerFeature find(@NotNull String featureName) {
            Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
            return this.getKnownFeatures().get(featureName);
        }

        private final CompilerFeature get(String name2) {
            return (CompilerFeature)MapsKt.getValue(this.getKnownFeatures(), (Object)name2);
        }

        @NotNull
        public final CompilerFeature getABI_AMDGPU_KERNEL() {
            return this.get("abi_amdgpu_kernel");
        }

        @NotNull
        public final CompilerFeature getABI_AVR_INTERRUPT() {
            return this.get("abi_avr_interrupt");
        }

        @NotNull
        public final CompilerFeature getABI_C_CMSE_NONSECURE_CALL() {
            return this.get("abi_c_cmse_nonsecure_call");
        }

        @NotNull
        public final CompilerFeature getABI_EFIAPI() {
            return this.get("abi_efiapi");
        }

        @NotNull
        public final CompilerFeature getABI_MSP430_INTERRUPT() {
            return this.get("abi_msp430_interrupt");
        }

        @NotNull
        public final CompilerFeature getABI_PTX() {
            return this.get("abi_ptx");
        }

        @NotNull
        public final CompilerFeature getABI_THISCALL() {
            return this.get("abi_thiscall");
        }

        @NotNull
        public final CompilerFeature getABI_UNADJUSTED() {
            return this.get("abi_unadjusted");
        }

        @NotNull
        public final CompilerFeature getABI_VECTORCALL() {
            return this.get("abi_vectorcall");
        }

        @NotNull
        public final CompilerFeature getABI_X86_INTERRUPT() {
            return this.get("abi_x86_interrupt");
        }

        @NotNull
        public final CompilerFeature getADT_CONST_PARAMS() {
            return this.get("adt_const_params");
        }

        @NotNull
        public final CompilerFeature getARBITRARY_ENUM_DISCRIMINANT() {
            return this.get("arbitrary_enum_discriminant");
        }

        @NotNull
        public final CompilerFeature getASSOCIATED_TYPE_DEFAULTS() {
            return this.get("associated_type_defaults");
        }

        @NotNull
        public final CompilerFeature getASYNC_FOR_LOOP() {
            return this.get("async_for_loop");
        }

        @NotNull
        public final CompilerFeature getBOX_PATTERNS() {
            return this.get("box_patterns");
        }

        @NotNull
        public final CompilerFeature getBOX_SYNTAX() {
            return this.get("box_syntax");
        }

        @NotNull
        public final CompilerFeature getCONST_FN_TRAIT_BOUND() {
            return this.get("const_fn_trait_bound");
        }

        @NotNull
        public final CompilerFeature getCONST_GENERICS_DEFAULTS() {
            return this.get("const_generics_defaults");
        }

        @NotNull
        public final CompilerFeature getCONST_TRAIT_IMPL() {
            return this.get("const_trait_impl");
        }

        @NotNull
        public final CompilerFeature getCOROUTINES() {
            return COROUTINES;
        }

        @NotNull
        public final CompilerFeature getCRATE_IN_PATHS() {
            return this.get("crate_in_paths");
        }

        @NotNull
        public final CompilerFeature getC_UNWIND() {
            return this.get("c_unwind");
        }

        @NotNull
        public final CompilerFeature getC_UNWIND_PARTIAL_STABILIZATION() {
            return C_UNWIND_PARTIAL_STABILIZATION;
        }

        @NotNull
        public final CompilerFeature getC_VARIADIC() {
            return this.get("c_variadic");
        }

        @NotNull
        public final CompilerFeature getDECL_MACRO() {
            return this.get("decl_macro");
        }

        @NotNull
        public final CompilerFeature getEXCLUSIVE_RANGE_PATTERN() {
            return this.get("exclusive_range_pattern");
        }

        @NotNull
        public final CompilerFeature getEXTERN_CRATE_SELF() {
            return this.get("extern_crate_self");
        }

        @NotNull
        public final CompilerFeature getEXTERN_TYPES() {
            return this.get("extern_types");
        }

        @NotNull
        public final CompilerFeature getFORMAT_ARGS_CAPTURE() {
            return this.get("format_args_capture");
        }

        @NotNull
        public final CompilerFeature getGENERATORS() {
            return GENERATORS;
        }

        @NotNull
        public final CompilerFeature getGENERIC_ASSOCIATED_TYPES() {
            return this.get("generic_associated_types");
        }

        @NotNull
        public final CompilerFeature getGEN_BLOCKS() {
            return this.get("gen_blocks");
        }

        @NotNull
        public final CompilerFeature getIF_LET_GUARD() {
            return this.get("if_let_guard");
        }

        @NotNull
        public final CompilerFeature getIF_WHILE_OR_PATTERNS() {
            return this.get("if_while_or_patterns");
        }

        @NotNull
        public final CompilerFeature getINHERENT_ASSOCIATED_TYPES() {
            return this.get("inherent_associated_types");
        }

        @NotNull
        public final CompilerFeature getINLINE_CONST() {
            return this.get("inline_const");
        }

        @NotNull
        public final CompilerFeature getINLINE_CONST_PAT() {
            return this.get("inline_const_pat");
        }

        @NotNull
        public final CompilerFeature getINTRINSICS() {
            return this.get("intrinsics");
        }

        @NotNull
        public final CompilerFeature getIRREFUTABLE_LET_PATTERNS() {
            return this.get("irrefutable_let_patterns");
        }

        @NotNull
        public final CompilerFeature getLABEL_BREAK_VALUE() {
            return this.get("label_break_value");
        }

        @NotNull
        public final CompilerFeature getLET_CHAINS() {
            return this.get("let_chains");
        }

        @NotNull
        public final CompilerFeature getLET_ELSE() {
            return this.get("let_else");
        }

        @NotNull
        public final CompilerFeature getMIN_CONST_GENERICS() {
            return this.get("min_const_generics");
        }

        @NotNull
        public final CompilerFeature getNON_MODRS_MODS() {
            return this.get("non_modrs_mods");
        }

        @NotNull
        public final CompilerFeature getOR_PATTERNS() {
            return this.get("or_patterns");
        }

        @NotNull
        public final CompilerFeature getPARAM_ATTRS() {
            return this.get("param_attrs");
        }

        @NotNull
        public final CompilerFeature getPLATFORM_INTRINSICS() {
            return this.get("platform_intrinsics");
        }

        @NotNull
        public final CompilerFeature getRAW_REF_OP() {
            return this.get("raw_ref_op");
        }

        @NotNull
        public final CompilerFeature getRETURN_POSITION_IMPL_TRAIT_IN_TRAIT() {
            return this.get("return_position_impl_trait_in_trait");
        }

        @NotNull
        public final CompilerFeature getSLICE_PATTERNS() {
            return this.get("slice_patterns");
        }

        @NotNull
        public final CompilerFeature getTYPE_ALIAS_IMPORT_TRAIT() {
            return this.get("type_alias_impl_trait");
        }

        @NotNull
        public final CompilerFeature getUNBOXED_CLOSURES() {
            return this.get("unboxed_closures");
        }

        @NotNull
        public final CompilerFeature getUNSAFE_EXTERN_BLOCKS() {
            return this.get("unsafe_extern_blocks");
        }

        @NotNull
        public final CompilerFeature getWASM_ABI() {
            return this.get("wasm_abi");
        }

        @NotNull
        public final CompilerFeature getHALF_OPEN_RANGE_PATTERNS() {
            return this.get("half_open_range_patterns");
        }

        @NotNull
        public final CompilerFeature getCONST_CLOSURES() {
            return this.get("const_closures");
        }

        @NotNull
        public final CompilerFeature getC_STR_LITERAL() {
            return this.get("c_str_literals");
        }

        @NotNull
        public final CompilerFeature getSPECIALIZATION() {
            return SPECIALIZATION;
        }

        @NotNull
        public final CompilerFeature getMIN_SPECIALIZATION() {
            return MIN_SPECIALIZATION;
        }

        @NotNull
        public final CompilerFeature getRUST_COLD_CC() {
            return this.get("rust_cold_cc");
        }

        @NotNull
        public final CompilerFeature getABI_RISCV_INTERRUPT() {
            return this.get("abi_riscv_interrupt");
        }

        @NotNull
        public final CompilerFeature getIMPORTED_MAIN() {
            return this.get("imported_main");
        }

        @NotNull
        public final CompilerFeature getPOSTFIX_MATCH() {
            return this.get("postfix_match");
        }

        @NotNull
        public final CompilerFeature getMACRO_METAVAR_EXPR() {
            return this.get("macro_metavar_expr");
        }

        @NotNull
        public final CompilerFeature getMACRO_METAVAR_EXPR_CONCAT() {
            return this.get("macro_metavar_expr_concat");
        }

        @NotNull
        public final CompilerFeature getPRECISE_CAPTURING() {
            return this.get("precise_capturing");
        }

        @NotNull
        public final CompilerFeature getABI_CUSTOM() {
            return this.get("abi_custom");
        }

        @NotNull
        public final CompilerFeature getABI_GPU_KERNEL() {
            return this.get("abi_gpu_kernel");
        }

        @NotNull
        public final CompilerFeature getABI_CMSE_NONSECURE_ENTRY() {
            return this.get("cmse_nonsecure_entry");
        }

        @NotNull
        public final CompilerFeature getCONST_REFS_TO_STATIC() {
            return this.get("const_refs_to_static");
        }

        @NotNull
        public final CompilerFeature getGENERIC_ARG_INFER() {
            return this.get("generic_arg_infer");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[FeatureState.values().length];
            try {
                nArray[FeatureState.ACCEPTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureState.REMOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.NO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.UNSURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.YES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[FeatureAvailability.values().length];
            try {
                nArray[FeatureAvailability.NOT_AVAILABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureAvailability.CAN_BE_ADDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureAvailability.REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

