/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.utils.checkMatch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.utils.checkMatch.CheckMatchException;
import org.rust.ide.utils.checkMatch.Constructor;
import org.rust.ide.utils.checkMatch.Pattern;
import org.rust.ide.utils.checkMatch.PatternKind;
import org.rust.lang.core.psi.RsEnumItem;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyArray;
import org.rust.lang.core.types.ty.TyRef;
import org.rust.lang.core.types.ty.TySlice;
import org.rust.lang.core.types.ty.TyTuple;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\u0000J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/utils/checkMatch/Witness;", "", "patterns", "", "Lorg/rust/ide/utils/checkMatch/Pattern;", "<init>", "(Ljava/util/List;)V", "getPatterns", "()Ljava/util/List;", "toString", "", "clone", "pushWildConstructor", "constructor", "Lorg/rust/ide/utils/checkMatch/Constructor;", "type", "Lorg/rust/lang/core/types/ty/Ty;", "applyConstructor", "intellij.rustrover.core"})
public final class Witness {
    @NotNull
    private final List<Pattern> patterns;

    public Witness(@NotNull List<Pattern> patterns) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        this.patterns = patterns;
    }

    public /* synthetic */ Witness(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        this(list);
    }

    @NotNull
    public final List<Pattern> getPatterns() {
        return this.patterns;
    }

    @NotNull
    public String toString() {
        return this.patterns.toString();
    }

    @NotNull
    public final Witness clone() {
        return new Witness(CollectionsKt.toMutableList((Collection)this.patterns));
    }

    @NotNull
    public final Witness pushWildConstructor(@NotNull Constructor constructor, @NotNull Ty type) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List<Ty> subPatternTypes = constructor.subTypes(type);
        for (Ty ty2 : subPatternTypes) {
            this.patterns.add(Pattern.Companion.wild(ty2));
        }
        return this.applyConstructor(constructor, type);
    }

    @NotNull
    public final Witness applyConstructor(@NotNull Constructor constructor, @NotNull Ty type) {
        PatternKind patternKind;
        List<Pattern> list;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        int arity = constructor.arity(type);
        int len = this.patterns.size();
        try {
            list = this.patterns.subList(len - arity, len);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CheckMatchException("Index out of bounds");
        }
        List<Pattern> oldPatterns = list;
        List pats = CollectionsKt.toList((Iterable)CollectionsKt.reversed((Iterable)oldPatterns));
        oldPatterns.clear();
        if (type instanceof TyAdt) {
            patternKind = ((TyAdt)type).getItem() instanceof RsEnumItem ? (PatternKind)new PatternKind.Variant((RsEnumItem)((TyAdt)type).getItem(), ((Constructor.Variant)constructor).getVariant(), pats) : (PatternKind)new PatternKind.Leaf(pats);
        } else if (type instanceof TyTuple && !((Collection)((TyTuple)type).getTypes()).isEmpty()) {
            patternKind = new PatternKind.Leaf(pats);
        } else if (type instanceof TyRef) {
            patternKind = new PatternKind.Deref((Pattern)CollectionsKt.first((List)pats));
        } else {
            if (type instanceof TySlice) {
                throw new NotImplementedError(null, 1, null);
            }
            if (type instanceof TyArray) {
                throw new NotImplementedError(null, 1, null);
            }
            patternKind = constructor instanceof Constructor.ConstantValue ? (PatternKind)new PatternKind.Const(((Constructor.ConstantValue)constructor).getValue()) : (PatternKind)PatternKind.Wild.INSTANCE;
        }
        PatternKind kind2 = patternKind;
        this.patterns.add(new Pattern(type, kind2));
        return this;
    }

    public Witness() {
        this(null, 1, null);
    }
}

