/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.utils.checkMatch;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.presentation.TypeRenderingKt;
import org.rust.ide.utils.checkMatch.Constructor;
import org.rust.ide.utils.checkMatch.PatternKind;
import org.rust.ide.utils.checkMatch.PatternKt;
import org.rust.lang.core.psi.RsEnumItem;
import org.rust.lang.core.psi.RsEnumVariant;
import org.rust.lang.core.psi.RsRawIdentifiersKt;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsEnumVariantKt;
import org.rust.lang.core.psi.ext.RsFieldsOwner;
import org.rust.lang.core.psi.ext.RsStructOrEnumItemElement;
import org.rust.lang.core.resolve.NamespaceKt;
import org.rust.lang.core.types.ty.Ty;
import org.rust.lang.core.types.ty.TyAdt;
import org.rust.lang.core.types.ty.TyRef;
import org.rust.lang.core.types.ty.TyTuple;
import org.rust.lang.core.types.ty.TyUnknown;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\rH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\u00a8\u0006!"}, d2={"Lorg/rust/ide/utils/checkMatch/Pattern;", "", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "kind", "Lorg/rust/ide/utils/checkMatch/PatternKind;", "<init>", "(Lorg/rust/lang/core/types/ty/Ty;Lorg/rust/ide/utils/checkMatch/PatternKind;)V", "getTy", "()Lorg/rust/lang/core/types/ty/Ty;", "getKind", "()Lorg/rust/ide/utils/checkMatch/PatternKind;", "text", "", "ctx", "Lorg/rust/lang/core/psi/ext/RsElement;", "constructors", "", "Lorg/rust/ide/utils/checkMatch/Constructor;", "getConstructors", "()Ljava/util/List;", "ergonomicType", "getErgonomicType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\norg/rust/ide/utils/checkMatch/Pattern\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class Pattern {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Ty ty;
    @NotNull
    private final PatternKind kind;

    public Pattern(@NotNull Ty ty2, @NotNull PatternKind kind2) {
        Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        this.ty = ty2;
        this.kind = kind2;
    }

    @NotNull
    public final Ty getTy() {
        return this.ty;
    }

    @NotNull
    public final PatternKind getKind() {
        return this.kind;
    }

    @NotNull
    public final String text(@Nullable RsElement ctx) {
        Object object;
        PatternKind patternKind = this.kind;
        if (patternKind instanceof PatternKind.Wild) {
            object = "_";
        } else if (patternKind instanceof PatternKind.Binding) {
            object = ((PatternKind.Binding)this.kind).getName();
        } else if (patternKind instanceof PatternKind.Variant) {
            Object object2;
            PsiElement psiElement2;
            String string = ((PatternKind.Variant)this.kind).getVariant().getName();
            if (string == null) {
                string = "";
            }
            String variantName = string;
            String itemName = TypeRenderingKt.renderInsertionSafe$default(this.ty, null, 0, null, false, false, false, false, 103, null);
            if (ctx != null && (psiElement2 = RsElementKt.findInScope(ctx, variantName, NamespaceKt.getVALUES())) != null) {
                PsiElement psiElement3;
                PsiElement it2 = psiElement3 = psiElement2;
                boolean bl = false;
                RsEnumVariant rsEnumVariant = it2 instanceof RsEnumVariant ? (RsEnumVariant)it2 : null;
                object2 = Intrinsics.areEqual((Object)(rsEnumVariant != null ? RsEnumVariantKt.getParentEnum(rsEnumVariant) : null), (Object)((PatternKind.Variant)this.kind).getItem()) ? psiElement3 : null;
            } else {
                object2 = null;
            }
            PsiElement variantInScope = object2;
            String name2 = variantInScope != null ? RsRawIdentifiersKt.escapeIdentifierIfNeeded(variantName) : RsRawIdentifiersKt.escapeIdentifierIfNeeded(itemName) + "::" + RsRawIdentifiersKt.escapeIdentifierIfNeeded(variantName);
            String initializer = PatternKt.access$initializer(((PatternKind.Variant)this.kind).getVariant(), ((PatternKind.Variant)this.kind).getSubPatterns(), ctx);
            object = name2 + initializer;
        } else if (patternKind instanceof PatternKind.Leaf) {
            List<Pattern> subPatterns = ((PatternKind.Leaf)this.kind).getSubPatterns();
            Ty ty2 = this.ty;
            if (ty2 instanceof TyTuple) {
                object = CollectionsKt.joinToString$default((Iterable)subPatterns, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, arg_0 -> Pattern.text$lambda$1(ctx, arg_0), (int)24, null);
            } else if (ty2 instanceof TyAdt) {
                Object name3;
                Object object3;
                Object initializer = ((TyAdt)this.ty).getItem();
                Object object4 = initializer instanceof RsStructItem ? (RsStructItem)initializer : null;
                if (object4 == null || (object4 = object4.getName()) == null) {
                    RsStructOrEnumItemElement rsStructOrEnumItemElement = ((TyAdt)this.ty).getItem();
                    RsEnumVariant rsEnumVariant = rsStructOrEnumItemElement instanceof RsEnumVariant ? (RsEnumVariant)((Object)rsStructOrEnumItemElement) : null;
                    object4 = rsEnumVariant != null ? rsEnumVariant.getName() : null;
                }
                if ((object3 = (name3 = object4)) == null) {
                    object3 = "";
                }
                String escapedName = RsRawIdentifiersKt.escapeIdentifierIfNeeded((String)object3);
                RsStructOrEnumItemElement rsStructOrEnumItemElement = ((TyAdt)this.ty).getItem();
                Intrinsics.checkNotNull((Object)rsStructOrEnumItemElement, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.ext.RsFieldsOwner");
                initializer = PatternKt.access$initializer((RsFieldsOwner)((Object)rsStructOrEnumItemElement), subPatterns, ctx);
                object = escapedName + (String)initializer;
            } else {
                object = "";
            }
        } else if (patternKind instanceof PatternKind.Range) {
            object = ((PatternKind.Range)this.kind).getLc() + (((PatternKind.Range)this.kind).isInclusive() ? ".." : "..=") + ((PatternKind.Range)this.kind).getRc();
        } else if (patternKind instanceof PatternKind.Deref) {
            object = "&" + ((PatternKind.Deref)this.kind).getSubPattern().text(ctx);
        } else if (patternKind instanceof PatternKind.Const) {
            object = ((PatternKind.Const)this.kind).getValue().toString();
        } else {
            if (patternKind instanceof PatternKind.Slice) {
                throw new NotImplementedError(null, 1, null);
            }
            if (patternKind instanceof PatternKind.Array) {
                throw new NotImplementedError(null, 1, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Nullable
    public final List<Constructor> getConstructors() {
        List list;
        PatternKind patternKind = this.kind;
        if (Intrinsics.areEqual((Object)patternKind, (Object)PatternKind.Wild.INSTANCE) || patternKind instanceof PatternKind.Binding) {
            list = null;
        } else if (patternKind instanceof PatternKind.Variant) {
            list = CollectionsKt.listOf((Object)new Constructor.Variant(((PatternKind.Variant)this.kind).getVariant()));
        } else if (patternKind instanceof PatternKind.Leaf || patternKind instanceof PatternKind.Deref) {
            list = CollectionsKt.listOf((Object)Constructor.Single.INSTANCE);
        } else if (patternKind instanceof PatternKind.Const) {
            list = CollectionsKt.listOf((Object)new Constructor.ConstantValue(((PatternKind.Const)this.kind).getValue()));
        } else if (patternKind instanceof PatternKind.Range) {
            list = CollectionsKt.listOf((Object)new Constructor.ConstantRange(((PatternKind.Range)this.kind).getLc(), ((PatternKind.Range)this.kind).getRc(), ((PatternKind.Range)this.kind).isInclusive()));
        } else {
            if (patternKind instanceof PatternKind.Slice) {
                throw new NotImplementedError(null, 1, null);
            }
            if (patternKind instanceof PatternKind.Array) {
                throw new NotImplementedError(null, 1, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @NotNull
    public final Ty getErgonomicType() {
        Ty ty2;
        Ty referencedBase = this.ty;
        while (referencedBase instanceof TyRef) {
            referencedBase = ((TyRef)referencedBase).getReferenced();
        }
        Ty it2 = ty2 = referencedBase;
        boolean bl = false;
        Ty ty3 = it2 instanceof TyAdt && ((TyAdt)it2).getItem() instanceof RsEnumItem ? ty2 : null;
        if (ty3 == null) {
            ty3 = this.ty;
        }
        return ty3;
    }

    @NotNull
    public final Ty component1() {
        return this.ty;
    }

    @NotNull
    public final PatternKind component2() {
        return this.kind;
    }

    @NotNull
    public final Pattern copy(@NotNull Ty ty2, @NotNull PatternKind kind2) {
        Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        return new Pattern(ty2, kind2);
    }

    public static /* synthetic */ Pattern copy$default(Pattern pattern2, Ty ty2, PatternKind patternKind, int n, Object object) {
        if ((n & 1) != 0) {
            ty2 = pattern2.ty;
        }
        if ((n & 2) != 0) {
            patternKind = pattern2.kind;
        }
        return pattern2.copy(ty2, patternKind);
    }

    @NotNull
    public String toString() {
        return "Pattern(ty=" + this.ty + ", kind=" + this.kind + ")";
    }

    public int hashCode() {
        int result2 = this.ty.hashCode();
        result2 = result2 * 31 + this.kind.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Pattern)) {
            return false;
        }
        Pattern pattern2 = (Pattern)other;
        if (!Intrinsics.areEqual((Object)this.ty, (Object)pattern2.ty)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.kind, (Object)pattern2.kind);
    }

    private static final CharSequence text$lambda$1(RsElement $ctx, Pattern it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.text($ctx);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/ide/utils/checkMatch/Pattern$Companion;", "", "<init>", "()V", "wild", "Lorg/rust/ide/utils/checkMatch/Pattern;", "ty", "Lorg/rust/lang/core/types/ty/Ty;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern wild(@NotNull Ty ty2) {
            Intrinsics.checkNotNullParameter((Object)ty2, (String)"ty");
            return new Pattern(ty2, PatternKind.Wild.INSTANCE);
        }

        public static /* synthetic */ Pattern wild$default(Companion companion, Ty ty2, int n, Object object) {
            if ((n & 1) != 0) {
                ty2 = TyUnknown.INSTANCE;
            }
            return companion.wild(ty2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

