/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.utils;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.formatter.impl.SpacingUtil;
import org.rust.ide.injected.RsDoctestLanguageInjectorKt;
import org.rust.ide.utils.WhiteSpaceUtilKt;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsInnerAttr;
import org.rust.lang.core.psi.RsMacro;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsMembers;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.RsElement;
import org.rust.lang.core.psi.ext.RsItemElement;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.psi.ext.RsTraitOrImpl;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J*\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\tJ\u0017\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0082\bR\u0018\u0010\b\u001a\u00020\t*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0018\u0010\u0011\u001a\u00020\t*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0018\u0010\u0012\u001a\u00020\t*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0018\u0010\u0013\u001a\u00020\t*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/rust/ide/utils/WhiteSpaceUtil;", "", "<init>", "()V", "ensureLineFeedsAround", "", "element", "Lcom/intellij/psi/PsiElement;", "isFormatterItem", "", "(Lcom/intellij/psi/PsiElement;)Z", "ensureLineFeedsBetween", "left", "right", "psiFactory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "appendLineFeedsInTheEnd", "isInDoctestInjectionFunction", "isInMod", "isInImplOrTrait", "runSafely", "runnable", "Lkotlin/Function0;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nWhiteSpaceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhiteSpaceUtil.kt\norg/rust/ide/utils/WhiteSpaceUtil\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 utils.kt\norg/rust/openapiext/UtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n130#1,8:140\n130#1,2:148\n132#1,6:166\n1104#2,3:150\n1#3:153\n318#4,10:154\n1869#5,2:164\n*S KotlinDebug\n*F\n+ 1 WhiteSpaceUtil.kt\norg/rust/ide/utils/WhiteSpaceUtil\n*L\n38#1:140,8\n65#1:148,2\n65#1:166,6\n76#1:150,3\n81#1:154,10\n112#1:164,2\n*E\n"})
public final class WhiteSpaceUtil {
    @NotNull
    public static final WhiteSpaceUtil INSTANCE = new WhiteSpaceUtil();

    private WhiteSpaceUtil() {
    }

    public final void ensureLineFeedsAround(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        WhiteSpaceUtil this_$iv = this;
        boolean $i$f$runSafely = false;
        try {
            PsiElement prev;
            boolean bl = false;
            if (!INSTANCE.isFormatterItem(element)) {
                return;
            }
            RsElement cfr_ignored_0 = (RsElement)element;
            if (!(INSTANCE.isInMod(element) || INSTANCE.isInImplOrTrait(element) || INSTANCE.isInDoctestInjectionFunction(element))) {
                return;
            }
            Project project = ((RsElement)element).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RsPsiFactory psiFactory = new RsPsiFactory(project, false, false, 6, null);
            PsiElement next = PsiElementExtensionsKt.getNextNonWhitespaceSibling(element);
            if (next != null) {
                INSTANCE.ensureLineFeedsBetween(element, next, psiFactory, false);
            }
            if ((prev = PsiElementExtensionsKt.getPrevNonWhitespaceSibling(element)) != null) {
                INSTANCE.ensureLineFeedsBetween(prev, element, psiFactory, true);
            }
        }
        catch (ProcessCanceledException e$iv) {
            throw e$iv;
        }
        catch (Exception e$iv) {
            WhiteSpaceUtilKt.access$getLOG$p().error((Throwable)e$iv);
        }
    }

    private final boolean isFormatterItem(PsiElement $this$isFormatterItem) {
        return $this$isFormatterItem instanceof RsItemElement || $this$isFormatterItem instanceof RsInnerAttr || $this$isFormatterItem instanceof RsMacro || $this$isFormatterItem instanceof RsMacroCall;
    }

    public final void ensureLineFeedsBetween(@NotNull PsiElement left, @NotNull PsiElement right, @NotNull RsPsiFactory psiFactory, boolean appendLineFeedsInTheEnd) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)psiFactory, (String)"psiFactory");
        WhiteSpaceUtil this_$iv = this;
        boolean $i$f$runSafely = false;
        try {
            List whitespaces;
            block20: {
                Object object;
                PsiElement psiElement2;
                PsiElement updatedWhitespace;
                PsiElement anchor;
                String neededWhitespace;
                PsiElement parent2;
                block22: {
                    block21: {
                        PsiElement $i$f$weakAssert3;
                        block17: {
                            Object object2;
                            block19: {
                                block18: {
                                    PsiElement psiElement3;
                                    boolean bl = false;
                                    whitespaces = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)left.getNextSibling(), WhiteSpaceUtil::ensureLineFeedsBetween$lambda$0$0), arg_0 -> WhiteSpaceUtil.ensureLineFeedsBetween$lambda$0$1(right, arg_0)));
                                    String whitespaceText = CollectionsKt.joinToString$default((Iterable)whitespaces, (CharSequence)"", null, null, (int)0, null, WhiteSpaceUtil::ensureLineFeedsBetween$lambda$0$2, (int)30, null);
                                    boolean needsBlankLine = INSTANCE.isFormatterItem(left) && INSTANCE.isFormatterItem(right) && SpacingUtil.INSTANCE.needsBlankLineBetweenItems(PsiElementExtensionsKt.getElementType(left), PsiElementExtensionsKt.getElementType(right));
                                    CharSequence $this$count$iv = whitespaceText;
                                    boolean $i$f$count = false;
                                    int count$iv = 0;
                                    for (int j = 0; j < $this$count$iv.length(); ++j) {
                                        char element$iv;
                                        char it2 = element$iv = $this$count$iv.charAt(j);
                                        boolean bl2 = false;
                                        if (!(it2 == '\n')) continue;
                                        ++count$iv;
                                    }
                                    int lineFeedsCount = count$iv;
                                    int neededWhitespaceCount = needsBlankLine ? 2 : 1;
                                    boolean alreadyHasEnoughLines = lineFeedsCount >= neededWhitespaceCount;
                                    PsiElement it3 = psiElement3 = left.getParent();
                                    boolean bl3 = false;
                                    boolean $i$f$weakAssert2 = false;
                                    boolean $i$f$weakAssert3 = false;
                                    if (UtilsKt.isUnitTestMode() || UtilsKt.isInternal()) {
                                        boolean bl4 = false;
                                        if (!Intrinsics.areEqual((Object)it3, (Object)right.getParent())) {
                                            boolean bl5 = false;
                                            String message$iv$iv = "Assertion failed";
                                            throw new AssertionError((Object)message$iv$iv);
                                        }
                                    }
                                    parent2 = psiElement3;
                                    if (alreadyHasEnoughLines) {
                                        PsiFile psiFile = left.getContainingFile();
                                        if ((psiFile != null ? psiFile.getVirtualFile() : null) instanceof VirtualFileWindow) {
                                            return;
                                        }
                                        if (!((Collection)whitespaces).isEmpty()) {
                                            parent2.deleteChildRange((PsiElement)CollectionsKt.first((List)whitespaces), (PsiElement)CollectionsKt.last((List)whitespaces));
                                        }
                                        v1 = StringsKt.repeat((CharSequence)"\n", (int)neededWhitespaceCount);
                                    } else {
                                        v1 = neededWhitespace = appendLineFeedsInTheEnd ? whitespaceText + StringsKt.repeat((CharSequence)"\n", (int)(neededWhitespaceCount - lineFeedsCount)) : StringsKt.repeat((CharSequence)"\n", (int)(neededWhitespaceCount - lineFeedsCount)) + whitespaceText;
                                    }
                                    if (!appendLineFeedsInTheEnd) break block17;
                                    object2 = (PsiElement)CollectionsKt.lastOrNull((List)whitespaces);
                                    if (object2 == null) break block18;
                                    PsiElement it4 = $i$f$weakAssert3 = object2;
                                    boolean bl6 = false;
                                    object2 = it4.isValid() ? $i$f$weakAssert3 : null;
                                    if (object2 != null) break block19;
                                }
                                object2 = left;
                            }
                            anchor = object2;
                            updatedWhitespace = psiFactory.createWhitespace(neededWhitespace);
                            psiElement2 = parent2.addAfter(updatedWhitespace, anchor);
                            break block20;
                        }
                        object = (PsiElement)CollectionsKt.firstOrNull((List)whitespaces);
                        if (object == null) break block21;
                        PsiElement it5 = $i$f$weakAssert3 = object;
                        boolean bl = false;
                        object = it5.isValid() ? $i$f$weakAssert3 : null;
                        if (object != null) break block22;
                    }
                    object = right;
                }
                anchor = object;
                updatedWhitespace = psiFactory.createWhitespace(neededWhitespace);
                psiElement2 = parent2.addBefore(updatedWhitespace, anchor);
            }
            Iterable $this$forEach$iv = whitespaces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement it6 = (PsiElement)element$iv;
                boolean bl = false;
                if (!it6.isValid()) continue;
                it6.delete();
            }
        }
        catch (ProcessCanceledException e$iv) {
            throw e$iv;
        }
        catch (Exception e$iv) {
            WhiteSpaceUtilKt.access$getLOG$p().error((Throwable)e$iv);
        }
    }

    public static /* synthetic */ void ensureLineFeedsBetween$default(WhiteSpaceUtil whiteSpaceUtil, PsiElement psiElement2, PsiElement psiElement3, RsPsiFactory rsPsiFactory, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            Project project = psiElement2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            rsPsiFactory = new RsPsiFactory(project, false, false, 6, null);
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        whiteSpaceUtil.ensureLineFeedsBetween(psiElement2, psiElement3, rsPsiFactory, bl);
    }

    private final boolean isInDoctestInjectionFunction(PsiElement $this$isInDoctestInjectionFunction) {
        PsiFile psiFile = $this$isInDoctestInjectionFunction.getContainingFile();
        RsFile rsFile = psiFile instanceof RsFile ? (RsFile)psiFile : null;
        if (rsFile == null) {
            return false;
        }
        RsFile file = rsFile;
        if (!RsDoctestLanguageInjectorKt.isDoctestInjection(file)) {
            return false;
        }
        PsiElement psiElement2 = $this$isInDoctestInjectionFunction.getParent();
        RsBlock rsBlock = psiElement2 instanceof RsBlock ? (RsBlock)psiElement2 : null;
        if (rsBlock == null) {
            return false;
        }
        RsBlock block = rsBlock;
        return block.getParent() instanceof RsFunction;
    }

    private final boolean isInMod(PsiElement $this$isInMod) {
        return $this$isInMod.getParent() instanceof RsMod;
    }

    private final boolean isInImplOrTrait(PsiElement $this$isInImplOrTrait) {
        return $this$isInImplOrTrait.getParent() instanceof RsMembers && $this$isInImplOrTrait.getParent().getParent() instanceof RsTraitOrImpl;
    }

    private final void runSafely(Function0<Unit> runnable) {
        boolean $i$f$runSafely = false;
        try {
            runnable.invoke();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            WhiteSpaceUtilKt.access$getLOG$p().error((Throwable)e);
        }
    }

    private static final PsiElement ensureLineFeedsBetween$lambda$0$0(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return it2.getNextSibling();
    }

    private static final boolean ensureLineFeedsBetween$lambda$0$1(PsiElement $right, PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return !Intrinsics.areEqual((Object)it2, (Object)$right);
    }

    private static final CharSequence ensureLineFeedsBetween$lambda$0$2(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        String string = it2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

