/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.utils;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.macros.MacroExpansionContext;
import org.rust.lang.core.macros.MacroExpansionKt;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsBlockExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsMacroCall;
import org.rust.lang.core.psi.RsStmt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.core.psi.ext.RsBlockExprKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u001a+\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000e\u001a+\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000e\u001a%\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a%\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0012\u001a(\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\u0015*\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005\u001a\u0014\u0010\u0016\u001a\u0004\u0018\u00010\r*\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\r*\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0018\u001a\u00020\r*\u00020\r2\u0006\u0010\u0019\u001a\u00020\r\u001a9\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\u0002\u0010 \u00a8\u0006!"}, d2={"findExpressionAtCaret", "Lorg/rust/lang/core/psi/RsExpr;", "file", "Lorg/rust/lang/core/psi/RsFile;", "offset", "", "expressionAtOffset", "findExpressionInRange", "Lcom/intellij/psi/PsiFile;", "startOffset", "endOffset", "findStatementsInRange", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiFile;II)[Lcom/intellij/psi/PsiElement;", "findStatementsOrExprInRange", "element1", "element2", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiElement;", "findStatementsInRangeUnchecked", "getElementRange", "Lkotlin/Pair;", "findElementAtIgnoreWhitespaceBefore", "findElementAtIgnoreWhitespaceAfter", "getTopmostParentInside", "parent", "collectElements", "start", "stop", "pred", "Lkotlin/Function1;", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)[Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nSearchByOffset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchByOffset.kt\norg/rust/ide/utils/SearchByOffsetKt\n+ 2 PsiElementExtensions.kt\norg/rust/lang/core/psi/ext/PsiElementExtensionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,191:1\n15#2:192\n15#2:193\n15#2:202\n320#3,7:194\n1#4:201\n13870#5,3:203\n*S KotlinDebug\n*F\n+ 1 SearchByOffset.kt\norg/rust/ide/utils/SearchByOffsetKt\n*L\n31#1:192\n44#1:193\n96#1:202\n83#1:194,7\n118#1:203,3\n*E\n"})
public final class SearchByOffsetKt {
    @Nullable
    public static final RsExpr findExpressionAtCaret(@NotNull RsFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RsExpr expr = SearchByOffsetKt.expressionAtOffset(file, offset);
        RsExpr exprBefore = SearchByOffsetKt.expressionAtOffset(file, offset - 1);
        return expr == null ? exprBefore : (exprBefore == null ? expr : (PsiTreeUtil.isAncestor((PsiElement)expr, (PsiElement)exprBefore, (boolean)false) ? exprBefore : expr));
    }

    private static final RsExpr expressionAtOffset(RsFile $this$expressionAtOffset, int offset) {
        RsExpr rsExpr;
        PsiElement psiElement2 = $this$expressionAtOffset.findElementAt(offset);
        if (psiElement2 != null) {
            PsiElement $this$ancestorOrSelf$iv = psiElement2;
            boolean $i$f$ancestorOrSelf = false;
            rsExpr = (RsExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsExpr.class, (boolean)false);
        } else {
            rsExpr = null;
        }
        return rsExpr;
    }

    @Nullable
    public static final RsExpr findExpressionInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        PsiElement parent2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Pair<PsiElement, PsiElement> pair = SearchByOffsetKt.getElementRange(file, startOffset, endOffset);
        if (pair == null) {
            return null;
        }
        Pair<PsiElement, PsiElement> pair2 = pair;
        PsiElement element1 = (PsiElement)pair2.component1();
        PsiElement element2 = (PsiElement)pair2.component2();
        PsiElement psiElement2 = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement $this$ancestorOrSelf$iv = parent2 = psiElement2;
        boolean $i$f$ancestorOrSelf = false;
        RsExpr rsExpr = (RsExpr)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsExpr.class, (boolean)false);
        if (rsExpr == null) {
            return null;
        }
        parent2 = rsExpr;
        if (parent2 instanceof RsBlockExpr && RsBlockExprKt.isIfElseBlock((RsBlockExpr)parent2)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)element1, (Object)PsiTreeUtil.getDeepestFirst((PsiElement)parent2)) && Intrinsics.areEqual((Object)element2, (Object)PsiTreeUtil.getDeepestLast((PsiElement)element2))) {
            return (RsExpr)parent2;
        }
        return null;
    }

    @NotNull
    public static final PsiElement[] findStatementsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Pair<PsiElement, PsiElement> pair = SearchByOffsetKt.getElementRange(file, startOffset, endOffset);
        if (pair == null) {
            return new PsiElement[0];
        }
        Pair<PsiElement, PsiElement> pair2 = pair;
        PsiElement element1 = (PsiElement)pair2.component1();
        PsiElement element2 = (PsiElement)pair2.component2();
        return SearchByOffsetKt.findStatementsInRange(element1, element2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PsiElement[] findStatementsOrExprInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Pair<PsiElement, PsiElement> pair = SearchByOffsetKt.getElementRange(file, startOffset, endOffset);
        if (pair == null) {
            return new PsiElement[0];
        }
        Pair<PsiElement, PsiElement> pair2 = pair;
        PsiElement element1 = (PsiElement)pair2.component1();
        PsiElement element2 = (PsiElement)pair2.component2();
        PsiElement psiElement2 = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (psiElement2 == null) {
            return new PsiElement[0];
        }
        PsiElement parent2 = psiElement2;
        if (startOffset == PsiElementKt.getStartOffset(parent2) && endOffset == PsiElementKt.getEndOffset(parent2)) {
            void $this$lastOrNull$iv;
            Sequence<PsiElement> sequence2 = PsiElementKt.getAncestors(parent2);
            boolean $i$f$lastOrNull = false;
            Object last$iv = null;
            for (Object element$iv : $this$lastOrNull$iv) {
                PsiElement it2 = (PsiElement)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it2.getTextRange(), (Object)parent2.getTextRange()) && (it2 instanceof RsExpr && (!(it2 instanceof RsBlockExpr) || !RsBlockExprKt.isIfElseBlock((RsBlockExpr)it2)) || it2 instanceof RsStmt))) continue;
                last$iv = element$iv;
            }
            PsiElement mostDistantParent = last$iv;
            if (mostDistantParent != null) {
                PsiElement it3 = mostDistantParent;
                boolean bl = false;
                PsiElement[] psiElementArray = new PsiElement[]{it3};
                return psiElementArray;
            }
        }
        return SearchByOffsetKt.findStatementsInRange(element1, element2);
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiElement[] findStatementsInRange(PsiElement element1, PsiElement element2) {
        RsBlock rsBlock;
        block6: {
            block5: {
                void $this$ancestorOrSelf$iv;
                PsiElement psiElement2 = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
                if (psiElement2 == null) break block5;
                PsiElement psiElement3 = psiElement2;
                boolean $i$f$ancestorOrSelf = false;
                rsBlock = (RsBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$ancestorOrSelf$iv, RsBlock.class, (boolean)false);
                if (rsBlock != null) break block6;
            }
            return new PsiElement[0];
        }
        RsBlock parent2 = rsBlock;
        int realStartOffset = PsiElementKt.getStartOffset(element1);
        int realEndOffset = PsiElementKt.getEndOffset(element2);
        PsiElement checkedElement1 = SearchByOffsetKt.getTopmostParentInside(element1, parent2);
        if (realStartOffset != PsiElementKt.getStartOffset(checkedElement1)) {
            return new PsiElement[0];
        }
        PsiElement checkedElement2 = SearchByOffsetKt.getTopmostParentInside(element2, parent2);
        if (realEndOffset != PsiElementKt.getEndOffset(checkedElement2)) {
            return new PsiElement[0];
        }
        return SearchByOffsetKt.findStatementsInRangeUnchecked(checkedElement1, checkedElement2);
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiElement[] findStatementsInRangeUnchecked(PsiElement element1, PsiElement element2) {
        PsiElement[] elements2;
        PsiElement[] $this$forEachIndexed$iv = elements2 = SearchByOffsetKt.collectElements(element1, element2.getNextSibling(), (Function1<? super PsiElement, Boolean>)((Function1)SearchByOffsetKt::findStatementsInRangeUnchecked$lambda$0));
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (PsiElement item$iv : $this$forEachIndexed$iv) {
            void element;
            int n = index$iv++;
            PsiElement psiElement2 = item$iv;
            int idx = n;
            boolean bl = false;
            if (element instanceof RsStmt || element instanceof RsMacroCall && MacroExpansionKt.getExpansionContext((RsMacroCall)element) == MacroExpansionContext.STMT || idx == elements2.length - 1 && element instanceof RsExpr || element instanceof PsiComment) continue;
            return new PsiElement[0];
        }
        return elements2;
    }

    @Nullable
    public static final Pair<PsiElement, PsiElement> getElementRange(@NotNull PsiFile $this$getElementRange, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$getElementRange, (String)"<this>");
        PsiElement psiElement2 = SearchByOffsetKt.findElementAtIgnoreWhitespaceBefore($this$getElementRange, startOffset);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement element1 = psiElement2;
        PsiElement psiElement3 = SearchByOffsetKt.findElementAtIgnoreWhitespaceAfter($this$getElementRange, endOffset - 1);
        if (psiElement3 == null) {
            return null;
        }
        PsiElement element2 = psiElement3;
        if (PsiElementKt.getStartOffset(element1) >= PsiElementKt.getEndOffset(element2)) {
            return null;
        }
        return TuplesKt.to((Object)element1, (Object)element2);
    }

    @Nullable
    public static final PsiElement findElementAtIgnoreWhitespaceBefore(@NotNull PsiFile $this$findElementAtIgnoreWhitespaceBefore, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$findElementAtIgnoreWhitespaceBefore, (String)"<this>");
        PsiElement element = $this$findElementAtIgnoreWhitespaceBefore.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            return $this$findElementAtIgnoreWhitespaceBefore.findElementAt(((PsiWhiteSpace)element).getTextRange().getEndOffset());
        }
        return element;
    }

    @Nullable
    public static final PsiElement findElementAtIgnoreWhitespaceAfter(@NotNull PsiFile $this$findElementAtIgnoreWhitespaceAfter, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$findElementAtIgnoreWhitespaceAfter, (String)"<this>");
        PsiElement element = $this$findElementAtIgnoreWhitespaceAfter.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            return $this$findElementAtIgnoreWhitespaceAfter.findElementAt(((PsiWhiteSpace)element).getTextRange().getStartOffset() - 1);
        }
        return element;
    }

    @NotNull
    public static final PsiElement getTopmostParentInside(@NotNull PsiElement $this$getTopmostParentInside, @NotNull PsiElement parent2) {
        Intrinsics.checkNotNullParameter((Object)$this$getTopmostParentInside, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        if (Intrinsics.areEqual((Object)parent2, (Object)$this$getTopmostParentInside)) {
            return $this$getTopmostParentInside;
        }
        PsiElement element = $this$getTopmostParentInside;
        while (!Intrinsics.areEqual((Object)parent2, (Object)element.getParent())) {
            Intrinsics.checkNotNullExpressionValue((Object)element.getParent(), (String)"getParent(...)");
        }
        return element;
    }

    @NotNull
    public static final PsiElement[] collectElements(@NotNull PsiElement start2, @Nullable PsiElement stop, @NotNull Function1<? super PsiElement, Boolean> pred) {
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter(pred, (String)"pred");
        if (!(stop == null || Intrinsics.areEqual((Object)start2.getParent(), (Object)stop.getParent()))) {
            throw new IllegalStateException("Check failed.");
        }
        Sequence psiSeq = SequencesKt.generateSequence((Object)start2, arg_0 -> SearchByOffsetKt.collectElements$lambda$0(stop, arg_0));
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray((Collection)SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)psiSeq, pred)));
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"toPsiElementArray(...)");
        return psiElementArray;
    }

    private static final boolean findStatementsInRangeUnchecked$lambda$0(PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return !(it2 instanceof PsiWhiteSpace);
    }

    private static final PsiElement collectElements$lambda$0(PsiElement $stop, PsiElement it2) {
        Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
        return Intrinsics.areEqual((Object)it2.getNextSibling(), (Object)$stop) ? null : it2.getNextSibling();
    }
}

