/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.utils;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.popup.PopupFactoryImpl;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.CargoConfig;
import org.rust.cargo.CargoConstants;
import org.rust.cargo.CfgOptions;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.tools.Cargo;
import org.rust.cargo.toolchain.tools.CargoKt;
import org.rust.ide.statistics.RsCfgSwitcherUsageCollector;
import org.rust.ide.typing.RsResolveContextPromoter;
import org.rust.lang.core.psi.RsFileKt;
import org.rust.stdext.RsResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ*\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/utils/RsResolveContextPopup;", "", "<init>", "()V", "createPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "modifyCfgOptions", "", "cargoProjects", "Lorg/rust/cargo/project/model/CargoProjectsService;", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "rustcTarget", "", "DefaultTargetItem", "TargetItem", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsResolveContextPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsResolveContextPopup.kt\norg/rust/ide/utils/RsResolveContextPopup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1#2:170\n*E\n"})
public final class RsResolveContextPopup {
    @NotNull
    public static final RsResolveContextPopup INSTANCE = new RsResolveContextPopup();

    private RsResolveContextPopup() {
    }

    @Nullable
    public final ListPopup createPopup(@NotNull Project project, @NotNull VirtualFile file, @NotNull DataContext context) {
        PopupFactoryImpl.ActionGroupPopup actionGroupPopup;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (RsFileKt.isNotRustFile(file) && !CargoConstants.INSTANCE.getCONFIG_FILES().contains(file.getName())) {
            return null;
        }
        if (!file.isValid()) {
            return null;
        }
        CargoProjectsService cargoProjects = CargoProjectServiceKt.getCargoProjects(project);
        CargoProject cargoProject = cargoProjects.findProjectForFile(file);
        if (cargoProject == null) {
            return null;
        }
        CargoProject cargoProject2 = cargoProject;
        Object object = cargoProject2.getRustcInfo();
        if (object == null || (object = ((RustcInfo)object).getRustcTargets()) == null) {
            return null;
        }
        Object rustcTargets = object;
        RsResolveContextPromoter.Helper.INSTANCE.getGotItTooltip().gotIt();
        Object object2 = cargoProject2.getWorkspace();
        if (object2 == null || (object2 = object2.getCargoConfig()) == null || (object2 = ((CargoConfig)object2).getBuildTargets()) == null || (object2 = (String)CollectionsKt.firstOrNull(object2)) == null) {
            Object object3 = cargoProject2.getRustcInfo();
            object2 = object3 != null && (object3 = ((RustcInfo)object3).getVersion()) != null ? ((RustcVersion)object3).getHost() : null;
        }
        List<String> defaultRustcTarget = object2;
        String currentRustcTarget = RustProjectSettingsServiceKt.getRustSettings(project).getRustcTarget();
        Object object4 = cargoProject2.getRustcInfo();
        String arch = object4 != null && (object4 = ((RustcInfo)object4).getVersion()) != null && (object4 = ((RustcVersion)object4).getHost()) != null ? StringsKt.substringBefore$default((String)object4, (String)"-", null, (int)2, null) : null;
        DefaultActionGroup group2 = new DefaultActionGroup();
        if (rustcTargets.size() > 1) {
            List list;
            Object object5;
            group2.add((AnAction)new DefaultTargetItem((String)((Object)defaultRustcTarget), project, cargoProjects, cargoProject2, currentRustcTarget == null));
            if (arch != null) {
                object5 = new String[]{arch + "-unknown-linux-gnu", arch + "-pc-windows-msvc", arch + "-apple-darwin"};
                list = CollectionsKt.listOf((Object[])object5);
            } else {
                list = CollectionsKt.emptyList();
            }
            List popularRustcTargets = list;
            for (String popularRustcTarget : popularRustcTargets) {
                if (!rustcTargets.contains(popularRustcTarget) || Intrinsics.areEqual((Object)popularRustcTarget, defaultRustcTarget)) continue;
                group2.add((AnAction)new TargetItem(popularRustcTarget, project, cargoProjects, cargoProject2, Intrinsics.areEqual((Object)popularRustcTarget, (Object)currentRustcTarget)));
            }
            group2.add((AnAction)Separator.getInstance());
            object5 = rustcTargets.iterator();
            while (object5.hasNext()) {
                String rustcTarget = (String)object5.next();
                if (popularRustcTargets.contains(rustcTarget) || Intrinsics.areEqual((Object)rustcTarget, defaultRustcTarget)) continue;
                group2.add((AnAction)new TargetItem(rustcTarget, project, cargoProjects, cargoProject2, Intrinsics.areEqual((Object)rustcTarget, (Object)currentRustcTarget)));
            }
        }
        PopupFactoryImpl.ActionGroupPopup $this$createPopup_u24lambda_u242 = actionGroupPopup = new PopupFactoryImpl.ActionGroupPopup(RsBundle.INSTANCE.message("resolve.contexts.popup.header", new Object[0]), (ActionGroup)group2, context, false, true, true, false, null, 10, arg_0 -> RsResolveContextPopup.createPopup$lambda$1(arg_0 -> RsResolveContextPopup.createPopup$lambda$0(currentRustcTarget, arg_0), arg_0), null);
        boolean bl = false;
        $this$createPopup_u24lambda_u242.setAdText(RsBundle.INSTANCE.message("resolve.contexts.popup.footer", new Object[0]), 10);
        return (ListPopup)actionGroupPopup;
    }

    private final void modifyCfgOptions(Project project, CargoProjectsService cargoProjects, CargoProject cargoProject, String rustcTarget) {
        cargoProjects.modifyCfgOptions(cargoProject, (Function0<? extends CompletableFuture<CfgOptions>>)((Function0)() -> RsResolveContextPopup.modifyCfgOptions$lambda$0(project, cargoProject, rustcTarget)));
    }

    private static final boolean createPopup$lambda$0(String $currentRustcTarget, AnAction action2) {
        TargetItem targetItem = action2 instanceof TargetItem ? (TargetItem)action2 : null;
        return Intrinsics.areEqual((Object)(targetItem != null ? targetItem.getRustcTarget() : null), (Object)$currentRustcTarget);
    }

    private static final boolean createPopup$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CompletableFuture modifyCfgOptions$lambda$0(Project $project, CargoProject $cargoProject, String $rustcTarget) {
        CompletableFuture<CfgOptions> future = new CompletableFuture<CfgOptions>();
        Task.Backgroundable task2 = new Task.Backgroundable($project, future, $cargoProject, $rustcTarget){
            final /* synthetic */ Project $project;
            final /* synthetic */ CompletableFuture<CfgOptions> $future;
            final /* synthetic */ CargoProject $cargoProject;
            final /* synthetic */ String $rustcTarget;
            {
                this.$project = $project;
                this.$future = $future;
                this.$cargoProject = $cargoProject;
                this.$rustcTarget = $rustcTarget;
                super($project, "This message should not be visible", false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Object object = RustProjectSettingsServiceKt.getToolchain(this.$project);
                this.$future.complete(object != null && (object = CargoKt.cargo((RsToolchainBase)object)) != null && (object = ((Cargo)object).getCfgOption(this.$project, this.$cargoProject.getRootDirPath(), this.$rustcTarget)) != null ? ((RsResult)object).ok() : null);
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new EmptyProgressIndicator());
        return future;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B3\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/utils/RsResolveContextPopup$DefaultTargetItem;", "Lcom/intellij/openapi/actionSystem/AnAction;", "rustcTarget", "", "project", "Lcom/intellij/openapi/project/Project;", "cargoProjects", "Lorg/rust/cargo/project/model/CargoProjectsService;", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "isSelected", "", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/rust/cargo/project/model/CargoProjectsService;Lorg/rust/cargo/project/model/CargoProject;Z)V", "getRustcTarget", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rustrover.core"})
    private static final class DefaultTargetItem
    extends AnAction {
        @Nullable
        private final String rustcTarget;
        @NotNull
        private final Project project;
        @NotNull
        private final CargoProjectsService cargoProjects;
        @NotNull
        private final CargoProject cargoProject;

        public DefaultTargetItem(@NlsActions.ActionText @Nullable String rustcTarget, @NotNull Project project, @NotNull CargoProjectsService cargoProjects, @NotNull CargoProject cargoProject, boolean isSelected) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cargoProjects, (String)"cargoProjects");
            Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
            this.rustcTarget = rustcTarget;
            this.project = project;
            this.cargoProjects = cargoProjects;
            this.cargoProject = cargoProject;
            String string = this.rustcTarget;
            if (string == null) {
                string = "<unknown>";
            }
            String text = string + " (default)";
            this.getTemplatePresentation().setText(text, false);
            if (isSelected) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Nullable
        public final String getRustcTarget() {
            return this.rustcTarget;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RsCfgSwitcherUsageCollector.INSTANCE.logRustcTargetSelected(null);
            INSTANCE.modifyCfgOptions(this.project, this.cargoProjects, this.cargoProject, null);
            RustProjectSettingsServiceKt.getRustSettings(this.project).modify(DefaultTargetItem::actionPerformed$lambda$0);
        }

        private static final Unit actionPerformed$lambda$0(RustProjectSettingsService.RustProjectSettings it2) {
            Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
            it2.setRustcTarget(null);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/utils/RsResolveContextPopup$TargetItem;", "Lcom/intellij/openapi/actionSystem/AnAction;", "rustcTarget", "", "project", "Lcom/intellij/openapi/project/Project;", "cargoProjects", "Lorg/rust/cargo/project/model/CargoProjectsService;", "cargoProject", "Lorg/rust/cargo/project/model/CargoProject;", "isSelected", "", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/rust/cargo/project/model/CargoProjectsService;Lorg/rust/cargo/project/model/CargoProject;Z)V", "getRustcTarget", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rustrover.core"})
    private static final class TargetItem
    extends AnAction {
        @NotNull
        private final String rustcTarget;
        @NotNull
        private final Project project;
        @NotNull
        private final CargoProjectsService cargoProjects;
        @NotNull
        private final CargoProject cargoProject;

        public TargetItem(@NlsActions.ActionText @NotNull String rustcTarget, @NotNull Project project, @NotNull CargoProjectsService cargoProjects, @NotNull CargoProject cargoProject, boolean isSelected) {
            Intrinsics.checkNotNullParameter((Object)rustcTarget, (String)"rustcTarget");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)cargoProjects, (String)"cargoProjects");
            Intrinsics.checkNotNullParameter((Object)cargoProject, (String)"cargoProject");
            this.rustcTarget = rustcTarget;
            this.project = project;
            this.cargoProjects = cargoProjects;
            this.cargoProject = cargoProject;
            String text = this.rustcTarget;
            this.getTemplatePresentation().setText(text, false);
            if (isSelected) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @NotNull
        public final String getRustcTarget() {
            return this.rustcTarget;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RsCfgSwitcherUsageCollector.INSTANCE.logRustcTargetSelected(this.rustcTarget);
            INSTANCE.modifyCfgOptions(this.project, this.cargoProjects, this.cargoProject, this.rustcTarget);
            RustProjectSettingsServiceKt.getRustSettings(this.project).modify(arg_0 -> TargetItem.actionPerformed$lambda$0(this, arg_0));
        }

        private static final Unit actionPerformed$lambda$0(TargetItem this$0, RustProjectSettingsService.RustProjectSettings it2) {
            Intrinsics.checkNotNullParameter((Object)((Object)it2), (String)"it");
            it2.setRustcTarget(this$0.rustcTarget);
            return Unit.INSTANCE;
        }
    }
}

