/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.utils;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.lang.core.macros.RsExpandedElementKt;
import org.rust.lang.core.psi.ext.RsPossibleMacroCall;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\b\u00a8\u0006\u000e"}, d2={"Lorg/rust/ide/utils/PsiModificationUtil;", "", "<init>", "()V", "canReplaceAll", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "([Lcom/intellij/psi/PsiElement;)Z", "", "canReplace", "element", "isWriteableRegardlessMacros", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nPsiModificationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiModificationUtil.kt\norg/rust/ide/utils/PsiModificationUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 utils.kt\norg/rust/openapiext/UtilsKt\n*L\n1#1,58:1\n12767#2,2:59\n1740#3,3:61\n305#4,10:64\n*S KotlinDebug\n*F\n+ 1 PsiModificationUtil.kt\norg/rust/ide/utils/PsiModificationUtil\n*L\n21#1:59,2\n25#1:61,3\n39#1:64,10\n*E\n"})
public final class PsiModificationUtil {
    @NotNull
    public static final PsiModificationUtil INSTANCE = new PsiModificationUtil();

    private PsiModificationUtil() {
    }

    public final boolean canReplaceAll(PsiElement ... elements2) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)elements2, (String)"elements");
            PsiElement[] $this$all$iv = elements2;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int j = 0; j < n; ++j) {
                PsiElement element$iv;
                PsiElement it2 = element$iv = $this$all$iv[j];
                boolean bl2 = false;
                if (INSTANCE.canReplace(it2)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public final boolean canReplaceAll(@NotNull List<? extends PsiElement> elements2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements2, (String)"elements");
            Iterable $this$all$iv = elements2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (INSTANCE.canReplace(it2)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean canReplace(@NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        RsPossibleMacroCall macroCall = RsExpandedElementKt.findMacroCallExpandedFrom(element);
        if (macroCall == null) {
            bl = this.isWriteableRegardlessMacros(element);
        } else {
            TextRange textRange = element.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            TextRange sourceRange = RsExpandedElementKt.mapRangeFromExpansionToCallBodyStrict(element, textRange);
            bl = sourceRange != null && this.isWriteableRegardlessMacros(macroCall);
        }
        return bl;
    }

    public final boolean isWriteableRegardlessMacros(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean $i$f$testAssert = false;
        boolean $i$f$testAssert2 = false;
        if (UtilsKt.isUnitTestMode()) {
            boolean bl = false;
            if (!(!RsExpandedElementKt.isExpandedFromMacro(element))) {
                boolean bl2 = false;
                String message$iv$iv = "Assertion failed";
                throw new AssertionError((Object)message$iv$iv);
            }
        }
        if (!BaseIntentionAction.canModify((PsiElement)element)) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        VirtualFile virtualFile2 = virtualFile instanceof LightVirtualFile ? ((LightVirtualFile)virtualFile).getOriginalFile() : (virtualFile instanceof VirtualFileWindow ? ((VirtualFileWindow)virtualFile).getDelegate() : virtualFile);
        if (virtualFile2 == null) {
            return true;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Project project = containingFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return !CargoProjectServiceKt.isGeneratedFile(CargoProjectServiceKt.getCargoProjects(project), virtualFile3);
    }
}

