/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.psi.RsBinaryExpr;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsLitExpr;
import org.rust.lang.core.psi.RsOuterAttributedExpr;
import org.rust.lang.core.psi.RsParenExpr;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsUnaryExpr;
import org.rust.lang.core.psi.ext.BinaryOperator;
import org.rust.lang.core.psi.ext.BoolOp;
import org.rust.lang.core.psi.ext.ComparisonOp;
import org.rust.lang.core.psi.ext.EqualityOp;
import org.rust.lang.core.psi.ext.LogicOp;
import org.rust.lang.core.psi.ext.RsExprKt;
import org.rust.lang.core.psi.ext.UnaryOperator;
import org.rust.lang.core.types.consts.CtValueKt;
import org.rust.lang.core.types.ty.TyBool;
import org.rust.lang.utils.RsBooleanExpUtilsKt;
import org.rust.lang.utils.evaluation.ConstExprEvaluatorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\"\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/utils/BooleanExprSimplifier;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "factory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "simplify", "Lorg/rust/lang/core/psi/RsExpr;", "expr", "simplifyBinaryOperation", "op", "Lorg/rust/lang/core/psi/ext/BinaryOperator;", "const", "Lorg/rust/lang/core/psi/RsLitExpr;", "Companion", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nBooleanExprSimplifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BooleanExprSimplifier.kt\norg/rust/ide/utils/BooleanExprSimplifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class BooleanExprSimplifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final RsPsiFactory factory;

    public BooleanExprSimplifier(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.factory = new RsPsiFactory(this.project, false, false, 6, null);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final RsExpr simplify(@NotNull RsExpr expr) {
        RsExpr rsExpr;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        if (expr instanceof RsLitExpr) {
            return null;
        }
        Boolean value = BooleanExprSimplifier.Companion.eval(expr);
        if (value != null) {
            return this.factory.createExpression(String.valueOf(value));
        }
        RsExpr rsExpr2 = expr;
        if (rsExpr2 instanceof RsBinaryExpr) {
            RsExpr rsExpr3;
            RsExpr lhs;
            RsExpr rsExpr4 = ((RsBinaryExpr)expr).getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)rsExpr4, (String)"getLeft(...)");
            RsExpr left = rsExpr4;
            RsExpr rsExpr5 = ((RsBinaryExpr)expr).getRight();
            if (rsExpr5 == null) {
                return null;
            }
            RsExpr right = rsExpr5;
            BinaryOperator op = RsExprKt.getOperatorType((RsBinaryExpr)expr);
            RsExpr rsExpr6 = this.simplify(left);
            if (rsExpr6 == null) {
                rsExpr6 = lhs = left;
            }
            if ((rsExpr3 = this.simplify(right)) == null) {
                rsExpr3 = right;
            }
            RsExpr rhs = rsExpr3;
            rsExpr = lhs instanceof RsLitExpr ? this.simplifyBinaryOperation(op, (RsLitExpr)lhs, rhs) : (rhs instanceof RsLitExpr ? this.simplifyBinaryOperation(op, (RsLitExpr)rhs, lhs) : this.factory.createExpression(lhs.getText() + " " + ((RsBinaryExpr)expr).getBinaryOp().getText() + " " + rhs.getText()));
        } else if (rsExpr2 instanceof RsUnaryExpr) {
            RsExpr rsExpr7 = ((RsUnaryExpr)expr).getExpr();
            RsParenExpr rsParenExpr = rsExpr7 instanceof RsParenExpr ? (RsParenExpr)rsExpr7 : null;
            if (rsParenExpr == null) {
                return expr;
            }
            RsParenExpr parenExpr = rsParenExpr;
            RsExpr interior = parenExpr.getExpr();
            if (RsExprKt.getOperatorType((RsUnaryExpr)expr) == UnaryOperator.NOT && interior instanceof RsBinaryExpr) {
                PsiElement psiElement2 = RsBooleanExpUtilsKt.negate(interior);
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsExpr");
                rsExpr = (RsExpr)psiElement2;
            } else {
                rsExpr = null;
            }
        } else if (rsExpr2 instanceof RsParenExpr) {
            RsExpr wrapped = ((RsParenExpr)expr).getExpr();
            if (wrapped != null) {
                RsExpr interiorSimplified;
                RsExpr rsExpr8 = interiorSimplified = this.simplify(wrapped);
                if (rsExpr8 != null) {
                    RsExpr it2 = rsExpr8;
                    boolean bl = false;
                    rsExpr = this.factory.createExpression("(" + it2.getText() + ")");
                } else {
                    rsExpr = null;
                }
            } else {
                rsExpr = null;
            }
        } else {
            rsExpr = null;
        }
        return rsExpr;
    }

    private final RsExpr simplifyBinaryOperation(BinaryOperator op, RsLitExpr rsLitExpr, RsExpr expr) {
        Object object = rsLitExpr.getBoolLiteral();
        if (object == null || (object = object.getText()) == null) {
            return null;
        }
        Object literal = object;
        BinaryOperator binaryOperator = op;
        return Intrinsics.areEqual((Object)binaryOperator, (Object)LogicOp.AND.INSTANCE) ? (Intrinsics.areEqual((Object)literal, (Object)"false") ? this.factory.createExpression("false") : expr) : (Intrinsics.areEqual((Object)binaryOperator, (Object)LogicOp.OR.INSTANCE) ? (Intrinsics.areEqual((Object)literal, (Object)"true") ? this.factory.createExpression("true") : expr) : (Intrinsics.areEqual((Object)binaryOperator, (Object)EqualityOp.EQ.INSTANCE) ? (Intrinsics.areEqual((Object)literal, (Object)"false") ? this.factory.createExpression("!" + expr.getText()) : expr) : (Intrinsics.areEqual((Object)binaryOperator, (Object)EqualityOp.EXCLEQ.INSTANCE) ? (Intrinsics.areEqual((Object)literal, (Object)"true") ? this.factory.createExpression("!" + expr.getText()) : expr) : null)));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0017\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/utils/BooleanExprSimplifier$Companion;", "", "<init>", "()V", "canBeSimplified", "", "expr", "Lorg/rust/lang/core/psi/RsExpr;", "canBeEvaluated", "eval", "(Lorg/rust/lang/core/psi/RsExpr;)Ljava/lang/Boolean;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canBeSimplified(@NotNull RsExpr expr) {
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            if (expr instanceof RsLitExpr) {
                return false;
            }
            if (this.canBeEvaluated(expr)) {
                return true;
            }
            RsExpr rsExpr = expr;
            if (rsExpr instanceof RsBinaryExpr) {
                RsExpr rsExpr2 = ((RsBinaryExpr)expr).getLeft();
                Intrinsics.checkNotNullExpressionValue((Object)rsExpr2, (String)"getLeft(...)");
                RsExpr left = rsExpr2;
                RsExpr rsExpr3 = ((RsBinaryExpr)expr).getRight();
                if (rsExpr3 == null) {
                    return false;
                }
                RsExpr right = rsExpr3;
                Object[] objectArray = new BoolOp[]{LogicOp.AND.INSTANCE, LogicOp.OR.INSTANCE, EqualityOp.EQ.INSTANCE, EqualityOp.EXCLEQ.INSTANCE};
                if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)RsExprKt.getOperatorType((RsBinaryExpr)expr))) {
                    if (this.canBeSimplified(left) || this.canBeSimplified(right)) {
                        return true;
                    }
                    if (this.canBeEvaluated(left) || this.canBeEvaluated(right)) {
                        return true;
                    }
                }
            } else {
                if (rsExpr instanceof RsParenExpr) {
                    RsExpr wrapped = ((RsParenExpr)expr).getExpr();
                    return wrapped != null && this.canBeSimplified(wrapped);
                }
                if (rsExpr instanceof RsOuterAttributedExpr) {
                    RsExpr wrapped = ((RsOuterAttributedExpr)expr).getExpr();
                    return wrapped != null && this.canBeSimplified(wrapped);
                }
                if (rsExpr instanceof RsUnaryExpr) {
                    if (RsExprKt.getOperatorType((RsUnaryExpr)expr) != UnaryOperator.NOT) {
                        return false;
                    }
                    RsExpr rsExpr4 = ((RsUnaryExpr)expr).getExpr();
                    RsParenExpr rsParenExpr = rsExpr4 instanceof RsParenExpr ? (RsParenExpr)rsExpr4 : null;
                    if (rsParenExpr == null) {
                        return false;
                    }
                    RsParenExpr parenExpr = rsParenExpr;
                    RsExpr rsExpr5 = parenExpr.getExpr();
                    Object object = rsExpr5 instanceof RsBinaryExpr ? (RsBinaryExpr)rsExpr5 : null;
                    if (object == null || (object = RsExprKt.getOperatorType((RsBinaryExpr)object)) == null) {
                        return false;
                    }
                    Object binOp = object;
                    return binOp instanceof EqualityOp || binOp instanceof ComparisonOp;
                }
            }
            return false;
        }

        private final boolean canBeEvaluated(RsExpr expr) {
            return this.eval(expr) != null;
        }

        private final Boolean eval(RsExpr expr) {
            return CtValueKt.asBool(ConstExprEvaluatorKt.evaluate(expr, TyBool.Companion.getINSTANCE(), null));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

