/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing.paste;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.statistics.RsConvertJsonToStructUsagesCollector;
import org.rust.ide.typing.paste.JsonStructParserKt;
import org.rust.ide.typing.paste.PotentialJsonTransferableData;
import org.rust.ide.typing.paste.RsConvertJsonToStructCopyPasteProcessorKt;
import org.rust.ide.typing.paste.Struct;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.ext.RsMod;
import org.rust.lang.core.resolve2.FacadeMetaInfoKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JF\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016\u00a8\u0006\u001d"}, d2={"Lorg/rust/ide/typing/paste/RsConvertJsonToStructCopyPasteProcessor;", "Lcom/intellij/codeInsight/editorActions/CopyPastePostProcessor;", "Lcom/intellij/codeInsight/editorActions/TextBlockTransferableData;", "<init>", "()V", "collectTransferableData", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startOffsets", "", "endOffsets", "extractTransferableData", "content", "Ljava/awt/datatransfer/Transferable;", "processTransferableData", "", "project", "Lcom/intellij/openapi/project/Project;", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "caretOffset", "", "indented", "Lcom/intellij/openapi/util/Ref;", "", "values", "intellij.rustrover.core"})
public final class RsConvertJsonToStructCopyPasteProcessor
extends CopyPastePostProcessor<TextBlockTransferableData> {
    @NotNull
    public List<TextBlockTransferableData> collectTransferableData(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)startOffsets, (String)"startOffsets");
        Intrinsics.checkNotNullParameter((Object)endOffsets, (String)"endOffsets");
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<TextBlockTransferableData> extractTransferableData(@NotNull Transferable content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        try {
            if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                Object object = content.getTransferData(DataFlavor.stringFlavor);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String text = (String)object;
                return CollectionsKt.listOf((Object)new PotentialJsonTransferableData(text));
            }
            return CollectionsKt.emptyList();
        }
        catch (Throwable e) {
            return CollectionsKt.emptyList();
        }
    }

    public void processTransferableData(@NotNull Project project, @NotNull Editor editor2, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<? super Boolean> indented, @NotNull List<? extends TextBlockTransferableData> values) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(indented, (String)"indented");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        PsiFile psiFile = UtilsKt.toPsiFile(document, project);
        RsFile rsFile = psiFile instanceof RsFile ? (RsFile)psiFile : null;
        if (rsFile == null) {
            return;
        }
        RsFile file = rsFile;
        Object object = CollectionsKt.getOrNull(values, (int)0);
        PotentialJsonTransferableData potentialJsonTransferableData = object instanceof PotentialJsonTransferableData ? (PotentialJsonTransferableData)object : null;
        if (potentialJsonTransferableData == null) {
            return;
        }
        PotentialJsonTransferableData data2 = potentialJsonTransferableData;
        String text = data2.getText();
        PsiElement elementAtCaret = file.findElementAt(caretOffset);
        if (elementAtCaret != null && !(elementAtCaret.getParent() instanceof RsMod)) {
            return;
        }
        List<Struct> list = JsonStructParserKt.extractStructsFromJson(text);
        if (list == null) {
            return;
        }
        List<Struct> structs = list;
        RsConvertJsonToStructUsagesCollector.INSTANCE.logJsonTextPasted(project);
        if (!RsConvertJsonToStructCopyPasteProcessorKt.access$shouldConvertJson(project)) {
            return;
        }
        RsPsiFactory factory2 = new RsPsiFactory(project, false, false, 6, null);
        PsiElement psiElement2 = elementAtCaret;
        Object object2 = psiElement2 != null ? psiElement2.getParent() : null;
        RsMod rsMod = object2 instanceof RsMod ? (RsMod)object2 : null;
        if (rsMod == null) {
            rsMod = file;
        }
        RsMod parentMod = rsMod;
        Set<String> existingNames = FacadeMetaInfoKt.allScopeItemNames(parentMod);
        Map nameMap = RsConvertJsonToStructCopyPasteProcessorKt.access$generateStructNames(structs, existingNames);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        List insertedItems = new ArrayList();
        boolean hasSerdeDependency = RsConvertJsonToStructCopyPasteProcessorKt.access$hasSerdeDependency(file);
        ActionsKt.runWriteAction(() -> RsConvertJsonToStructCopyPasteProcessor.processTransferableData$lambda$0(editor2, bounds, psiDocumentManager, file, caretOffset, structs, factory2, nameMap, hasSerdeDependency, insertedItems));
        if (!((Collection)insertedItems).isEmpty()) {
            RsConvertJsonToStructCopyPasteProcessorKt.access$replacePlaceholders(editor2, insertedItems, nameMap, file);
        }
        RsConvertJsonToStructUsagesCollector.INSTANCE.logPastedJsonConverted(project);
    }

    private static final Unit processTransferableData$lambda$0(Editor $editor, RangeMarker $bounds, PsiDocumentManager $psiDocumentManager, RsFile $file, int $caretOffset, List $structs, RsPsiFactory $factory, Map $nameMap, boolean $hasSerdeDependency, List $insertedItems) {
        $editor.getDocument().deleteString($bounds.getStartOffset(), $bounds.getEndOffset());
        $psiDocumentManager.commitDocument($editor.getDocument());
        PsiElement element = $file.findElementAt($caretOffset);
        PsiElement psiElement2 = element;
        if (psiElement2 == null || (psiElement2 = psiElement2.getParent()) == null) {
            psiElement2 = $file;
        }
        PsiElement parent2 = psiElement2;
        PsiElement anchor = element;
        for (Struct struct : $structs) {
            RsStructItem inserted;
            if (RsConvertJsonToStructCopyPasteProcessorKt.access$createAndInsertStruct($factory, anchor, parent2, struct, $nameMap, $hasSerdeDependency) == null) continue;
            anchor = inserted;
            $insertedItems.add(UtilsKt.createSmartPointer((PsiElement)inserted));
        }
        return Unit.INSTANCE;
    }
}

