/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing.paste;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.inspections.import.AutoImportFix;
import org.rust.ide.inspections.import.AutoImportFixContext;
import org.rust.ide.typing.paste.CandidateToImport;
import org.rust.ide.typing.paste.QualifiedItemPath;
import org.rust.ide.typing.paste.RsImportCopyPasteProcessorKt;
import org.rust.ide.utils.import.ImportCandidate;
import org.rust.ide.utils.import.ImportContext;
import org.rust.ide.utils.import.ImportInfo;
import org.rust.lang.core.psi.RsMethodCall;
import org.rust.lang.core.psi.RsPatBinding;
import org.rust.lang.core.psi.RsPath;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.lang.core.psi.ext.RsQualifiedNamedElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bJ\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016H\u0002J&\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/rust/ide/typing/paste/ImportingProcessor;", "", "shouldQualifyPath", "", "<init>", "(Z)V", "processPath", "Lorg/rust/ide/typing/paste/CandidateToImport;", "path", "Lorg/rust/lang/core/psi/RsPath;", "importMapCandidate", "Lorg/rust/ide/typing/paste/QualifiedItemPath;", "processMethodCall", "Lorg/rust/ide/typing/paste/CandidateToImport$ElImportCandidate;", "methodCall", "Lorg/rust/lang/core/psi/RsMethodCall;", "processPatBinding", "binding", "Lorg/rust/lang/core/psi/RsPatBinding;", "getImportCandidate", "Lorg/rust/ide/utils/import/ImportCandidate;", "getCtx", "Lkotlin/Function0;", "Lorg/rust/ide/inspections/import/AutoImportFixContext;", "getQualifyCandidate", "Lkotlin/Pair;", "Lorg/rust/ide/utils/import/ImportInfo;", "element", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsImportCopyPasteProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsImportCopyPasteProcessor.kt\norg/rust/ide/typing/paste/ImportingProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,494:1\n1#2:495\n*E\n"})
final class ImportingProcessor {
    private final boolean shouldQualifyPath;

    public ImportingProcessor(boolean shouldQualifyPath) {
        this.shouldQualifyPath = shouldQualifyPath;
    }

    @Nullable
    public final CandidateToImport processPath(@NotNull RsPath path, @NotNull QualifiedItemPath importMapCandidate) {
        CandidateToImport candidateToImport;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)importMapCandidate, (String)"importMapCandidate");
        ImportCandidate importCandidate = this.getImportCandidate(importMapCandidate, (Function0<AutoImportFixContext>)((Function0)() -> ImportingProcessor.processPath$lambda$0(path)));
        if (importCandidate != null) {
            return new CandidateToImport.ElImportCandidate(importCandidate);
        }
        if (this.shouldQualifyPath) {
            CandidateToImport.PathQualifyCandidate pathQualifyCandidate;
            Pair<RsPath, ImportInfo> pair = this.getQualifyCandidate(path, importMapCandidate);
            if (pair != null) {
                Pair<RsPath, ImportInfo> it2 = pair;
                boolean bl = false;
                pathQualifyCandidate = new CandidateToImport.PathQualifyCandidate(it2);
            } else {
                pathQualifyCandidate = null;
            }
            candidateToImport = pathQualifyCandidate;
        } else {
            candidateToImport = null;
        }
        return candidateToImport;
    }

    @Nullable
    public final CandidateToImport.ElImportCandidate processMethodCall(@NotNull RsMethodCall methodCall, @NotNull QualifiedItemPath importMapCandidate) {
        CandidateToImport.ElImportCandidate elImportCandidate;
        Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
        Intrinsics.checkNotNullParameter((Object)importMapCandidate, (String)"importMapCandidate");
        ImportCandidate importCandidate = this.getImportCandidate(importMapCandidate, (Function0<AutoImportFixContext>)((Function0)() -> ImportingProcessor.processMethodCall$lambda$0(methodCall)));
        if (importCandidate != null) {
            ImportCandidate it2 = importCandidate;
            boolean bl = false;
            elImportCandidate = new CandidateToImport.ElImportCandidate(it2);
        } else {
            elImportCandidate = null;
        }
        return elImportCandidate;
    }

    @Nullable
    public final CandidateToImport.ElImportCandidate processPatBinding(@NotNull RsPatBinding binding, @NotNull QualifiedItemPath importMapCandidate) {
        CandidateToImport.ElImportCandidate elImportCandidate;
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)importMapCandidate, (String)"importMapCandidate");
        ImportCandidate importCandidate = this.getImportCandidate(importMapCandidate, (Function0<AutoImportFixContext>)((Function0)() -> ImportingProcessor.processPatBinding$lambda$0(binding)));
        if (importCandidate != null) {
            ImportCandidate it2 = importCandidate;
            boolean bl = false;
            elImportCandidate = new CandidateToImport.ElImportCandidate(it2);
        } else {
            elImportCandidate = null;
        }
        return elImportCandidate;
    }

    private final ImportCandidate getImportCandidate(QualifiedItemPath importMapCandidate, Function0<AutoImportFixContext> getCtx) {
        AutoImportFixContext ctx = (AutoImportFixContext)getCtx.invoke();
        return RsImportCopyPasteProcessorKt.access$getCandidate(ctx, importMapCandidate);
    }

    private final Pair<RsPath, ImportInfo> getQualifyCandidate(RsPath element, QualifiedItemPath importMapCandidate) {
        Object object = element.getReference();
        if (object == null || (object = object.multiResolve()) == null) {
            return null;
        }
        Object resolvedTargets = object;
        if (resolvedTargets.isEmpty()) {
            Integer n = RsElementKt.getContainingCrate(element).getId();
            if (n != null && importMapCandidate.getCrateId() == n.intValue()) {
                ImportInfo.LocalImportInfo importInfo = new ImportInfo.LocalImportInfo("crate" + importMapCandidate.getCrateRelativePath());
                return TuplesKt.to((Object)element, (Object)importInfo);
            }
        } else {
            RsQualifiedNamedElement resolvedTarget;
            Object object2 = CollectionsKt.singleOrNull((List)resolvedTargets);
            RsQualifiedNamedElement rsQualifiedNamedElement = resolvedTarget = object2 instanceof RsQualifiedNamedElement ? (RsQualifiedNamedElement)object2 : null;
            if (importMapCandidate.matches(resolvedTarget)) {
                return null;
            }
            AutoImportFixContext otherCtx = AutoImportFix.Companion.findApplicableContext$default(AutoImportFix.Companion, element, ImportContext.Type.OTHER, false, 4, null);
            ImportCandidate importCandidate = RsImportCopyPasteProcessorKt.access$getCandidate(otherCtx, importMapCandidate);
            if (importCandidate == null) {
                return null;
            }
            ImportCandidate otherCandidate = importCandidate;
            return TuplesKt.to((Object)element, (Object)otherCandidate.getInfo());
        }
        return null;
    }

    private static final AutoImportFixContext processPath$lambda$0(RsPath $path) {
        return AutoImportFix.Companion.findApplicableContext$default(AutoImportFix.Companion, $path, null, false, 6, null);
    }

    private static final AutoImportFixContext processMethodCall$lambda$0(RsMethodCall $methodCall) {
        return AutoImportFix.Companion.findApplicableContext($methodCall);
    }

    private static final AutoImportFixContext processPatBinding$lambda$0(RsPatBinding $binding) {
        return AutoImportFix.Companion.findApplicableContext($binding);
    }
}

