/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing.paste;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.typing.paste.DataType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/rust/ide/typing/paste/DataTypeVisitor;", "", "<init>", "()V", "visit", "", "dataType", "Lorg/rust/ide/typing/paste/DataType;", "visitArray", "Lorg/rust/ide/typing/paste/DataType$Array;", "visitNullable", "Lorg/rust/ide/typing/paste/DataType$Nullable;", "visitStruct", "Lorg/rust/ide/typing/paste/DataType$StructRef;", "visitInteger", "Lorg/rust/ide/typing/paste/DataType$Integer;", "visitFloat", "Lorg/rust/ide/typing/paste/DataType$Float;", "visitBoolean", "Lorg/rust/ide/typing/paste/DataType$Boolean;", "visitString", "Lorg/rust/ide/typing/paste/DataType$String;", "visitUnknown", "Lorg/rust/ide/typing/paste/DataType$Unknown;", "intellij.rustrover.core"})
public class DataTypeVisitor {
    public void visit(@NotNull DataType dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        DataType dataType2 = dataType;
        if (dataType2 instanceof DataType.Array) {
            this.visitArray((DataType.Array)dataType);
        } else if (dataType2 instanceof DataType.Nullable) {
            this.visitNullable((DataType.Nullable)dataType);
        } else if (dataType2 instanceof DataType.StructRef) {
            this.visitStruct((DataType.StructRef)dataType);
        } else if (dataType2 instanceof DataType.Boolean) {
            this.visitBoolean((DataType.Boolean)dataType);
        } else if (dataType2 instanceof DataType.Float) {
            this.visitFloat((DataType.Float)dataType);
        } else if (dataType2 instanceof DataType.Integer) {
            this.visitInteger((DataType.Integer)dataType);
        } else if (dataType2 instanceof DataType.String) {
            this.visitString((DataType.String)dataType);
        } else if (dataType2 instanceof DataType.Unknown) {
            this.visitUnknown((DataType.Unknown)dataType);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public void visitArray(@NotNull DataType.Array dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        this.visit(dataType.getType());
    }

    public void visitNullable(@NotNull DataType.Nullable dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        this.visit(dataType.getType());
    }

    public void visitStruct(@NotNull DataType.StructRef dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        Iterator<DataType> iterator2 = dataType.getStruct().getFields().values().iterator();
        while (iterator2.hasNext()) {
            DataType fieldType;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            this.visit(fieldType);
        }
    }

    public void visitInteger(@NotNull DataType.Integer dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
    }

    public void visitFloat(@NotNull DataType.Float dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
    }

    public void visitBoolean(@NotNull DataType.Boolean dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
    }

    public void visitString(@NotNull DataType.String dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
    }

    public void visitUnknown(@NotNull DataType.Unknown dataType) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
    }
}

