/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing.assist;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.typing.assist.AfterFunctionOrStructEnterProcessor;
import org.rust.ide.typing.assist.AfterSemicolonEnterProcessor;
import org.rust.ide.typing.assist.CommaFixer;
import org.rust.ide.typing.assist.FunctionOrStructFixer;
import org.rust.ide.typing.assist.MethodCallFixer;
import org.rust.ide.typing.assist.SemicolonFixer;
import org.rust.lang.core.psi.RsBlock;
import org.rust.lang.core.psi.RsConstant;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsExternCrateItem;
import org.rust.lang.core.psi.RsFunction;
import org.rust.lang.core.psi.RsMatchArm;
import org.rust.lang.core.psi.RsStructItem;
import org.rust.lang.core.psi.RsTraitAlias;
import org.rust.lang.core.psi.RsTypeAlias;
import org.rust.lang.core.psi.ext.PsiElementKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0014\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/typing/assist/RsSmartEnterProcessor;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers;", "<init>", "()V", "getStatementAtCaret", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "doNotStepInto", "", "element", "processDefaultEnter", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "PlainEnterProcessor", "Helper", "intellij.rustrover.core"})
public final class RsSmartEnterProcessor
extends SmartEnterProcessorWithFixers {
    public RsSmartEnterProcessor() {
        SmartEnterProcessorWithFixers.Fixer[] fixerArray = new SmartEnterProcessorWithFixers.Fixer[]{new MethodCallFixer(), new SemicolonFixer(), new CommaFixer(), new FunctionOrStructFixer()};
        this.addFixers(fixerArray);
        fixerArray = new SmartEnterProcessorWithFixers.FixEnterProcessor[]{new AfterSemicolonEnterProcessor(), new AfterFunctionOrStructEnterProcessor(), new PlainEnterProcessor()};
        this.addEnterProcessors((SmartEnterProcessorWithFixers.FixEnterProcessor[])fixerArray);
    }

    @Nullable
    protected PsiElement getStatementAtCaret(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiElement psiElement2 = super.getStatementAtCaret(editor2, psiFile);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement atCaret = psiElement2;
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        for (PsiElement element : PsiElementKt.getAncestors(atCaret)) {
            boolean stopAtParent;
            IElementType elementType;
            Intrinsics.checkNotNullExpressionValue((Object)element.getNode().getElementType(), (String)"getElementType(...)");
            if (Intrinsics.areEqual((Object)elementType, (Object)RsElementTypes.LBRACE) || Intrinsics.areEqual((Object)elementType, (Object)RsElementTypes.RBRACE)) continue;
            boolean isSuitableElement = Helper.INSTANCE.isSuitableElement(element);
            PsiElement parent2 = element.getParent();
            boolean bl = stopAtParent = parent2 instanceof RsBlock || parent2 instanceof RsFunction || parent2 instanceof RsStructItem;
            if (!isSuitableElement && !stopAtParent) continue;
            return element;
        }
        return null;
    }

    public boolean doNotStepInto(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return true;
    }

    protected void processDefaultEnter(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        SmartEnterProcessorWithFixers.plainEnter((Editor)editor2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/rust/ide/typing/assist/RsSmartEnterProcessor$Helper;", "", "<init>", "()V", "isSuitableElement", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.rustrover.core"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        public final boolean isSuitableElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return element instanceof RsMatchArm || element instanceof RsTypeAlias || element instanceof RsTraitAlias || element instanceof RsConstant || element instanceof RsExternCrateItem;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/rust/ide/typing/assist/RsSmartEnterProcessor$PlainEnterProcessor;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$FixEnterProcessor;", "<init>", "()V", "doEnter", "", "atCaret", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "modified", "intellij.rustrover.core"})
    private static final class PlainEnterProcessor
    extends SmartEnterProcessorWithFixers.FixEnterProcessor {
        public boolean doEnter(@NotNull PsiElement atCaret, @NotNull PsiFile file, @NotNull Editor editor2, boolean modified) {
            Intrinsics.checkNotNullParameter((Object)atCaret, (String)"atCaret");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.plainEnter(editor2);
            return true;
        }
    }
}

