/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.GotItTooltip;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.RsBundle;
import org.rust.ide.status.RsResolveContextWidget;
import org.rust.ide.typing.RsResolveContextPromoterKt;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.ext.CfgUtilsKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/rust/ide/typing/RsResolveContextPromoter;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "newTypingStarted", "", "c", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "Helper", "intellij.rustrover.core"})
public final class RsResolveContextPromoter
extends TypedHandlerDelegate {
    public void newTypingStarted(char c, @NotNull Editor editor2, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = UtilsKt.getProject(context);
        if (project == null) {
            return;
        }
        Project project2 = project;
        PsiFile psiFile = UtilsKt.getPsiFile(context);
        RsFile rsFile = psiFile instanceof RsFile ? (RsFile)psiFile : null;
        if (rsFile == null) {
            return;
        }
        RsFile file = rsFile;
        if (!Helper.INSTANCE.getGotItTooltip().canShow()) {
            return;
        }
        Object[] objectArray = new Object[]{this};
        ReadAction.nonBlocking(() -> RsResolveContextPromoter.newTypingStarted$lambda$0(file, editor2)).finishOnUiThread(ModalityState.defaultModalityState(), arg_0 -> RsResolveContextPromoter.newTypingStarted$lambda$2(arg_0 -> RsResolveContextPromoter.newTypingStarted$lambda$1(project2, arg_0), arg_0)).inSmartMode(project2).coalesceBy(objectArray).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private static final Boolean newTypingStarted$lambda$0(RsFile $file, Editor $editor) {
        if (!$file.isValid() || $editor.isDisposed()) {
            return false;
        }
        PsiElement psiElement2 = $file.findElementAt($editor.getCaretModel().getOffset());
        if (psiElement2 == null) {
            return false;
        }
        PsiElement element = psiElement2;
        if (CfgUtilsKt.isEnabledByCfg(element)) {
            return false;
        }
        if (!RsResolveContextPromoterKt.access$isUnderTargetSpecificOption(element)) {
            return false;
        }
        return true;
    }

    private static final Unit newTypingStarted$lambda$1(Project $project, Boolean show) {
        if (show.booleanValue()) {
            Helper.INSTANCE.showGotItTooltip($project);
        }
        return Unit.INSTANCE;
    }

    private static final void newTypingStarted$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/rust/ide/typing/RsResolveContextPromoter$Helper;", "", "<init>", "()V", "showGotItTooltip", "", "project", "Lcom/intellij/openapi/project/Project;", "getGotItTooltip", "Lcom/intellij/ui/GotItTooltip;", "intellij.rustrover.core"})
    public static final class Helper {
        @NotNull
        public static final Helper INSTANCE = new Helper();

        private Helper() {
        }

        public final void showGotItTooltip(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar == null) {
                return;
            }
            StatusBar statusBar2 = statusBar;
            StatusBarWidget statusBarWidget = statusBar2.getWidget("rustResolveContextWidget");
            RsResolveContextWidget rsResolveContextWidget = statusBarWidget instanceof RsResolveContextWidget ? (RsResolveContextWidget)statusBarWidget : null;
            if (rsResolveContextWidget == null) {
                return;
            }
            RsResolveContextWidget widget = rsResolveContextWidget;
            JComponent jComponent = widget.getComponent();
            JComponent jComponent2 = jComponent instanceof JComponent ? jComponent : null;
            if (jComponent2 == null) {
                return;
            }
            JComponent component = jComponent2;
            this.getGotItTooltip().show(component, GotItTooltip.TOP_MIDDLE);
        }

        @NotNull
        public final GotItTooltip getGotItTooltip() {
            GotItTooltip gotItTooltip = new GotItTooltip("resolve.context.promoter", RsBundle.INSTANCE.message("resolve.context.promoter.message", new Object[0]), null, 4, null).withHeader(RsBundle.INSTANCE.message("resolve.context.promoter.header", new Object[0]));
            Icon icon = AllIcons.General.BalloonInformation;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BalloonInformation");
            return gotItTooltip.withIcon(icon);
        }
    }
}

