/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.typing.RsEnableableBackspaceHandlerDelegate;
import org.rust.ide.typing.RsTypingSettings;
import org.rust.ide.typing.RustRawLiteralHashesBalancerKt;
import org.rust.ide.typing.UtilsKt;
import org.rust.lang.core.psi.RsTokenTypeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/rust/ide/typing/RsRawLiteralHashesDeleter;", "Lorg/rust/ide/typing/RsEnableableBackspaceHandlerDelegate;", "<init>", "()V", "offsets", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/TextRange;", "deleting", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "deleted", "intellij.rustrover.core"})
public final class RsRawLiteralHashesDeleter
extends RsEnableableBackspaceHandlerDelegate {
    @Nullable
    private Pair<? extends TextRange, ? extends TextRange> offsets;

    @Override
    public boolean deleting(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (!RsTypingSettings.Companion.getInstance().getBalanceRawStrings()) {
            return false;
        }
        int caretOffset = editor2.getCaretModel().getOffset();
        CharSequence charSequence = editor2.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        if (!UtilsKt.isValidOffset(caretOffset, charSequence)) {
            return false;
        }
        EditorHighlighter editorHighlighter = ((EditorEx)editor2).getHighlighter();
        Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"getHighlighter(...)");
        EditorHighlighter highlighter = editorHighlighter;
        HighlighterIterator highlighterIterator = highlighter.createIterator(caretOffset - 1);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator2 = highlighterIterator;
        if (c != '#' || !RsTokenTypeKt.getRS_RAW_LITERALS().contains(iterator2.getTokenType())) {
            return false;
        }
        this.offsets = RustRawLiteralHashesBalancerKt.access$getHashesOffsets(iterator2);
        return this.offsets != null;
    }

    @Override
    public boolean deleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        int caretOffset = editor2.getCaretModel().getOffset() + 1;
        Pair<? extends TextRange, ? extends TextRange> pair = this.offsets;
        if (pair == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Pair<? extends TextRange, ? extends TextRange> pair2 = pair;
        TextRange openHashes = (TextRange)pair2.component1();
        TextRange closeHashes = (TextRange)pair2.component2();
        int n = caretOffset;
        if (openHashes.grown(1).contains(n)) {
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            UtilsKt.deleteChar(document, closeHashes.getEndOffset() - 2);
        } else if (closeHashes.grown(1).contains(n)) {
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            UtilsKt.deleteChar(document, openHashes.getStartOffset());
        }
        return false;
    }
}

