/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing;

import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.typing.RsTypingSettings;
import org.rust.ide.typing.UtilsKt;
import org.rust.lang.core.psi.LiteralOffsets;
import org.rust.lang.core.psi.RsComplexLiteral;
import org.rust.lang.core.psi.RsElementTypes;
import org.rust.lang.core.psi.RsTokenTypeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\f\u0010\u0010\u001a\u00020\u0011*\u00020\bH\u0002J\u0016\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/typing/RsQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/SimpleTokenSetQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/MultiCharQuoteHandler;", "<init>", "()V", "isOpeningQuote", "", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "isClosingQuote", "isInsideLiteral", "isNonClosedLiteral", "chars", "", "advanceToTheLastToken", "", "isDeepInsideLiteral", "getClosingQuote", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsQuoteHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsQuoteHandler.kt\norg/rust/ide/typing/RsQuoteHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public final class RsQuoteHandler
extends SimpleTokenSetQuoteHandler
implements MultiCharQuoteHandler {
    public RsQuoteHandler() {
        IElementType[] iElementTypeArray = new IElementType[]{RsElementTypes.BYTE_LITERAL, RsElementTypes.STRING_LITERAL, RsElementTypes.BYTE_STRING_LITERAL, RsElementTypes.CSTRING_LITERAL, RsElementTypes.RAW_STRING_LITERAL, RsElementTypes.RAW_BYTE_STRING_LITERAL, RsElementTypes.RAW_CSTRING_LITERAL};
        super(iElementTypeArray);
    }

    public boolean isOpeningQuote(@NotNull HighlighterIterator iterator2, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        IElementType elementType = iterator2.getTokenType();
        int start2 = iterator2.getStart();
        IElementType iElementType = elementType;
        return Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.RAW_BYTE_STRING_LITERAL) || Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.RAW_CSTRING_LITERAL) ? offset - start2 <= 2 : (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.BYTE_STRING_LITERAL) || Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.CSTRING_LITERAL) || Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.RAW_STRING_LITERAL) ? offset - start2 <= 1 : (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.BYTE_LITERAL) ? offset == start2 + 1 : super.isOpeningQuote(iterator2, offset)));
    }

    public boolean isClosingQuote(@NotNull HighlighterIterator iterator2, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        return super.isClosingQuote(iterator2, offset);
    }

    public boolean isInsideLiteral(@NotNull HighlighterIterator iterator2) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        return StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator2.getTokenType()) ? true : super.isInsideLiteral(iterator2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isNonClosedLiteral(@NotNull HighlighterIterator iterator2, @NotNull CharSequence chars) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        if (Intrinsics.areEqual((Object)iterator2.getTokenType(), (Object)RsElementTypes.BYTE_LITERAL)) {
            if (iterator2.getEnd() - iterator2.getStart() != 2) return false;
            return true;
        }
        if (RsTokenTypeKt.getRS_RAW_LITERALS().contains(iterator2.getTokenType())) {
            char lastChar = chars.charAt(iterator2.getEnd() - 1);
            if (lastChar == '#') return false;
            if (lastChar == '\"') return false;
            return true;
        }
        if (super.isNonClosedLiteral(iterator2, chars)) {
            return true;
        }
        this.advanceToTheLastToken(iterator2);
        if (!this.myLiteralTokenSet.contains(iterator2.getTokenType())) return false;
        RsComplexLiteral rsComplexLiteral = UtilsKt.getLiteralDumb(iterator2);
        Intrinsics.checkNotNull((Object)rsComplexLiteral);
        if (rsComplexLiteral.getOffsets().getCloseDelim() != null) return false;
        return true;
    }

    private final void advanceToTheLastToken(HighlighterIterator $this$advanceToTheLastToken) {
        while (!$this$advanceToTheLastToken.atEnd()) {
            $this$advanceToTheLastToken.advance();
        }
        $this$advanceToTheLastToken.retreat();
    }

    public final boolean isDeepInsideLiteral(@NotNull HighlighterIterator iterator2, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        if (!this.isInsideLiteral(iterator2)) {
            return false;
        }
        IElementType tt = iterator2.getTokenType();
        int start2 = iterator2.getStart();
        if (Intrinsics.areEqual((Object)tt, (Object)RsElementTypes.RAW_STRING_LITERAL) || Intrinsics.areEqual((Object)tt, (Object)RsElementTypes.RAW_BYTE_STRING_LITERAL) || Intrinsics.areEqual((Object)tt, (Object)RsElementTypes.RAW_CSTRING_LITERAL)) {
            Object object = UtilsKt.getLiteralDumb(iterator2);
            return object != null && (object = object.getOffsets()) != null && (object = ((LiteralOffsets)object).getValue()) != null ? object.containsOffset(offset - start2) : false;
        }
        if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(tt)) {
            return true;
        }
        Pair<IElementType, IElementType> pair = UtilsKt.getSiblingTokens(iterator2);
        IElementType prev = (IElementType)pair.component1();
        IElementType next = (IElementType)pair.component2();
        if (!StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(prev)) {
            return !this.isOpeningQuote(iterator2, offset);
        }
        if (!StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(next)) {
            return !this.isClosingQuote(iterator2, offset - 1);
        }
        return true;
    }

    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator2, int offset) {
        int n;
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        if (!RsTypingSettings.Companion.getInstance().getBalanceRawStrings()) {
            return null;
        }
        RsComplexLiteral rsComplexLiteral = UtilsKt.getLiteralDumb(iterator2);
        if (rsComplexLiteral == null) {
            return null;
        }
        RsComplexLiteral literal = rsComplexLiteral;
        if (!RsTokenTypeKt.getRS_RAW_LITERALS().contains(literal.getNode().getElementType())) {
            return null;
        }
        TextRange textRange = literal.getOffsets().getOpenDelim();
        if (textRange != null) {
            int it2 = textRange.getLength();
            boolean bl = false;
            n = it2 - 1;
        } else {
            n = 0;
        }
        int hashes = n;
        char c = '\"';
        String string = StringsKt.repeat((CharSequence)"#", (int)hashes);
        return c + string;
    }
}

