/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.statistics.RsCounterUsagesCollector;
import org.rust.ide.typing.OriginalContent;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006H\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00060\u00060\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"DOCUMENT_LISTENER_DISPOSABLE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/Disposable;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "ORIGINAL_CONTENT", "Lorg/rust/ide/typing/OriginalContent;", "updateNotificationsFor", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "showNotificationAgain", "originalContent", "hideNotification", "intellij.rustrover.core"})
public final class RsLibraryFileContentRestoringKt {
    @NotNull
    private static final Key<Disposable> DOCUMENT_LISTENER_DISPOSABLE;
    @NotNull
    private static final Key<OriginalContent> ORIGINAL_CONTENT;

    private static final void updateNotificationsFor(VirtualFile file) {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            EditorNotifications.getInstance((Project)project2).updateNotifications(file);
        }
    }

    private static final void showNotificationAgain(VirtualFile file, OriginalContent originalContent) {
        if (originalContent.getHideNotification() && file.replace(ORIGINAL_CONTENT, (Object)originalContent, (Object)OriginalContent.copy$default(originalContent, null, false, 0, null, 13, null))) {
            RsLibraryFileContentRestoringKt.updateNotificationsFor(file);
        }
    }

    private static final void hideNotification(VirtualFile file, OriginalContent originalContent) {
        if (!originalContent.getHideNotification() && file.replace(ORIGINAL_CONTENT, (Object)originalContent, (Object)OriginalContent.copy$default(originalContent, null, true, 0, null, 13, null))) {
            RsCounterUsagesCollector.INSTANCE.logRestoreLibraryFileContent(RsCounterUsagesCollector.RestoreType.MANUALLY);
            RsLibraryFileContentRestoringKt.updateNotificationsFor(file);
        }
    }

    public static final /* synthetic */ Key access$getDOCUMENT_LISTENER_DISPOSABLE$p() {
        return DOCUMENT_LISTENER_DISPOSABLE;
    }

    public static final /* synthetic */ Key access$getORIGINAL_CONTENT$p() {
        return ORIGINAL_CONTENT;
    }

    public static final /* synthetic */ void access$updateNotificationsFor(VirtualFile file) {
        RsLibraryFileContentRestoringKt.updateNotificationsFor(file);
    }

    public static final /* synthetic */ void access$showNotificationAgain(VirtualFile file, OriginalContent originalContent) {
        RsLibraryFileContentRestoringKt.showNotificationAgain(file, originalContent);
    }

    public static final /* synthetic */ void access$hideNotification(VirtualFile file, OriginalContent originalContent) {
        RsLibraryFileContentRestoringKt.hideNotification(file, originalContent);
    }

    static {
        Key key = Key.create((String)"rust.library.file.document.listener");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DOCUMENT_LISTENER_DISPOSABLE = key;
        Key key2 = Key.create((String)"rust.library.file.original.content");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        ORIGINAL_CONTENT = key2;
    }
}

