/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.typing.RsEnterInStringLiteralHandlerKt;
import org.rust.ide.typing.RsQuoteHandler;
import org.rust.ide.typing.UtilsKt;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsTokenTypeKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/typing/RsEnterInStringLiteralHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "<init>", "()V", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvanceRef", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "intellij.rustrover.core"})
public final class RsEnterInStringLiteralHandler
implements EnterHandlerDelegate {
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        EnterHandlerDelegate.Result result2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvanceRef, (String)"caretAdvanceRef");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!(file instanceof RsFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Integer caretOffset = (Integer)caretOffsetRef.get();
        Intrinsics.checkNotNull((Object)caretOffset);
        int n = caretOffset;
        CharSequence charSequence = editor2.getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        if (!UtilsKt.isValidInnerOffset(n, charSequence)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        EditorHighlighter editorHighlighter = ((EditorEx)editor2).getHighlighter();
        Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"getHighlighter(...)");
        EditorHighlighter highlighter = editorHighlighter;
        HighlighterIterator highlighterIterator = highlighter.createIterator(caretOffset.intValue());
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator2 = highlighterIterator;
        if (!new RsQuoteHandler().isDeepInsideLiteral(iterator2, caretOffset)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator2.getTokenType())) {
            int n2 = iterator2.getStart();
            if (caretOffset == n2) {
                iterator2.retreat();
            } else {
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        IElementType iElementType = iterator2.getTokenType();
        if (RsTokenTypeKt.getRS_STRING_LITERALS().contains(iElementType)) {
            CharSequence tokenText;
            CharSequence charSequence2 = tokenText = ((EditorEx)editor2).getDocument().getImmutableCharSequence().subSequence(iterator2.getStart(), iterator2.getEnd());
            if (RsEnterInStringLiteralHandlerKt.access$getUNESCAPED_NEWLINE$p().containsMatchIn(charSequence2)) {
                return EnterHandlerDelegate.Result.Continue;
            }
            ((EditorEx)editor2).getDocument().insertString(caretOffset.intValue(), (CharSequence)"\\");
            caretOffsetRef.set((Object)(caretOffset + 1));
            result2 = EnterHandlerDelegate.Result.DefaultForceIndent;
        } else {
            result2 = RsTokenTypeKt.getRS_RAW_LITERALS().contains(iElementType) ? EnterHandlerDelegate.Result.DefaultSkipIndent : EnterHandlerDelegate.Result.Continue;
        }
        return result2;
    }
}

