/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.lang.core.parser.RustParserUtil;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.ext.PsiElementExtensionsKt;
import org.rust.lang.core.psi.ext.PsiElementKt;
import org.rust.lang.doc.psi.RsDocComment;
import org.rust.lang.doc.psi.RsDocKind;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/rust/ide/typing/RsEnterInLineCommentHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "<init>", "()V", "preprocessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "caretOffsetRef", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvanceRef", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "isEolWhitespace", "", "Lcom/intellij/psi/PsiElement;", "caretOffset", "intellij.rustrover.core"})
public final class RsEnterInLineCommentHandler
implements EnterHandlerDelegate {
    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        String string;
        IElementType iElementType;
        RsDocComment containingDoc;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffsetRef, (String)"caretOffsetRef");
        Intrinsics.checkNotNullParameter(caretAdvanceRef, (String)"caretAdvanceRef");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!(file instanceof RsFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)((RsFile)file).getProject()).commitDocument(document2);
        Integer caretOffset = (Integer)caretOffsetRef.get();
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence text = charSequence;
        Intrinsics.checkNotNull((Object)caretOffset);
        int offset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)" \t");
        boolean isEOL = offset < text.length() && text.charAt(offset) == '\n';
        PsiElement psiElement2 = ((RsFile)file).findElementAt(offset);
        if (psiElement2 == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement elementAtCaret = psiElement2;
        if (isEOL && this.isEolWhitespace(elementAtCaret, offset)) {
            PsiElement psiElement3 = elementAtCaret.getPrevSibling();
            if (psiElement3 == null) {
                return EnterHandlerDelegate.Result.Continue;
            }
            elementAtCaret = psiElement3;
        }
        if ((containingDoc = org.rust.lang.doc.psi.ext.PsiElementKt.getContainingDoc(elementAtCaret)) != null) {
            elementAtCaret = containingDoc;
        }
        if (Intrinsics.areEqual((Object)(iElementType = PsiElementExtensionsKt.getElementType(elementAtCaret)), (Object)RustParserUtil.Helper.OUTER_EOL_DOC_COMMENT)) {
            string = RsDocKind.OuterEol.getPrefix();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)RustParserUtil.Helper.INNER_EOL_DOC_COMMENT)) {
            string = RsDocKind.InnerEol.getPrefix();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)RustParserUtil.Helper.EOL_COMMENT))) {
            if (isEOL) {
                return EnterHandlerDelegate.Result.Continue;
            }
            string = "//";
        } else {
            return EnterHandlerDelegate.Result.Continue;
        }
        String prefix = string;
        if (offset < elementAtCaret.getTextOffset() + prefix.length()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (StringsKt.startsWith$default((CharSequence)text, (CharSequence)prefix, (int)offset, (boolean)false, (int)4, null)) {
            int afterPrefix = offset + prefix.length();
            if (afterPrefix < document2.getTextLength() && text.charAt(afterPrefix) != ' ') {
                document2.insertString(afterPrefix, (CharSequence)" ");
            }
            caretOffsetRef.set((Object)offset);
        } else {
            Object prefixToAdd = text.charAt(caretOffset) != ' ' ? prefix + " " : prefix;
            document2.insertString(caretOffset.intValue(), (CharSequence)prefixToAdd);
            caretAdvanceRef.set((Object)((String)prefixToAdd).length());
        }
        return EnterHandlerDelegate.Result.Default;
    }

    private final boolean isEolWhitespace(PsiElement $this$isEolWhitespace, int caretOffset) {
        ASTNode aSTNode = $this$isEolWhitespace.getNode();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)TokenType.WHITE_SPACE)) {
            return false;
        }
        String string = $this$isEolWhitespace.getNode().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int pos = StringsKt.indexOf$default((CharSequence)string, (char)'\n', (int)0, (boolean)false, (int)6, null);
        return pos == -1 || caretOffset <= pos + PsiElementKt.getStartOffset($this$isEolWhitespace);
    }
}

