/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.typing.BraceHandler;
import org.rust.ide.typing.RsBraceHandlersKt;
import org.rust.lang.core.psi.RsFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/rust/ide/typing/RsBraceTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "handler", "Lorg/rust/ide/typing/BraceHandler;", "<init>", "(Lorg/rust/ide/typing/BraceHandler;)V", "openingTyped", "", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "charTyped", "intellij.rustrover.core"})
public abstract class RsBraceTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    private final BraceHandler handler;
    private boolean openingTyped;

    public RsBraceTypedHandler(@NotNull BraceHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        if (!(file instanceof RsFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            char c2 = c;
            if (c2 == this.handler.getOpening().getChar()) {
                this.openingTyped = this.handler.shouldComplete(editor2);
            } else if (c2 == this.handler.getClosing().getChar()) {
                HighlighterIterator highlighterIterator = RsBraceHandlersKt.createLexer(editor2, editor2.getCaretModel().getOffset());
                if (highlighterIterator == null) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                HighlighterIterator lexer = highlighterIterator;
                IElementType tokenType = lexer.getTokenType();
                if (Intrinsics.areEqual((Object)tokenType, (Object)this.handler.getClosing().getTokenType()) && this.handler.calculateBalance(editor2) == 0) {
                    EditorModificationUtil.moveCaretRelatively((Editor)editor2, (int)1);
                    return TypedHandlerDelegate.Result.STOP;
                }
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof RsFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (this.openingTyped) {
            this.openingTyped = false;
            int balance = this.handler.calculateBalance(editor2);
            if (balance == 1) {
                int offset = editor2.getCaretModel().getOffset();
                editor2.getDocument().insertString(offset, (CharSequence)String.valueOf(this.handler.getClosing().getChar()));
            }
        }
        TypedHandlerDelegate.Result result2 = super.charTyped(c, project, editor2, file);
        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"charTyped(...)");
        return result2;
    }
}

