/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.typing.BraceHandler;
import org.rust.ide.typing.RsEnableableBackspaceHandlerDelegate;
import org.rust.lang.core.psi.RsFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/rust/ide/typing/RsBraceBackspaceHandler;", "Lorg/rust/ide/typing/RsEnableableBackspaceHandlerDelegate;", "handler", "Lorg/rust/ide/typing/BraceHandler;", "<init>", "(Lorg/rust/ide/typing/BraceHandler;)V", "deleting", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "deleted", "intellij.rustrover.core"})
public abstract class RsBraceBackspaceHandler
extends RsEnableableBackspaceHandlerDelegate {
    @NotNull
    private final BraceHandler handler;

    public RsBraceBackspaceHandler(@NotNull BraceHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
    }

    @Override
    public boolean deleting(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if (c == this.handler.getOpening().getChar() && file instanceof RsFile) {
            int offset = editor2.getCaretModel().getOffset();
            HighlighterIterator highlighterIterator = ((EditorEx)editor2).getHighlighter().createIterator(offset);
            Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
            HighlighterIterator iterator2 = highlighterIterator;
            return Intrinsics.areEqual((Object)iterator2.getTokenType(), (Object)this.handler.getClosing().getTokenType());
        }
        return false;
    }

    @Override
    public boolean deleted(char c, @NotNull PsiFile file, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        int balance = this.handler.calculateBalance(editor2);
        if (balance < 0) {
            int offset = editor2.getCaretModel().getOffset();
            editor2.getDocument().deleteString(offset, offset + 1);
            return true;
        }
        return true;
    }
}

