/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.typing;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.typing.BraceHandler;
import org.rust.ide.typing.BraceKind;
import org.rust.ide.typing.RsAngleBraceHandlersKt;
import org.rust.ide.typing.RsBraceHandlersKt;
import org.rust.lang.core.psi.RsElementTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/rust/ide/typing/AngleBraceHandler;", "Lorg/rust/ide/typing/BraceHandler;", "<init>", "()V", "opening", "Lorg/rust/ide/typing/BraceKind;", "getOpening", "()Lorg/rust/ide/typing/BraceKind;", "closing", "getClosing", "shouldComplete", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "calculateBalance", "", "isTypeLikeIdentifier", "offset", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nRsAngleBraceHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsAngleBraceHandlers.kt\norg/rust/ide/typing/AngleBraceHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1761#2,3:85\n*S KotlinDebug\n*F\n+ 1 RsAngleBraceHandlers.kt\norg/rust/ide/typing/AngleBraceHandler\n*L\n81#1:85,3\n*E\n"})
public final class AngleBraceHandler
implements BraceHandler {
    @NotNull
    public static final AngleBraceHandler INSTANCE = new AngleBraceHandler();
    @NotNull
    private static final BraceKind opening;
    @NotNull
    private static final BraceKind closing;

    private AngleBraceHandler() {
    }

    @Override
    @NotNull
    public BraceKind getOpening() {
        return opening;
    }

    @Override
    @NotNull
    public BraceKind getClosing() {
        return closing;
    }

    @Override
    public boolean shouldComplete(@NotNull Editor editor2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        int offset = editor2.getCaretModel().getOffset();
        HighlighterIterator highlighterIterator = RsBraceHandlersKt.createLexer(editor2, offset - 1);
        if (highlighterIterator == null) {
            return false;
        }
        HighlighterIterator lexer = highlighterIterator;
        IElementType iElementType = lexer.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.COLONCOLON)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.IMPL)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.IDENTIFIER)) {
            if (lexer.getEnd() != offset) {
                return false;
            }
            if (lexer.getStart() > 1) {
                lexer.retreat();
                lexer.retreat();
                if (RsAngleBraceHandlersKt.access$getGENERIC_NAMED_ENTITY_KEYWORDS$p().contains(lexer.getTokenType())) {
                    return true;
                }
                lexer.advance();
                lexer.advance();
            }
            bl = this.isTypeLikeIdentifier(offset, editor2, lexer);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int calculateBalance(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        int offset = editor2.getCaretModel().getOffset() - 1;
        HighlighterIterator highlighterIterator = ((EditorEx)editor2).getHighlighter().createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator2 = highlighterIterator;
        while (iterator2.getStart() > 0 && !RsAngleBraceHandlersKt.access$getINVALID_INSIDE_TOKENS$p().contains(iterator2.getTokenType())) {
            iterator2.retreat();
        }
        if (RsAngleBraceHandlersKt.access$getINVALID_INSIDE_TOKENS$p().contains(iterator2.getTokenType())) {
            iterator2.advance();
        }
        int balance = 0;
        while (!iterator2.atEnd() && balance >= 0 && !RsAngleBraceHandlersKt.access$getINVALID_INSIDE_TOKENS$p().contains(iterator2.getTokenType())) {
            IElementType iElementType = iterator2.getTokenType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.LT)) {
                ++balance;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)RsElementTypes.GT)) {
                --balance;
            }
            iterator2.advance();
        }
        return balance;
    }

    private final boolean isTypeLikeIdentifier(int offset, Editor editor2, HighlighterIterator iterator2) {
        boolean bl;
        block6: {
            if (iterator2.getEnd() != offset) {
                return false;
            }
            CharSequence charSequence = editor2.getDocument().getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            CharSequence chars = charSequence;
            if (!Character.isUpperCase(chars.charAt(iterator2.getStart()))) {
                return false;
            }
            if (iterator2.getEnd() == iterator2.getStart() + 1) {
                return true;
            }
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)(iterator2.getStart() + 1), (int)iterator2.getEnd());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator3 = $this$any$iv.iterator();
                while (iterator3.hasNext()) {
                    int element$iv;
                    int it2 = element$iv = ((IntIterator)iterator3).nextInt();
                    boolean bl2 = false;
                    if (!Character.isLowerCase(chars.charAt(it2))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        IElementType iElementType = RsElementTypes.LT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"LT");
        opening = new BraceKind('<', iElementType);
        IElementType iElementType2 = RsElementTypes.GT;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"GT");
        closing = new BraceKind('>', iElementType2);
    }
}

