/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.template.postfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.rust.ide.fixes.AddRemainingArmsFix;
import org.rust.ide.fixes.AddWildcardArmFix;
import org.rust.ide.template.postfix.MatchProcessor;
import org.rust.ide.utils.checkMatch.CheckMatchUtilsKt;
import org.rust.lang.core.psi.RsExpr;
import org.rust.lang.core.psi.RsMatchBody;
import org.rust.lang.core.psi.RsMatchExpr;
import org.rust.lang.core.psi.RsPatWild;
import org.rust.lang.core.psi.RsPsiFactory;
import org.rust.lang.core.psi.RsStructLiteral;
import org.rust.lang.core.psi.ext.RsElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/rust/ide/template/postfix/GenericMatchProcessor;", "Lorg/rust/ide/template/postfix/MatchProcessor;", "<init>", "()V", "createMatch", "Lorg/rust/lang/core/psi/RsMatchExpr;", "factory", "Lorg/rust/lang/core/psi/RsPsiFactory;", "expression", "Lorg/rust/lang/core/psi/RsExpr;", "normalizeMatch", "", "matchExpr", "getElementsToReplace", "", "Lorg/rust/lang/core/psi/ext/RsElement;", "matchBody", "Lorg/rust/lang/core/psi/RsMatchBody;", "intellij.rustrover.core"})
@SourceDebugExtension(value={"SMAP\nMatchPostfixTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatchPostfixTemplate.kt\norg/rust/ide/template/postfix/GenericMatchProcessor\n+ 2 PsiElement.kt\norg/rust/lang/core/psi/ext/PsiElementKt\n*L\n1#1,135:1\n127#2:136\n*S KotlinDebug\n*F\n+ 1 MatchPostfixTemplate.kt\norg/rust/ide/template/postfix/GenericMatchProcessor\n*L\n111#1:136\n*E\n"})
final class GenericMatchProcessor
extends MatchProcessor {
    @NotNull
    public static final GenericMatchProcessor INSTANCE = new GenericMatchProcessor();

    private GenericMatchProcessor() {
    }

    @Override
    @NotNull
    public RsMatchExpr createMatch(@NotNull RsPsiFactory factory2, @NotNull RsExpr expression) {
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        String exprText = expression instanceof RsStructLiteral ? "(" + ((RsStructLiteral)expression).getText() + ")" : expression.getText();
        RsExpr rsExpr = factory2.createExpression("match " + exprText + " {}");
        Intrinsics.checkNotNull((Object)rsExpr, (String)"null cannot be cast to non-null type org.rust.lang.core.psi.RsMatchExpr");
        return (RsMatchExpr)rsExpr;
    }

    @Override
    public void normalizeMatch(@NotNull RsMatchExpr matchExpr2) {
        List patterns;
        Intrinsics.checkNotNullParameter((Object)matchExpr2, (String)"matchExpr");
        List list = CheckMatchUtilsKt.checkExhaustive(matchExpr2);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        AddRemainingArmsFix fix = (patterns = list).isEmpty() ? (AddRemainingArmsFix)new AddWildcardArmFix(matchExpr2) : new AddRemainingArmsFix(matchExpr2, patterns);
        Project project = matchExpr2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        fix.invoke(project, (Editor)null, matchExpr2);
    }

    @Override
    @NotNull
    public List<RsElement> getElementsToReplace(@NotNull RsMatchBody matchBody) {
        Intrinsics.checkNotNullParameter((Object)matchBody, (String)"matchBody");
        PsiElement $this$descendantsOfType$iv = matchBody;
        boolean $i$f$descendantsOfType = false;
        Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)$this$descendantsOfType$iv, RsPatWild.class);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
        return CollectionsKt.toList((Iterable)collection);
    }
}

