/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.structure;

import com.intellij.ide.navigationToolbar.StructureAwareNavBarModelExtension;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataMap;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.ide.structure.RsBreadcrumbsInfoProvider;
import org.rust.ide.structure.RsStructureViewModel;
import org.rust.lang.RsLanguage;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.RsFileBase;
import org.rust.lang.core.psi.ext.RsAbstractable;
import org.rust.lang.core.psi.ext.RsElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/rust/ide/structure/RsNavBarModelExtension;", "Lcom/intellij/ide/navigationToolbar/StructureAwareNavBarModelExtension;", "<init>", "()V", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "createModel", "Lcom/intellij/ide/structureView/StructureViewModel;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getPresentableText", "", "item", "", "getLeafElement", "Lcom/intellij/psi/PsiElement;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataMap;", "getIcon", "Ljavax/swing/Icon;", "obj", "intellij.rustrover.core"})
public final class RsNavBarModelExtension
extends StructureAwareNavBarModelExtension {
    @NotNull
    private final Language language = RsLanguage.INSTANCE;

    @NotNull
    protected Language getLanguage() {
        return this.language;
    }

    @Nullable
    protected StructureViewModel createModel(@NotNull PsiFile file, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(file instanceof RsFile)) {
            return null;
        }
        return (StructureViewModel)new RsStructureViewModel(editor2, (RsFileBase)file, false);
    }

    @Nullable
    public String getPresentableText(@Nullable Object item) {
        RsElement rsElement = item instanceof RsElement ? (RsElement)item : null;
        if (rsElement == null) {
            return null;
        }
        RsElement element = rsElement;
        if (element instanceof RsFile) {
            return ((RsFile)element).getName();
        }
        RsBreadcrumbsInfoProvider provider = new RsBreadcrumbsInfoProvider();
        return provider.getBreadcrumb(element);
    }

    @Nullable
    public PsiElement getLeafElement(@NotNull DataMap dataProvider) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        PsiElement psiElement2 = super.getLeafElement(dataProvider);
        RsElement rsElement = psiElement2 instanceof RsElement ? (RsElement)psiElement2 : null;
        if (rsElement == null) {
            return null;
        }
        RsElement leafElement = rsElement;
        if (new RsBreadcrumbsInfoProvider().getBreadcrumb(leafElement) == null) {
            return null;
        }
        return leafElement;
    }

    @Nullable
    public Icon getIcon(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj instanceof RsAbstractable) {
            Icon icon = (Icon)ReadAction.compute(() -> RsNavBarModelExtension.getIcon$lambda$0(obj));
            int maxDimension = JBUI.scale((int)32);
            if (icon != null && (icon.getIconHeight() > maxDimension || icon.getIconWidth() > maxDimension)) {
                icon = IconUtil.cropIcon((Icon)icon, (int)maxDimension, (int)maxDimension);
            }
            return icon;
        }
        return super.getIcon(obj);
    }

    private static final Icon getIcon$lambda$0(Object $obj) {
        return ((RsAbstractable)$obj).isValid() ? ((RsAbstractable)$obj).getIcon(0, false) : null;
    }
}

