/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.CargoConfig;
import org.rust.cargo.CargoConstants;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.CargoProjectsService;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.settings.RsProjectSettingsServiceBase;
import org.rust.cargo.project.settings.RustProjectSettingsService;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.ide.statistics.RsCfgSwitcherUsageCollector;
import org.rust.ide.status.RsResolveContextWidget;
import org.rust.ide.utils.RsResolveContextPopup;
import org.rust.lang.core.psi.RsFileKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lorg/rust/ide/status/RsResolveContextWidget;", "Lcom/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "ID", "", "createInstance", "Lcom/intellij/openapi/wm/StatusBarWidget;", "createPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getWidgetState", "Lcom/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup$WidgetState;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.rustrover.core"})
public final class RsResolveContextWidget
extends EditorBasedStatusBarPopup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ID = "rustResolveContextWidget";

    public RsResolveContextWidget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false);
        MessageBusConnection $this$_init__u24lambda_u240 = project.getMessageBus().connect((Disposable)this);
        boolean bl = false;
        $this$_init__u24lambda_u240.subscribe(CargoProjectsService.Companion.getCARGO_PROJECTS_TOPIC(), (arg_0, arg_1) -> RsResolveContextWidget.lambda$0$0(this, arg_0, arg_1));
        $this$_init__u24lambda_u240.subscribe(RsProjectSettingsServiceBase.Companion.getRUST_SETTINGS_TOPIC(), (Object)new RsProjectSettingsServiceBase.RsSettingsListener(this){
            final /* synthetic */ RsResolveContextWidget this$0;
            {
                this.this$0 = $receiver;
            }

            public <T extends RsProjectSettingsServiceBase.RsProjectSettingsBase<T>> void settingsChanged(RsProjectSettingsServiceBase.SettingsChangedEventBase<T> e) {
                Intrinsics.checkNotNullParameter(e, (String)"e");
                if (!(e instanceof RustProjectSettingsService.SettingsChangedEvent)) {
                    return;
                }
                if (((RustProjectSettingsService.SettingsChangedEvent)e).isChanged((KProperty1)1.settingsChanged.1.INSTANCE)) {
                    this.this$0.update();
                }
            }
        });
    }

    @NotNull
    public String ID() {
        return ID;
    }

    @NotNull
    protected StatusBarWidget createInstance(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (StatusBarWidget)new RsResolveContextWidget(project);
    }

    @Nullable
    protected ListPopup createPopup(@NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RsCfgSwitcherUsageCollector.INSTANCE.logResolveContextWidgetClicked(this.getProject());
        VirtualFile virtualFile = this.getSelectedFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return RsResolveContextPopup.INSTANCE.createPopup(this.getProject(), file, context);
    }

    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file) {
        Object object;
        List<String> list;
        if (file == null || RsFileKt.isNotRustFile(file) && !CargoConstants.INSTANCE.getCONFIG_FILES().contains(file.getName())) {
            return EditorBasedStatusBarPopup.WidgetState.HIDDEN;
        }
        if (!file.isValid()) {
            return RsResolveContextWidget.Companion.getNoContextState();
        }
        CargoProject cargoProject = CargoProjectServiceKt.getCargoProjects(this.getProject()).findProjectForFile(file);
        Object object2 = cargoProject;
        if (object2 == null || (object2 = object2.getRustcInfo()) == null || (object2 = ((RustcInfo)object2).getRustcTargets()) == null) {
            return RsResolveContextWidget.Companion.getNoContextState();
        }
        List<String> rustcTargets = object2;
        String string = RustProjectSettingsServiceKt.getRustSettings(this.getProject()).getRustcTarget();
        if (string == null && ((list = cargoProject.getWorkspace()) != null && (list = list.getCargoConfig()) != null && (list = ((CargoConfig)((Object)list)).getBuildTargets()) != null ? (String)CollectionsKt.firstOrNull(list) : (string = null)) == null && ((object = cargoProject.getRustcInfo()) != null && (object = ((RustcInfo)object).getVersion()) != null ? ((RustcVersion)object).getHost() : (string = null)) == null) {
            return RsResolveContextWidget.Companion.getNoContextState();
        }
        String currentRustcTarget = string;
        Object[] objectArray = new Object[]{currentRustcTarget};
        String tooltip = RsBundle.INSTANCE.message("resolve.contexts.popup.tooltip", objectArray);
        String string2 = StringUtil.shortenTextWithEllipsis((String)currentRustcTarget, (int)40, (int)15);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"shortenTextWithEllipsis(...)");
        String text = string2;
        return new EditorBasedStatusBarPopup.WidgetState(tooltip, text, rustcTargets.size() > 1);
    }

    private static final void lambda$0$0(RsResolveContextWidget this$0, CargoProjectsService cargoProjectsService, Collection collection) {
        Intrinsics.checkNotNullParameter((Object)cargoProjectsService, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"<unused var>");
        this$0.update();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/rust/ide/status/RsResolveContextWidget$Companion;", "", "<init>", "()V", "ID", "", "getNoContextState", "Lcom/intellij/openapi/wm/impl/status/EditorBasedStatusBarPopup$WidgetState;", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        private final EditorBasedStatusBarPopup.WidgetState getNoContextState() {
            return new EditorBasedStatusBarPopup.WidgetState(RsBundle.INSTANCE.message("resolve.contexts.widget.undefined.tooltip", new Object[0]), RsBundle.INSTANCE.message("resolve.contexts.widget.undefined", new Object[0]), false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

