/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rust.RsBundle;
import org.rust.cargo.project.configurable.RsExternalLinterConfigurable;
import org.rust.cargo.project.settings.RsExternalLinterProjectSettingsService;
import org.rust.cargo.project.settings.RsExternalLinterProjectSettingsServiceKt;
import org.rust.cargo.project.settings.RsProjectSettingsServiceBase;
import org.rust.cargo.toolchain.ExternalLinter;
import org.rust.ide.icons.RsIcons;
import org.rust.ide.statistics.ExternalLinterUsageCollector;
import org.rust.ide.status.RsExternalLinterWidget;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lorg/rust/ide/status/RsExternalLinterWidget;", "Lcom/intellij/openapi/wm/impl/status/TextPanel$WithIconAndArrows;", "Lcom/intellij/openapi/wm/CustomStatusBarWidget;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "linter", "Lorg/rust/cargo/toolchain/ExternalLinter;", "getLinter", "()Lorg/rust/cargo/toolchain/ExternalLinter;", "turnedOn", "", "getTurnedOn", "()Z", "value", "inProgress", "getInProgress", "setInProgress", "(Z)V", "ID", "", "install", "", "dispose", "getComponent", "Ljavax/swing/JComponent;", "update", "Companion", "intellij.rustrover.core"})
public final class RsExternalLinterWidget
extends TextPanel.WithIconAndArrows
implements CustomStatusBarWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private StatusBar statusBar;
    private boolean inProgress;
    @NotNull
    public static final String ID = "rustExternalLinterWidget";

    public RsExternalLinterWidget(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.setTextAlignment(0.5f);
        this.setBorder(JBUI.CurrentTheme.StatusBar.Widget.border());
    }

    private final ExternalLinter getLinter() {
        return RsExternalLinterProjectSettingsServiceKt.getExternalLinterSettings(this.project).getTool();
    }

    private final boolean getTurnedOn() {
        return RsExternalLinterProjectSettingsServiceKt.getExternalLinterSettings(this.project).getRunOnTheFly();
    }

    public final boolean getInProgress() {
        return this.inProgress;
    }

    public final void setInProgress(boolean value) {
        this.inProgress = value;
        this.update();
    }

    @NotNull
    public String ID() {
        return ID;
    }

    public void install(@NotNull StatusBar statusBar) {
        Intrinsics.checkNotNullParameter((Object)statusBar, (String)"statusBar");
        this.statusBar = statusBar;
        if (!this.project.isDisposed()) {
            new ClickListener(this){
                final /* synthetic */ RsExternalLinterWidget this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onClick(MouseEvent event, int clickCount) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    if (!RsExternalLinterWidget.access$getProject$p(this.this$0).isDisposed()) {
                        ExternalLinterUsageCollector.INSTANCE.logWidgetClicked(RsExternalLinterWidget.access$getProject$p(this.this$0));
                        Project $this$showSettingsDialog$iv = RsExternalLinterWidget.access$getProject$p(this.this$0);
                        boolean $i$f$showSettingsDialog = false;
                        ShowSettingsUtil.getInstance().showSettingsDialog($this$showSettingsDialog$iv, RsExternalLinterConfigurable.class);
                    }
                    return true;
                }
            }.installOn((Component)((Object)this), true);
            this.project.getMessageBus().connect((Disposable)this).subscribe(RsProjectSettingsServiceBase.Companion.getRUST_SETTINGS_TOPIC(), (Object)new RsProjectSettingsServiceBase.RsSettingsListener(this){
                final /* synthetic */ RsExternalLinterWidget this$0;
                {
                    this.this$0 = $receiver;
                }

                public <T extends RsProjectSettingsServiceBase.RsProjectSettingsBase<T>> void settingsChanged(RsProjectSettingsServiceBase.SettingsChangedEventBase<T> e) {
                    Intrinsics.checkNotNullParameter(e, (String)"e");
                    if (!(e instanceof RsExternalLinterProjectSettingsService.SettingsChangedEvent)) {
                        return;
                    }
                    if (((RsExternalLinterProjectSettingsService.SettingsChangedEvent)e).isChanged((KProperty1)install.settingsChanged.1.INSTANCE) || ((RsExternalLinterProjectSettingsService.SettingsChangedEvent)e).isChanged((KProperty1)install.settingsChanged.2.INSTANCE)) {
                        RsExternalLinterWidget.access$update(this.this$0);
                    }
                }
            });
        }
        this.update();
        statusBar.updateWidget(this.ID());
    }

    public void dispose() {
        this.statusBar = null;
        UIUtil.dispose((Component)((Component)((Object)this)));
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)((Object)this);
    }

    private final void update() {
        if (this.project.isDisposed()) {
            return;
        }
        UIUtil.invokeLaterIfNeeded(() -> RsExternalLinterWidget.update$lambda$0(this));
    }

    private static final void update$lambda$0(RsExternalLinterWidget this$0) {
        if (this$0.project.isDisposed()) {
            return;
        }
        this$0.setText(this$0.getLinter().getTitle());
        String status = this$0.getTurnedOn() ? RsBundle.INSTANCE.message("on", new Object[0]) : RsBundle.INSTANCE.message("off", new Object[0]);
        Object[] objectArray = new Object[]{this$0.getLinter().getTitle(), status, this$0.inProgress ? 0 : 1};
        this$0.setToolTipText(RsBundle.INSTANCE.message("0.2.choice.0.is.in.progress.1.on.the.fly.analysis.is.turned.1", objectArray));
        this$0.setIcon(!this$0.getTurnedOn() ? RsIcons.INSTANCE.getGEAR_OFF() : (this$0.inProgress ? (Icon)RsIcons.INSTANCE.getGEAR_ANIMATED() : RsIcons.INSTANCE.getGEAR()));
        this$0.repaint();
    }

    public static final /* synthetic */ Project access$getProject$p(RsExternalLinterWidget $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$update(RsExternalLinterWidget $this) {
        $this.update();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/rust/ide/status/RsExternalLinterWidget$Companion;", "", "<init>", "()V", "ID", "", "intellij.rustrover.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

