/*
 * Decompiled with CFR 0.152.
 */
package org.rust.ide.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.model.CargoProjectServiceKt;
import org.rust.cargo.project.model.RustcInfo;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.impl.RustcVersion;
import org.rust.cargo.toolchain.tools.RustupKt;
import org.rust.ide.statistics.RsToolchainUsagesCollectorKt;
import org.rust.ide.statistics.ToolchainType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lorg/rust/ide/statistics/RsToolchainUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rustrover.core"})
public final class RsToolchainUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    public EventLogGroup getGroup() {
        return RsToolchainUsagesCollectorKt.access$getGROUP$p();
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        RustcVersion rustcVersion;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Collection<CargoProject> cargoProjects = CargoProjectServiceKt.getCargoProjects(project).getAllProjects();
        if (cargoProjects.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set metrics = new LinkedHashSet();
        RustcInfo rustcInfo = ((CargoProject)CollectionsKt.first((Iterable)cargoProjects)).getRustcInfo();
        RustcVersion rustcVersion2 = rustcVersion = rustcInfo != null ? rustcInfo.getVersion() : null;
        if (rustcVersion != null) {
            Version version = new Version(rustcVersion.getSemver().getMajor(), rustcVersion.getSemver().getMinor(), rustcVersion.getSemver().getPatch());
            ((Collection)metrics).add(RsToolchainUsagesCollectorKt.access$getCOMPILER_EVENT$p().metric((Object)version, (Object)rustcVersion.getChannel(), (Object)rustcVersion.getHost()));
        }
        RsToolchainBase toolchain2 = RustProjectSettingsServiceKt.getToolchain(project);
        Collection collection = metrics;
        RsToolchainBase rsToolchainBase = toolchain2;
        collection.add(RsToolchainUsagesCollectorKt.access$getRUSTUP_EVENT$p().metric((Object)(rsToolchainBase != null ? RustupKt.isRustupAvailable(rsToolchainBase) : false)));
        ((Collection)metrics).add(RsToolchainUsagesCollectorKt.access$getTYPE_EVENT$p().metric((Object)ToolchainType.Companion.from(toolchain2)));
        return metrics;
    }
}

